/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock;

import com.javadocking.DockingManager;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.DockableHider;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.Position;
import com.javadocking.dock.TabDockV6Addition;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragListener;
import com.javadocking.event.DockableEvent;
import com.javadocking.event.DockingEventSupport;
import com.javadocking.event.DockingListener;
import com.javadocking.util.JvmVersionUtil;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabDock
extends JPanel
implements LeafDock,
DockableHider {
    private static final double priorityRectangleRelativeTopOffset = 0.25;
    private static final double priorityRectangleRelativeLeftOffset = 0.25;
    private static final double priorityRectangleRelativeBottomOffset = 0.25;
    private static final double priorityRectangleRelativeRightOffset = 0.25;
    private static final String PROPERTY_DOCKABLE_IDS = "dockableIds";
    private static final String PROPERTY_SELECTED_DOCKABLE_ID = "selectedDockableId";
    private Map panelDockableMapping = new HashMap();
    private Map contentPanelMapping = new HashMap();
    private Map descriptionListenerMapping = new HashMap();
    private CompositeDock parentDock;
    private JTabbedPane tabbedPane;
    private Rectangle priorityRectangle = new Rectangle();
    private DockingEventSupport dockingEventSupport = new DockingEventSupport();
    private List hiddenDockables = new ArrayList();

    public TabDock() {
        super(new BorderLayout());
        this.tabbedPane = DockingManager.getComponentFactory().createJTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        SingleSelectionModel selectionModel = this.tabbedPane.getModel();
        selectionModel.addChangeListener(new TabChangelistener());
        DragListener dragListener = DockingManager.getDockDragListenerFactory().createDragListener(this);
        this.tabbedPane.addMouseListener(dragListener);
        this.tabbedPane.addMouseMotionListener(dragListener);
    }

    public int getDockPriority(Dockable dockable, Point relativeLocation) {
        if ((dockable.getDockingModes() & 0x10) == 0) {
            return 0;
        }
        if (dockable.getContent() != null) {
            if (this.isEmpty()) {
                return 3;
            }
            this.getPriorityRectangle(this.priorityRectangle);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return 3;
            }
            return 2;
        }
        if (dockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                if (compositeDockable.getDockable(index).getContent() != null) continue;
                return 0;
            }
            this.getPriorityRectangle(this.priorityRectangle);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public int retrieveDockingRectangle(Dockable dockable, Point relativeLocation, Point dockableOffset, Rectangle rectangle) {
        int priority = this.getDockPriority(dockable, relativeLocation);
        if (priority != 0) {
            rectangle.setBounds(0, 0, this.getSize().width, this.getSize().height);
        }
        return priority;
    }

    public boolean addDockable(Dockable dockableToAdd, Point relativeLocation, Point dockableOffset) {
        if (this.getDockPriority(dockableToAdd, relativeLocation) == 0) {
            return false;
        }
        Component dockableContent = dockableToAdd.getContent();
        if (dockableContent != null) {
            JPanel dockablePanel = this.createComponentOfDockable(dockableToAdd);
            this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, null, this, dockableToAdd));
            dockableToAdd.setState(1, this);
            if (JvmVersionUtil.getVersion() >= 6) {
                Component header = (Component)((Object)DockingManager.getComponentFactory().createTabDockHeader(dockableToAdd, this.getHeaderPosition()));
                TabDockV6Addition.addTab(this.tabbedPane, dockablePanel, header);
            } else {
                this.tabbedPane.addTab(dockableToAdd.getTitle(), dockableToAdd.getIcon(), dockablePanel);
            }
            if (dockableToAdd.getDescription() != null) {
                this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, dockableToAdd.getDescription());
            }
            DockableChangeListener changeListener = new DockableChangeListener(dockableToAdd);
            dockableToAdd.addPropertyChangeListener(changeListener);
            this.descriptionListenerMapping.put(dockableToAdd, changeListener);
            this.tabbedPane.setSelectedComponent(dockablePanel);
            this.panelDockableMapping.put(dockablePanel, dockableToAdd);
            this.contentPanelMapping.put(dockableToAdd.getContent(), dockablePanel);
            dockableToAdd.setLastDockingMode(16);
            this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, null, this, dockableToAdd));
        }
        if (dockableToAdd instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockableToAdd;
            Dockable selectedDockable = compositeDockable.getSelectedDockable();
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dockable childDockable = compositeDockable.getDockable(index);
                Component childDockableContent = childDockable.getContent();
                if (childDockableContent == null) continue;
                JPanel dockablePanel = this.createComponentOfDockable(childDockable);
                childDockable.setState(1, this);
                if (JvmVersionUtil.getVersion() >= 6) {
                    Component header = (Component)((Object)DockingManager.getComponentFactory().createTabDockHeader(childDockable, this.getHeaderPosition()));
                    TabDockV6Addition.addTab(this.tabbedPane, dockablePanel, header);
                } else {
                    this.tabbedPane.addTab(childDockable.getTitle(), childDockable.getIcon(), dockablePanel);
                }
                if (childDockable.getDescription() != null) {
                    this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, childDockable.getDescription());
                }
                DockableChangeListener descriptionListener = new DockableChangeListener(childDockable);
                dockableToAdd.addPropertyChangeListener(descriptionListener);
                this.descriptionListenerMapping.put(childDockable, descriptionListener);
                this.panelDockableMapping.put(dockablePanel, childDockable);
                this.contentPanelMapping.put(childDockable.getContent(), dockablePanel);
                childDockable.setLastDockingMode(16);
                if (selectedDockable == null || !childDockable.equals(selectedDockable)) continue;
                this.tabbedPane.setSelectedComponent(dockablePanel);
            }
            compositeDockable.setDock(this);
        }
        SwingUtil.repaintParent(this);
        return true;
    }

    public boolean canRemoveDockable(Dockable dockableToRemove) {
        if (this.panelDockableMapping.values().contains(dockableToRemove)) {
            return true;
        }
        if (dockableToRemove instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockableToRemove;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                if (this.canRemoveDockable(compositeDockable.getDockable(index))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean removeDockable(Dockable dockableToRemove) {
        if (!this.canRemoveDockable(dockableToRemove)) {
            return false;
        }
        Component dockableComponent = dockableToRemove.getContent();
        if (dockableComponent != null) {
            Component dockablePanel = (Component)this.contentPanelMapping.get(dockableToRemove.getContent());
            this.panelDockableMapping.remove(dockablePanel);
            this.contentPanelMapping.remove(dockableComponent);
            PropertyChangeListener descriptionListener = (PropertyChangeListener)this.descriptionListenerMapping.remove(dockableToRemove);
            dockableToRemove.removePropertyChangeListener(descriptionListener);
            for (int index = 0; index < this.tabbedPane.getTabCount(); ++index) {
                if (!this.tabbedPane.getComponentAt(index).equals(dockablePanel)) continue;
                this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, this, null, dockableToRemove));
                this.tabbedPane.remove(index);
                if (JvmVersionUtil.getVersion() >= 6) {
                    TabDockV6Addition.repaintTabComponents(this.tabbedPane);
                }
                dockableToRemove.setState(2, null);
                this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, this, null, dockableToRemove));
                return true;
            }
        }
        if (dockableToRemove instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockableToRemove;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                if (this.removeDockable(compositeDockable.getDockable(index))) continue;
                return false;
            }
            compositeDockable.setDock(null);
            return true;
        }
        throw new IllegalStateException("Couldn't find a tab with the component of the dockable");
    }

    public boolean isEmpty() {
        return this.panelDockableMapping.size() == 0;
    }

    public boolean isFull() {
        return false;
    }

    public CompositeDock getParentDock() {
        return this.parentDock;
    }

    public void setParentDock(CompositeDock parentDock) {
        this.parentDock = parentDock;
    }

    public void saveProperties(String prefix, Properties properties, Map childDocks) {
        Dockable dockable;
        String[] dockableIdArray = new String[this.tabbedPane.getTabCount()];
        for (int index = 0; index < dockableIdArray.length; ++index) {
            dockableIdArray[index] = ((Dockable)this.panelDockableMapping.get(this.tabbedPane.getComponentAt(index))).getID();
        }
        PropertiesUtil.setStringArray(properties, prefix + PROPERTY_DOCKABLE_IDS, dockableIdArray);
        String maximizedDockableId = null;
        for (int index = 0; index < this.getDockableCount(); ++index) {
            dockable = this.getDockable(index);
            if (dockable.getState() != 4) continue;
            maximizedDockableId = dockable.getID();
            break;
        }
        if (maximizedDockableId != null) {
            PropertiesUtil.setString(properties, prefix + PROPERTY_SELECTED_DOCKABLE_ID, maximizedDockableId);
        } else {
            Component selectedComponent = this.tabbedPane.getSelectedComponent();
            if (selectedComponent != null && (dockable = this.retrieveDockableOfComponent(selectedComponent)) != null) {
                PropertiesUtil.setString(properties, prefix + PROPERTY_SELECTED_DOCKABLE_ID, dockable.getID());
            }
        }
    }

    public void loadProperties(String prefix, Properties properties, Map childDockIds, Map dockablesMap, Window owner) throws IOException {
        Object selectedDockableObject;
        String[] dockableIdArray = new String[]{};
        dockableIdArray = PropertiesUtil.getStringArray(properties, prefix + PROPERTY_DOCKABLE_IDS, dockableIdArray);
        for (int index = 0; index < dockableIdArray.length; ++index) {
            Object dockableObject = dockablesMap.get(dockableIdArray[index]);
            if (dockableObject == null) continue;
            if (dockableObject instanceof Dockable) {
                Dockable dockable = (Dockable)dockableObject;
                this.addDockable(dockable, new Position(this.panelDockableMapping.size()));
                continue;
            }
            throw new IOException("The values in the dockables mapping should be of type com.javadocking.Dockable.");
        }
        boolean hasSelectedDockable = false;
        String selectedDockableId = null;
        selectedDockableId = PropertiesUtil.getString(properties, prefix + PROPERTY_SELECTED_DOCKABLE_ID, selectedDockableId);
        if (selectedDockableId != null && (selectedDockableObject = dockablesMap.get(selectedDockableId)) instanceof Dockable) {
            Dockable selectedDockable = (Dockable)selectedDockableObject;
            hasSelectedDockable = this.setSelectedDockable(selectedDockable);
        }
        if (!hasSelectedDockable && this.tabbedPane != null && this.tabbedPane.getTabCount() > 0) {
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingEventSupport.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingEventSupport.removeDockingListener(listener);
    }

    public Dockable getDockable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getDockableCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return (Dockable)this.panelDockableMapping.get(this.tabbedPane.getComponentAt(index));
    }

    public int getDockableCount() {
        return this.panelDockableMapping.size();
    }

    public boolean containsDockable(Dockable dockable) {
        return this.panelDockableMapping.values().contains(dockable);
    }

    public boolean moveDockable(Dockable dockableToMove, Point relativeLocation) {
        int previousTabIndex;
        if (dockableToMove instanceof CompositeDockable) {
            return false;
        }
        if (!this.panelDockableMapping.values().contains(dockableToMove)) {
            throw new IllegalArgumentException("The dockable should be docked in this dock.");
        }
        Component dockableContent = dockableToMove.getContent();
        Component dockablePanel = (Component)this.contentPanelMapping.get(dockableContent);
        int newTabIndex = this.tabbedPane.indexAtLocation(relativeLocation.x, relativeLocation.y);
        if (newTabIndex < 0) {
            Point relativeLocationInDockable = new Point(relativeLocation);
            if (dockablePanel.contains(relativeLocationInDockable = SwingUtilities.convertPoint(this, relativeLocationInDockable, dockablePanel))) {
                return false;
            }
            newTabIndex = this.panelDockableMapping.size() - 1;
        }
        if ((previousTabIndex = this.tabbedPane.indexOfComponent(dockablePanel)) == newTabIndex) {
            return false;
        }
        this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, this, this, dockableToMove));
        this.tabbedPane.removeTabAt(previousTabIndex);
        if (JvmVersionUtil.getVersion() >= 6) {
            Component header = (Component)((Object)DockingManager.getComponentFactory().createTabDockHeader(dockableToMove, this.getHeaderPosition()));
            TabDockV6Addition.insertTab(this.tabbedPane, newTabIndex, dockablePanel, header);
        } else {
            this.tabbedPane.insertTab(dockableToMove.getTitle(), dockableToMove.getIcon(), dockablePanel, null, newTabIndex);
        }
        this.tabbedPane.setSelectedIndex(newTabIndex);
        this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, this, this, dockableToMove));
        return true;
    }

    public Position getDockablePosition(Dockable dockable) throws IllegalArgumentException {
        Component dockablePanel = (Component)this.contentPanelMapping.get(dockable.getContent());
        int position = this.tabbedPane.indexOfComponent(dockablePanel);
        if (position >= 0) {
            return new Position(position);
        }
        throw new IllegalArgumentException("The dockable is not docked in this dock.");
    }

    public void addDockable(Dockable dockableToAdd, Position position) {
        Component dockableContent;
        int tabPosition = this.getDockableCount();
        if (position.getDimensions() == 1 && position.getPosition(0) >= 0 && position.getPosition(0) <= this.getDockableCount()) {
            tabPosition = position.getPosition(0);
        }
        if ((dockableContent = dockableToAdd.getContent()) != null) {
            JPanel dockablePanel = this.createComponentOfDockable(dockableToAdd);
            dockableToAdd.setState(1, this);
            if (JvmVersionUtil.getVersion() >= 6) {
                Component header = (Component)((Object)DockingManager.getComponentFactory().createTabDockHeader(dockableToAdd, this.getHeaderPosition()));
                TabDockV6Addition.insertTab(this.tabbedPane, tabPosition, dockablePanel, header);
            } else {
                this.tabbedPane.insertTab(dockableToAdd.getTitle(), dockableToAdd.getIcon(), dockablePanel, null, tabPosition);
            }
            if (dockableToAdd.getDescription() != null) {
                this.tabbedPane.setToolTipTextAt(tabPosition, dockableToAdd.getDescription());
            }
            DockableChangeListener changeListener = new DockableChangeListener(dockableToAdd);
            dockableToAdd.addPropertyChangeListener(changeListener);
            this.descriptionListenerMapping.put(dockableToAdd, changeListener);
            this.tabbedPane.setSelectedComponent(dockablePanel);
            this.panelDockableMapping.put(dockablePanel, dockableToAdd);
            this.contentPanelMapping.put(dockableToAdd.getContent(), dockablePanel);
            dockableToAdd.setLastDockingMode(16);
        }
        if (dockableToAdd instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockableToAdd;
            Dockable selectedDockable = compositeDockable.getSelectedDockable();
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dockable childDockable = compositeDockable.getDockable(index);
                Component childDockableContent = childDockable.getContent();
                if (childDockableContent == null) continue;
                JPanel childDockablePanel = this.createComponentOfDockable(childDockable);
                childDockable.setDock(this);
                if (JvmVersionUtil.getVersion() >= 6) {
                    Component header = (Component)((Object)DockingManager.getComponentFactory().createTabDockHeader(childDockable, this.getHeaderPosition()));
                    TabDockV6Addition.insertTab(this.tabbedPane, tabPosition, childDockablePanel, header);
                } else {
                    this.tabbedPane.insertTab(childDockable.getTitle(), null, childDockablePanel, null, tabPosition);
                }
                if (childDockable.getDescription() != null) {
                    this.tabbedPane.setToolTipTextAt(tabPosition, childDockable.getDescription());
                }
                DockableChangeListener descriptionListener = new DockableChangeListener(childDockable);
                dockableToAdd.addPropertyChangeListener(descriptionListener);
                this.descriptionListenerMapping.put(childDockable, descriptionListener);
                this.panelDockableMapping.put(childDockablePanel, childDockable);
                this.contentPanelMapping.put(childDockable.getContent(), childDockablePanel);
                ++tabPosition;
                if (selectedDockable == null || !childDockable.equals(selectedDockable)) continue;
                this.tabbedPane.setSelectedComponent(childDockablePanel);
            }
            compositeDockable.setDock(this);
        }
        SwingUtil.repaintParent(this);
    }

    public void hideDockable(Dockable dockableToHide) throws IllegalArgumentException {
        if (!this.panelDockableMapping.containsValue(dockableToHide)) {
            throw new IllegalArgumentException("The dockable is not docked in this dock.");
        }
        if (this.hiddenDockables.contains(dockableToHide)) {
            throw new IllegalStateException("The dockable is already hidden.");
        }
        this.hiddenDockables.add(dockableToHide);
        JPanel dockablePanel = (JPanel)this.contentPanelMapping.get(dockableToHide.getContent());
        dockablePanel.removeAll();
        dockablePanel.revalidate();
        dockablePanel.repaint();
    }

    public int getHiddenDockableCount() {
        return this.hiddenDockables.size();
    }

    public Dockable getHiddenDockable(int index) {
        if (index < 0 || index >= this.getHiddenDockableCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return (Dockable)this.hiddenDockables.get(index);
    }

    public void restoreDockable(Dockable dockableToRestore) {
        if (!this.panelDockableMapping.values().contains(dockableToRestore)) {
            throw new IllegalArgumentException("The dockable is not hidden.");
        }
        if (!this.hiddenDockables.contains(dockableToRestore)) {
            throw new IllegalStateException("The dockable is not hidden.");
        }
        this.hiddenDockables.remove(dockableToRestore);
        JPanel dockablePanel = (JPanel)this.contentPanelMapping.get(dockableToRestore.getContent());
        dockablePanel.add(dockableToRestore.getContent());
        dockablePanel.revalidate();
        dockablePanel.repaint();
    }

    public Dockable retrieveDockableOfComponent(Component component) {
        if (!(component instanceof JPanel)) {
            return null;
        }
        if (((JPanel)component).getComponentCount() > 0) {
            Component dockableContent = ((JPanel)component).getComponent(0);
            for (int index = 0; index < this.getDockableCount(); ++index) {
                if (!dockableContent.equals(this.getDockable(index).getContent())) continue;
                return this.getDockable(index);
            }
        }
        return null;
    }

    protected JPanel createComponentOfDockable(Dockable dockable) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(dockable.getContent(), "Center");
        return panel;
    }

    public boolean setSelectedDockable(Dockable dockable) {
        boolean selected = false;
        Component dockableContent = dockable.getContent();
        if (dockableContent != null) {
            Component dockablePanel = (Component)this.contentPanelMapping.get(dockableContent);
            int indexToSelect = this.tabbedPane.indexOfComponent(dockablePanel);
            if (indexToSelect >= 0) {
                this.tabbedPane.setSelectedIndex(indexToSelect);
                selected = true;
            }
        } else if (dockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            Dockable selectedDockable = compositeDockable.getSelectedDockable();
            if (selectedDockable == null && compositeDockable.getDockableCount() > 0) {
                selectedDockable = compositeDockable.getDockable(0);
            }
            if (selectedDockable != null) {
                selected = this.setSelectedDockable(selectedDockable);
            }
        }
        SwingUtil.repaintParent(this);
        return selected;
    }

    public Dockable getSelectedDockable() {
        if (this.tabbedPane.getTabCount() > 0) {
            Component selectedComponent = this.tabbedPane.getSelectedComponent();
            return (Dockable)this.panelDockableMapping.get(selectedComponent);
        }
        return null;
    }

    public int getHeaderPosition() {
        switch (this.tabbedPane.getTabPlacement()) {
            case 1: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        throw new IllegalStateException("Illegal placement of tabs [" + this.tabbedPane.getTabPlacement() + "].");
    }

    public void setHeaderPosition(int headerPosition) {
        switch (headerPosition) {
            case 3: {
                this.tabbedPane.setTabPlacement(1);
            }
            case 4: {
                this.tabbedPane.setTabPlacement(3);
            }
            case 1: {
                this.tabbedPane.setTabPlacement(2);
            }
            case 2: {
                this.tabbedPane.setTabPlacement(4);
            }
        }
        throw new IllegalStateException("Illegal position for the headers of the dockables [" + headerPosition + "].");
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    protected void getPriorityRectangle(Rectangle rectangle) {
        Dimension size = this.getSize();
        rectangle.setBounds((int)((double)size.width * 0.25), (int)((double)size.height * 0.25), (int)((double)size.width * 0.5), (int)((double)size.height * 0.5));
    }

    private class DockableChangeListener
    implements PropertyChangeListener {
        private Dockable dockable;

        public DockableChangeListener(Dockable dockable) {
            this.dockable = dockable;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("description")) {
                Position position = TabDock.this.getDockablePosition(this.dockable);
                int index = position.getPosition(0);
                TabDock.this.tabbedPane.setToolTipTextAt(index, this.dockable.getDescription());
            } else if (propertyChangeEvent.getPropertyName().equals("title")) {
                Position position = TabDock.this.getDockablePosition(this.dockable);
                int index = position.getPosition(0);
                TabDock.this.tabbedPane.setTitleAt(index, this.dockable.getTitle());
            } else if (propertyChangeEvent.getPropertyName().equals("icon")) {
                Position position = TabDock.this.getDockablePosition(this.dockable);
                int index = position.getPosition(0);
                TabDock.this.tabbedPane.setIconAt(index, this.dockable.getIcon());
            }
        }
    }

    private class TabChangelistener
    implements ChangeListener {
        private TabChangelistener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (JvmVersionUtil.getVersion() >= 6) {
                TabDockV6Addition.repaintTabComponents(TabDock.this.tabbedPane);
            }
        }
    }
}

