/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock;

import com.javadocking.DockingManager;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.Position;
import com.javadocking.dock.factory.CompositeDockFactory;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.dock.factory.LeafDockFactory;
import com.javadocking.dock.factory.SplitDockFactory;
import com.javadocking.dock.factory.TabDockFactory;
import com.javadocking.dockable.Dockable;
import com.javadocking.event.ChildDockEvent;
import com.javadocking.event.DockingEventSupport;
import com.javadocking.event.DockingListener;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class SplitDock
extends JPanel
implements CompositeDock {
    private static final int HORIZONTAL_SPLIT = 1;
    private static final int VERTICAL_SPLIT = 0;
    private static final String PROPERTY_ORIENTATION = "orientation";
    private static final String PROPERTY_LAST_WIDTH = "lastWidth";
    private static final String PROPERTY_LAST_HEIGHT = "lastHeight";
    private static final String PROPERTY_DIVIDER_LOCATION = "dividerLocation";
    private static final String PROPERTY_REMOVE_LAST_EMPTY_CHILD = "removeLastEmptyChild";
    private static final double centerPriorityRectangleRelativeTopOffset = 0.25;
    private static final double centerPriorityRectangleRelativeLeftOffset = 0.25;
    private static final double centerPriorityRectangleRelativeBottomOffset = 0.25;
    private static final double centerPriorityRectangleRelativeRightOffset = 0.25;
    private static final double leftPriorityRectangleRelativeWidth = 0.25;
    private static final double rightPriorityRectangleRelativeWidth = 0.25;
    private static final double topPriorityRectangleRelativeHeight = 0.25;
    private static final double bottomPriorityRectangleRelativeHeight = 0.25;
    private CompositeDock parentDock;
    private Dock singleChildDock;
    private Dock leftChildDock;
    private Dock rightChildDock;
    private DockFactory childDockFactory;
    private CompositeDockFactory compositeChildDockFactory;
    private JSplitPane splitPane;
    private Rectangle priorityRectangle = new Rectangle();
    private DockingEventSupport dockingEventSupport = new DockingEventSupport();
    private Dock ghostSingleChild;
    private JSplitPane ghostSplitPane;
    private int lastWidth;
    private int lastHeight;
    private boolean removeLastEmptyChild = true;
    private int lastDividerLocation;

    public SplitDock() {
        this(new LeafDockFactory(), new SplitDockFactory());
    }

    public SplitDock(DockFactory childDockFactory) {
        this(childDockFactory, new SplitDockFactory());
    }

    public SplitDock(DockFactory childDockFactory, CompositeDockFactory splitChildDockFactory) {
        super(new BorderLayout());
        this.childDockFactory = childDockFactory;
        this.compositeChildDockFactory = splitChildDockFactory;
    }

    public int getDockPriority(Dockable dockable, Point relativeLocation) {
        int dockPositions = dockable.getDockingModes();
        if ((dockPositions & 1) == 0 && (dockPositions & 2) == 0 && (dockPositions & 4) == 0 && (dockPositions & 8) == 0) {
            return 0;
        }
        if (this.isFull()) {
            return 0;
        }
        int dockPosition = this.getDockPosition(relativeLocation, dockable);
        int dockingMode = SplitDock.getDockingMode(dockPosition);
        if (this.childDockFactory.createDock(dockable, dockingMode) != null) {
            ArrayList childrenOfDockable = new ArrayList();
            ArrayList childrenOfDock = new ArrayList();
            DockingUtil.retrieveDockables(dockable, childrenOfDockable);
            DockingUtil.retrieveDockables(this, childrenOfDock);
            if (this.sameElements(childrenOfDockable, childrenOfDock)) {
                return 0;
            }
            CompositeDock parentDock = this.getParentDock();
            if (parentDock != null && parentDock instanceof SplitDock) {
                SplitDock parentSplitDock = (SplitDock)parentDock;
                if (parentDock.isFull()) {
                    int parentOrientation = parentSplitDock.splitPane.getOrientation();
                    int position = this.getDockPosition(relativeLocation, dockable);
                    Dock correspondentChild = null;
                    if (position == 1 && parentOrientation == 1) {
                        correspondentChild = parentSplitDock.leftChildDock;
                    } else if (position == 2 && parentOrientation == 1) {
                        correspondentChild = parentSplitDock.rightChildDock;
                    } else if (position == 3 && parentOrientation == 0) {
                        correspondentChild = parentSplitDock.leftChildDock;
                    } else if (position == 4 && parentOrientation == 0) {
                        correspondentChild = parentSplitDock.rightChildDock;
                    }
                    if (correspondentChild != null) {
                        childrenOfDock = new ArrayList();
                        DockingUtil.retrieveDockables(correspondentChild, childrenOfDock);
                        if (this.sameElements(childrenOfDockable, childrenOfDock)) {
                            return 0;
                        }
                    }
                }
            }
            if (this.canAddDockableWithPriority(dockable, relativeLocation)) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public int retrieveDockingRectangle(Dockable dockable, Point relativeLocation, Point dockableOffset, Rectangle rectangle) {
        int priority = this.getDockPriority(dockable, relativeLocation);
        if (priority != 0) {
            if (this.singleChildDock == null) {
                rectangle.setBounds(0, 0, this.getSize().width, this.getSize().height);
            } else {
                int position = this.getDockPosition(relativeLocation, dockable);
                int dockingMode = SplitDock.getDockingMode(position);
                Dimension childDockPreferredSize = ((Component)((Object)this.singleChildDock)).getPreferredSize();
                Dimension newDockablePreferredSize = this.childDockFactory.getDockPreferredSize(dockable, dockingMode);
                if (position == 1) {
                    int dockingWidth = this.getChildDockWidth(newDockablePreferredSize.width, childDockPreferredSize.width, this.getSize().width, position);
                    rectangle.setBounds(0, 0, dockingWidth, this.getSize().height);
                } else if (position == 2) {
                    int dockingWidth = this.getChildDockWidth(newDockablePreferredSize.width, childDockPreferredSize.width, this.getSize().width, position);
                    rectangle.setBounds(this.getSize().width - dockingWidth, 0, dockingWidth, this.getSize().height);
                } else if (position == 3) {
                    int dockingHeight = this.getChildDockWidth(newDockablePreferredSize.height, childDockPreferredSize.height, this.getSize().height, position);
                    rectangle.setBounds(0, 0, this.getSize().width, dockingHeight);
                } else if (position == 4) {
                    int dockingHeight = this.getChildDockWidth(newDockablePreferredSize.height, childDockPreferredSize.height, this.getSize().height, position);
                    rectangle.setBounds(0, this.getSize().height - dockingHeight, this.getSize().width, dockingHeight);
                }
            }
        }
        return priority;
    }

    public boolean addDockable(Dockable dockableToAdd, Point relativeLocation, Point dockableOffset) {
        if (this.getDockPriority(dockableToAdd, relativeLocation) == 0) {
            return false;
        }
        if (this.singleChildDock == null) {
            Dock newChildDock = this.childDockFactory.createDock(dockableToAdd, 128);
            newChildDock.addDockable(dockableToAdd, new Point(), dockableOffset);
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, null, this, newChildDock));
            this.singleChildDock = newChildDock;
            this.singleChildDock.setParentDock(this);
            this.add((Component)((Object)this.singleChildDock), "Center");
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, null, this, newChildDock));
        } else {
            int dockingHeight;
            int dockingWidth;
            int position = this.getDockPosition(relativeLocation, dockableToAdd);
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, this.singleChildDock));
            Dock oldSingleChildDock = this.singleChildDock;
            this.singleChildDock = null;
            this.remove((Component)((Object)oldSingleChildDock));
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, oldSingleChildDock));
            Dimension currentChildDockPreferredSize = ((Component)((Object)oldSingleChildDock)).getPreferredSize();
            SplitDock leftSplitDock = null;
            SplitDock rightSplitDock = null;
            try {
                switch (position) {
                    case 1: {
                        leftSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 1);
                        rightSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 2);
                        rightSplitDock.setSingleChildDock(oldSingleChildDock);
                        leftSplitDock.addDockable(dockableToAdd, new Point(), dockableOffset);
                        break;
                    }
                    case 3: {
                        leftSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 4);
                        rightSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 8);
                        rightSplitDock.setSingleChildDock(oldSingleChildDock);
                        leftSplitDock.addDockable(dockableToAdd, new Point(), dockableOffset);
                        break;
                    }
                    case 2: {
                        leftSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 1);
                        rightSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 2);
                        leftSplitDock.setSingleChildDock(oldSingleChildDock);
                        rightSplitDock.addDockable(dockableToAdd, new Point(), dockableOffset);
                        break;
                    }
                    case 4: {
                        leftSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 4);
                        rightSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 8);
                        leftSplitDock.setSingleChildDock(oldSingleChildDock);
                        rightSplitDock.addDockable(dockableToAdd, new Point(), dockableOffset);
                    }
                }
            }
            catch (ClassCastException exception) {
                System.out.println("The splitChildDockFactory should create a com.javadocking.dock.SplitDock for the modes DockingMode.LEFT, DockingMode.RIGHT, DockingMode.TOP and DockingMode.BOTTOM.");
                exception.printStackTrace();
            }
            int dockingMode = SplitDock.getDockingMode(position);
            Dimension preferredSize = this.childDockFactory.getDockPreferredSize(dockableToAdd, dockingMode);
            int dividerLocation = this.getSize().width / 2;
            if (position == 1) {
                dividerLocation = dockingWidth = this.getChildDockWidth(preferredSize.width, currentChildDockPreferredSize.width, this.getSize().width, position);
            } else if (position == 2) {
                dockingWidth = this.getChildDockWidth(preferredSize.width, currentChildDockPreferredSize.width, this.getSize().width, position);
                dividerLocation = this.getSize().width - dockingWidth;
            } else if (position == 3) {
                dividerLocation = dockingHeight = this.getChildDockWidth(preferredSize.height, currentChildDockPreferredSize.height, this.getSize().height, position);
            } else if (position == 4) {
                dockingHeight = this.getChildDockWidth(preferredSize.height, currentChildDockPreferredSize.height, this.getSize().height, position);
                dividerLocation = this.getSize().height - dockingHeight;
            }
            int orientation = 1;
            if (position == 3 || position == 4) {
                orientation = 0;
            }
            this.setDocks(leftSplitDock, rightSplitDock, orientation, dividerLocation);
        }
        SwingUtil.repaintParent(this);
        return true;
    }

    public boolean isEmpty() {
        return this.singleChildDock == null && this.leftChildDock == null && this.rightChildDock == null;
    }

    public boolean isFull() {
        return this.leftChildDock != null && this.rightChildDock != null;
    }

    public CompositeDock getParentDock() {
        return this.parentDock;
    }

    public void setParentDock(CompositeDock parentDock) {
        this.parentDock = parentDock;
    }

    public void saveProperties(String prefix, Properties properties, Map childDockIds) {
        String leafChildDockFactoryClassName = this.childDockFactory.getClass().getName();
        PropertiesUtil.setString(properties, prefix + "leafChildDockFactory", leafChildDockFactoryClassName);
        this.childDockFactory.saveProperties(prefix + "leafChildDockFactory.", properties);
        String splitChildDockFactoryClassName = this.compositeChildDockFactory.getClass().getName();
        PropertiesUtil.setString(properties, prefix + "splitChildDockFactory", splitChildDockFactoryClassName);
        this.compositeChildDockFactory.saveProperties(prefix + "splitChildDockFactory.", properties);
        if (this.splitPane != null) {
            PropertiesUtil.setInteger(properties, prefix + PROPERTY_ORIENTATION, this.splitPane.getOrientation());
            PropertiesUtil.setInteger(properties, prefix + PROPERTY_DIVIDER_LOCATION, this.splitPane.getDividerLocation());
        }
        if (this.leftChildDock != null && this.rightChildDock != null) {
            String leftChildDockId = (String)childDockIds.get(this.leftChildDock);
            String rightChildDockId = (String)childDockIds.get(this.rightChildDock);
            Position.setPositionProperty(properties, prefix + "childDock" + leftChildDockId + "." + "position", this.getChildDockPosition(this.leftChildDock));
            Position.setPositionProperty(properties, prefix + "childDock" + rightChildDockId + "." + "position", this.getChildDockPosition(this.rightChildDock));
        }
        PropertiesUtil.setInteger(properties, prefix + PROPERTY_LAST_WIDTH, this.getSize().width);
        PropertiesUtil.setInteger(properties, prefix + PROPERTY_LAST_HEIGHT, this.getSize().height);
        PropertiesUtil.setBoolean(properties, prefix + PROPERTY_REMOVE_LAST_EMPTY_CHILD, this.removeLastEmptyChild);
    }

    public void loadProperties(String prefix, Properties properties, Map childDocks, Map dockablesMap, Window owner) throws IOException {
        try {
            String leafChildDockFactoryClassName = LeafDockFactory.class.getName();
            leafChildDockFactoryClassName = PropertiesUtil.getString(properties, prefix + "leafChildDockFactory", leafChildDockFactoryClassName);
            Class<?> leafChildDockFactoryClazz = Class.forName(leafChildDockFactoryClassName);
            this.childDockFactory = (DockFactory)leafChildDockFactoryClazz.newInstance();
            this.childDockFactory.loadProperties(prefix + "leafChildDockFactory.", properties);
        }
        catch (ClassNotFoundException exception) {
            System.out.println("Could not create the leaf child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new TabDockFactory();
        }
        catch (IllegalAccessException exception) {
            System.out.println("Could not create the leaf child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new TabDockFactory();
        }
        catch (InstantiationException exception) {
            System.out.println("Could not create the leaf child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new TabDockFactory();
        }
        try {
            String splitChildDockFactoryClassName = SplitDockFactory.class.getName();
            splitChildDockFactoryClassName = PropertiesUtil.getString(properties, prefix + "splitChildDockFactory", splitChildDockFactoryClassName);
            Class<?> splitChildDockFactoryClazz = Class.forName(splitChildDockFactoryClassName);
            this.compositeChildDockFactory = (CompositeDockFactory)splitChildDockFactoryClazz.newInstance();
            this.compositeChildDockFactory.loadProperties(prefix + "splitChildDockFactory.", properties);
        }
        catch (ClassNotFoundException exception) {
            System.out.println("Could not create the split child dock factory.");
            exception.printStackTrace();
            this.compositeChildDockFactory = new SplitDockFactory();
        }
        catch (IllegalAccessException exception) {
            System.out.println("Could not create the split child dock factory.");
            exception.printStackTrace();
            this.compositeChildDockFactory = new SplitDockFactory();
        }
        catch (InstantiationException exception) {
            System.out.println("Could not create the split child dock factory.");
            exception.printStackTrace();
            this.compositeChildDockFactory = new SplitDockFactory();
        }
        this.lastWidth = PropertiesUtil.getInteger(properties, prefix + PROPERTY_LAST_WIDTH, this.lastWidth);
        this.lastHeight = PropertiesUtil.getInteger(properties, prefix + PROPERTY_LAST_HEIGHT, this.lastHeight);
        this.removeLastEmptyChild = PropertiesUtil.getBoolean(properties, prefix + PROPERTY_REMOVE_LAST_EMPTY_CHILD, this.removeLastEmptyChild);
        if (childDocks != null) {
            Iterator<Object> iterator;
            int childCount = childDocks.keySet().size();
            if (childCount == 1) {
                iterator = childDocks.values().iterator();
                Dock childDock = (Dock)iterator.next();
                this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, null, this, childDock));
                this.setSingleChildDock(childDock);
                this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, null, this, childDock));
            } else if (childCount == 2) {
                iterator = childDocks.keySet().iterator();
                String firstChildDockId = (String)iterator.next();
                String secondChildDockId = (String)iterator.next();
                Position position = null;
                position = Position.getPositionProperty(properties, prefix + "childDock" + firstChildDockId + "." + "position", position);
                int firstChildPosition = position.getPosition(0);
                SplitDock leftSplitDock = null;
                SplitDock rightSplitDock = null;
                if (firstChildPosition == 1 || firstChildPosition == 3) {
                    leftSplitDock = (SplitDock)childDocks.get(firstChildDockId);
                    rightSplitDock = (SplitDock)childDocks.get(secondChildDockId);
                } else {
                    leftSplitDock = (SplitDock)childDocks.get(secondChildDockId);
                    rightSplitDock = (SplitDock)childDocks.get(firstChildDockId);
                }
                int orientation = 1;
                int dividerLocation = 200;
                orientation = PropertiesUtil.getInteger(properties, prefix + PROPERTY_ORIENTATION, orientation);
                this.lastDividerLocation = dividerLocation = PropertiesUtil.getInteger(properties, prefix + PROPERTY_DIVIDER_LOCATION, dividerLocation);
                this.setDocks(leftSplitDock, rightSplitDock, orientation, dividerLocation);
            }
        }
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingEventSupport.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingEventSupport.removeDockingListener(listener);
    }

    public int getChildDockCount() {
        if (this.singleChildDock != null) {
            return 1;
        }
        if (this.leftChildDock != null && this.rightChildDock != null) {
            return 2;
        }
        return 0;
    }

    public Dock getChildDock(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getChildDockCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        if (this.singleChildDock != null) {
            return this.singleChildDock;
        }
        if (this.leftChildDock != null && this.rightChildDock != null) {
            if (index == 0) {
                return this.leftChildDock;
            }
            return this.rightChildDock;
        }
        return null;
    }

    public Position getChildDockPosition(Dock childDock) throws IllegalArgumentException {
        if (childDock.equals(this.singleChildDock)) {
            return new Position(0);
        }
        if (this.splitPane != null) {
            if (this.splitPane.getOrientation() == 1) {
                if (childDock.equals(this.leftChildDock)) {
                    return new Position(1);
                }
                if (childDock.equals(this.rightChildDock)) {
                    return new Position(2);
                }
            } else {
                if (childDock.equals(this.leftChildDock)) {
                    return new Position(3);
                }
                if (childDock.equals(this.rightChildDock)) {
                    return new Position(4);
                }
            }
        }
        throw new IllegalArgumentException("The dock is not docked in this composite dock.");
    }

    public void emptyChild(Dock emptyChildDock) {
        if (this.singleChildDock != null && this.singleChildDock.equals(emptyChildDock)) {
            if (this.isRemoveLastEmptyChild()) {
                this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, emptyChildDock));
                this.remove((Component)((Object)this.singleChildDock));
                this.singleChildDock = null;
                this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, emptyChildDock));
                if (this.parentDock != null && this.ghostSingleChild == null && this.ghostSplitPane == null) {
                    this.parentDock.emptyChild(this);
                }
            }
        } else if (this.leftChildDock != null && this.leftChildDock.equals(emptyChildDock)) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, emptyChildDock));
            this.lastDividerLocation = this.splitPane.getDividerLocation();
            this.remove(this.splitPane);
            this.singleChildDock = this.rightChildDock;
            this.singleChildDock.setParentDock(this);
            this.rightChildDock = null;
            this.leftChildDock = null;
            this.splitPane = null;
            this.add((Component)((Object)this.singleChildDock), "Center");
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, emptyChildDock));
        } else if (this.rightChildDock != null && this.rightChildDock.equals(emptyChildDock)) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, emptyChildDock));
            this.lastDividerLocation = this.splitPane.getDividerLocation();
            this.remove(this.splitPane);
            this.singleChildDock = this.leftChildDock;
            this.singleChildDock.setParentDock(this);
            this.rightChildDock = null;
            this.leftChildDock = null;
            this.splitPane = null;
            this.add((Component)((Object)this.singleChildDock), "Center");
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, emptyChildDock));
        }
        SwingUtil.repaintParent(this);
    }

    public void ghostChild(Dock childDock) {
        if (this.singleChildDock != null && this.singleChildDock.equals(childDock)) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, childDock));
            this.ghostSingleChild = this.singleChildDock;
            this.singleChildDock = null;
            ((Component)((Object)this.ghostSingleChild)).setVisible(false);
            if (this.parentDock != null) {
                this.parentDock.ghostChild(this);
            }
        } else if (this.leftChildDock != null && this.leftChildDock.equals(childDock)) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, childDock));
            this.lastDividerLocation = this.splitPane.getDividerLocation();
            this.ghostSplitPane = this.splitPane;
            this.ghostSplitPane.remove((Component)((Object)this.rightChildDock));
            this.ghostSplitPane.setVisible(false);
            this.singleChildDock = this.rightChildDock;
            this.singleChildDock.setParentDock(this);
            this.rightChildDock = null;
            this.leftChildDock = null;
            this.splitPane = null;
            this.add((Component)((Object)this.singleChildDock), "Center");
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, childDock));
        } else if (this.rightChildDock != null && this.rightChildDock.equals(childDock)) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, childDock));
            this.lastDividerLocation = this.splitPane.getDividerLocation();
            this.ghostSplitPane = this.splitPane;
            this.ghostSplitPane.remove((Component)((Object)this.leftChildDock));
            this.ghostSplitPane.setVisible(false);
            this.singleChildDock = this.leftChildDock;
            this.singleChildDock.setParentDock(this);
            this.leftChildDock = null;
            this.rightChildDock = null;
            this.splitPane = null;
            this.add((Component)((Object)this.singleChildDock), "Center");
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, childDock));
        }
        SwingUtil.repaintParent(this);
    }

    public void clearGhosts() {
        if (this.ghostSingleChild != null) {
            this.remove((Component)((Object)this.ghostSingleChild));
            Dock oldGhostChild = this.ghostSingleChild;
            this.ghostSingleChild = null;
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, oldGhostChild));
        }
        if (this.ghostSplitPane != null) {
            this.remove(this.ghostSplitPane);
            this.ghostSplitPane = null;
        }
        if (this.isEmpty() && this.getParentDock() != null) {
            this.getParentDock().emptyChild(this);
        }
    }

    public void addChildDock(Dock dockToAdd, Position position) throws IllegalStateException {
        if (this.isFull()) {
            throw new IllegalStateException("This dock is full.");
        }
        if (this.isEmpty()) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, null, this, dockToAdd));
            this.setSingleChildDock(dockToAdd);
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, null, this, dockToAdd));
        } else {
            int dockingHeight;
            int dockingWidth;
            int possiblePosition;
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, this.singleChildDock));
            Dock oldSingleChildDock = this.singleChildDock;
            this.singleChildDock = null;
            this.remove((Component)((Object)oldSingleChildDock));
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, oldSingleChildDock));
            Dimension currentChildDockPreferredSize = ((Component)((Object)oldSingleChildDock)).getPreferredSize();
            int splitPosition = 2;
            if (position.getDimensions() == 1 && ((possiblePosition = position.getPosition(0)) == 1 || possiblePosition == 2 || possiblePosition == 3 || possiblePosition == 4)) {
                splitPosition = possiblePosition;
            }
            SplitDock leftSplitDock = null;
            SplitDock rightSplitDock = null;
            try {
                switch (splitPosition) {
                    case 1: {
                        leftSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 1);
                        rightSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 2);
                        rightSplitDock.setSingleChildDock(oldSingleChildDock);
                        leftSplitDock.setSingleChildDock(dockToAdd);
                        break;
                    }
                    case 3: {
                        leftSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 4);
                        rightSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 8);
                        rightSplitDock.setSingleChildDock(oldSingleChildDock);
                        leftSplitDock.setSingleChildDock(dockToAdd);
                        break;
                    }
                    case 2: {
                        leftSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 1);
                        rightSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 2);
                        leftSplitDock.setSingleChildDock(oldSingleChildDock);
                        rightSplitDock.setSingleChildDock(dockToAdd);
                        break;
                    }
                    case 4: {
                        leftSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 4);
                        rightSplitDock = (SplitDock)this.compositeChildDockFactory.createDock(null, 8);
                        leftSplitDock.setSingleChildDock(oldSingleChildDock);
                        rightSplitDock.setSingleChildDock(dockToAdd);
                    }
                }
            }
            catch (ClassCastException exception) {
                System.out.println("The splitChildDockFactory should create a com.javadocking.dock.SplitDock for the modes DockingMode.LEFT, DockingMode.RIGHT, DockingMode.TOP and DockingMode.BOTTOM.");
                exception.printStackTrace();
            }
            Dimension preferredSize = ((Component)((Object)dockToAdd)).getPreferredSize();
            int dockWidth = this.getSize().width;
            int dockHeight = this.getSize().height;
            if (dockWidth == 0 && dockHeight == 0) {
                dockWidth = this.lastWidth;
                dockHeight = this.lastHeight;
            }
            int dividerLocation = dockWidth / 2;
            if (splitPosition == 1) {
                dividerLocation = dockingWidth = this.getChildDockWidth(preferredSize.width, currentChildDockPreferredSize.width, dockWidth, splitPosition);
            } else if (splitPosition == 2) {
                dockingWidth = this.getChildDockWidth(preferredSize.width, currentChildDockPreferredSize.width, dockWidth, splitPosition);
                dividerLocation = dockWidth - dockingWidth;
            } else if (splitPosition == 3) {
                dividerLocation = dockingHeight = this.getChildDockWidth(preferredSize.height, currentChildDockPreferredSize.height, dockHeight, splitPosition);
            } else if (splitPosition == 4) {
                dockingHeight = this.getChildDockWidth(preferredSize.height, currentChildDockPreferredSize.height, dockHeight, splitPosition);
                dividerLocation = dockHeight - dockingHeight;
            }
            int orientation = 1;
            if (splitPosition == 3 || splitPosition == 4) {
                orientation = 0;
            }
            this.setDocks(leftSplitDock, rightSplitDock, orientation, dividerLocation);
        }
        SwingUtil.repaintParent(this);
    }

    public DockFactory getChildDockFactory() {
        return this.childDockFactory;
    }

    public void setChildDockFactory(DockFactory childDockFactory) {
        if (childDockFactory == null) {
            throw new IllegalArgumentException("The leaf child dock factory cannot be null.");
        }
        this.childDockFactory = childDockFactory;
    }

    public boolean isRemoveLastEmptyChild() {
        return this.removeLastEmptyChild;
    }

    public void setRemoveLastEmptyChild(boolean removeLasTemptyChild) {
        this.removeLastEmptyChild = removeLasTemptyChild;
    }

    public CompositeDockFactory getCompositeChildDockFactory() {
        return this.compositeChildDockFactory;
    }

    public void setCompositeChildDockFactory(CompositeDockFactory splitDockFactory) {
        if (splitDockFactory == null) {
            throw new IllegalArgumentException("The split dock factory cannot be null.");
        }
        this.compositeChildDockFactory = splitDockFactory;
    }

    public void setDividerLocation(int dividerLocation) {
        if (this.splitPane != null) {
            this.splitPane.setDividerLocation(dividerLocation);
        }
    }

    public int getDividerLocation() {
        if (this.splitPane != null) {
            return this.splitPane.getDividerLocation();
        }
        return 0;
    }

    public void setSingleChildDock(Dock dock) {
        if (!this.isEmpty()) {
            throw new IllegalStateException("This dock is not empty.");
        }
        this.singleChildDock = dock;
        this.singleChildDock.setParentDock(this);
        this.add((Component)((Object)this.singleChildDock), "Center");
        SwingUtil.repaintParent(this);
    }

    private void setDocks(Dock leftDock, Dock rightDock, int orientation, int dividerLocation) {
        if (!this.isEmpty()) {
            throw new IllegalStateException("This dock is not empty.");
        }
        this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, null, this, leftDock));
        this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, null, this, rightDock));
        this.leftChildDock = leftDock;
        this.leftChildDock.setParentDock(this);
        this.rightChildDock = rightDock;
        this.rightChildDock.setParentDock(this);
        this.splitPane = DockingManager.getComponentFactory().createJSplitPane();
        this.splitPane.setLeftComponent((Component)((Object)this.leftChildDock));
        this.splitPane.setRightComponent((Component)((Object)this.rightChildDock));
        this.splitPane.setOrientation(orientation);
        if (this.lastDividerLocation != 0) {
            this.splitPane.setDividerLocation(this.lastDividerLocation);
        } else {
            this.splitPane.setDividerLocation(dividerLocation);
        }
        this.splitPane.setResizeWeight(0.5);
        this.add((Component)this.splitPane, "Center");
        this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, null, this, leftDock));
        this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, null, this, rightDock));
        SwingUtil.repaintParent(this);
    }

    protected void getPriorityRectangle(Rectangle rectangle, int position) {
        Dimension size = this.getSize();
        switch (position) {
            case 1: {
                rectangle.setBounds(0, 0, (int)((double)size.width * 0.25), size.height);
                break;
            }
            case 2: {
                rectangle.setBounds((int)((double)size.width * 0.75), 0, (int)((double)size.width * 0.25), size.height);
                break;
            }
            case 3: {
                rectangle.setBounds(0, 0, size.width, (int)((double)size.height * 0.25));
                break;
            }
            case 4: {
                rectangle.setBounds(0, (int)((double)size.height * 0.75), size.width, (int)((double)size.height * 0.25));
                break;
            }
            case 0: {
                rectangle.setBounds((int)((double)size.width * 0.25), (int)((double)size.height * 0.25), (int)((double)size.width * 0.5), (int)((double)size.height * 0.5));
            }
        }
    }

    protected boolean canAddDockableWithPriority(Dockable dockable, Point relativeLocation) {
        if (this.isEmpty()) {
            this.getPriorityRectangle(this.priorityRectangle, 0);
            return this.priorityRectangle.contains(relativeLocation);
        }
        int dockModes = dockable.getDockingModes();
        Dockable otherDockable = DockingUtil.createDockable(this);
        int otherDockModes = 2147354623;
        if (otherDockable != null) {
            otherDockModes = otherDockable.getDockingModes();
        }
        if ((dockModes & 1) != 0 && (otherDockModes & 2) != 0) {
            this.getPriorityRectangle(this.priorityRectangle, 1);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return true;
            }
        }
        if ((dockModes & 2) != 0 && (otherDockModes & 1) != 0) {
            this.getPriorityRectangle(this.priorityRectangle, 2);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return true;
            }
        }
        if ((dockModes & 4) != 0 && (otherDockModes & 8) != 0) {
            this.getPriorityRectangle(this.priorityRectangle, 3);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return true;
            }
        }
        if ((dockModes & 8) != 0 && (otherDockModes & 4) != 0) {
            this.getPriorityRectangle(this.priorityRectangle, 4);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return true;
            }
        }
        return false;
    }

    protected int getDockPosition(Point relativeLocation, Dockable newDockable) {
        if (this.isEmpty()) {
            return 0;
        }
        int dockModes = newDockable.getDockingModes();
        Dockable otherDockable = DockingUtil.createDockable(this);
        int otherDockModes = 2147354623;
        if (otherDockable != null) {
            otherDockModes = otherDockable.getDockingModes();
        }
        Dimension dimension = this.getSize();
        int halfWidth = dimension.width / 2;
        int halfHeight = dimension.height / 2;
        if (relativeLocation.x < halfWidth) {
            if (relativeLocation.y < halfHeight) {
                if (relativeLocation.x < relativeLocation.y) {
                    if ((dockModes & 1) != 0 && (otherDockModes & 2) != 0) {
                        return 1;
                    }
                } else if ((dockModes & 4) != 0 && (otherDockModes & 8) != 0) {
                    return 3;
                }
            } else if (relativeLocation.x < dimension.height - relativeLocation.y ? (dockModes & 1) != 0 && (otherDockModes & 2) != 0 : (dockModes & 1) != 0 && (otherDockModes & 2) != 0) {
                return 1;
            }
        } else if (relativeLocation.y < halfHeight) {
            if (dimension.width - relativeLocation.x < relativeLocation.y) {
                if ((dockModes & 2) != 0 && (otherDockModes & 1) != 0) {
                    return 2;
                }
            } else if ((dockModes & 4) != 0 && (otherDockModes & 8) != 0) {
                return 3;
            }
        } else if (dimension.width - relativeLocation.x < dimension.height - relativeLocation.y) {
            if ((dockModes & 2) != 0 && (otherDockModes & 1) != 0) {
                return 2;
            }
        } else if ((dockModes & 8) != 0 && (otherDockModes & 4) != 0) {
            return 4;
        }
        if ((dockModes & 2) != 0) {
            return 2;
        }
        if ((dockModes & 1) != 0) {
            return 1;
        }
        if ((dockModes & 8) != 0) {
            return 4;
        }
        if ((dockModes & 4) != 0) {
            return 3;
        }
        return 2;
    }

    protected int getChildDockWidth(int preferredWidth, int existingPreferredWidth, int totalWidth, int position) {
        if (preferredWidth + existingPreferredWidth == 0) {
            return 0;
        }
        return preferredWidth * totalWidth / (preferredWidth + existingPreferredWidth);
    }

    private boolean sameElements(List firstList, List secondList) {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        for (int index = 0; index < firstList.size(); ++index) {
            if (secondList.contains(firstList.get(index))) continue;
            return false;
        }
        return true;
    }

    private static int getDockingMode(int dockPosition) {
        switch (dockPosition) {
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 0: {
                return 128;
            }
        }
        throw new IllegalArgumentException("Position [" + dockPosition + "] is not a valid position in a BorderDock.");
    }
}

