/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock;

import com.javadocking.DockingManager;
import com.javadocking.component.DockHeader;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.DockableHider;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.Position;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragListener;
import com.javadocking.event.DockableEvent;
import com.javadocking.event.DockingEventSupport;
import com.javadocking.event.DockingListener;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.util.SwingUtil;
import com.javadocking.visualizer.ExternalizeDock;
import com.javadocking.visualizer.Externalizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;

public class SingleDock
extends JPanel
implements LeafDock,
DockableHider,
ExternalizeDock {
    public static final Position SINGLE_POSITION = new Position();
    private static final String PROPERTY_DOCKABLE_IDS = "dockableIds";
    private static double priorityRectangleRelativeTopOffset = 0.25;
    private static double priorityRectangleRelativeLeftOffset = 0.25;
    private static double priorityRectangleRelativeBottomOffset = 0.25;
    private static double priorityRectangleRelativeRightOffset = 0.25;
    private Dockable dockable;
    private boolean externalized = false;
    private Externalizer externalizer;
    private CompositeDock parentDock;
    private DockHeader header;
    private int headerPosition = 3;
    private Rectangle priorityRectangle = new Rectangle();
    private DockingEventSupport dockingEventSupport = new DockingEventSupport();
    private DockHeader ghostHeader;
    private boolean hidden;

    public SingleDock() {
        super(new BorderLayout());
    }

    public int getDockPriority(Dockable dockable, Point relativeLocation) {
        if ((dockable.getDockingModes() & 0x40) == 0) {
            return 0;
        }
        Dockable singleDockable = this.getDeepestSingleChild(dockable);
        if (singleDockable == null) {
            return 0;
        }
        if (singleDockable.getContent() != null && !this.isFull()) {
            this.getPriorityRectangle(this.priorityRectangle);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public int retrieveDockingRectangle(Dockable dockable, Point relativeLocation, Point dockableOffset, Rectangle rectangle) {
        int priority = this.getDockPriority(dockable, relativeLocation);
        if (priority != 0) {
            rectangle.setBounds(0, 0, this.getSize().width, this.getSize().height);
        }
        return priority;
    }

    public boolean addDockable(Dockable dockableToAdd, Point relativeLocation, Point dockableOffset) {
        if (this.getDockPriority(dockableToAdd, relativeLocation) == 0) {
            return false;
        }
        Dockable singleDockable = this.getDeepestSingleChild(dockableToAdd);
        if (singleDockable != null) {
            this.addDockable(singleDockable, SINGLE_POSITION);
            dockableToAdd.setState(1, this);
            return true;
        }
        return false;
    }

    public boolean canRemoveDockable(Dockable dockableToRemove) {
        return dockableToRemove.equals(this.dockable);
    }

    public boolean removeDockable(Dockable dockableToRemove) {
        if (!this.canRemoveDockable(dockableToRemove)) {
            return false;
        }
        this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, this, null, dockableToRemove));
        if (this.hidden) {
            this.hidden = false;
        } else {
            this.remove(this.dockable.getContent());
        }
        this.dockable.setState(2, null);
        this.dockable = null;
        if (this.header != null) {
            if (this.ghostHeader == null) {
                this.ghostHeader = this.header;
                ((Component)((Object)this.header)).setVisible(false);
            } else {
                this.remove((Component)((Object)this.header));
            }
            this.header = null;
        }
        this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, this, null, dockableToRemove));
        SwingUtil.repaintParent(this);
        return true;
    }

    public boolean isEmpty() {
        return this.dockable == null;
    }

    public boolean isFull() {
        return this.dockable != null;
    }

    public CompositeDock getParentDock() {
        return this.parentDock;
    }

    public void setParentDock(CompositeDock parentDock) {
        this.parentDock = parentDock;
    }

    public void saveProperties(String prefix, Properties properties, Map childDocks) {
        if (this.dockable != null) {
            PropertiesUtil.setString(properties, prefix + PROPERTY_DOCKABLE_IDS, this.dockable.getID());
            PropertiesUtil.setInteger(properties, prefix + "headerPosition", this.headerPosition);
        }
        PropertiesUtil.setBoolean(properties, prefix + "externalized", this.externalized);
    }

    public void loadProperties(String prefix, Properties properties, Map childDocks, Map dockablesMap, Window owner) throws IOException {
        Object dockableObject;
        boolean externalized = false;
        externalized = PropertiesUtil.getBoolean(properties, prefix + "externalized", externalized);
        String dockableId = null;
        dockableId = PropertiesUtil.getString(properties, prefix + PROPERTY_DOCKABLE_IDS, dockableId);
        if (dockableId != null && (dockableObject = dockablesMap.get(dockableId)) != null) {
            if (dockableObject instanceof Dockable) {
                Dockable dockable = (Dockable)dockableObject;
                if (externalized) {
                    this.externalizeDockable(dockable);
                } else {
                    this.addDockable(dockable, SINGLE_POSITION);
                }
            } else {
                throw new IOException("The values in the dockables mapping should be of type com.javadocking.Dockable.");
            }
        }
        int headerPosition = 3;
        headerPosition = PropertiesUtil.getInteger(properties, prefix + "headerPosition", headerPosition);
        this.setHeaderPosition(headerPosition);
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingEventSupport.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingEventSupport.removeDockingListener(listener);
    }

    public Dockable getDockable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getDockableCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return this.dockable;
    }

    public int getDockableCount() {
        if (this.dockable != null) {
            return 1;
        }
        return 0;
    }

    public boolean containsDockable(Dockable otherDockable) {
        return otherDockable.equals(this.dockable);
    }

    public boolean moveDockable(Dockable dockableToMove, Point relativeLocation) {
        if (!dockableToMove.equals(this.dockable)) {
            throw new IllegalArgumentException("The dockable should be docked in this dock.");
        }
        return false;
    }

    public Position getDockablePosition(Dockable childDockable) throws IllegalArgumentException {
        if (childDockable.equals(this.dockable)) {
            return SINGLE_POSITION;
        }
        throw new IllegalArgumentException("The dockable is not docked in this dock.");
    }

    public void addDockable(Dockable dockableToAdd, Position position) {
        if (!this.isEmpty()) {
            throw new IllegalStateException("The dock is full.");
        }
        this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, null, this, dockableToAdd));
        this.dockable = dockableToAdd;
        this.add(dockableToAdd.getContent(), "Center");
        this.dockable.setState(1, this);
        this.dockable.setLastDockingMode(64);
        this.hidden = false;
        if (this.dockable.isWithHeader()) {
            DragListener dragListener = DockingManager.getDockDragListenerFactory().createDragListener(this);
            this.header = DockingManager.getComponentFactory().createSingleDockHeader(this, 3);
            this.header.setDragListener(dragListener);
            this.add((Component)((Object)this.header), this.getBorderLayoutString(this.headerPosition));
        }
        this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, null, this, dockableToAdd));
        SwingUtil.repaintParent(this);
    }

    public void hideDockable(Dockable dockableToHide) throws IllegalArgumentException {
        if (!dockableToHide.equals(this.dockable)) {
            throw new IllegalArgumentException("The dockable is not docked in this dock.");
        }
        if (this.hidden) {
            throw new IllegalStateException("The dockable is already hidden.");
        }
        this.hidden = true;
        this.remove(this.dockable.getContent());
        this.revalidate();
        this.repaint();
    }

    public int getHiddenDockableCount() {
        if (this.hidden) {
            return 1;
        }
        return 0;
    }

    public Dockable getHiddenDockable(int index) {
        if (index < 0 || index >= this.getHiddenDockableCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        if (this.hidden) {
            return this.dockable;
        }
        return null;
    }

    public void restoreDockable(Dockable dockableToRestore) {
        if (!dockableToRestore.equals(this.dockable)) {
            throw new IllegalArgumentException("The dockable is not in this dock.");
        }
        if (!this.hidden) {
            throw new IllegalStateException("No dockable is hidden.");
        }
        this.add(this.dockable.getContent(), "Center");
        this.hidden = false;
    }

    public void externalizeDockable(Dockable dockableToExternalize) {
        this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, null, this, dockableToExternalize));
        this.dockable = dockableToExternalize;
        this.add(dockableToExternalize.getContent(), "Center");
        this.dockable.setDock(this);
        this.externalized = true;
        if (this.dockable.getState() != 16) {
            this.dockable.setState(16, this.getExternalizer());
        }
        if (this.dockable.isWithHeader()) {
            DragListener dragListener = DockingManager.getDockDragListenerFactory().createDragListener(this);
            this.header = DockingManager.getComponentFactory().createSingleDockHeader(this, 3);
            this.header.setDragListener(dragListener);
            this.add((Component)((Object)this.header), this.getBorderLayoutString(this.headerPosition));
        }
        this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, null, this, dockableToExternalize));
        SwingUtil.repaintParent(this);
    }

    public Externalizer getExternalizer() {
        if (this.isExternalized()) {
            return this.externalizer;
        }
        return null;
    }

    public void setExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    public boolean isExternalized() {
        return this.externalized;
    }

    public void clearGhosts() {
        if (this.ghostHeader != null) {
            this.ghostHeader = null;
        }
    }

    protected void getPriorityRectangle(Rectangle rectangle) {
        Dimension size = this.getSize();
        rectangle.setBounds((int)((double)size.width * priorityRectangleRelativeLeftOffset), (int)((double)size.height * priorityRectangleRelativeTopOffset), (int)((double)size.width * (1.0 - priorityRectangleRelativeLeftOffset - priorityRectangleRelativeRightOffset)), (int)((double)size.height * (1.0 - priorityRectangleRelativeTopOffset - priorityRectangleRelativeBottomOffset)));
    }

    public int getHeaderPosition() {
        return this.headerPosition;
    }

    public void setHeaderPosition(int headerPosition) {
        this.headerPosition = headerPosition;
        if (this.header != null) {
            this.remove((Component)((Object)this.header));
            String borderLayoutString = this.getBorderLayoutString(headerPosition);
            this.add((Component)((Object)this.header), borderLayoutString);
        }
    }

    private Dockable getDeepestSingleChild(Dockable dockable) {
        if (dockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            if (compositeDockable.getDockableCount() == 1) {
                return this.getDeepestSingleChild(compositeDockable.getDockable(0));
            }
            return null;
        }
        return dockable;
    }

    private String getBorderLayoutString(int position) {
        switch (this.headerPosition) {
            case 3: {
                return "North";
            }
            case 4: {
                return "South";
            }
            case 2: {
                return "East";
            }
            case 1: {
                return "West";
            }
        }
        throw new IllegalArgumentException("Illegal header position.");
    }
}

