/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock;

import com.javadocking.DockingManager;
import com.javadocking.component.DockHeader;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.Position;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragListener;
import com.javadocking.event.DockableEvent;
import com.javadocking.event.DockingEventSupport;
import com.javadocking.event.DockingListener;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.util.SwingUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LineDock
extends JPanel
implements LeafDock {
    private static final String PROPERTY_DOCKABLE_IDS = "dockableIds";
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private static final int priorityBorder = 10;
    private static final double priorityRectangleRelativeOffset = 0.25;
    private CompositeDock parentDock;
    private List childDockables = new ArrayList();
    private DockHeader handle;
    private int orientation = 0;
    private boolean grid;
    private int horizontalDockingMode = 256;
    private int verticalDockingMode = 512;
    private boolean addCompositeDockables = true;
    private Rectangle priorityRectangle = new Rectangle();
    private Rectangle helpRectangle = new Rectangle();
    private Point dockablePanelPosition = new Point();
    private Point dockablePosition = new Point();
    private JPanel dockablePanel;
    private DockingEventSupport dockingEventSupport = new DockingEventSupport();
    private boolean realSizeRectangle = true;

    public LineDock() {
        this(0, false);
    }

    public LineDock(int orientation, boolean grid) {
        this(orientation, grid, 256, 512);
    }

    public LineDock(int orientation, boolean grid, int horizontalDockingMode, int verticalDockingMode) {
        this.orientation = orientation;
        this.grid = grid;
        this.horizontalDockingMode = horizontalDockingMode;
        this.verticalDockingMode = verticalDockingMode;
        DragListener dragListener = DockingManager.getDockDragListenerFactory().createDragListener(this);
        int handlePosition = 1;
        if (orientation == 1) {
            handlePosition = 3;
        }
        this.handle = DockingManager.getComponentFactory().createDockHeader(this, handlePosition);
        this.handle.setDragListener(dragListener);
        this.initializeUi();
    }

    public int getDockPriority(Dockable dockable, Point relativeLocation) {
        if (!this.checkDockingModes(dockable)) {
            return 0;
        }
        if (dockable.getContent() != null) {
            if (this.canAddDockableWithPriority(dockable, relativeLocation)) {
                return 3;
            }
            return 2;
        }
        if (dockable instanceof CompositeDockable) {
            if (!this.addCompositeDockables && !this.isEmpty()) {
                return 0;
            }
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            ArrayList childrenOfDockable = new ArrayList();
            ArrayList childrenOfDock = new ArrayList();
            DockingUtil.retrieveDockables(dockable, childrenOfDockable);
            DockingUtil.retrieveDockables(this, childrenOfDock);
            if (this.sameElements(childrenOfDockable, childrenOfDock)) {
                return 0;
            }
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dockable childDockable = compositeDockable.getDockable(index);
                if (childDockable.getContent() != null) continue;
                return 0;
            }
            if (this.canAddDockableWithPriority(dockable, relativeLocation)) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public int retrieveDockingRectangle(Dockable dockable, Point relativeLocation, Point dockableOffset, Rectangle rectangle) {
        int priority = this.getDockPriority(dockable, relativeLocation);
        if (priority != 0) {
            if (this.childDockables.size() == 0) {
                if (this.realSizeRectangle) {
                    if (this.orientation == 0) {
                        int width = 0;
                        width = dockable instanceof CompositeDockable ? DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)((CompositeDockable)dockable), (int)256).width : dockable.getContent().getPreferredSize().width;
                        rectangle.setBounds(0, 0, width, this.getSize().height);
                    } else {
                        int height = 0;
                        height = dockable instanceof CompositeDockable ? DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)((CompositeDockable)dockable), (int)512).height : dockable.getContent().getPreferredSize().height;
                        rectangle.setBounds(0, 0, this.getSize().width, height);
                    }
                } else {
                    rectangle.setBounds(0, 0, this.getSize().width, this.getSize().height);
                }
            } else {
                this.dockablePanelPosition.setLocation(relativeLocation);
                this.dockablePanelPosition = SwingUtilities.convertPoint(this, this.dockablePanelPosition, this.dockablePanel);
                for (int index = 0; index < this.childDockables.size(); ++index) {
                    Component dockableComponent = ((Dockable)this.childDockables.get(index)).getContent();
                    this.dockablePosition.setLocation(dockableComponent.getLocation().x, dockableComponent.getLocation().y);
                    rectangle.setLocation(this.dockablePosition);
                    rectangle.setSize(dockableComponent.getSize().width, dockableComponent.getSize().height);
                    if (!rectangle.contains(this.dockablePanelPosition)) continue;
                    if (index == this.childDockables.size() - 1) {
                        if (this.orientation == 0) {
                            this.dockablePosition.setLocation(dockableComponent.getLocation().x + dockableComponent.getSize().width / 2, dockableComponent.getLocation().y);
                            rectangle.setLocation(this.dockablePosition);
                            if (this.realSizeRectangle) {
                                rectangle.setSize(dockableComponent.getSize().width, dockableComponent.getSize().height);
                            } else {
                                rectangle.setSize(dockableComponent.getSize().width / 2, dockableComponent.getSize().height);
                            }
                            if (rectangle.contains(this.dockablePanelPosition)) {
                                if (this.realSizeRectangle) {
                                    this.dockablePosition.setLocation(dockableComponent.getLocation().x + dockableComponent.getSize().width, dockableComponent.getLocation().y);
                                }
                            } else {
                                this.dockablePosition.setLocation(dockableComponent.getLocation().x, dockableComponent.getLocation().y);
                                rectangle.setLocation(this.dockablePosition);
                                rectangle.setSize(dockableComponent.getSize().width, dockableComponent.getSize().height);
                            }
                        } else {
                            this.dockablePosition.setLocation(dockableComponent.getLocation().x, dockableComponent.getLocation().y + dockableComponent.getSize().height / 2);
                            rectangle.setLocation(this.dockablePosition);
                            if (this.realSizeRectangle) {
                                rectangle.setSize(dockableComponent.getSize().width, dockableComponent.getSize().height);
                            } else {
                                rectangle.setSize(dockableComponent.getSize().width, dockableComponent.getSize().height / 2);
                            }
                            if (rectangle.contains(this.dockablePanelPosition)) {
                                if (this.realSizeRectangle) {
                                    this.dockablePosition.setLocation(dockableComponent.getLocation().x, dockableComponent.getLocation().y + dockableComponent.getSize().height);
                                }
                            } else {
                                this.dockablePosition.setLocation(dockableComponent.getLocation().x, dockableComponent.getLocation().y);
                                rectangle.setLocation(this.dockablePosition);
                                rectangle.setSize(dockableComponent.getSize().width, dockableComponent.getSize().height);
                            }
                        }
                    }
                    if (dockable instanceof CompositeDockable) {
                        CompositeDockable compositeDockable = (CompositeDockable)dockable;
                        if (this.realSizeRectangle) {
                            if (this.orientation == 0) {
                                int width = DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)compositeDockable, (int)256).width;
                                rectangle.setSize(width, dockableComponent.getSize().height);
                            } else {
                                int height = DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)compositeDockable, (int)512).height;
                                rectangle.setSize(dockableComponent.getSize().width, height);
                            }
                        } else {
                            Dimension rectangleSize = new Dimension(dockableComponent.getSize().width, dockableComponent.getSize().height);
                            for (int childIndex = 1; childIndex < compositeDockable.getDockableCount() && childIndex + index < this.childDockables.size(); ++childIndex) {
                                Component nextDockableComponent = ((Dockable)this.childDockables.get(index + childIndex)).getContent();
                                if (this.orientation == 0) {
                                    rectangleSize.setSize(rectangleSize.getSize().width + nextDockableComponent.getSize().width, rectangleSize.getSize().height);
                                    continue;
                                }
                                rectangleSize.setSize(rectangleSize.getSize().width, rectangleSize.getSize().height + nextDockableComponent.getSize().height);
                            }
                            rectangle.setSize(rectangleSize);
                        }
                    } else if (this.realSizeRectangle) {
                        if (this.orientation == 0) {
                            Dimension rectangleSize = new Dimension(dockable.getContent().getPreferredSize().width, dockableComponent.getSize().height);
                            rectangle.setSize(rectangleSize);
                        } else {
                            Dimension rectangleSize = new Dimension(dockableComponent.getSize().width, dockable.getContent().getPreferredSize().height);
                            rectangle.setSize(rectangleSize);
                        }
                    }
                    this.dockablePosition = SwingUtilities.convertPoint(this.dockablePanel, this.dockablePosition, this);
                    rectangle.setLocation(this.dockablePosition);
                    return priority;
                }
                if (this.realSizeRectangle) {
                    if (this.orientation == 0) {
                        Component dockableComponent = ((Dockable)this.childDockables.get(this.childDockables.size() - 1)).getContent();
                        this.dockablePosition.setLocation(dockableComponent.getLocation().x + dockableComponent.getSize().width, dockableComponent.getLocation().y);
                        this.dockablePosition = SwingUtilities.convertPoint(this.dockablePanel, this.dockablePosition, this);
                        int width = 0;
                        width = dockable instanceof CompositeDockable ? DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)((CompositeDockable)dockable), (int)256).width : dockable.getContent().getPreferredSize().width;
                        rectangle.setLocation(this.dockablePosition);
                        rectangle.setSize(width, dockableComponent.getSize().height);
                        return priority;
                    }
                    Component dockableComponent = ((Dockable)this.childDockables.get(this.childDockables.size() - 1)).getContent();
                    this.dockablePosition.setLocation(dockableComponent.getLocation().x, dockableComponent.getLocation().y + dockableComponent.getSize().height);
                    this.dockablePosition = SwingUtilities.convertPoint(this.dockablePanel, this.dockablePosition, this);
                    int height = 0;
                    height = dockable instanceof CompositeDockable ? DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)((CompositeDockable)dockable), (int)512).height : dockable.getContent().getPreferredSize().height;
                    rectangle.setLocation(this.dockablePosition);
                    rectangle.setSize(dockableComponent.getSize().width, height);
                    return priority;
                }
                if (this.orientation == 0) {
                    Component dockableComponent = ((Dockable)this.childDockables.get(this.childDockables.size() - 1)).getContent();
                    this.dockablePosition.setLocation(dockableComponent.getLocation().x + dockableComponent.getSize().width / 2, dockableComponent.getLocation().y);
                    this.dockablePosition = SwingUtilities.convertPoint(this.dockablePanel, this.dockablePosition, this);
                    rectangle.setLocation(this.dockablePosition);
                    rectangle.setSize(dockableComponent.getSize().width / 2, dockableComponent.getSize().height);
                    return priority;
                }
                Component dockableComponent = ((Dockable)this.childDockables.get(this.childDockables.size() - 1)).getContent();
                this.dockablePosition.setLocation(dockableComponent.getLocation().x, dockableComponent.getLocation().y + dockableComponent.getSize().height / 2);
                this.dockablePosition = SwingUtilities.convertPoint(this.dockablePanel, this.dockablePosition, this);
                rectangle.setLocation(this.dockablePosition);
                rectangle.setSize(dockableComponent.getSize().width, dockableComponent.getSize().height / 2);
                return priority;
            }
        }
        return priority;
    }

    public boolean addDockable(Dockable dockableToAdd, Point relativeLocation, Point dockableOffset) {
        if (this.getDockPriority(dockableToAdd, relativeLocation) == 0) {
            return false;
        }
        int position = this.getDockPosition(dockableToAdd, relativeLocation);
        if (dockableToAdd instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockableToAdd;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                this.addDockable(compositeDockable.getDockable(index), new Position(position));
                ++position;
            }
            dockableToAdd.setState(1, this);
            SwingUtil.repaintParent(this);
            return true;
        }
        this.addDockable(dockableToAdd, new Position(position));
        SwingUtil.repaintParent(this);
        return true;
    }

    public boolean canRemoveDockable(Dockable dockable) {
        if (dockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                if (this.childDockables.contains(compositeDockable.getDockable(index))) continue;
                return false;
            }
            return true;
        }
        return this.childDockables.contains(dockable);
    }

    public boolean removeDockable(Dockable dockable) {
        if (!this.canRemoveDockable(dockable)) {
            return false;
        }
        if (dockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dockable childDockable = compositeDockable.getDockable(index);
                this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, this, null, childDockable));
                this.dockablePanel.remove(childDockable.getContent());
                this.childDockables.remove(childDockable);
                childDockable.setState(2, null);
                this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, this, null, childDockable));
            }
            compositeDockable.setState(2, null);
            SwingUtil.repaintParent(this);
            return true;
        }
        this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, this, null, dockable));
        this.dockablePanel.remove(dockable.getContent());
        this.childDockables.remove(dockable);
        dockable.setState(2, null);
        this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, this, null, dockable));
        SwingUtil.repaintParent(this);
        return true;
    }

    public boolean isEmpty() {
        return this.childDockables.size() == 0;
    }

    public boolean isFull() {
        return false;
    }

    public CompositeDock getParentDock() {
        return this.parentDock;
    }

    public void setParentDock(CompositeDock parentDock) {
        this.parentDock = parentDock;
    }

    public void saveProperties(String prefix, Properties properties, Map childDockIds) {
        PropertiesUtil.setInteger(properties, prefix + "orientation", this.orientation);
        PropertiesUtil.setBoolean(properties, prefix + "grid", this.grid);
        String[] dockableIdArray = new String[this.childDockables.size()];
        for (int index = 0; index < dockableIdArray.length; ++index) {
            dockableIdArray[index] = ((Dockable)this.childDockables.get(index)).getID();
        }
        PropertiesUtil.setStringArray(properties, prefix + PROPERTY_DOCKABLE_IDS, dockableIdArray);
        PropertiesUtil.setInteger(properties, prefix + "horizontalDockingMode", this.horizontalDockingMode);
        PropertiesUtil.setInteger(properties, prefix + "verticalDockingMode", this.verticalDockingMode);
    }

    public void loadProperties(String prefix, Properties properties, Map newChildDocks, Map dockablesMap, Window owner) throws IOException {
        int horizontalDockingMode = 256;
        int verticalDockingMode = 512;
        horizontalDockingMode = PropertiesUtil.getInteger(properties, prefix + "horizontalDockingMode", horizontalDockingMode);
        verticalDockingMode = PropertiesUtil.getInteger(properties, prefix + "verticalDockingMode", verticalDockingMode);
        this.setHorizontalDockingMode(horizontalDockingMode);
        this.setVerticalDockingMode(verticalDockingMode);
        int orientation = 0;
        boolean grid = false;
        orientation = PropertiesUtil.getInteger(properties, prefix + "orientation", orientation);
        grid = PropertiesUtil.getBoolean(properties, prefix + "grid", grid);
        this.setOrientation(orientation);
        this.setGrid(grid);
        String[] dockableIdArray = new String[]{};
        dockableIdArray = PropertiesUtil.getStringArray(properties, prefix + PROPERTY_DOCKABLE_IDS, dockableIdArray);
        int position = 0;
        for (int index = 0; index < dockableIdArray.length; ++index) {
            Object dockableObject = dockablesMap.get(dockableIdArray[index]);
            if (dockableObject == null) continue;
            if (dockableObject instanceof Dockable) {
                Dockable dockable = (Dockable)dockableObject;
                this.addDockable(dockable, new Position(position));
                ++position;
                continue;
            }
            throw new IOException("The values in the dockables mapping should be of type com.javadocking.Dockable.");
        }
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingEventSupport.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingEventSupport.removeDockingListener(listener);
    }

    public int getDockableCount() {
        return this.childDockables.size();
    }

    public Dockable getDockable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getDockableCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return (Dockable)this.childDockables.get(index);
    }

    public boolean containsDockable(Dockable dockable) {
        return this.childDockables.contains(dockable);
    }

    public boolean moveDockable(Dockable dockableToMove, Point relativeLocation) {
        int previousDockableIndex;
        if (dockableToMove instanceof CompositeDockable) {
            return false;
        }
        if (!this.childDockables.contains(dockableToMove)) {
            throw new IllegalArgumentException("The dockable should be docked in this dock.");
        }
        int newDockableIndex = this.getDockPosition(dockableToMove, relativeLocation);
        if (newDockableIndex < 0 || newDockableIndex >= this.childDockables.size()) {
            newDockableIndex = this.childDockables.size() - 1;
        }
        if ((previousDockableIndex = this.childDockables.indexOf(dockableToMove)) == newDockableIndex) {
            return false;
        }
        this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, this, this, dockableToMove));
        this.childDockables.remove(dockableToMove);
        this.childDockables.add(newDockableIndex, dockableToMove);
        this.rebuildUI();
        this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, this, this, dockableToMove));
        SwingUtil.repaintParent(this);
        return true;
    }

    public Position getDockablePosition(Dockable dockable) throws IllegalArgumentException {
        int position = this.childDockables.indexOf(dockable);
        if (position >= 0) {
            return new Position(position);
        }
        throw new IllegalArgumentException("The dockable is not docked in this dock.");
    }

    public void addDockable(Dockable dockable, Position position) {
        if (dockable instanceof CompositeDockable) {
            if (!this.addCompositeDockables && !this.isEmpty()) {
                return;
            }
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            for (int index = compositeDockable.getDockableCount() - 1; index > 0; --index) {
                this.addDockable(compositeDockable.getDockable(index), position);
            }
            return;
        }
        int linePosition = this.getDockableCount();
        if (position.getDimensions() == 1 && position.getPosition(0) >= 0 && position.getPosition(0) <= this.getDockableCount()) {
            linePosition = position.getPosition(0);
        }
        this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, null, this, dockable));
        this.childDockables.add(linePosition, dockable);
        dockable.setState(1, this);
        this.setLastDockingMode(dockable);
        this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, null, this, dockable));
        this.dockablePanel.removeAll();
        for (int index = 0; index < this.childDockables.size(); ++index) {
            this.dockablePanel.add(((Dockable)this.childDockables.get(index)).getContent());
        }
        SwingUtil.repaintParent(this);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int newOrientation) {
        if (newOrientation != this.orientation) {
            this.orientation = newOrientation;
            if (this.orientation == 0) {
                this.handle.setPosition(1);
            } else {
                this.handle.setPosition(3);
            }
            this.rebuildUI();
        }
    }

    public boolean getGrid() {
        return this.grid;
    }

    public void setGrid(boolean newGrid) {
        if (newGrid != this.grid) {
            this.grid = newGrid;
            this.rebuildUI();
        }
    }

    public boolean isAddCompositeDockables() {
        return this.addCompositeDockables;
    }

    public void setAddCompositeDockables(boolean addCompositeDockables) {
        this.addCompositeDockables = addCompositeDockables;
    }

    protected boolean checkDockingModes(Dockable dockable) {
        int dockPositions = dockable.getDockingModes();
        if (this.getOrientation() == 0 && (dockPositions & this.horizontalDockingMode) == 0) {
            return false;
        }
        return this.getOrientation() != 1 || (dockPositions & this.verticalDockingMode) != 0;
    }

    private void setLastDockingMode(Dockable dockable) {
        if (this.getOrientation() == 0) {
            dockable.setLastDockingMode(this.horizontalDockingMode);
        }
        if (this.getOrientation() == 1) {
            dockable.setLastDockingMode(this.verticalDockingMode);
        }
    }

    private int getDockPosition(Dockable newDockable, Point relativePosition) {
        if (this.childDockables.size() == 0) {
            return 0;
        }
        this.dockablePanelPosition.setLocation(relativePosition);
        this.dockablePanelPosition = SwingUtilities.convertPoint(this, this.dockablePanelPosition, this.dockablePanel);
        for (int index = 0; index < this.childDockables.size(); ++index) {
            Component dockableComponent = ((Dockable)this.childDockables.get(index)).getContent();
            this.dockablePosition.setLocation(dockableComponent.getLocation().x, dockableComponent.getLocation().y);
            this.helpRectangle.setBounds(dockableComponent.getLocation().x, dockableComponent.getLocation().y, dockableComponent.getSize().width, dockableComponent.getSize().height);
            if (!this.helpRectangle.contains(this.dockablePanelPosition)) continue;
            if (index == this.childDockables.size() - 1) {
                if (this.orientation == 0) {
                    this.helpRectangle.setBounds(dockableComponent.getLocation().x + dockableComponent.getSize().width / 2, dockableComponent.getLocation().y, dockableComponent.getSize().width / 2, dockableComponent.getSize().height);
                    if (this.helpRectangle.contains(this.dockablePanelPosition)) {
                        return this.childDockables.size();
                    }
                } else {
                    this.helpRectangle.setBounds(dockableComponent.getLocation().x, dockableComponent.getLocation().y + dockableComponent.getSize().height / 2, dockableComponent.getSize().width, dockableComponent.getSize().height / 2);
                    if (this.helpRectangle.contains(this.dockablePanelPosition)) {
                        return this.childDockables.size();
                    }
                }
            }
            return index;
        }
        return this.childDockables.size();
    }

    protected boolean canAddDockableWithPriority(Dockable dockable, Point relativeLocation) {
        if (this.childDockables.size() == 0) {
            Dimension size = this.getSize();
            this.priorityRectangle.setBounds((int)((double)size.width * 0.25), (int)((double)size.height * 0.25), (int)((double)size.width * 0.5), (int)((double)size.height * 0.5));
            return this.priorityRectangle.contains(relativeLocation);
        }
        this.dockablePanelPosition.setLocation(relativeLocation);
        this.dockablePanelPosition = SwingUtilities.convertPoint(this, this.dockablePanelPosition, this.dockablePanel);
        for (int index = 0; index < this.childDockables.size(); ++index) {
            Component dockableComponent = ((Dockable)this.childDockables.get(index)).getContent();
            this.dockablePosition.setLocation(dockableComponent.getLocation().x + 10, dockableComponent.getLocation().y + 10);
            this.helpRectangle.setBounds(dockableComponent.getLocation().x, dockableComponent.getLocation().y, dockableComponent.getSize().width - 20, dockableComponent.getSize().height - 20);
            if (!this.helpRectangle.contains(this.dockablePanelPosition)) continue;
            return true;
        }
        return false;
    }

    private void initializeUi() {
        this.dockablePanel = new JPanel();
        if (this.grid) {
            if (this.orientation == 1) {
                this.dockablePanel.setLayout(new GridLayout(0, 1));
            } else {
                this.dockablePanel.setLayout(new GridLayout(1, 0));
            }
        } else if (this.orientation == 1) {
            this.dockablePanel.setLayout(new BoxLayout(this.dockablePanel, 1));
        } else {
            this.dockablePanel.setLayout(new BoxLayout(this.dockablePanel, 0));
        }
        if (this.orientation == 1) {
            this.setLayout(new BoxLayout(this, 1));
        } else {
            this.setLayout(new BoxLayout(this, 0));
        }
        this.add((JComponent)((Object)this.handle));
        this.add(this.dockablePanel);
    }

    private void rebuildUI() {
        this.removeAll();
        this.initializeUi();
        for (int index = 0; index < this.childDockables.size(); ++index) {
            Dockable childDockable = (Dockable)this.childDockables.get(index);
            this.dockablePanel.add(childDockable.getContent());
        }
    }

    private boolean sameElements(List firstList, List secondList) {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        for (int index = 0; index < firstList.size(); ++index) {
            if (secondList.contains(firstList.get(index))) continue;
            return false;
        }
        return true;
    }

    public int getHorizontalDockingMode() {
        return this.horizontalDockingMode;
    }

    public void setHorizontalDockingMode(int horizontalDockingMode) {
        this.horizontalDockingMode = horizontalDockingMode;
    }

    public int getVerticalDockingMode() {
        return this.verticalDockingMode;
    }

    public void setVerticalDockingMode(int verticalDockingMode) {
        this.verticalDockingMode = verticalDockingMode;
    }

    public boolean getRealSizeRectangle() {
        return this.realSizeRectangle;
    }

    public void setRealSizeRectangle(boolean realSizeRectangle) {
        this.realSizeRectangle = realSizeRectangle;
    }
}

