/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock;

import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.util.PropertiesUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class HidableFloatDock
extends FloatDock {
    private static final String PROPERTY_HIDDEN = "hidden";
    private boolean hidden = false;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public HidableFloatDock() {
    }

    public HidableFloatDock(Window owner) {
        super(owner);
    }

    public HidableFloatDock(Window owner, DockFactory childDockFactory) {
        super(owner, childDockFactory);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        boolean oldValue = this.hidden;
        this.hidden = hidden;
        this.hide(hidden);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_HIDDEN, oldValue, hidden);
    }

    public void addChildDock(Dock dock, Point location, Dimension size) {
        super.addChildDock(dock, location, size);
        Window window = (Window)this.getChildDockWindows().get(dock);
        if (window != null && this.hidden) {
            window.setVisible(!this.hidden);
        }
    }

    public void loadProperties(String prefix, Properties properties, Map newChildDocks, Map dockablesMap, Window owner) throws IOException {
        this.hidden = PropertiesUtil.getBoolean(properties, prefix + PROPERTY_HIDDEN, this.hidden);
        super.loadProperties(prefix, properties, newChildDocks, dockablesMap, owner);
    }

    public void saveProperties(String prefix, Properties properties, Map childDockIds) {
        PropertiesUtil.setBoolean(properties, prefix + PROPERTY_HIDDEN, this.hidden);
        super.saveProperties(prefix, properties, childDockIds);
    }

    private void hide(boolean hidden) {
        Map childDockWindows = this.getChildDockWindows();
        Iterator iterator = this.getChildDockWindows().values().iterator();
        while (iterator.hasNext()) {
            Window window = (Window)iterator.next();
            window.setVisible(!hidden);
        }
    }
}

