/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock;

import com.javadocking.DockingManager;
import com.javadocking.component.DockHeader;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.Position;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragListener;
import com.javadocking.event.DockableEvent;
import com.javadocking.event.DockingEventSupport;
import com.javadocking.event.DockingListener;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GridDock
extends JPanel
implements LeafDock {
    private static final String PROPERTY_DOCKABLE_IDS = "dockableIds";
    private static final int priorityBorder = 10;
    private static final double priorityRectangleRelativeOffset = 0.25;
    public static final int FILL_SQUARE_HORIZONTAL = 0;
    public static final int FILL_SQUARE_VERTICAL = 1;
    public static final int FILL_FLOW_HORIZONTAL = 2;
    public static final int FILL_FLOW_VERTICAL = 3;
    private CompositeDock parentDock;
    private int dockingMode = 1024;
    private List childDockables = new ArrayList();
    private DockHeader handle;
    private int columnCount = 1;
    private int fillMode = 2;
    private boolean addCompositeDockables = true;
    private Rectangle priorityRectangle = new Rectangle();
    private Rectangle helpRectangle = new Rectangle();
    private Point dockablePanelPosition = new Point();
    private Point dockablePosition = new Point();
    private JPanel dockablePanel;
    private DockingEventSupport dockingEventSupport = new DockingEventSupport();

    public GridDock() {
        this(1024);
    }

    public GridDock(int dockingMode) {
        super(new BorderLayout());
        this.dockingMode = dockingMode;
        DragListener dragListener = DockingManager.getDockDragListenerFactory().createDragListener(this);
        this.handle = DockingManager.getComponentFactory().createDockHeader(this, 1);
        this.handle.setDragListener(dragListener);
        this.initializeUi(1);
    }

    public int getDockPriority(Dockable dockable, Point relativeLocation) {
        if (!this.checkDockingModes(dockable)) {
            return 0;
        }
        if (dockable.getContent() != null) {
            if (this.canAddDockableWithPriority(dockable, relativeLocation)) {
                return 3;
            }
            return 2;
        }
        if (dockable instanceof CompositeDockable) {
            if (!this.addCompositeDockables && !this.isEmpty()) {
                return 0;
            }
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            ArrayList childrenOfDockable = new ArrayList();
            ArrayList childrenOfDock = new ArrayList();
            DockingUtil.retrieveDockables(dockable, childrenOfDockable);
            DockingUtil.retrieveDockables(this, childrenOfDock);
            if (this.sameElements(childrenOfDockable, childrenOfDock)) {
                return 0;
            }
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dockable childDockable = compositeDockable.getDockable(index);
                if (childDockable.getContent() != null) continue;
                return 0;
            }
            if (this.canAddDockableWithPriority(dockable, relativeLocation)) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public int retrieveDockingRectangle(Dockable dockable, Point relativeLocation, Point dockableOffset, Rectangle rectangle) {
        int priority = this.getDockPriority(dockable, relativeLocation);
        if (priority != 0) {
            if (this.childDockables.size() == 0) {
                rectangle.setBounds(0, 0, this.getSize().width, this.getSize().height);
            } else {
                this.dockablePanelPosition.setLocation(relativeLocation);
                this.dockablePanelPosition = SwingUtilities.convertPoint(this, this.dockablePanelPosition, this.dockablePanel);
                for (int index = 0; index < this.childDockables.size(); ++index) {
                    Component dockableComponent = ((Dockable)this.childDockables.get(index)).getContent();
                    this.dockablePosition.setLocation(dockableComponent.getLocation().x, dockableComponent.getLocation().y);
                    rectangle.setLocation(this.dockablePosition);
                    rectangle.setSize(dockableComponent.getSize().width, dockableComponent.getSize().height);
                    if (!rectangle.contains(this.dockablePanelPosition)) continue;
                    if (index == this.childDockables.size() - 1 && this.childDockables.size() % this.columnCount == 0) {
                        this.dockablePosition.setLocation(dockableComponent.getLocation().x + dockableComponent.getSize().width / 2, dockableComponent.getLocation().y);
                        rectangle.setLocation(this.dockablePosition);
                        rectangle.setSize(dockableComponent.getSize().width / 2, dockableComponent.getSize().height);
                        if (!rectangle.contains(this.dockablePanelPosition)) {
                            this.dockablePosition.setLocation(dockableComponent.getLocation().x, dockableComponent.getLocation().y);
                            rectangle.setLocation(this.dockablePosition);
                            rectangle.setSize(dockableComponent.getSize().width, dockableComponent.getSize().height);
                        }
                    }
                    this.dockablePosition = SwingUtilities.convertPoint(this.dockablePanel, this.dockablePosition, this);
                    rectangle.setLocation(this.dockablePosition);
                    return priority;
                }
                Component dockableComponent = ((Dockable)this.childDockables.get(this.childDockables.size() - 1)).getContent();
                if (this.childDockables.size() % this.columnCount == 0) {
                    this.dockablePosition.setLocation(dockableComponent.getLocation().x + dockableComponent.getSize().width / 2, dockableComponent.getLocation().y);
                    this.dockablePosition = SwingUtilities.convertPoint(this.dockablePanel, this.dockablePosition, this);
                    rectangle.setLocation(this.dockablePosition);
                    rectangle.setSize(dockableComponent.getSize().width / 2, dockableComponent.getSize().height);
                    return priority;
                }
                this.dockablePosition.setLocation(dockableComponent.getLocation().x + dockableComponent.getSize().width, dockableComponent.getLocation().y);
                this.dockablePosition = SwingUtilities.convertPoint(this.dockablePanel, this.dockablePosition, this);
                rectangle.setLocation(this.dockablePosition);
                int width = dockableComponent.getSize().width;
                if (this.childDockables.size() - this.columnCount >= 0) {
                    Component previousRowComponent = ((Dockable)this.childDockables.get(this.childDockables.size() - this.columnCount)).getContent();
                    width = previousRowComponent.getSize().width;
                }
                rectangle.setSize(width, dockableComponent.getSize().height);
            }
        }
        return priority;
    }

    public boolean addDockable(Dockable dockableToAdd, Point relativeLocation, Point dockableOffset) {
        if (this.getDockPriority(dockableToAdd, relativeLocation) == 0) {
            return false;
        }
        int position = this.getDockPosition(dockableToAdd, relativeLocation);
        if (dockableToAdd instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockableToAdd;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                this.addDockable(compositeDockable.getDockable(index), new Position(position));
                ++position;
            }
            dockableToAdd.setState(1, this);
            SwingUtil.repaintParent(this);
            return true;
        }
        this.addDockable(dockableToAdd, new Position(position));
        SwingUtil.repaintParent(this);
        return true;
    }

    public boolean canRemoveDockable(Dockable dockable) {
        if (dockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                if (this.childDockables.contains(compositeDockable.getDockable(index))) continue;
                return false;
            }
            return true;
        }
        return this.childDockables.contains(dockable);
    }

    public boolean removeDockable(Dockable dockable) {
        if (!this.canRemoveDockable(dockable)) {
            return false;
        }
        if (dockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dockable childDockable = compositeDockable.getDockable(index);
                this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, this, null, childDockable));
                this.dockablePanel.remove(childDockable.getContent());
                this.childDockables.remove(childDockable);
                childDockable.setState(2, null);
                this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, this, null, childDockable));
            }
            compositeDockable.setState(2, null);
            this.rebuildUI(this.calculateColumnCount());
            SwingUtil.repaintParent(this);
            return true;
        }
        this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, this, null, dockable));
        this.dockablePanel.remove(dockable.getContent());
        this.childDockables.remove(dockable);
        dockable.setState(2, null);
        this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, this, null, dockable));
        this.rebuildUI(this.calculateColumnCount());
        SwingUtil.repaintParent(this);
        return true;
    }

    public boolean isEmpty() {
        return this.childDockables.size() == 0;
    }

    public boolean isFull() {
        return false;
    }

    public CompositeDock getParentDock() {
        return this.parentDock;
    }

    public void setParentDock(CompositeDock parentDock) {
        this.parentDock = parentDock;
    }

    public void saveProperties(String prefix, Properties properties, Map childDockIds) {
        PropertiesUtil.setInteger(properties, prefix + "dockingMode", this.dockingMode);
        PropertiesUtil.setInteger(properties, prefix + "fillMode", this.fillMode);
        PropertiesUtil.setInteger(properties, prefix + "columnCount", this.columnCount);
        String[] dockableIdArray = new String[this.childDockables.size()];
        for (int index = 0; index < dockableIdArray.length; ++index) {
            dockableIdArray[index] = ((Dockable)this.childDockables.get(index)).getID();
        }
        PropertiesUtil.setStringArray(properties, prefix + PROPERTY_DOCKABLE_IDS, dockableIdArray);
    }

    public void loadProperties(String prefix, Properties properties, Map newChildDocks, Map dockablesMap, Window owner) throws IOException {
        int dockingMode = 1024;
        dockingMode = PropertiesUtil.getInteger(properties, prefix + "dockingMode", dockingMode);
        this.setDockingMode(dockingMode);
        int fillMode = 2;
        fillMode = PropertiesUtil.getInteger(properties, prefix + "fillMode", fillMode);
        this.setFillMode(fillMode);
        String[] dockableIdArray = new String[]{};
        dockableIdArray = PropertiesUtil.getStringArray(properties, prefix + PROPERTY_DOCKABLE_IDS, dockableIdArray);
        int position = 0;
        for (int index = 0; index < dockableIdArray.length; ++index) {
            Object dockableObject = dockablesMap.get(dockableIdArray[index]);
            if (dockableObject == null) continue;
            if (dockableObject instanceof Dockable) {
                Dockable dockable = (Dockable)dockableObject;
                this.addDockable(dockable, new Position(position));
                ++position;
                continue;
            }
            throw new IOException("The values in the dockables mapping should be of type com.javadocking.Dockable.");
        }
        int savedColumnCount = this.columnCount;
        savedColumnCount = PropertiesUtil.getInteger(properties, prefix + "columnCount", savedColumnCount);
        int savedRowCount = (int)Math.ceil((double)dockablesMap.size() / (double)savedColumnCount);
        while (dockablesMap.size() <= savedRowCount * (savedColumnCount - 1)) {
            --savedColumnCount;
        }
        if (savedColumnCount <= 0) {
            savedColumnCount = 1;
        }
        if (savedColumnCount != this.columnCount) {
            this.rebuildUI(savedColumnCount);
        }
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingEventSupport.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingEventSupport.removeDockingListener(listener);
    }

    public int getDockableCount() {
        return this.childDockables.size();
    }

    public Dockable getDockable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getDockableCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return (Dockable)this.childDockables.get(index);
    }

    public boolean containsDockable(Dockable dockable) {
        return this.childDockables.contains(dockable);
    }

    public boolean moveDockable(Dockable dockableToMove, Point relativeLocation) {
        int previousDockableIndex;
        if (dockableToMove instanceof CompositeDockable) {
            return false;
        }
        if (!this.childDockables.contains(dockableToMove)) {
            throw new IllegalArgumentException("The dockable should be docked in this dock.");
        }
        int newDockableIndex = this.getDockPosition(dockableToMove, relativeLocation);
        if (newDockableIndex < 0 || newDockableIndex >= this.childDockables.size()) {
            newDockableIndex = this.childDockables.size() - 1;
        }
        if ((previousDockableIndex = this.childDockables.indexOf(dockableToMove)) == newDockableIndex) {
            return false;
        }
        this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, this, this, dockableToMove));
        this.childDockables.remove(dockableToMove);
        this.childDockables.add(newDockableIndex, dockableToMove);
        this.rebuildUI(this.calculateColumnCount());
        this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, this, this, dockableToMove));
        SwingUtil.repaintParent(this);
        return true;
    }

    public Position getDockablePosition(Dockable dockable) throws IllegalArgumentException {
        int position = this.childDockables.indexOf(dockable);
        if (position >= 0) {
            return new Position(position);
        }
        throw new IllegalArgumentException("The dockable is not docked in this dock.");
    }

    public void addDockable(Dockable dockable, Position position) {
        if (dockable instanceof CompositeDockable) {
            if (!this.addCompositeDockables && !this.isEmpty()) {
                return;
            }
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            for (int index = compositeDockable.getDockableCount() - 1; index > 0; --index) {
                this.addDockable(compositeDockable.getDockable(index), position);
            }
            return;
        }
        int linePosition = this.getDockableCount();
        if (position.getDimensions() == 1 && position.getPosition(0) >= 0 && position.getPosition(0) <= this.getDockableCount()) {
            linePosition = position.getPosition(0);
        }
        this.dockingEventSupport.fireDockingWillChange(new DockableEvent(this, null, this, dockable));
        this.childDockables.add(linePosition, dockable);
        dockable.setState(1, this);
        this.setLastDockingMode(dockable);
        this.rebuildUI(this.calculateColumnCount());
        this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, null, this, dockable));
        SwingUtil.repaintParent(this);
    }

    public int getFillMode() {
        return this.fillMode;
    }

    public void setFillMode(int newFillMode) {
        if (newFillMode != this.fillMode) {
            this.fillMode = newFillMode;
            this.rebuildUI(this.calculateColumnCount());
        }
    }

    public boolean isAddCompositeDockables() {
        return this.addCompositeDockables;
    }

    public void setAddCompositeDockables(boolean addCompositeDockables) {
        this.addCompositeDockables = addCompositeDockables;
    }

    protected int getDockPosition(Dockable newDockable, Point relativeLocation) {
        if (this.childDockables.size() == 0) {
            return 0;
        }
        this.dockablePanelPosition.setLocation(relativeLocation);
        this.dockablePanelPosition = SwingUtilities.convertPoint(this, this.dockablePanelPosition, this.dockablePanel);
        for (int index = 0; index < this.childDockables.size(); ++index) {
            Component dockableComponent = ((Dockable)this.childDockables.get(index)).getContent();
            this.dockablePosition.setLocation(dockableComponent.getLocation().x, dockableComponent.getLocation().y);
            this.helpRectangle.setBounds(dockableComponent.getLocation().x, dockableComponent.getLocation().y, dockableComponent.getSize().width, dockableComponent.getSize().height);
            if (!this.helpRectangle.contains(this.dockablePanelPosition)) continue;
            if (index == this.childDockables.size() - 1 && this.childDockables.size() % this.columnCount == 0) {
                this.helpRectangle.setBounds(dockableComponent.getLocation().x + dockableComponent.getSize().width / 2, dockableComponent.getLocation().y, dockableComponent.getSize().width / 2, dockableComponent.getSize().height);
                if (this.helpRectangle.contains(this.dockablePanelPosition)) {
                    return this.childDockables.size();
                }
            }
            return index;
        }
        return this.childDockables.size();
    }

    protected boolean canAddDockableWithPriority(Dockable dockable, Point relativeLocation) {
        if (this.childDockables.size() == 0) {
            Dimension size = this.getSize();
            this.priorityRectangle.setBounds((int)((double)size.width * 0.25), (int)((double)size.height * 0.25), (int)((double)size.width * 0.5), (int)((double)size.height * 0.5));
            return this.priorityRectangle.contains(relativeLocation);
        }
        this.dockablePanelPosition.setLocation(relativeLocation);
        this.dockablePanelPosition = SwingUtilities.convertPoint(this, this.dockablePanelPosition, this.dockablePanel);
        for (int index = 0; index < this.childDockables.size(); ++index) {
            Component dockableComponent = ((Dockable)this.childDockables.get(index)).getContent();
            this.dockablePosition.setLocation(dockableComponent.getLocation().x, dockableComponent.getLocation().y);
            this.priorityRectangle.setBounds(dockableComponent.getLocation().x + 10, dockableComponent.getLocation().y + 10, dockableComponent.getSize().width - 20, dockableComponent.getSize().height - 20);
            if (!this.priorityRectangle.contains(this.dockablePanelPosition)) continue;
            return true;
        }
        Component dockableComponent = ((Dockable)this.childDockables.get(this.childDockables.size() - 1)).getContent();
        this.priorityRectangle.setBounds(dockableComponent.getLocation().x + 10, dockableComponent.getLocation().y + 10, dockableComponent.getSize().width - 20, dockableComponent.getSize().height - 20);
        if (this.childDockables.size() < this.columnCount * this.columnCount) {
            this.priorityRectangle.setLocation(dockableComponent.getLocation().x + 10 + dockableComponent.getSize().width, dockableComponent.getLocation().y + 10);
            if (this.priorityRectangle.contains(this.dockablePanelPosition)) {
                return true;
            }
        }
        return false;
    }

    protected int calculateColumnCount() {
        int dockableCount = this.childDockables.size();
        if (dockableCount == 0) {
            return 1;
        }
        if (this.getSize().width == 0 || this.getSize().height == 0 || this.fillMode == 0 || this.fillMode == 1) {
            int newColumnCount = (int)Math.ceil(Math.sqrt(this.childDockables.size()));
            if (this.fillMode == 1 && (newColumnCount - 1) * newColumnCount >= this.childDockables.size()) {
                --newColumnCount;
            }
            if (newColumnCount <= 0) {
                newColumnCount = 1;
            }
            return newColumnCount;
        }
        Dimension maxPreferredSize = new Dimension(0, 0);
        for (int index = 0; index < dockableCount; ++index) {
            Dimension childSize = ((Dockable)this.childDockables.get(index)).getContent().getPreferredSize();
            maxPreferredSize.setSize(Math.max(maxPreferredSize.width, childSize.width), Math.max(maxPreferredSize.height, childSize.height));
        }
        if (maxPreferredSize.width <= 0) {
            maxPreferredSize.width = 1;
        }
        if (maxPreferredSize.height <= 0) {
            maxPreferredSize.height = 1;
        }
        if (this.fillMode == 2) {
            int newColumnCount = (int)Math.ceil(Math.sqrt((double)(this.getSize().width * maxPreferredSize.height * dockableCount) / (double)(this.getSize().height * maxPreferredSize.width)));
            if (newColumnCount <= 0) {
                newColumnCount = 1;
            }
            int newRowCount = (int)Math.ceil((double)dockableCount / (double)newColumnCount);
            while (dockableCount <= newRowCount * (newColumnCount - 1)) {
                --newColumnCount;
            }
            if (newColumnCount <= 0) {
                newColumnCount = 1;
            }
            return newColumnCount;
        }
        if (this.fillMode == 3) {
            int newRowCount = (int)Math.ceil(Math.sqrt((double)(this.getSize().height * maxPreferredSize.width * dockableCount) / (double)(this.getSize().width * maxPreferredSize.height)));
            if (newRowCount <= 0) {
                newRowCount = 1;
            }
            int newColCount = (int)Math.ceil((double)dockableCount / (double)newRowCount);
            return newColCount;
        }
        throw new IllegalStateException("The fill mode [" + this.fillMode + "] is unknown.");
    }

    private void initializeUi(int newColumnCount) {
        this.columnCount = newColumnCount;
        this.setLayout(new BoxLayout(this, 0));
        this.dockablePanel = new JPanel();
        this.dockablePanel.setLayout(new GridLayout(0, newColumnCount));
        this.add((JComponent)((Object)this.handle));
        this.add(this.dockablePanel);
    }

    private void rebuildUI(int columnCount) {
        this.removeAll();
        this.initializeUi(columnCount);
        for (int index = 0; index < this.childDockables.size(); ++index) {
            Dockable childDockable = (Dockable)this.childDockables.get(index);
            this.dockablePanel.add(childDockable.getContent());
        }
    }

    private boolean sameElements(List firstList, List secondList) {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        for (int index = 0; index < firstList.size(); ++index) {
            if (secondList.contains(firstList.get(index))) continue;
            return false;
        }
        return true;
    }

    private boolean checkDockingModes(Dockable dockable) {
        int dockPositions = dockable.getDockingModes();
        return (dockPositions & this.dockingMode) != 0;
    }

    private void setLastDockingMode(Dockable dockable) {
        dockable.setLastDockingMode(this.dockingMode);
    }

    public int getDockingMode() {
        return this.dockingMode;
    }

    public void setDockingMode(int dockingMode) {
        this.dockingMode = dockingMode;
    }
}

