/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock;

import com.javadocking.DockingManager;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.Position;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.dock.factory.SingleDockFactory;
import com.javadocking.dock.factory.SplitDockFactory;
import com.javadocking.dockable.Dockable;
import com.javadocking.event.ChildDockEvent;
import com.javadocking.event.DockingEventSupport;
import com.javadocking.event.DockingListener;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FloatDock
implements CompositeDock {
    private static final String PROPERTY_WINDOW_DIMENSION = "windowRectangle";
    private static final Point DEFAULT_WINDOW_LOCATION = new Point(30, 30);
    private DockFactory childDockFactory;
    private List childDocks = new LinkedList();
    private Map childDockWindows = new HashMap();
    private int dockPriority = 2;
    private Window owner;
    private WindowClosingListener windowClosingListener = new WindowClosingListener();
    private List windowFocusListeners = new ArrayList();
    private OwnerWindowListener ownerWindowListener = new OwnerWindowListener();
    private DockingEventSupport dockingEventSupport = new DockingEventSupport();
    private Dock ghostChildDock;

    public FloatDock() {
        this(null, new SplitDockFactory());
    }

    public FloatDock(Window owner) {
        this(owner, new SplitDockFactory());
    }

    public FloatDock(Window owner, DockFactory childDockFactory) {
        this.childDockFactory = childDockFactory;
        this.setOwner(owner);
    }

    public int getDockPriority(Dockable dockableToAdd, Point relativeLocation) {
        if ((dockableToAdd.getDockingModes() & 0x20) != 0 && this.childDockFactory.createDock(dockableToAdd, 32) != null) {
            return this.dockPriority;
        }
        return 0;
    }

    public int retrieveDockingRectangle(Dockable dockable, Point relativeLocation, Point dockableOffset, Rectangle rectangle) {
        int priority = this.getDockPriority(dockable, relativeLocation);
        if (priority != 0) {
            Dimension preferredSize = this.childDockFactory.getDockPreferredSize(dockable, 32);
            int offsetX = dockableOffset.x;
            int offsetY = dockableOffset.y;
            if (offsetX > preferredSize.width) {
                offsetX = preferredSize.width;
            }
            if (offsetY > preferredSize.height) {
                offsetY = preferredSize.height;
            }
            rectangle.setBounds(relativeLocation.x - offsetX, relativeLocation.y - offsetY, preferredSize.width, preferredSize.height);
        }
        return priority;
    }

    public boolean addDockable(Dockable dockableToAdd, Point relativeLocation, Point dockableOffset) {
        if (this.getDockPriority(dockableToAdd, relativeLocation) == 0) {
            return false;
        }
        Dock childDock = this.childDockFactory.createDock(dockableToAdd, 32);
        if (childDock == null) {
            return false;
        }
        childDock.setParentDock(this);
        childDock.addDockable(dockableToAdd, new Point(), dockableOffset);
        Dimension preferredSize = this.childDockFactory.getDockPreferredSize(dockableToAdd, 32);
        int offsetX = dockableOffset.x;
        int offsetY = dockableOffset.y;
        if (offsetX > preferredSize.width) {
            offsetX = preferredSize.width;
        }
        if (offsetY > preferredSize.height) {
            offsetY = preferredSize.height;
        }
        this.addChildDock(childDock, new Point(relativeLocation.x - offsetX, relativeLocation.y - offsetY), null);
        return true;
    }

    public boolean isEmpty() {
        return this.childDocks.size() == 0;
    }

    public boolean isFull() {
        return false;
    }

    public CompositeDock getParentDock() {
        return null;
    }

    public void setParentDock(CompositeDock parentDock) {
    }

    public void saveProperties(String prefix, Properties properties, Map childDockIds) {
        PropertiesUtil.setInteger(properties, prefix + "dockPriority", this.getDockPriority());
        String className = this.childDockFactory.getClass().getName();
        PropertiesUtil.setString(properties, prefix + "childDockFactory", className);
        this.childDockFactory.saveProperties(prefix + "childDockFactory.", properties);
        int[] dim = new int[2];
        for (int index = 0; index < this.childDocks.size(); ++index) {
            Dock dock = (Dock)this.childDocks.get(index);
            String childDockId = (String)childDockIds.get(dock);
            Window window = (Window)this.childDockWindows.get(dock);
            dim[0] = window.getSize().width;
            dim[1] = window.getSize().height;
            PropertiesUtil.setIntegerArray(properties, prefix + "childDock" + "." + childDockId + "." + PROPERTY_WINDOW_DIMENSION, dim);
            Position.setPositionProperty(properties, prefix + "childDock" + "." + childDockId + "." + "position", this.getChildDockPosition(dock));
        }
    }

    public void loadProperties(String prefix, Properties properties, Map newChildDocks, Map dockablesMap, Window owner) throws IOException {
        try {
            String className = SingleDockFactory.class.getName();
            className = PropertiesUtil.getString(properties, prefix + "childDockFactory", className);
            Class<?> clazz = Class.forName(className);
            this.childDockFactory = (DockFactory)clazz.newInstance();
            this.childDockFactory.loadProperties(prefix + "childDockFactory.", properties);
        }
        catch (ClassNotFoundException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        catch (IllegalAccessException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        catch (InstantiationException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        this.setOwner(owner);
        int dockPriority = 2;
        dockPriority = PropertiesUtil.getInteger(properties, prefix + "dockPriority", dockPriority);
        this.setDockPriority(dockPriority);
        String[] childDockIdsArray = new String[newChildDocks.keySet().size()];
        Iterator keyIterator = newChildDocks.keySet().iterator();
        while (keyIterator.hasNext()) {
            String childDockId = (String)keyIterator.next();
            Position position = null;
            position = Position.getPositionProperty(properties, prefix + "childDock" + "." + childDockId + "." + "position", position);
            childDockIdsArray[position.getPosition((int)2)] = childDockId;
        }
        for (int index = childDockIdsArray.length - 1; index >= 0; --index) {
            Dock dock = (Dock)newChildDocks.get(childDockIdsArray[index]);
            if (dock instanceof CompositeDock) {
                DockingUtil.removeEmptyChildren((CompositeDock)dock);
            }
            if (dock.isEmpty()) continue;
            int[] dim = null;
            dim = PropertiesUtil.getIntegerArray(properties, prefix + "childDock" + "." + childDockIdsArray[index] + "." + PROPERTY_WINDOW_DIMENSION, dim);
            Position position = null;
            position = Position.getPositionProperty(properties, prefix + "childDock" + "." + childDockIdsArray[index] + "." + "position", position);
            if (dim == null || dim.length != 2) continue;
            this.addChildDock(dock, new Point(position.getPosition(0), position.getPosition(1)), new Dimension(dim[0], dim[1]));
        }
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingEventSupport.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingEventSupport.removeDockingListener(listener);
    }

    public void emptyChild(Dock childDock) {
        if (this.childDocks.contains(childDock)) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, childDock));
            this.childDocks.remove(childDock);
            this.childDockWindows.remove(childDock);
            Window window = SwingUtilities.windowForComponent((Component)((Object)childDock));
            window.setVisible(false);
            window.dispose();
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, childDock));
        }
    }

    public void ghostChild(Dock childDock) {
        if (this.childDocks.contains(childDock)) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, childDock));
            this.childDocks.remove(childDock);
            this.childDockWindows.remove(childDock);
            this.ghostChildDock = childDock;
            Window window = SwingUtilities.windowForComponent((Component)((Object)childDock));
            window.setVisible(false);
        }
    }

    public void clearGhosts() {
        if (this.ghostChildDock != null) {
            Window window = SwingUtilities.windowForComponent((Component)((Object)this.ghostChildDock));
            window.setVisible(false);
            window.dispose();
            Dock oldGhostChildDock = this.ghostChildDock;
            this.ghostChildDock = null;
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, oldGhostChildDock));
        }
    }

    public int getChildDockCount() {
        return this.childDocks.size();
    }

    public Dock getChildDock(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getChildDockCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return (Dock)this.childDocks.get(index);
    }

    public Position getChildDockPosition(Dock childDock) throws IllegalArgumentException {
        Window window = (Window)this.childDockWindows.get(childDock);
        int index = this.childDocks.indexOf(childDock);
        if (index >= 0 && window != null) {
            int[] positions = new int[]{window.getLocation().x, window.getLocation().y, index};
            return new Position(positions);
        }
        throw new IllegalArgumentException("The dock is not docked in this composite dock.");
    }

    public void addChildDock(Dock dock, Position position) throws IllegalStateException {
        Point point = null;
        point = position.getDimensions() >= 2 ? new Point(position.getPosition(0), position.getPosition(1)) : new Point(0, 0);
        this.addChildDock(dock, point, null);
    }

    public DockFactory getChildDockFactory() {
        return this.childDockFactory;
    }

    public void setChildDockFactory(DockFactory childDockFactory) {
        if (childDockFactory == null) {
            throw new IllegalArgumentException("The child dock factory cannot be null.");
        }
        this.childDockFactory = childDockFactory;
    }

    public Window getOwner() {
        return this.owner;
    }

    public void setOwner(Window owner) {
        this.owner = owner;
        if (this.owner != null) {
            owner.addWindowListener(this.ownerWindowListener);
        }
    }

    protected Map getChildDockWindows() {
        return this.childDockWindows;
    }

    public int getDockPriority() {
        return this.dockPriority;
    }

    public void setDockPriority(int dockPriority) {
        this.dockPriority = dockPriority;
    }

    public void addWindowFocusListener(WindowFocusListener windowFocusListener) {
        this.windowFocusListeners.add(windowFocusListener);
    }

    public void removeWindowFocusListener(WindowFocusListener windowFocusListener) {
        this.windowFocusListeners.remove(windowFocusListener);
        Iterator iterator = this.childDockWindows.values().iterator();
        while (iterator.hasNext()) {
            Window window = (Window)iterator.next();
            window.removeWindowFocusListener(windowFocusListener);
        }
    }

    public void moveDock(Dock childDock, Point relativeLocation, Point dockableOffset) {
        this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, this, childDock));
        Point point = new Point(relativeLocation.x - dockableOffset.x, relativeLocation.y - dockableOffset.y);
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)childDock));
        window.setLocation(new Point(point.x, point.y));
        this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, this, childDock));
    }

    public void addChildDock(Dock dock, Point location, Dimension size) {
        this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, null, this, dock));
        Point point = new Point(location.x, location.y);
        this.checkFloatingWindowLocation(point);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(DockingManager.getComponentFactory().createFloatingBorder());
        panel.add((Component)((Object)dock), "Center");
        Window dialog = DockingManager.getComponentFactory().createWindow(this.owner);
        if (dialog instanceof JDialog) {
            ((JDialog)dialog).setContentPane(panel);
        } else {
            ((JFrame)dialog).setContentPane(panel);
        }
        dialog.addWindowFocusListener(new MoveToFrontListener(dock));
        Iterator iterator = this.windowFocusListeners.iterator();
        while (iterator.hasNext()) {
            dialog.addWindowFocusListener((WindowFocusListener)iterator.next());
        }
        dialog.addWindowListener(this.windowClosingListener);
        if (size != null) {
            dialog.setSize(size.width, size.height);
        } else {
            dialog.pack();
        }
        dialog.setLocation(point.x - dialog.getInsets().left, point.y - dialog.getInsets().top);
        this.childDockWindows.put(dock, dialog);
        dock.setParentDock(this);
        this.childDocks.add(0, dock);
        this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, null, this, dock));
        dialog.setVisible(true);
    }

    protected void getDefaultFloatingWindowLocation(Point location) {
        location.move(FloatDock.DEFAULT_WINDOW_LOCATION.x, FloatDock.DEFAULT_WINDOW_LOCATION.y);
    }

    private void checkFloatingWindowLocation(Point location) {
        if (!SwingUtil.isLocationInScreenBounds(location)) {
            this.getDefaultFloatingWindowLocation(location);
        }
    }

    private class OwnerWindowListener
    implements WindowListener {
        private OwnerWindowListener() {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            for (int index = 0; index < FloatDock.this.childDocks.size(); ++index) {
                Dock dock = (Dock)FloatDock.this.childDocks.get(index);
                Window window = (Window)FloatDock.this.childDockWindows.get(dock);
                window.setVisible(false);
                window.dispose();
                FloatDock.this.childDocks.remove(dock);
                FloatDock.this.childDockWindows.remove(dock);
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }

    private class MoveToFrontListener
    implements WindowFocusListener {
        private Dock childDock;

        public MoveToFrontListener(Dock childDock) {
            this.childDock = childDock;
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
            if (FloatDock.this.childDocks.contains(this.childDock)) {
                FloatDock.this.childDocks.remove(this.childDock);
                FloatDock.this.childDocks.add(0, this.childDock);
            }
        }

        public void windowLostFocus(WindowEvent windowEvent) {
        }
    }

    private class WindowClosingListener
    implements WindowListener {
        private WindowClosingListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Container contentPane = SwingUtil.getContentPane(windowEvent.getWindow());
            Dock childDock = (Dock)((Object)contentPane.getComponent(0));
            FloatDock.this.childDocks.remove(childDock);
            FloatDock.this.childDockWindows.remove(childDock);
            ArrayList childDockables = new ArrayList();
            DockingUtil.retrieveDockables(childDock, childDockables);
            Iterator iterator = childDockables.iterator();
            while (iterator.hasNext()) {
                Dockable dockable = (Dockable)iterator.next();
                dockable.setState(2, null);
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }
    }
}

