/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock;

import com.javadocking.DockingManager;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.Position;
import com.javadocking.dock.TabDockV6Addition;
import com.javadocking.dock.factory.CompositeTabDockFactory;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.dock.factory.SingleDockFactory;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragListener;
import com.javadocking.event.ChildDockEvent;
import com.javadocking.event.DockableEvent;
import com.javadocking.event.DockingEvent;
import com.javadocking.event.DockingEventSupport;
import com.javadocking.event.DockingListener;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.JvmVersionUtil;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CompositeTabDock
extends JPanel
implements CompositeDock {
    private static final double priorityRectangleRelativeTopOffset = 0.25;
    private static final double priorityRectangleRelativeLeftOffset = 0.25;
    private static final double priorityRectangleRelativeBottomOffset = 0.25;
    private static final double priorityRectangleRelativeRightOffset = 0.25;
    private static final String PROPERTY_SELECTED_DOCK_ID = "selectedDockableId";
    private CompositeDock parentDock;
    private JTabbedPane tabbedPane;
    private DockFactory childDockFactory;
    private Rectangle priorityRectangle = new Rectangle();
    private DockingEventSupport dockingEventSupport = new DockingEventSupport();
    private Map dockingChangeListeners = new HashMap();
    private JTabbedPane ghostTabbedPane;

    public CompositeTabDock() {
        this(new CompositeTabDockFactory());
    }

    public CompositeTabDock(DockFactory childDockFactory) {
        super(new BorderLayout());
        this.childDockFactory = childDockFactory;
        this.initializeUi();
        SingleSelectionModel selectionModel = this.tabbedPane.getModel();
        selectionModel.addChangeListener(new TabChangelistener());
        DragListener dragListener = DockingManager.getDockDragListenerFactory().createDragListener(this);
        this.tabbedPane.addMouseListener(dragListener);
        this.tabbedPane.addMouseMotionListener(dragListener);
    }

    public int getDockPriority(Dockable dockable, Point relativeLocation) {
        if ((dockable.getDockingModes() & 0x10) == 0) {
            return 0;
        }
        if (this.childDockFactory.createDock(dockable, 16) != null) {
            this.getPriorityRectangle(this.priorityRectangle);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return 3;
            }
            return 2;
        }
        if (dockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dockable childDockable = compositeDockable.getDockable(index);
                if (this.childDockFactory.createDock(childDockable, 16) == null) {
                    return 0;
                }
                if (childDockable.getContent() == null) {
                    return 0;
                }
                ++index;
            }
            this.getPriorityRectangle(this.priorityRectangle);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public int retrieveDockingRectangle(Dockable dockable, Point relativeLocation, Point dockableOffset, Rectangle rectangle) {
        int priority = this.getDockPriority(dockable, relativeLocation);
        if (priority != 0) {
            rectangle.setBounds(0, 0, this.getSize().width, this.getSize().height);
        }
        return priority;
    }

    public boolean addDockable(Dockable dockableToAdd, Point relativeLocation, Point dockableOffset) {
        if (this.getDockPriority(dockableToAdd, relativeLocation) == 0) {
            return false;
        }
        Dock childDock = this.childDockFactory.createDock(dockableToAdd, 16);
        if (childDock != null) {
            childDock.setParentDock(this);
            if (dockableToAdd instanceof CompositeDockable) {
                CompositeDockable compositeDockableToAdd = (CompositeDockable)dockableToAdd;
                for (int index = 0; index < compositeDockableToAdd.getDockableCount(); ++index) {
                    childDock.addDockable(compositeDockableToAdd.getDockable(index), new Point(0, 0), new Point(0, 0));
                }
            } else {
                childDock.addDockable(dockableToAdd, new Point(0, 0), new Point(0, 0));
            }
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, null, this, childDock));
            if (JvmVersionUtil.getVersion() >= 6) {
                Component header = (Component)((Object)DockingManager.getComponentFactory().createCompositeTabDockHeader(childDock, this.getHeaderPosition()));
                TabDockV6Addition.addTab(this.tabbedPane, (Component)((Object)childDock), header);
            } else {
                this.tabbedPane.addTab(this.getTitle(dockableToAdd), (Component)((Object)childDock));
            }
            if (dockableToAdd.getDescription() != null) {
                this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, dockableToAdd.getDescription());
            } else {
                this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, this.getTitle(dockableToAdd));
            }
            this.tabbedPane.setSelectedComponent((Component)((Object)childDock));
            this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, null, this, dockableToAdd));
            childDock.addDockingListener(new DockingChangeListener(childDock, this));
        } else if (dockableToAdd instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockableToAdd;
            Dockable selectedDockable = compositeDockable.getSelectedDockable();
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dockable childDockable = compositeDockable.getDockable(index);
                childDock = this.childDockFactory.createDock(dockableToAdd, 16);
                if (childDock == null) continue;
                childDock.setParentDock(this);
                childDock.addDockable(childDockable, new Point(0, 0), new Point(0, 0));
                this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, null, this, childDock));
                if (JvmVersionUtil.getVersion() >= 6) {
                    Component header = (Component)((Object)DockingManager.getComponentFactory().createTabDockHeader(childDockable, this.getHeaderPosition()));
                    TabDockV6Addition.addTab(this.tabbedPane, (Component)((Object)childDock), header);
                } else {
                    this.tabbedPane.addTab(childDockable.getTitle(), (Component)((Object)childDock));
                }
                if (childDockable.getDescription() != null) {
                    this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, childDockable.getDescription());
                }
                if (selectedDockable != null && childDockable.equals(selectedDockable)) {
                    this.tabbedPane.setSelectedComponent((Component)((Object)childDock));
                }
                this.dockingEventSupport.fireDockingChanged(new DockableEvent(this, null, this, dockableToAdd));
                childDock.addDockingListener(new DockingChangeListener(childDock, this));
            }
        }
        SwingUtil.repaintParent(this);
        return true;
    }

    public boolean isEmpty() {
        return this.tabbedPane.getTabCount() == 0;
    }

    public boolean isFull() {
        return false;
    }

    public CompositeDock getParentDock() {
        return this.parentDock;
    }

    public void setParentDock(CompositeDock parentDock) {
        this.parentDock = parentDock;
    }

    public void saveProperties(String prefix, Properties properties, Map childDockIds) {
        String className = this.childDockFactory.getClass().getName();
        PropertiesUtil.setString(properties, prefix + "childDockFactory", className);
        this.childDockFactory.saveProperties(prefix + "childDockFactory.", properties);
        for (int index = 0; index < this.tabbedPane.getTabCount(); ++index) {
            Dock dock = (Dock)((Object)this.tabbedPane.getComponentAt(index));
            String childDockId = (String)childDockIds.get(dock);
            Position.setPositionProperty(properties, prefix + "childDock" + childDockId + "." + "position", this.getChildDockPosition(dock));
        }
        Dock selectedDock = (Dock)((Object)this.tabbedPane.getSelectedComponent());
        if (selectedDock != null) {
            String childDockId = (String)childDockIds.get(selectedDock);
            PropertiesUtil.setString(properties, prefix + PROPERTY_SELECTED_DOCK_ID, childDockId);
        }
    }

    public void loadProperties(String prefix, Properties properties, Map newChildDocks, Map dockablesMap, Window owner) throws IOException {
        Dock dock;
        try {
            String className = SingleDockFactory.class.getName();
            className = PropertiesUtil.getString(properties, prefix + "childDockFactory", className);
            Class<?> clazz = Class.forName(className);
            this.childDockFactory = (DockFactory)clazz.newInstance();
            this.childDockFactory.loadProperties(prefix + "childDockFactory.", properties);
        }
        catch (ClassNotFoundException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        catch (IllegalAccessException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        catch (InstantiationException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        String[] childDockIdsArray = new String[newChildDocks.keySet().size()];
        Iterator keyIterator = newChildDocks.keySet().iterator();
        while (keyIterator.hasNext()) {
            String childDockId = (String)keyIterator.next();
            Position position = null;
            position = Position.getPositionProperty(properties, prefix + "childDock" + childDockId + "." + "position", position);
            childDockIdsArray[position.getPosition((int)0)] = childDockId;
        }
        int position = 0;
        for (int index = 0; index < childDockIdsArray.length; ++index) {
            Dock dock2 = (Dock)newChildDocks.get(childDockIdsArray[index]);
            if (dock2.isEmpty()) continue;
            this.addChildDock(dock2, new Position(position));
            ++position;
        }
        boolean hasSelectedDock = false;
        String selectedDockId = null;
        selectedDockId = PropertiesUtil.getString(properties, prefix + PROPERTY_SELECTED_DOCK_ID, selectedDockId);
        if (selectedDockId != null && (dock = (Dock)newChildDocks.get(selectedDockId)) != null) {
            hasSelectedDock = this.setSelectedDock(dock);
        }
        if (!hasSelectedDock && this.tabbedPane != null && this.tabbedPane.getTabCount() > 0) {
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingEventSupport.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingEventSupport.removeDockingListener(listener);
    }

    public void addChildDock(Dock childDock, Position position) throws IllegalStateException {
        int tabPosition = this.tabbedPane.getTabCount();
        if (position.getDimensions() == 1 && position.getPosition(0) >= 0 && position.getPosition(0) <= this.getChildDockCount()) {
            tabPosition = position.getPosition(0);
        }
        childDock.setParentDock(this);
        this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, null, this, childDock));
        if (JvmVersionUtil.getVersion() >= 6) {
            Component header = (Component)((Object)DockingManager.getComponentFactory().createCompositeTabDockHeader(childDock, this.getHeaderPosition()));
            TabDockV6Addition.insertTab(this.tabbedPane, tabPosition, (Component)((Object)childDock), header);
        } else {
            Dockable dockableForDock = DockingUtil.createDockable(childDock);
            this.tabbedPane.insertTab(this.getTitle(dockableForDock), null, (Component)((Object)childDock), "", tabPosition);
        }
        this.tabbedPane.setSelectedComponent((Component)((Object)childDock));
        this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, null, this, childDock));
        childDock.addDockingListener(new DockingChangeListener(childDock, this));
        SwingUtil.repaintParent(this);
    }

    public int getChildDockCount() {
        return this.tabbedPane.getTabCount();
    }

    public Dock getChildDock(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getChildDockCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return (Dock)((Object)this.tabbedPane.getComponentAt(index));
    }

    public Position getChildDockPosition(Dock childDock) throws IllegalArgumentException {
        int position = -1;
        for (int index = 0; index < this.tabbedPane.getTabCount(); ++index) {
            Dock dock = (Dock)((Object)this.tabbedPane.getComponentAt(index));
            if (!dock.equals(childDock)) continue;
            position = index;
            break;
        }
        if (position >= 0) {
            return new Position(position);
        }
        throw new IllegalArgumentException("The dock is not docked in this composite dock.");
    }

    public void emptyChild(Dock emptyChildDock) {
        int position = -1;
        for (int index = 0; index < this.tabbedPane.getTabCount(); ++index) {
            Dock dock = (Dock)((Object)this.tabbedPane.getComponentAt(index));
            if (!dock.equals(emptyChildDock)) continue;
            position = index;
            break;
        }
        if (position >= 0) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, emptyChildDock));
            this.tabbedPane.remove((Component)((Object)emptyChildDock));
            DockingChangeListener dockingChangeListener = (DockingChangeListener)this.dockingChangeListeners.get(emptyChildDock);
            emptyChildDock.removeDockingListener(dockingChangeListener);
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, emptyChildDock));
            if (this.isEmpty() && this.ghostTabbedPane == null && this.getParentDock() != null) {
                this.getParentDock().emptyChild(this);
            }
            SwingUtil.repaintParent(this);
        }
    }

    public void ghostChild(Dock emptyChildDock) {
        int position = -1;
        for (int index = 0; index < this.tabbedPane.getTabCount(); ++index) {
            Dock dock = (Dock)((Object)this.tabbedPane.getComponentAt(index));
            if (!dock.equals(emptyChildDock)) continue;
            position = index;
            break;
        }
        if (position >= 0) {
            int index;
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, emptyChildDock));
            this.tabbedPane.remove((Component)((Object)emptyChildDock));
            DockingChangeListener dockingChangeListener = (DockingChangeListener)this.dockingChangeListeners.get(emptyChildDock);
            emptyChildDock.removeDockingListener(dockingChangeListener);
            this.ghostTabbedPane = this.tabbedPane;
            this.ghostTabbedPane.setVisible(false);
            this.initializeUi();
            ArrayList<Dock> docksToAdd = new ArrayList<Dock>();
            for (index = this.ghostTabbedPane.getTabCount() - 1; index >= 0; --index) {
                if (index == position) continue;
                Dock childDock = (Dock)((Object)this.ghostTabbedPane.getComponentAt(index));
                this.ghostTabbedPane.remove((Component)((Object)childDock));
                docksToAdd.add(childDock);
            }
            for (index = docksToAdd.size() - 1; index >= 0; --index) {
                this.tabbedPane.add((Component)docksToAdd.get(index));
            }
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, emptyChildDock));
        }
    }

    public void clearGhosts() {
        if (this.ghostTabbedPane != null) {
            this.remove(this.ghostTabbedPane);
            this.ghostTabbedPane = null;
            if (this.isEmpty() && this.getParentDock() != null) {
                this.getParentDock().emptyChild(this);
            }
        }
    }

    public DockFactory getChildDockFactory() {
        return this.childDockFactory;
    }

    public void setChildDockFactory(DockFactory childDockFactory) {
        if (childDockFactory == null) {
            throw new IllegalArgumentException("The child dock factory cannot be null.");
        }
        this.childDockFactory = childDockFactory;
    }

    public boolean setSelectedDock(Dock dock) {
        if (dock instanceof Component) {
            for (int index = 0; index < this.tabbedPane.getTabCount(); ++index) {
                if (!this.tabbedPane.getComponentAt(index).equals(dock)) continue;
                this.tabbedPane.setSelectedComponent((Component)((Object)dock));
                SwingUtil.repaintParent(this);
                return true;
            }
        }
        return false;
    }

    public Dock getSelectedDock() {
        if (this.tabbedPane.getTabCount() > 0) {
            return (Dock)((Object)this.tabbedPane.getSelectedComponent());
        }
        return null;
    }

    public int getHeaderPosition() {
        switch (this.tabbedPane.getTabPlacement()) {
            case 1: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        throw new IllegalStateException("Illegal placement of tabs [" + this.tabbedPane.getTabPlacement() + "].");
    }

    public void setHeaderPosition(int headerPosition) {
        switch (headerPosition) {
            case 3: {
                this.tabbedPane.setTabPlacement(1);
            }
            case 4: {
                this.tabbedPane.setTabPlacement(3);
            }
            case 1: {
                this.tabbedPane.setTabPlacement(2);
            }
            case 2: {
                this.tabbedPane.setTabPlacement(4);
            }
        }
        throw new IllegalStateException("Illegal position for the headers of the dockables [" + headerPosition + "].");
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    protected void getPriorityRectangle(Rectangle rectangle) {
        Dimension size = this.getSize();
        rectangle.setBounds((int)((double)size.width * 0.25), (int)((double)size.height * 0.25), (int)((double)size.width * 0.5), (int)((double)size.height * 0.5));
    }

    protected String getTitle(Dockable dockable) {
        String separator = " ,";
        if (dockable instanceof CompositeDockable) {
            String title = "";
            boolean empty = true;
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                if (!empty) {
                    title = title + separator;
                }
                title = title + this.getTitle(compositeDockable.getDockable(index));
            }
            return title;
        }
        if (dockable.getTitle() != null) {
            return dockable.getTitle();
        }
        return "";
    }

    private void initializeUi() {
        this.tabbedPane = DockingManager.getComponentFactory().createJTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
    }

    private class DockingChangeListener
    implements DockingListener {
        private Dock childDock;

        public DockingChangeListener(Dock childDock, CompositeTabDock parent) {
            this.childDock = childDock;
            CompositeTabDock.this.dockingChangeListeners.put(parent, childDock);
        }

        public void dockingChanged(DockingEvent dockingEvent) {
            for (int index = 0; index < CompositeTabDock.this.getChildDockCount(); ++index) {
                if (!CompositeTabDock.this.getChildDock(index).equals(this.childDock)) continue;
                if (JvmVersionUtil.getVersion() >= 6) {
                    Component header = (Component)((Object)DockingManager.getComponentFactory().createCompositeTabDockHeader(this.childDock, CompositeTabDock.this.getHeaderPosition()));
                    TabDockV6Addition.setTabComponentAt(CompositeTabDock.this.tabbedPane, index, header);
                    continue;
                }
                Dockable dockableForDock = DockingUtil.createDockable(this.childDock);
                CompositeTabDock.this.tabbedPane.setTitleAt(index, CompositeTabDock.this.getTitle(dockableForDock));
            }
        }

        public void dockingWillChange(DockingEvent dockingEvent) {
        }
    }

    private class TabChangelistener
    implements ChangeListener {
        private TabChangelistener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (JvmVersionUtil.getVersion() >= 6) {
                TabDockV6Addition.repaintTabComponents(CompositeTabDock.this.tabbedPane);
            }
        }
    }
}

