/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.component;

import com.javadocking.component.DockHeader;
import com.javadocking.dock.LeafDock;
import com.javadocking.drag.DragListener;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.swing.JPanel;

public class PointDockHeader
extends JPanel
implements DockHeader {
    private static final int HEADER_SIZE = 9;
    private static final Image POINT;
    private static final int POINT_DISTANCE = 4;
    private LeafDock dock;
    private DragListener dragListener;
    private int position;

    public PointDockHeader(LeafDock dock, int position) {
        super(new BorderLayout());
        this.setPosition(position);
        this.dock = dock;
    }

    public void dispose() {
    }

    public void setDragListener(DragListener dragListener) {
        this.dragListener = dragListener;
        this.addMouseMotionListener(dragListener);
        this.addMouseListener(dragListener);
    }

    public DragListener getDragListener() {
        return this.dragListener;
    }

    public LeafDock getDock() {
        return this.dock;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
        if (position == 3 || position == 4) {
            this.setMinimumSize(new Dimension(9, 9));
            this.setMaximumSize(new Dimension(Short.MAX_VALUE, 9));
            this.setPreferredSize(new Dimension(9, 9));
        } else {
            this.setMinimumSize(new Dimension(9, 9));
            this.setMaximumSize(new Dimension(9, Short.MAX_VALUE));
            this.setPreferredSize(new Dimension(9, 9));
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.position == 3 || this.position == 4) {
            int y = 3;
            for (int x = 4; x < this.getWidth() - 4; x += 4) {
                graphics.drawImage(POINT, x, y, this);
            }
        } else {
            int x = 3;
            for (int y = 4; y < this.getHeight() - 4; y += 4) {
                graphics.drawImage(POINT, x, y, this);
            }
        }
    }

    static {
        DirectColorModel colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        SampleModel sampleModel = ((ColorModel)colorModel).createCompatibleSampleModel(3, 3);
        int[] pixels = new int[]{-2699322, -5001045, -1053721, -5001053, -7501702, -1, -1579033, -1, -262145};
        DataBufferInt dataBuffer = new DataBufferInt(pixels, 9);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBuffer, new Point());
        POINT = new BufferedImage(colorModel, writableRaster, false, null);
    }
}

