/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.component;

import com.javadocking.DockingManager;
import com.javadocking.component.SelectableDockableHeader;
import com.javadocking.dockable.DefaultCompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.dockable.DraggableContent;
import com.javadocking.dockable.action.DefaultDockableStateAction;
import com.javadocking.dockable.action.ShowActionMode;
import com.javadocking.drag.DragListener;
import com.javadocking.util.DockingUtil;
import com.javadocking.visualizer.Visualizer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class MinimzeHeader
extends SelectableDockableHeader
implements DraggableContent {
    private static final int HEADER_HEIGHT = 20;
    private static final int DIVIDER_WIDTH = 6;
    private static final int MAXIMUM_WIDTH = 140;
    private Border selectedBorder = BorderFactory.createLineBorder(Color.gray);
    private Border deselectedBorder = BorderFactory.createBevelBorder(1, Color.gray, Color.white);
    private Dockable dockable;

    public MinimzeHeader(Dockable dockable, int position) {
        this(dockable, position, ShowActionMode.NO_ACTIONS, ShowActionMode.ALL_ACTIONS);
    }

    public MinimzeHeader(Dockable dockable, int position, ShowActionMode showActionMode, ShowActionMode selectedShowActionMode) {
        super(dockable, position, showActionMode, selectedShowActionMode);
        this.dockable = dockable;
        this.addMouseListener(new SelectionListener());
        this.setBorder(this.deselectedBorder);
        this.addToolTip(dockable);
    }

    public void addDragListener(DragListener dragListener) {
        JLabel iconLabel;
        this.addMouseListener(dragListener);
        this.addMouseMotionListener(dragListener);
        JLabel titleLabel = this.getTitleLabel();
        if (titleLabel != null) {
            titleLabel.addMouseListener(dragListener);
            titleLabel.addMouseMotionListener(dragListener);
        }
        if ((iconLabel = this.getIconLabel()) != null) {
            iconLabel.addMouseListener(dragListener);
            iconLabel.addMouseMotionListener(dragListener);
        }
    }

    public Border getDeselectedBorder() {
        return this.deselectedBorder;
    }

    public void setDeselectedBorder(Border border) {
        this.deselectedBorder = border;
    }

    public Border getSelectedBorder() {
        return this.selectedBorder;
    }

    public void setSelectedBorder(Border selectedBorder) {
        this.selectedBorder = selectedBorder;
    }

    public void setSelected(boolean selected) {
        boolean oldSelected = super.isSelected();
        super.setSelected(selected);
        if (oldSelected != selected) {
            if (selected) {
                this.setBorder(this.selectedBorder);
            } else {
                this.setBorder(this.deselectedBorder);
            }
        }
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (this.getTitleLabel() != null) {
            this.getTitleLabel().addMouseListener(mouseListener);
        }
        if (this.getIconLabel() != null) {
            this.getIconLabel().addMouseListener(mouseListener);
        }
        super.addMouseListener(mouseListener);
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        Dimension maximumSize = this.getMaximumSize();
        if (preferredSize.width > maximumSize.width) {
            return new Dimension(maximumSize.width, preferredSize.height);
        }
        return preferredSize;
    }

    protected int getHeaderHeight() {
        return 20;
    }

    protected int getHeaderMaximumWidth() {
        return 140;
    }

    protected int calculatePreferredWidth() {
        int icon = 0;
        if (this.getIconLabel() != null) {
            icon = this.getIconLabel().getPreferredSize().width;
        }
        int action = 0;
        if (this.getActionPanel() != null) {
            for (int index = 0; index < this.getActionPanel().getComponentCount(); ++index) {
                action += this.getActionPanel().getComponent((int)index).getPreferredSize().width;
            }
        }
        int selectedAction = 0;
        if (this.getSelectedActionPanel() != null) {
            for (int index = 0; index < this.getSelectedActionPanel().getComponentCount(); ++index) {
                selectedAction += this.getSelectedActionPanel().getComponent((int)index).getPreferredSize().width;
            }
        }
        if (action > selectedAction) {
            selectedAction = action;
        }
        return 12 + icon + this.getTitleLabel().getPreferredSize().width + selectedAction;
    }

    private void addToolTip(Dockable dockable) {
        String description = dockable.getDescription();
        if (description != null) {
            this.setToolTipText(description);
            if (this.getTitleLabel() != null) {
                this.getTitleLabel().setToolTipText(description);
            }
            if (this.getIconLabel() != null) {
                this.getIconLabel().setToolTipText(description);
            }
        }
    }

    private class SelectionListener
    implements MouseListener {
        private boolean react = true;

        private SelectionListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                JPopupMenu popupMenu;
                this.react = false;
                DefaultCompositeDockable compositeDockable = null;
                Object object = MinimzeHeader.this.dockable.getVisualizer();
                if (object instanceof Visualizer) {
                    int selectedIndex = -1;
                    Visualizer visualizer = (Visualizer)object;
                    Dockable[] dockables = new Dockable[visualizer.getVisualizedDockableCount()];
                    for (int index = 0; index < visualizer.getVisualizedDockableCount(); ++index) {
                        Dockable dockableOfComposite;
                        dockables[index] = dockableOfComposite = visualizer.getVisualizedDockable(index);
                        if (!MinimzeHeader.this.dockable.equals(dockableOfComposite)) continue;
                        selectedIndex = index;
                    }
                    compositeDockable = new DefaultCompositeDockable(dockables, selectedIndex);
                }
                if ((popupMenu = DockingManager.getComponentFactory().createPopupMenu(MinimzeHeader.this.dockable, compositeDockable)) != null) {
                    popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            } else {
                this.react = true;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.react) {
                if (mouseEvent.getClickCount() == 2) {
                    DefaultDockableStateAction restoreAction = new DefaultDockableStateAction(DockingUtil.retrieveDockableOfDockModel(MinimzeHeader.this.dockable.getID()), 1);
                    restoreAction.actionPerformed(new ActionEvent(this, 1001, "Restore"));
                } else {
                    MinimzeHeader.this.setSelected(!MinimzeHeader.this.isSelected());
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }
    }
}

