/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking;

import com.javadocking.DockingManager;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.Position;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.event.DockableEvent;
import com.javadocking.model.DefaultDockingPath;
import com.javadocking.model.DockModel;
import com.javadocking.model.DockingPath;
import com.javadocking.model.DockingPathModel;
import com.javadocking.util.DockingUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class DockingExecutor {
    public boolean changeDocking(Dockable dockable, Dock destinationDock, Point relativeLocation, Point dockableOffset) {
        DockableEvent dockingChangedEvent;
        boolean result = true;
        boolean removalSuccessFull = false;
        LeafDock originDock = dockable.getDock();
        DockableEvent dockingWillChangeEvent = new DockableEvent(this, originDock, destinationDock, dockable);
        dockable.fireDockingWillChange(dockingWillChangeEvent);
        if (originDock != null && originDock.equals(destinationDock)) {
            result = originDock.moveDockable(dockable, relativeLocation);
        } else {
            Dock floatChildDock;
            removalSuccessFull = this.removeDockable(dockable);
            result = removalSuccessFull;
            if (result && destinationDock != null && !destinationDock.equals(originDock) && (result = destinationDock.addDockable(dockable, relativeLocation, dockableOffset)) && (floatChildDock = DockingUtil.getFloatChildDock(dockable.getDock())) != null) {
                Window window = SwingUtilities.getWindowAncestor((Component)((Object)floatChildDock));
                window.pack();
            }
        }
        if (result) {
            dockingChangedEvent = new DockableEvent(this, originDock, destinationDock, dockable);
            dockable.fireDockingChanged(dockingChangedEvent);
        } else if (removalSuccessFull) {
            dockingChangedEvent = new DockableEvent(this, originDock, null, dockable);
            dockable.fireDockingChanged(dockingChangedEvent);
        }
        return result;
    }

    public boolean changeDocking(Dockable dockable, LeafDock destinationDock, Position position) {
        DockableEvent dockingChangedEvent;
        boolean removalSuccessFull;
        LeafDock originDock = dockable.getDock();
        DockableEvent dockingWillChangeEvent = new DockableEvent(this, originDock, destinationDock, dockable);
        dockable.fireDockingWillChange(dockingWillChangeEvent);
        boolean success = removalSuccessFull = this.removeDockable(dockable);
        if (success && destinationDock != null) {
            Dock floatChildDock;
            destinationDock.addDockable(dockable, position);
            if (success && (floatChildDock = DockingUtil.getFloatChildDock(dockable.getDock())) != null) {
                Window window = SwingUtilities.getWindowAncestor((Component)((Object)floatChildDock));
                window.pack();
            }
        }
        if (success) {
            dockingChangedEvent = new DockableEvent(this, originDock, destinationDock, dockable);
            dockable.fireDockingChanged(dockingChangedEvent);
        } else if (removalSuccessFull) {
            dockingChangedEvent = new DockableEvent(this, originDock, null, dockable);
            dockable.fireDockingChanged(dockingChangedEvent);
        }
        return success;
    }

    public boolean changeDocking(Dockable dockable, Dock rootDock) {
        if (rootDock == null) {
            LeafDock originDock = dockable.getDock();
            if (originDock != null) {
                DockableEvent dockingWillChangeEvent = new DockableEvent(this, originDock, null, dockable);
                dockable.fireDockingWillChange(dockingWillChangeEvent);
                if (this.removeDockable(dockable)) {
                    DockableEvent dockingChangedEvent = new DockableEvent(this, originDock, null, dockable);
                    dockable.fireDockingChanged(dockingChangedEvent);
                    return true;
                }
                return false;
            }
            return true;
        }
        if (rootDock instanceof CompositeDock) {
            CompositeDock compositeDock = (CompositeDock)rootDock;
            for (int index = 0; index < compositeDock.getChildDockCount(); ++index) {
                if (!this.changeDocking(dockable, compositeDock.getChildDock(index))) continue;
                return true;
            }
        }
        Point location = new Point();
        if (rootDock instanceof Component) {
            Dimension size = ((Component)((Object)rootDock)).getSize();
            location.move(size.width / 2, size.height / 2);
        }
        return rootDock.getDockPriority(dockable, location) != 0 && DockingManager.getDockingExecutor().changeDocking(dockable, rootDock, location, new Point());
    }

    public boolean changeDocking(Dockable dockable, DockingPath dockingPath) {
        LeafDock leafDock;
        Dock childDock;
        Dock currentDock;
        if (dockingPath == null) {
            throw new NullPointerException("Docking path null.");
        }
        DockModel dockModel = DockingManager.getDockModel();
        if (dockModel == null) {
            throw new NullPointerException("Dock model of docking manager null.");
        }
        String rootDockKey = dockingPath.getRootDockKey();
        Dock rootDock = dockModel.getRootDock(rootDockKey);
        if (rootDock == null) {
            return false;
        }
        if (!dockingPath.getDock(0).equals(rootDock)) {
            return false;
        }
        int dockIndex = 0;
        while (dockIndex < dockingPath.getDockCount()) {
            currentDock = dockingPath.getDock(dockIndex);
            if (currentDock instanceof CompositeDock) {
                CompositeDock compositeDock = (CompositeDock)currentDock;
                boolean found = false;
                if (dockIndex < dockingPath.getDockCount() - 1) {
                    Dock childDockToSearch = dockingPath.getDock(dockIndex + 1);
                    for (int childIndex = 0; childIndex < compositeDock.getChildDockCount(); ++childIndex) {
                        childDock = compositeDock.getChildDock(childIndex);
                        if (!childDock.equals(childDockToSearch)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) break;
                ++dockIndex;
                continue;
            }
            if (!(currentDock instanceof LeafDock)) continue;
            leafDock = (LeafDock)currentDock;
            DockingManager.getDockingExecutor().changeDocking(dockable, leafDock, dockingPath.getPositionInDock(dockIndex));
            return true;
        }
        if ((currentDock = dockingPath.getDock(dockIndex)) instanceof CompositeDock) {
            Dock childDock2;
            Position currentPosition = dockingPath.getPositionInDock(dockIndex);
            CompositeDock compositeDock = (CompositeDock)currentDock;
            Dock currentPositionChildDock = null;
            for (int index = 0; index < compositeDock.getChildDockCount(); ++index) {
                childDock = compositeDock.getChildDock(index);
                Position childPosition = compositeDock.getChildDockPosition(childDock);
                if (!childPosition.equals(currentPosition)) continue;
                currentPositionChildDock = childDock;
                break;
            }
            if (currentPositionChildDock == null && !compositeDock.isFull() && (childDock2 = compositeDock.getChildDockFactory().createDock(dockable, Integer.MAX_VALUE)) != null) {
                LeafDock originDock = dockable.getDock();
                DockableEvent dockingWillChangeEvent = new DockableEvent(this, originDock, compositeDock, dockable);
                dockable.fireDockingWillChange(dockingWillChangeEvent);
                boolean removalSuccessFull = this.removeDockable(dockable);
                if (!removalSuccessFull) {
                    return false;
                }
                boolean succes = childDock2.addDockable(dockable, new Point(0, 0), new Point(0, 0));
                if (succes) {
                    compositeDock.addChildDock(childDock2, currentPosition);
                    DockableEvent dockingChangedEvent = new DockableEvent(this, originDock, compositeDock, dockable);
                    dockable.fireDockingChanged(dockingChangedEvent);
                    return true;
                }
                DockableEvent dockingChangedEvent = new DockableEvent(this, originDock, null, dockable);
                dockable.fireDockingChanged(dockingChangedEvent);
            }
            boolean succes = false;
            if (currentPositionChildDock != null) {
                succes = this.changeDocking(dockable, currentPositionChildDock);
            }
            for (CompositeDock parentDock = compositeDock; !succes && parentDock != null; parentDock = parentDock.getParentDock()) {
                succes = this.changeDocking(dockable, parentDock);
            }
            return succes;
        }
        if (currentDock instanceof LeafDock) {
            leafDock = (LeafDock)currentDock;
            DockingManager.getDockingExecutor().changeDocking(dockable, leafDock, dockingPath.getPositionInDock(dockIndex));
            return true;
        }
        return false;
    }

    public CompositeDock cleanDock(Dock dock, boolean ghost) {
        Dock floatChildDock;
        int index;
        CompositeDock dockWithGhosts = null;
        if (dock.isEmpty() && dock.getParentDock() != null) {
            if (ghost) {
                dock.getParentDock().ghostChild(dock);
                dockWithGhosts = dock.getParentDock();
            } else {
                dock.getParentDock().emptyChild(dock);
            }
        }
        if (dock instanceof CompositeDock) {
            CompositeDock compositeDock = (CompositeDock)dock;
            ArrayList<Dock> emptyChildren = new ArrayList<Dock>();
            for (index = 0; index < compositeDock.getChildDockCount(); ++index) {
                Dock childDock = compositeDock.getChildDock(index);
                if (this.hasDockables(childDock)) continue;
                emptyChildren.add(childDock);
            }
            for (index = 0; index < emptyChildren.size(); ++index) {
                compositeDock.emptyChild((Dock)emptyChildren.get(index));
            }
        }
        if ((floatChildDock = DockingUtil.getFloatChildDock(dock)) != null) {
            FloatDock floatDock = (FloatDock)floatChildDock.getParentDock();
            for (index = 0; index < floatDock.getChildDockCount(); ++index) {
                if (!floatDock.getChildDock(index).equals(floatChildDock)) continue;
                Window window = SwingUtilities.getWindowAncestor((Component)((Object)floatChildDock));
                window.pack();
                break;
            }
        }
        return dockWithGhosts;
    }

    private void saveDockingPath(Dockable dockable) {
        if (dockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                this.saveDockingPath(compositeDockable.getDockable(index));
            }
            return;
        }
        if (dockable.getDock() != null && dockable.getState() != 16) {
            DockModel dockModel = DockingManager.getDockModel();
            if (dockModel == null) {
                throw new NullPointerException("Dock model of docking manager null.");
            }
            DockingPathModel dockingPathModel = DockingManager.getDockingPathModel();
            if (dockingPathModel == null) {
                throw new NullPointerException("Docking path model of docking manager null.");
            }
            DefaultDockingPath dockingPath = DefaultDockingPath.createDockingPath(dockable);
            dockingPathModel.add(dockingPath);
        }
    }

    private boolean hasDockables(Dock dock) {
        if (dock instanceof LeafDock) {
            LeafDock leafDock = (LeafDock)dock;
            return leafDock.getDockableCount() != 0;
        }
        if (dock instanceof CompositeDock) {
            CompositeDock compositeDock = (CompositeDock)dock;
            for (int index = 0; index < compositeDock.getChildDockCount(); ++index) {
                if (!this.hasDockables(compositeDock.getChildDock(index))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean removeDockable(Dockable dockable) {
        LeafDock originDock = dockable.getDock();
        if (originDock != null) {
            return this.removeSingleDockable(dockable);
        }
        if (dockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            boolean success = true;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                if (this.removeDockable(compositeDockable.getDockable(index))) continue;
                success = false;
            }
            return success;
        }
        return true;
    }

    private boolean removeSingleDockable(Dockable dockable) {
        LeafDock originDock = dockable.getDock();
        if (originDock == null) {
            throw new IllegalArgumentException("The dockable [" + dockable.getTitle() + "] is not docked. It should be docked in a LeafDock.");
        }
        this.saveDockingPath(dockable);
        return originDock.removeDockable(dockable);
    }
}

