import { DB_FILENAME } from "$lib/config";
import sqlite3 from "sqlite3";
import { open } from "sqlite";
import slugify from "slugify";

export const get = async () => {
  const db = await open({
    filename: DB_FILENAME,
    driver: sqlite3.Database,
  });

  // CREATE TABLE AND INSERT EXAMPLE ROW
  //   await db.exec('CREATE TABLE post (id INTEGER PRIMARY KEY AUTOINCREMENT, title VARCHAR(150) NOT NULL, slug VARCHAR(250) NOT NULL, abstract VARCHAR (300), body TEXT, thumbnail VARCHAR(250), active INTEGER NOT NULL DEFAULT 1)')
  //   const testInsert = 'INSERT INTO post(title, slug, abstract, body, thumbnail) VALUES (:title, :slug, :abstract, :body, :thumbnail)';
  //   const params = {
  //       ":title": "Ala ma kota",
  //       ":slug": "ala",
  //       ":abstract": "sgdh skhgkljdsh gkasjdhg klasjghaklakl glakjhsgak",
  //       ":body" : "ksjdh fakljh fkljhaflkasdjhf aklsjdh aksdlhfaklsd hfakljfhakjhf alkjfhas",
  //       ":thumbnail": "https://www.bikester.pl/sf-content/BIKESTER/Aktionsgrafiken/20210527_BPL_gravel_585x380.jpg"
  //   }
  //   await db.run(testInsert, params);

  const sql = "SELECT * FROM post WHERE active = :active";
  const result = await db.all(sql, { ":active": 1 });

  return {
    body: { status: true, posts: result },
  };
};

export const post = async (request) => {
  const data = JSON.parse(request.body);
  const db = await open({
    filename: DB_FILENAME,
    driver: sqlite3.Database,
  });

  const query =
    "INSERT INTO post(title, slug, abstract, body, thumbnail) VALUES (:title, :slug, :abstract, :body, :thumbnail)";
  const params = {
    ":title": data.title,
    ":slug": slugify(data.title, { lower: true, locale: "pl", strict: true }),
    ":abstract": data.abstract,
    ":body": data.body,
    ":thumbnail": data.thumbnail,
  };

  const result = await db.run(query, params);

  const sql = "SELECT * FROM post WHERE active = :active";
  const posts = await db.all(sql, { ":active": 1 });


  if (result.lastID) {
    return {
      body: { status: true, posts },
    };
  } else {
    return {
      body: { status: false, posts },
    };
  }
};

export const del = async (request) => {
  const data = JSON.parse(request.body);
  const db = await open({
    filename: DB_FILENAME,
    driver: sqlite3.Database,
  });

  const query =
    "DELETE FROM post WHERE id = :id";
  const params = {
    ":id": data.id,
  };

  const result = await db.run(query, params);

  console.log(result)

  const sql = "SELECT * FROM post WHERE active = :active";
  const posts = await db.all(sql, { ":active": 1 });

  if (result.changes) {
    return {
      body: { status: true, posts },
    };
  } else {
    return {
      body: { status: false, posts },
    };
  }
};
