

class PrinterBase(object):

    @classmethod
    def print_restraints(cls, restraints):
        lines = []
        return lines


class ShelxPrinter(PrinterBase):

    @classmethod
    def _get_alt_loc(cls, atom):
        pass

    @classmethod
    def print_restraints(cls, restraints):
        lines = []
        return lines


class RefmacPrinter(PrinterBase):

    @classmethod
    def _get_alt_loc(cls, atom):
        if atom.alt_loc != '':
            return ' altecode {}'.format(atom.alt_loc)
        return atom.alt_loc

    @classmethod
    def print_restraints(cls, restraints):
        lines = []
        for restraint in restraints:
            line = ''
            if restraint.type == 'angle':
                atom0 = restraint.atoms[0]
                atom1 = restraint.atoms[1]
                atom2 = restraint.atoms[2]

                line = "exte angle first chain {} resi {} atom {}{} next chain {} resi {} atom {}{} next chain {} resi {} atom {}{} value {:.1f} sigma {:.1f} type {}".format(
                    atom0.chain_id,
                    atom0.res_id,
                    atom0.atom_name,
                    cls._get_alt_loc(atom0),

                    atom1.chain_id,
                    atom1.res_id,
                    atom1.atom_name,
                    cls._get_alt_loc(atom1),

                    atom2.chain_id,
                    atom2.res_id,
                    atom2.atom_name,
                    cls._get_alt_loc(atom2),

                    restraint.value,
                    restraint.sigma,
                    0 # type 0=override, 1=add to existing, 2=longer range distance
                )

            elif restraint.type == 'dist':
                atom0 = restraint.atoms[0]
                atom1 = restraint.atoms[1]

                line = "exte dist first chain {} resi {} atom {}{} second chain {} resi {} atom {}{} value {:.3f} sigma {:.3f} type {}".format(
                    atom0.chain_id,
                    atom0.res_id,
                    atom0.atom_name,
                    cls._get_alt_loc(atom0),

                    atom1.chain_id,
                    atom1.res_id,
                    atom1.atom_name,
                    cls._get_alt_loc(atom1),

                    restraint.value,
                    restraint.sigma,
                    0 # type 0=override, 1=add to existing, 2=longer range distance
                )

            # usuwanie duplikujacych sie wynykaow dla alt_loc (blank-blank) w przypadku gdy mamy A i B
            if line not in lines:
                lines.append(line)

        return "\n".join(lines)