/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.Random;
import moa.core.Example;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.streams.ExampleStream;
import moa.tasks.TaskMonitor;

public class ConceptDriftStream
extends AbstractOptionHandler
implements ExampleStream {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to add concept drift.", ExampleStream.class, "generators.RandomTreeGenerator");
    public ClassOption driftstreamOption = new ClassOption("driftstream", 'd', "Concept drift Stream.", ExampleStream.class, "generators.RandomTreeGenerator");
    public FloatOption alphaOption = new FloatOption("alpha", 'a', "Angle alpha of change grade.", 0.0, 0.0, 90.0);
    public IntOption positionOption = new IntOption("position", 'p', "Central position of concept drift change.", 0);
    public IntOption widthOption = new IntOption("width", 'w', "Width of concept drift change.", 1000);
    public IntOption randomSeedOption = new IntOption("randomSeed", 'r', "Seed for random noise.", 1);
    protected ExampleStream inputStream;
    protected ExampleStream driftStream;
    protected Random random;
    protected int numberInstanceStream;

    @Override
    public String getPurposeString() {
        return "Adds Concept Drift to examples in a stream.";
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.inputStream = (ExampleStream)this.getPreparedClassOption(this.streamOption);
        this.driftStream = (ExampleStream)this.getPreparedClassOption(this.driftstreamOption);
        this.random = new Random(this.randomSeedOption.getValue());
        this.numberInstanceStream = 0;
        if (this.alphaOption.getValue() != 0.0) {
            this.widthOption.setValue((int)(1.0 / Math.tan(this.alphaOption.getValue() * Math.PI / 180.0)));
        }
    }

    @Override
    public long estimatedRemainingInstances() {
        return this.inputStream.estimatedRemainingInstances() + this.driftStream.estimatedRemainingInstances();
    }

    @Override
    public InstancesHeader getHeader() {
        return this.inputStream.getHeader();
    }

    @Override
    public boolean hasMoreInstances() {
        return this.inputStream.hasMoreInstances() || this.driftStream.hasMoreInstances();
    }

    @Override
    public boolean isRestartable() {
        return this.inputStream.isRestartable() && this.driftStream.isRestartable();
    }

    public Example nextInstance() {
        ++this.numberInstanceStream;
        double x = -4.0 * (double)(this.numberInstanceStream - this.positionOption.getValue()) / (double)this.widthOption.getValue();
        double probabilityDrift = 1.0 / (1.0 + Math.exp(x));
        if (this.random.nextDouble() > probabilityDrift) {
            return this.inputStream.nextInstance();
        }
        return this.driftStream.nextInstance();
    }

    @Override
    public void restart() {
        this.inputStream.restart();
        this.driftStream.restart();
        this.numberInstanceStream = 0;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

