/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import moa.core.PropertiesReader;
import moa.core.Utils;

public class GUIDefaults
implements Serializable {
    private static final long serialVersionUID = 4954795757927524225L;
    public static final String PROPERTY_FILE = "moa/gui/GUI.props";
    protected static Properties PROPERTIES;

    public static String get(String property, String defaultValue) {
        return PROPERTIES.getProperty(property, defaultValue);
    }

    public static final Properties getProperties() {
        return PROPERTIES;
    }

    protected static Object getObject(String property, String defaultValue) {
        return GUIDefaults.getObject(property, defaultValue, Object.class);
    }

    protected static Object getObject(String property, String defaultValue, Class cls) {
        Object result = null;
        try {
            String tmpStr = GUIDefaults.get(property, defaultValue);
            String[] tmpOptions = Utils.splitOptions(tmpStr);
            if (tmpOptions.length != 0) {
                tmpStr = tmpOptions[0];
                tmpOptions[0] = "";
                result = Utils.forName(cls, tmpStr, tmpOptions);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static String[] getTabs() {
        String tabs = GUIDefaults.get("Tabs", "moa.gui.ClassificationTabPanel,moa.gui.RegressionTabPanel,moa.gui.MultiTargetTabPanel,moa.gui.clustertab.ClusteringTabPanel,moa.gui.outliertab.OutlierTabPanel,moa.gui.ConceptDriftTabPanel");
        String[] result = tabs.split(",");
        return result;
    }

    public static String getInitialDirectory() {
        String result = GUIDefaults.get("InitialDirectory", "%c");
        result = result.replaceAll("%t", System.getProperty("java.io.tmpdir"));
        result = result.replaceAll("%h", System.getProperty("user.home"));
        result = result.replaceAll("%c", System.getProperty("user.dir"));
        result = result.replaceAll("%%", System.getProperty("%"));
        return result;
    }

    public static void main(String[] args) {
        System.out.println("\nMOA defaults:");
        Enumeration<Object> names = PROPERTIES.propertyNames();
        Vector sorted = new Vector();
        while (names.hasMoreElements()) {
            sorted.add(names.nextElement());
        }
        Collections.sort(sorted);
        names = sorted.elements();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            System.out.println("- " + name + ": " + PROPERTIES.getProperty(name, ""));
        }
        System.out.println();
    }

    static {
        try {
            PROPERTIES = PropertiesReader.readProperties(PROPERTY_FILE);
        }
        catch (Exception e) {
            System.err.println("Problem reading properties. Fix before continuing.");
            e.printStackTrace();
            PROPERTIES = new Properties();
        }
    }
}

