/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.evaluation.CMM_GTAnalysis;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.DataPoint;

public class CMM
extends MeasureCollection {
    private static final long serialVersionUID = 1L;
    private Clustering clustering;
    private CMM_GTAnalysis gtAnalysis;
    private int numPoints;
    private int numFClusters;
    private int numGT0Classes;
    private int[] matchMap;
    private double[][] pointInclusionProbFC;
    private double pointInclusionProbThreshold = 0.5;
    private double lamdaMissed = 1.0;
    public boolean debug = false;
    public boolean enableClassMerge = true;
    public boolean enableModelError = true;

    @Override
    protected String[] getNames() {
        String[] names = new String[]{"CMM", "CMM Basic", "CMM Missed", "CMM Misplaced", "CMM Noise", "CA Seperability", "CA Noise", "CA Modell"};
        return names;
    }

    @Override
    protected boolean[] getDefaultEnabled() {
        boolean[] defaults = new boolean[]{false, false, false, false, false, false, false, false};
        return defaults;
    }

    @Override
    public void evaluateClustering(Clustering clustering, Clustering trueClustering, ArrayList<DataPoint> points) throws Exception {
        this.clustering = clustering;
        this.numPoints = points.size();
        this.numFClusters = clustering.size();
        this.gtAnalysis = new CMM_GTAnalysis(trueClustering, points, this.enableClassMerge);
        this.numGT0Classes = this.gtAnalysis.getNumberOfGT0Classes();
        this.addValue("CA Seperability", this.gtAnalysis.getClassSeparability());
        this.addValue("CA Noise", this.gtAnalysis.getNoiseSeparability());
        this.addValue("CA Modell", this.gtAnalysis.getModelQuality());
        this.calculateMatching();
        this.calculateError();
    }

    private void calculateMatching() {
        int[][] mapFC = new int[this.numFClusters][this.numGT0Classes];
        int[][] mapGT = new int[this.numGT0Classes][this.numGT0Classes];
        int[] sumsFC = new int[this.numFClusters];
        this.pointInclusionProbFC = new double[this.numPoints][this.numFClusters];
        for (int p = 0; p < this.numPoints; ++p) {
            CMM_GTAnalysis.CMMPoint cmdp = this.gtAnalysis.getPoint(p);
            for (int fc = 0; fc < this.numFClusters; ++fc) {
                Cluster cl = this.clustering.get(fc);
                this.pointInclusionProbFC[p][fc] = cl.getInclusionProbability(cmdp);
                if (!(this.pointInclusionProbFC[p][fc] >= this.pointInclusionProbThreshold) || cmdp.isNoise()) continue;
                int[] nArray = mapFC[fc];
                int n = cmdp.workclass();
                nArray[n] = nArray[n] + 1;
                int n2 = fc;
                sumsFC[n2] = sumsFC[n2] + 1;
            }
            if (cmdp.isNoise()) continue;
            for (int hc = 0; hc < this.numGT0Classes; ++hc) {
                if (hc == cmdp.workclass()) {
                    int[] nArray = mapGT[hc];
                    int n = hc;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                if (!(this.gtAnalysis.getGT0Cluster(hc).getInclusionProbability(cmdp) >= 1.0)) continue;
                int[] nArray = mapGT[hc];
                int n = cmdp.workclass();
                nArray[n] = nArray[n] + 1;
            }
        }
        this.matchMap = new int[this.numFClusters];
        for (int fc = 0; fc < this.numFClusters; ++fc) {
            int matchIndex = -1;
            for (int hc0 = 0; hc0 < this.numGT0Classes; ++hc0) {
                if (mapFC[fc][hc0] == 0) continue;
                if (matchIndex == -1) {
                    matchIndex = hc0;
                    continue;
                }
                matchIndex = -1;
                break;
            }
            int minDiff = Integer.MAX_VALUE;
            if (sumsFC[fc] != 0 && matchIndex == -1) {
                ArrayList<Integer> fitCandidates = new ArrayList<Integer>();
                for (int hc0 = 0; hc0 < this.numGT0Classes; ++hc0) {
                    int errDiff = 0;
                    for (int hc1 = 0; hc1 < this.numGT0Classes; ++hc1) {
                        double freq_diff = mapFC[fc][hc1] - mapGT[hc0][hc1];
                        if (!(freq_diff > 0.0)) continue;
                        errDiff = (int)((double)errDiff + freq_diff);
                    }
                    if (errDiff == 0) {
                        fitCandidates.add(hc0);
                    }
                    if (errDiff < minDiff) {
                        minDiff = errDiff;
                        matchIndex = hc0;
                    }
                    if (!this.debug) continue;
                }
                if (fitCandidates.size() != 0) {
                    int bestGTfit = (Integer)fitCandidates.get(0);
                    for (int i = 1; i < fitCandidates.size(); ++i) {
                        int GTfit = (Integer)fitCandidates.get(i);
                        if (mapFC[fc][GTfit] <= mapFC[fc][bestGTfit]) continue;
                        bestGTfit = (Integer)fitCandidates.get(i);
                    }
                    matchIndex = bestGTfit;
                }
            }
            this.matchMap[fc] = matchIndex;
            int realMatch = -1;
            if (matchIndex == -1) {
                if (this.debug) {
                    System.out.println("No cluster match: needs to be implemented?");
                }
            } else {
                realMatch = this.gtAnalysis.getGT0Cluster(this.matchMap[fc]).getLabel();
            }
            this.clustering.get(fc).setMeasureValue("CMM Match", "C" + realMatch);
            this.clustering.get(fc).setMeasureValue("CMM Workclass", "C" + this.matchMap[fc]);
        }
        if (this.debug) {
            for (int i = 0; i < this.numFClusters; ++i) {
                System.out.print("C" + (int)this.clustering.get(i).getId() + " N:" + (int)this.clustering.get(i).getWeight() + "  |  ");
                for (int j = 0; j < this.numGT0Classes; ++j) {
                    System.out.print(mapFC[i][j] + " ");
                }
                System.out.print(" = " + sumsFC[i] + " | ");
                String match = "-";
                if (this.matchMap[i] != -1) {
                    match = Integer.toString(this.gtAnalysis.getGT0Cluster(this.matchMap[i]).getLabel());
                }
                System.out.println(" --> " + match + "(work:" + this.matchMap[i] + ")");
            }
        }
    }

    private void calculateError() {
        int totalErrorCount = 0;
        int totalRedundancy = 0;
        int trueCoverage = 0;
        int totalCoverage = 0;
        int numNoise = 0;
        double errorNoise = 0.0;
        double errorNoiseMax = 0.0;
        double errorMissed = 0.0;
        double errorMissedMax = 0.0;
        double errorMisplaced = 0.0;
        double errorMisplacedMax = 0.0;
        double totalError = 0.0;
        double totalErrorMax = 0.0;
        for (int p = 0; p < this.numPoints; ++p) {
            CMM_GTAnalysis.CMMPoint cmdp = this.gtAnalysis.getPoint(p);
            double weight = cmdp.weight();
            if (cmdp.isNoise()) {
                ++numNoise;
                errorNoiseMax += cmdp.connectivity * weight;
            } else {
                errorMissedMax += cmdp.connectivity * weight;
                errorMisplacedMax += cmdp.connectivity * weight;
            }
            totalErrorMax += cmdp.connectivity * weight;
            double err = 0.0;
            int coverage = 0;
            for (int c = 0; c < this.numFClusters; ++c) {
                double errvalue;
                if (!(this.pointInclusionProbFC[p][c] >= this.pointInclusionProbThreshold)) continue;
                ++coverage;
                if (!cmdp.isNoise()) {
                    if (this.matchMap[c] == cmdp.workclass() || !((errvalue = this.misplacedError(cmdp, c)) > err)) continue;
                    err = errvalue;
                    continue;
                }
                errvalue = this.noiseError(cmdp, c);
                if (!(errvalue > err)) continue;
                err = errvalue;
            }
            if (coverage == 0) {
                if (!cmdp.isNoise()) {
                    err = this.missedError(cmdp, true);
                    errorMissed += weight * err;
                }
            } else if (!cmdp.isNoise()) {
                errorMisplaced += err * weight;
            } else {
                errorNoise += err * weight;
            }
            totalError += err * weight;
            if (err != 0.0) {
                ++totalErrorCount;
            }
            if (coverage > 0) {
                ++totalCoverage;
            }
            if (coverage > 0 && !cmdp.isNoise()) {
                ++trueCoverage;
            }
            if (coverage > 1) {
                ++totalRedundancy;
            }
            cmdp.p.setMeasureValue("CMM", err);
            cmdp.p.setMeasureValue("Redundancy", coverage);
        }
        this.addValue("CMM", totalErrorMax != 0.0 ? 1.0 - totalError / totalErrorMax : 1.0);
        this.addValue("CMM Missed", errorMissedMax != 0.0 ? 1.0 - errorMissed / errorMissedMax : 1.0);
        this.addValue("CMM Misplaced", errorMisplacedMax != 0.0 ? 1.0 - errorMisplaced / errorMisplacedMax : 1.0);
        this.addValue("CMM Noise", errorNoiseMax != 0.0 ? 1.0 - errorNoise / errorNoiseMax : 1.0);
        this.addValue("CMM Basic", 1.0 - (double)totalErrorCount / (double)this.numPoints);
        if (this.debug) {
            System.out.println("-------------");
        }
    }

    private double noiseError(CMM_GTAnalysis.CMMPoint cmdp, int assignedClusterID) {
        double error;
        int gtAssignedID = this.matchMap[assignedClusterID];
        if (gtAssignedID == -1) {
            error = 1.0;
            cmdp.p.setMeasureValue("CMM Type", "noise - cluster");
        } else if (this.enableModelError && this.gtAnalysis.getGT0Cluster(gtAssignedID).getInclusionProbability(cmdp) >= this.pointInclusionProbThreshold) {
            error = 1.0E-5;
            cmdp.p.setMeasureValue("CMM Type", "noise - byModel");
        } else {
            error = 1.0 - this.gtAnalysis.getConnectionValue(cmdp, gtAssignedID);
            cmdp.p.setMeasureValue("CMM Type", "noise");
        }
        return error;
    }

    private double missedError(CMM_GTAnalysis.CMMPoint cmdp, boolean useHullDistance) {
        cmdp.p.setMeasureValue("CMM Type", "missed");
        if (!useHullDistance) {
            return cmdp.connectivity;
        }
        double minHullDist = 1.0;
        for (int fc = 0; fc < this.numFClusters; ++fc) {
            if (this.matchMap[fc] == -1 || this.matchMap[fc] != cmdp.workclass()) continue;
            if (this.clustering.get(fc) instanceof SphereCluster) {
                double radius;
                SphereCluster sc = (SphereCluster)this.clustering.get(fc);
                double distanceFC = sc.getCenterDistance(cmdp);
                double hullDist = (distanceFC - (radius = sc.getRadius())) / (distanceFC + radius);
                if (!(hullDist < minHullDist)) continue;
                minHullDist = hullDist;
                continue;
            }
            double min = 1.0;
            double max = 1.0;
            double hullDist = min / max;
            if (!(hullDist < minHullDist)) continue;
            minHullDist = hullDist;
        }
        if (minHullDist > 1.0) {
            minHullDist = 1.0;
        }
        double weight = 1.0 - Math.exp(-this.lamdaMissed * minHullDist);
        cmdp.p.setMeasureValue("HullDistWeight", weight);
        return weight * cmdp.connectivity;
    }

    private double misplacedError(CMM_GTAnalysis.CMMPoint cmdp, int assignedClusterID) {
        double err_value;
        double weight = 0.0;
        int gtAssignedID = this.matchMap[assignedClusterID];
        if (gtAssignedID == -1) {
            System.out.println("Point " + cmdp.getTimestamp() + " from gtcluster " + cmdp.trueClass + " assigned to noise cluster " + assignedClusterID);
            return 1.0;
        }
        if (gtAssignedID == cmdp.workclass()) {
            return 0.0;
        }
        if (this.enableModelError && this.gtAnalysis.getGT0Cluster(gtAssignedID).getInclusionProbability(cmdp) >= this.pointInclusionProbThreshold) {
            weight = 0.0;
            cmdp.p.setMeasureValue("CMM Type", "missplaced - byModel");
        } else {
            weight = 1.0 - this.gtAnalysis.getConnectionValue(cmdp, gtAssignedID);
        }
        if (weight == 0.0) {
            err_value = 1.0E-5;
        } else {
            err_value = weight * cmdp.connectivity;
            cmdp.p.setMeasureValue("CMM Type", "missplaced");
        }
        return err_value;
    }

    public String getParameterString() {
        String para = this.gtAnalysis.getParameterString();
        para = para + "lambdaMissed=" + this.lamdaMissed + ";";
        return para;
    }
}

