/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.clustream;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import moa.cluster.CFCluster;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.clustream.ClustreamKernel;
import moa.core.Measurement;

public class Clustream
extends AbstractClusterer {
    private static final long serialVersionUID = 1L;
    public IntOption timeWindowOption = new IntOption("horizon", 'h', "Rang of the window.", 1000);
    public IntOption maxNumKernelsOption = new IntOption("maxNumKernels", 'k', "Maximum number of micro kernels to use.", 100);
    public IntOption kernelRadiFactorOption = new IntOption("kernelRadiFactor", 't', "Multiplier for the kernel radius", 2);
    private int timeWindow;
    private long timestamp = -1L;
    private ClustreamKernel[] kernels;
    private boolean initialized;
    private List<ClustreamKernel> buffer;
    private int bufferSize;
    private double t;
    private int m;

    @Override
    public void resetLearningImpl() {
        this.kernels = new ClustreamKernel[this.maxNumKernelsOption.getValue()];
        this.timeWindow = this.timeWindowOption.getValue();
        this.initialized = false;
        this.buffer = new LinkedList<ClustreamKernel>();
        this.bufferSize = this.maxNumKernelsOption.getValue();
        this.t = this.kernelRadiFactorOption.getValue();
        this.m = this.maxNumKernelsOption.getValue();
    }

    @Override
    public void trainOnInstanceImpl(Instance instance) {
        int dim = instance.numValues();
        ++this.timestamp;
        if (!this.initialized) {
            if (this.buffer.size() < this.bufferSize) {
                this.buffer.add(new ClustreamKernel(instance, dim, this.timestamp, this.t, this.m));
                return;
            }
            int k = this.kernels.length;
            assert (k <= this.bufferSize);
            Cluster[] centers = new ClustreamKernel[k];
            for (int i = 0; i < k; ++i) {
                centers[i] = this.buffer.get(i);
            }
            Clustering kmeans_clustering = Clustream.kMeans(k, centers, this.buffer);
            for (int i = 0; i < kmeans_clustering.size(); ++i) {
                this.kernels[i] = new ClustreamKernel(new DenseInstance(1.0, ((ClustreamKernel)centers[i]).getCenter()), dim, this.timestamp, this.t, this.m);
            }
            this.buffer.clear();
            this.initialized = true;
            return;
        }
        CFCluster closestKernel = null;
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < this.kernels.length; ++i) {
            double distance = Clustream.distance(instance.toDoubleArray(), this.kernels[i].getCenter());
            if (!(distance < minDistance)) continue;
            closestKernel = this.kernels[i];
            minDistance = distance;
        }
        double radius = 0.0;
        if (closestKernel.getWeight() == 1.0) {
            radius = Double.MAX_VALUE;
            double[] center = ((ClustreamKernel)closestKernel).getCenter();
            for (int i = 0; i < this.kernels.length; ++i) {
                if (this.kernels[i] == closestKernel) continue;
                double distance = Clustream.distance(this.kernels[i].getCenter(), center);
                radius = Math.min(distance, radius);
            }
        } else {
            radius = ((ClustreamKernel)closestKernel).getRadius();
        }
        if (minDistance < radius) {
            ((ClustreamKernel)closestKernel).insert(instance, this.timestamp);
            return;
        }
        long threshold = this.timestamp - (long)this.timeWindow;
        for (int i = 0; i < this.kernels.length; ++i) {
            if (!(this.kernels[i].getRelevanceStamp() < (double)threshold)) continue;
            this.kernels[i] = new ClustreamKernel(instance, dim, this.timestamp, this.t, this.m);
            return;
        }
        int closestA = 0;
        int closestB = 0;
        minDistance = Double.MAX_VALUE;
        for (int i = 0; i < this.kernels.length; ++i) {
            double[] centerA = this.kernels[i].getCenter();
            for (int j = i + 1; j < this.kernels.length; ++j) {
                double dist = Clustream.distance(centerA, this.kernels[j].getCenter());
                if (!(dist < minDistance)) continue;
                minDistance = dist;
                closestA = i;
                closestB = j;
            }
        }
        assert (closestA != closestB);
        this.kernels[closestA].add(this.kernels[closestB]);
        this.kernels[closestB] = new ClustreamKernel(instance, dim, this.timestamp, this.t, this.m);
    }

    @Override
    public Clustering getMicroClusteringResult() {
        if (!this.initialized) {
            return new Clustering(new Cluster[0]);
        }
        Cluster[] res = new ClustreamKernel[this.kernels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new ClustreamKernel(this.kernels[i], this.t, this.m);
        }
        return new Clustering(res);
    }

    @Override
    public boolean implementsMicroClusterer() {
        return true;
    }

    @Override
    public Clustering getClusteringResult() {
        return null;
    }

    public String getName() {
        return "Clustream " + this.timeWindow;
    }

    private static double distance(double[] pointA, double[] pointB) {
        double distance = 0.0;
        for (int i = 0; i < pointA.length; ++i) {
            double d = pointA[i] - pointB[i];
            distance += d * d;
        }
        return Math.sqrt(distance);
    }

    public static Clustering kMeans(int k, List<? extends Cluster> data) {
        Random random = new Random(0L);
        Cluster[] centers = new Cluster[k];
        for (int i = 0; i < centers.length; ++i) {
            int rid = random.nextInt(k);
            centers[i] = new SphereCluster(data.get(rid).getCenter(), 0.0);
        }
        Clustering clustering = Clustream.kMeans(k, centers, data);
        return clustering;
    }

    /*
     * WARNING - void declaration
     */
    public static Clustering kMeans(int k, Cluster[] centers, List<? extends Cluster> data) {
        assert (centers.length == k);
        assert (k > 0);
        int dimensions = centers[0].getCenter().length;
        ArrayList clustering = new ArrayList();
        for (int i = 0; i < k; ++i) {
            clustering.add(new ArrayList());
        }
        int repetitions = 100;
        while (repetitions-- >= 0) {
            void var7_7;
            for (Cluster cluster : data) {
                double minDistance = Clustream.distance(cluster.getCenter(), centers[0].getCenter());
                int closestCluster = 0;
                for (int i = 1; i < k; ++i) {
                    double distance = Clustream.distance(cluster.getCenter(), centers[i].getCenter());
                    if (!(distance < minDistance)) continue;
                    closestCluster = i;
                    minDistance = distance;
                }
                ((ArrayList)clustering.get(closestCluster)).add(cluster);
            }
            SphereCluster[] newCenters = new SphereCluster[centers.length];
            boolean bl = false;
            while (var7_7 < k) {
                newCenters[var7_7] = Clustream.calculateCenter((ArrayList)clustering.get((int)var7_7), dimensions);
                ((ArrayList)clustering.get((int)var7_7)).clear();
                ++var7_7;
            }
            centers = newCenters;
        }
        return new Clustering(centers);
    }

    private static SphereCluster calculateCenter(ArrayList<Cluster> cluster, int dimensions) {
        double[] res = new double[dimensions];
        for (int i = 0; i < res.length; ++i) {
            res[i] = 0.0;
        }
        if (cluster.size() == 0) {
            return new SphereCluster(res, 0.0);
        }
        for (Cluster point : cluster) {
            double[] center = point.getCenter();
            for (int i = 0; i < res.length; ++i) {
                int n = i;
                res[n] = res[n] + center[i];
            }
        }
        int i = 0;
        while (i < res.length) {
            int n = i++;
            res[n] = res[n] / (double)cluster.size();
        }
        double radius = 0.0;
        for (Cluster point : cluster) {
            double dist = Clustream.distance(res, point.getCenter());
            if (!(dist > radius)) continue;
            radius = dist;
        }
        SphereCluster sc = new SphereCluster(res, radius);
        sc.setWeight(cluster.size());
        return sc;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

