/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.functions;

import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.classifiers.AbstractMultiLabelLearner;
import moa.classifiers.MultiTargetRegressor;
import moa.classifiers.rules.multilabel.errormeasurers.AbstractMultiTargetErrorMeasurer;
import moa.classifiers.rules.multilabel.errormeasurers.MultiTargetErrorMeasurer;
import moa.classifiers.rules.multilabel.functions.AMRulesFunction;
import moa.core.Measurement;
import moa.options.ClassOption;

public class AdaptiveMultiTargetRegressor
extends AbstractMultiLabelLearner
implements MultiTargetRegressor,
AMRulesFunction {
    private static final long serialVersionUID = 1L;
    private static final int NUM_LEARNERS = 2;
    public ClassOption baseLearnerOption1 = new ClassOption("baseLearner1", 'l', "First base learner.", MultiTargetRegressor.class, "moa.classifiers.rules.multilabel.functions.MultiLabelTargetMeanRegressor");
    public ClassOption baseLearnerOption2 = new ClassOption("baseLearner2", 'm', "Second base learner.", MultiTargetRegressor.class, "moa.classifiers.rules.multilabel.functions.MultiLabelPerceptronRegressor");
    public ClassOption errorMeasurerOption = new ClassOption("errorMeasurer", 'e', "Measure of error for deciding which learner should predict.", AbstractMultiTargetErrorMeasurer.class, "MeanAbsoluteDeviationMT");
    protected boolean hasStarted;
    protected MultiTargetRegressor[] baseLearner;
    protected MultiTargetErrorMeasurer[] errorMeasurer;

    @Override
    public void trainOnInstanceImpl(MultiLabelInstance instance) {
        int i;
        if (!this.hasStarted) {
            this.baseLearner = new MultiTargetRegressor[2];
            this.errorMeasurer = new MultiTargetErrorMeasurer[2];
            this.baseLearner[0] = (MultiTargetRegressor)this.getPreparedClassOption(this.baseLearnerOption1);
            this.baseLearner[1] = (MultiTargetRegressor)this.getPreparedClassOption(this.baseLearnerOption2);
            for (i = 0; i < 2; ++i) {
                this.baseLearner[i].resetLearning();
                this.errorMeasurer[i] = (MultiTargetErrorMeasurer)((MultiTargetErrorMeasurer)this.getPreparedClassOption(this.errorMeasurerOption)).copy();
            }
            this.hasStarted = true;
        }
        for (i = 0; i < 2; ++i) {
            Prediction prediction = this.baseLearner[i].getPredictionForInstance(instance);
            if (prediction != null) {
                this.errorMeasurer[i].addPrediction(prediction, instance);
            }
            this.baseLearner[i].trainOnInstanceImpl(instance);
        }
    }

    @Override
    public Prediction getPredictionForInstance(MultiLabelInstance inst) {
        Prediction prediction = null;
        if (this.hasStarted) {
            int bestIndex = 0;
            double minError = Double.MAX_VALUE;
            for (int i = 0; i < 2; ++i) {
                double error = this.errorMeasurer[i].getCurrentError();
                if (!(error < minError)) continue;
                minError = error;
                bestIndex = i;
            }
            prediction = this.baseLearner[bestIndex].getPredictionForInstance(inst);
        }
        return prediction;
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public void resetLearningImpl() {
        this.hasStarted = false;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public String getPurposeString() {
        return "Learns two regressors and uses the regressor with less error to predict.";
    }

    @Override
    public void resetWithMemory() {
        if (this.errorMeasurer == null) {
            this.errorMeasurer = new MultiTargetErrorMeasurer[2];
        }
        for (int i = 0; i < 2; ++i) {
            this.errorMeasurer[i] = (MultiTargetErrorMeasurer)((MultiTargetErrorMeasurer)this.getPreparedClassOption(this.errorMeasurerOption)).copy();
            if (!(this.baseLearner[i] instanceof AMRulesFunction)) continue;
            ((AMRulesFunction)((Object)this.baseLearner[i])).resetWithMemory();
        }
    }
}

