/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.core.voting;

import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.classifiers.rules.multilabel.core.voting.AbstractErrorWeightedVoteMultiLabel;

public class InverseErrorWeightedVoteMultiLabel
extends AbstractErrorWeightedVoteMultiLabel {
    private static final double EPS = 1.0E-9;
    private static final long serialVersionUID = 6359349250620616482L;

    @Override
    public Prediction computeWeightedVote() {
        int n = this.votes.size();
        if (n > 0) {
            int numOutputs = this.outputAttributesCount.length;
            this.weights = new double[n][numOutputs];
            this.weightedVote = new MultiLabelPrediction(numOutputs);
            double[] sumError = new double[numOutputs];
            for (int o = 0; o < numOutputs; ++o) {
                for (int i = 0; i < n; ++i) {
                    if (!((Prediction)this.votes.get(i)).hasVotesForAttribute(o) || this.errors.get(i) == null) continue;
                    this.weights[i][o] = 1.0 / (((double[])this.errors.get(i))[o] + 1.0E-9);
                    int n2 = o;
                    sumError[n2] = sumError[n2] + this.weights[i][o];
                }
                int numClasses = ((Prediction)this.votes.get(0)).numClasses(o);
                for (int i = 0; i < n; ++i) {
                    if (((Prediction)this.votes.get(i)).hasVotesForAttribute(o)) {
                        if (sumError[o] > 0.0) {
                            double[] dArray = this.weights[i];
                            int n3 = o;
                            dArray[n3] = dArray[n3] / sumError[o];
                        } else {
                            this.weights[i][o] = 1.0 / (double)this.outputAttributesCount[o];
                        }
                    }
                    for (int j = 0; j < numClasses; ++j) {
                        this.weightedVote.setVote(o, j, this.weightedVote.getVote(o, j) + ((Prediction)this.votes.get(i)).getVote(o, j) * this.weights[i][o]);
                    }
                }
            }
        }
        return this.weightedVote;
    }
}

