/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.core.voting;

import com.yahoo.labs.samoa.instances.Prediction;
import java.util.ArrayList;
import java.util.List;
import moa.AbstractMOAObject;
import moa.classifiers.rules.multilabel.core.voting.ErrorWeightedVoteMultiLabel;

public abstract class AbstractErrorWeightedVoteMultiLabel
extends AbstractMOAObject
implements ErrorWeightedVoteMultiLabel {
    private static final long serialVersionUID = 1L;
    protected List<Prediction> votes = new ArrayList<Prediction>();
    protected List<double[]> errors = new ArrayList<double[]>();
    protected double[][] weights;
    protected int[] outputAttributesCount;
    protected Prediction weightedVote = null;

    @Override
    public void addVote(Prediction vote, double[] error) {
        int numOutputs = vote.numOutputAttributes();
        if (this.outputAttributesCount == null) {
            this.outputAttributesCount = new int[numOutputs];
        }
        for (int i = 0; i < numOutputs; ++i) {
            if (!vote.hasVotesForAttribute(i)) continue;
            int n = i;
            this.outputAttributesCount[n] = this.outputAttributesCount[n] + 1;
        }
        this.votes.add(vote);
        this.errors.add(error);
    }

    @Override
    public abstract Prediction computeWeightedVote();

    @Override
    public double getWeightedError() {
        double[] errors = this.getOutputAttributesErrors();
        if (errors != null) {
            int numOutputs = errors.length;
            double error = 0.0;
            for (int i = 0; i < numOutputs; ++i) {
                error += errors[i];
            }
            return error / (double)numOutputs;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public double[][] getWeights() {
        return this.weights;
    }

    @Override
    public int getNumberVotes() {
        return this.votes.size();
    }

    @Override
    public int getNumberVotes(int outputAttribute) {
        return this.outputAttributesCount[outputAttribute];
    }

    @Override
    public double[] getOutputAttributesErrors() {
        if (this.weights != null && this.weights.length == this.errors.size()) {
            int numOutputs = this.outputAttributesCount.length;
            int numVotes = this.weights.length;
            double[] weightedError = new double[numOutputs];
            for (int i = 0; i < numVotes; ++i) {
                for (int j = 0; j < numOutputs; ++j) {
                    if (this.errors.get(i) == null || this.errors.get(i)[j] == Double.MAX_VALUE) continue;
                    int n = j;
                    weightedError[n] = weightedError[n] + this.errors.get(i)[j] * this.weights[i][j];
                }
            }
            return weightedError;
        }
        return null;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    public Prediction getPrediction() {
        if (this.weightedVote == null) {
            this.weightedVote = this.computeWeightedVote();
        }
        return this.weightedVote;
    }
}

