/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.core;

import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.Prediction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import moa.AbstractMOAObject;
import moa.classifiers.MultiLabelLearner;
import moa.classifiers.core.driftdetection.ChangeDetector;
import moa.classifiers.rules.core.anomalydetection.AnomalyDetector;
import moa.classifiers.rules.multilabel.attributeclassobservers.NominalStatisticsObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.NumericStatisticsObserver;
import moa.classifiers.rules.multilabel.core.LearningLiteral;
import moa.classifiers.rules.multilabel.core.Literal;
import moa.classifiers.rules.multilabel.core.splitcriteria.MultiLabelSplitCriterion;
import moa.classifiers.rules.multilabel.errormeasurers.MultiLabelErrorMeasurer;
import moa.classifiers.rules.multilabel.outputselectors.OutputAttributesSelector;
import moa.core.StringUtils;

public class MultiLabelRule
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    protected List<Literal> literalList = new LinkedList<Literal>();
    protected LearningLiteral learningLiteral;
    protected int ruleNumberID;
    protected MultiLabelRule otherBranchRule;

    public MultiLabelRule(LearningLiteral learningLiteral) {
        this.learningLiteral = learningLiteral;
    }

    public MultiLabelRule() {
    }

    public MultiLabelRule(int id) {
        this();
        this.ruleNumberID = id;
    }

    public int getRuleNumberID() {
        return this.ruleNumberID;
    }

    public void setRuleNumberID(int ruleNumberID) {
        this.ruleNumberID = ruleNumberID;
    }

    public boolean isCovering(MultiLabelInstance inst) {
        boolean isCovering = true;
        for (Literal l : this.literalList) {
            if (l.evaluate(inst)) continue;
            isCovering = false;
            break;
        }
        return isCovering;
    }

    public int[] getOutputsCovered() {
        return this.learningLiteral.getOutputsToLearn();
    }

    @Override
    public void getDescription(StringBuilder out, int indent) {
        StringUtils.appendIndented(out, indent + 1, "Rule Nr." + this.ruleNumberID + " Instances seen:" + this.learningLiteral.getWeightSeenSinceExpansion() + "\n");
        for (Literal literal : this.literalList) {
            literal.getDescription(out, indent + 1);
            StringUtils.appendIndented(out, indent + 1, " ");
        }
        StringUtils.appendNewline(out);
    }

    public boolean updateChangeDetection(MultiLabelInstance instance) {
        return this.learningLiteral.updateAndCheckChange(instance);
    }

    public boolean updateAnomalyDetection(MultiLabelInstance instance) {
        return this.learningLiteral.updateAndCheckAnomalyDetection(instance);
    }

    public void trainOnInstance(MultiLabelInstance instance) {
        this.learningLiteral.trainOnInstance(instance);
    }

    public double getWeightSeenSinceExpansion() {
        return this.learningLiteral.getWeightSeenSinceExpansion();
    }

    public LearningLiteral getLearningNode() {
        return this.learningLiteral;
    }

    public double[] getCurrentErrors() {
        return this.learningLiteral.getErrors();
    }

    public Prediction getPredictionForInstance(MultiLabelInstance instance) {
        return this.learningLiteral.getPredictionForInstance(instance);
    }

    public boolean tryToExpand(double splitConfidence, double tieThresholdOption) {
        boolean hasExpanded = this.learningLiteral.tryToExpand(splitConfidence, tieThresholdOption);
        if (hasExpanded) {
            this.otherBranchRule = new MultiLabelRule(this.learningLiteral.getOtherBranchLearningLiteral());
            int attribIndex = this.learningLiteral.getBestSuggestion().getPredicate().getAttributeIndex();
            boolean isEqualOrLess = this.learningLiteral.getBestSuggestion().getPredicate().isEqualOrLess();
            Iterator<Literal> it = this.literalList.iterator();
            while (it.hasNext()) {
                Literal l = it.next();
                if (l.predicate.getAttributeIndex() != attribIndex || l.predicate.isEqualOrLess() != isEqualOrLess) continue;
                it.remove();
                break;
            }
            this.literalList.add(new Literal(this.learningLiteral.getBestSuggestion().getPredicate()));
            this.learningLiteral = this.learningLiteral.getExpandedLearningLiteral();
        }
        return hasExpanded;
    }

    public MultiLabelRule getNewRuleFromOtherBranch() {
        return this.otherBranchRule;
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        this.getDescription(out, 1);
        return out.toString();
    }

    public void setSplitCriterion(MultiLabelSplitCriterion splitCriterion) {
        this.learningLiteral.setSplitCriterion(splitCriterion);
    }

    public void setChangeDetector(ChangeDetector changeDetector) {
        this.learningLiteral.setChangeDetector(changeDetector);
    }

    public void setAnomalyDetector(AnomalyDetector anomalyDetector) {
        this.learningLiteral.setAnomalyDetector(anomalyDetector);
    }

    public void setNumericObserverOption(NumericStatisticsObserver numericStatisticsObserver) {
        this.learningLiteral.setNumericObserverOption(numericStatisticsObserver);
    }

    public void setLearner(MultiLabelLearner learner) {
        this.learningLiteral.setLearner(learner);
    }

    public void setErrorMeasurer(MultiLabelErrorMeasurer errorMeasurer) {
        this.learningLiteral.setErrorMeasurer(errorMeasurer);
    }

    public void setOutputAttributesSelector(OutputAttributesSelector outputSelector) {
        this.learningLiteral.setOutputAttributesSelector(outputSelector);
    }

    public void setNominalObserverOption(NominalStatisticsObserver nominalStatisticsObserver) {
        this.learningLiteral.setNominalObserverOption(nominalStatisticsObserver);
    }

    public void setRandomGenerator(Random random) {
        this.learningLiteral.setRandomGenerator(random);
    }

    public void setAttributesPercentage(double attributesPercentage) {
        this.learningLiteral.setAttributesPercentage(attributesPercentage);
    }
}

