/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.core;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.Prediction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import moa.classifiers.MultiLabelLearner;
import moa.classifiers.core.driftdetection.ChangeDetector;
import moa.classifiers.rules.core.anomalydetection.AnomalyDetector;
import moa.classifiers.rules.multilabel.attributeclassobservers.AttributeStatisticsObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.NominalStatisticsObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.NumericStatisticsObserver;
import moa.classifiers.rules.multilabel.core.AttributeExpansionSuggestion;
import moa.classifiers.rules.multilabel.core.splitcriteria.MultiLabelSplitCriterion;
import moa.classifiers.rules.multilabel.errormeasurers.MultiLabelErrorMeasurer;
import moa.classifiers.rules.multilabel.outputselectors.OutputAttributesSelector;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.options.AbstractOptionHandler;

public abstract class LearningLiteral
extends AbstractOptionHandler {
    private static final long serialVersionUID = 1L;
    protected AutoExpandVector<AttributeStatisticsObserver> attributeObservers;
    protected DoubleVector[] literalStatistics;
    protected int[] outputsToLearn;
    protected MultiLabelLearner learner;
    protected MultiLabelErrorMeasurer errorMeasurer;
    protected ChangeDetector[] changeDetectors;
    protected ChangeDetector changeDetector;
    protected AnomalyDetector anomalyDetector;
    protected MultiLabelSplitCriterion splitCriterion;
    protected double weightSeen;
    protected boolean hasStarted;
    protected LearningLiteral expandedLearningLiteral;
    protected LearningLiteral otherBranchLearningLiteral;
    protected AttributeExpansionSuggestion bestSuggestion;
    protected NumericStatisticsObserver numericStatisticsObserver;
    protected NominalStatisticsObserver nominalStatisticsObserver;
    protected OutputAttributesSelector outputSelector;
    protected Random randomGenerator;
    protected boolean[] attributesMask;
    protected double attributesPercentage;

    public LearningLiteral() {
    }

    public LearningLiteral(int[] outputsToLearn) {
        this();
        this.outputsToLearn = (int[])outputsToLearn.clone();
    }

    public abstract void trainOnInstance(MultiLabelInstance var1);

    public Prediction getPredictionForInstance(MultiLabelInstance instance) {
        if (this.learner != null) {
            return this.learner.getPredictionForInstance(instance);
        }
        return null;
    }

    public abstract boolean tryToExpand(double var1, double var3);

    public boolean updateAndCheckChange(MultiLabelInstance instance) {
        boolean hasChanged = false;
        if (this.hasStarted) {
            if (this.changeDetectors == null) {
                this.changeDetectors = new ChangeDetector[this.outputsToLearn.length];
                for (int i = 0; i < this.outputsToLearn.length; ++i) {
                    this.changeDetectors[i] = this.changeDetector.copy();
                }
            }
            Prediction prediction = this.getPredictionForInstance(instance);
            double[] normalizedErrors = this.getNormalizedErrors(prediction, instance);
            for (int i = 0; i < this.outputsToLearn.length; ++i) {
                this.changeDetectors[i].input(normalizedErrors[i]);
                if (!this.changeDetectors[i].getChange()) continue;
                hasChanged = true;
                break;
            }
        }
        return hasChanged;
    }

    protected abstract double[] getNormalizedErrors(Prediction var1, Instance var2);

    public boolean updateAndCheckAnomalyDetection(MultiLabelInstance instance) {
        if (this.hasStarted) {
            return this.anomalyDetector.updateAndCheckAnomalyDetection(instance);
        }
        return false;
    }

    public double getWeightSeenSinceExpansion() {
        return this.weightSeen;
    }

    public int[] getOutputsToLearn() {
        return this.outputsToLearn;
    }

    public void setOutputsToLearn(int[] outputsToLearn) {
        this.outputsToLearn = outputsToLearn;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    public LearningLiteral getExpandedLearningLiteral() {
        return this.expandedLearningLiteral;
    }

    public LearningLiteral getOtherBranchLearningLiteral() {
        return this.otherBranchLearningLiteral;
    }

    public double[] getErrors() {
        if (this.errorMeasurer != null) {
            return this.errorMeasurer.getCurrentErrors();
        }
        return null;
    }

    public void setSplitCriterion(MultiLabelSplitCriterion splitCriterion) {
        this.splitCriterion = splitCriterion;
    }

    public void setChangeDetector(ChangeDetector changeDetector) {
        this.changeDetectors = null;
        this.changeDetector = changeDetector;
    }

    public void setAnomalyDetector(AnomalyDetector anomalyDetector) {
        this.anomalyDetector = anomalyDetector;
    }

    public void setNumericObserverOption(NumericStatisticsObserver numericStatisticsObserver) {
        if (this.attributeObservers != null) {
            for (AttributeStatisticsObserver obs : this.attributeObservers) {
                if (!(obs instanceof NumericStatisticsObserver)) continue;
                Object var3_3 = null;
            }
        }
        this.numericStatisticsObserver = numericStatisticsObserver;
    }

    public void setLearner(MultiLabelLearner learner) {
        this.learner = learner;
    }

    public void setErrorMeasurer(MultiLabelErrorMeasurer errorMeasurer) {
        this.errorMeasurer = errorMeasurer;
    }

    public AttributeExpansionSuggestion getBestSuggestion() {
        return this.bestSuggestion;
    }

    public static double computeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    public void setOutputAttributesSelector(OutputAttributesSelector outputSelector) {
        this.outputSelector = outputSelector;
    }

    public void setNominalObserverOption(NominalStatisticsObserver nominalStatisticsObserver) {
        this.nominalStatisticsObserver = nominalStatisticsObserver;
    }

    public void setRandomGenerator(Random random) {
        this.randomGenerator = random;
    }

    public void setAttributesPercentage(double attributesPercentage) {
        this.attributesPercentage = attributesPercentage;
    }

    protected void initializeAttibutesMask(MultiLabelInstance inst) {
        int i;
        int numInputAttributes = inst.numInputAttributes();
        int numAttributesSelected = (int)Math.round((double)numInputAttributes * this.attributesPercentage / 100.0);
        this.attributesMask = new boolean[numInputAttributes];
        ArrayList<Integer> indices = new ArrayList<Integer>(numInputAttributes);
        for (i = 0; i < numInputAttributes; ++i) {
            indices.add(i);
        }
        Collections.shuffle(indices, this.randomGenerator);
        for (i = 0; i < numAttributesSelected; ++i) {
            this.attributesMask[((Integer)indices.get((int)i)).intValue()] = true;
        }
    }
}

