/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.Prediction;
import java.util.Iterator;
import moa.classifiers.AbstractMultiLabelLearner;
import moa.classifiers.MultiLabelLearner;
import moa.classifiers.core.driftdetection.ChangeDetector;
import moa.classifiers.rules.core.anomalydetection.AnomalyDetector;
import moa.classifiers.rules.core.anomalydetection.OddsRatioScore;
import moa.classifiers.rules.multilabel.attributeclassobservers.NominalStatisticsObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.NumericStatisticsObserver;
import moa.classifiers.rules.multilabel.core.MultiLabelRule;
import moa.classifiers.rules.multilabel.core.MultiLabelRuleSet;
import moa.classifiers.rules.multilabel.core.splitcriteria.MultiLabelSplitCriterion;
import moa.classifiers.rules.multilabel.core.voting.ErrorWeightedVoteMultiLabel;
import moa.classifiers.rules.multilabel.errormeasurers.MultiLabelErrorMeasurer;
import moa.classifiers.rules.multilabel.outputselectors.OutputAttributesSelector;
import moa.classifiers.rules.multilabel.outputselectors.SelectAllOutputs;
import moa.core.Measurement;
import moa.core.StringUtils;
import moa.options.ClassOption;

public abstract class AMRulesMultiLabelLearner
extends AbstractMultiLabelLearner
implements MultiLabelLearner {
    private static final long serialVersionUID = 1L;
    protected MultiLabelRuleSet ruleSet = new MultiLabelRuleSet();
    protected MultiLabelRule defaultRule;
    protected int ruleNumberID = 1;
    protected double[] statistics;
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "Hoeffding Bound Parameter. The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-7, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Hoeffding Bound Parameter. Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "Hoeffding Bound Parameter. The number of instances a leaf should observe between split attempts.", 200, 1, Integer.MAX_VALUE);
    public ClassOption learnerOption;
    public FlagOption unorderedRulesOption = new FlagOption("setUnorderedRulesOn", 'U', "unorderedRules.");
    public ClassOption changeDetector = new ClassOption("changeDetector", 'H', "Change Detector.", ChangeDetector.class, "PageHinkleyDM -d 0.05 -l 35.0");
    public ClassOption anomalyDetector = new ClassOption("anomalyDetector", 'A', "Anomaly Detector.", AnomalyDetector.class, OddsRatioScore.class.getName());
    public ClassOption splitCriterionOption;
    public ClassOption errorMeasurerOption;
    public ClassOption weightedVoteOption;
    public ClassOption numericObserverOption = new ClassOption("numericObserver", 'y', "Numeric observer.", NumericStatisticsObserver.class, "MultiLabelBSTree");
    public ClassOption nominalObserverOption = new ClassOption("nominalObserver", 'z', "Nominal observer.", NominalStatisticsObserver.class, "MultiLabelNominalAttributeObserver");
    public IntOption VerbosityOption = new IntOption("verbosity", 'v', "Output Verbosity Control Level. 1 (Less) to 5 (More)", 1, 1, 5);
    public ClassOption outputSelectorOption = new ClassOption("outputSelector", 'O', "Output attributes selector", OutputAttributesSelector.class, SelectAllOutputs.class.getName());
    protected double attributesPercentage = 100.0;
    private double numChangesDetected;
    private double numAnomaliesDetected;
    private double numInstances;

    public double getAttributesPercentage() {
        return this.attributesPercentage;
    }

    public void setAttributesPercentage(double attributesPercentage) {
        this.attributesPercentage = attributesPercentage;
    }

    public AMRulesMultiLabelLearner() {
    }

    public AMRulesMultiLabelLearner(double attributesPercentage) {
        this();
        this.attributesPercentage = attributesPercentage;
    }

    @Override
    public Prediction getPredictionForInstance(MultiLabelInstance inst) {
        ErrorWeightedVoteMultiLabel vote = this.getVotes(inst);
        if (vote != null) {
            return vote.getPrediction();
        }
        return null;
    }

    public ErrorWeightedVoteMultiLabel getVotes(MultiLabelInstance instance) {
        Prediction vote;
        ErrorWeightedVoteMultiLabel errorWeightedVote = this.newErrorWeightedVote();
        this.debug("Test", 3);
        int numberOfRulesCovering = 0;
        this.VerboseToConsole(instance);
        for (MultiLabelRule rule : this.ruleSet) {
            if (!rule.isCovering(instance)) continue;
            ++numberOfRulesCovering;
            Prediction vote2 = rule.getPredictionForInstance(instance);
            if (vote2 != null) {
                double[] errors = rule.getCurrentErrors();
                this.debug("Rule No" + rule.getRuleNumberID() + " Vote: " + vote2.toString() + " Error: " + errors + " Y: " + instance.classValue(), 3);
                errorWeightedVote.addVote(vote2, errors);
            }
            if (this.unorderedRulesOption.isSet()) continue;
            break;
        }
        if (numberOfRulesCovering == 0 && (vote = this.defaultRule.getPredictionForInstance(instance)) != null) {
            double[] errors = this.defaultRule.getCurrentErrors();
            errorWeightedVote.addVote(vote, errors);
            this.debug("Default Rule Vote " + vote.toString() + "\n Error " + errors + "  Y: " + instance, 3);
        }
        errorWeightedVote.computeWeightedVote();
        return errorWeightedVote;
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public void trainOnInstanceImpl(MultiLabelInstance instance) {
        this.numInstances += instance.weight();
        this.debug("Train", 3);
        this.debug("N\u00ba instance " + this.numInstances + " - " + instance.toString(), 3);
        boolean rulesCoveringInstance = false;
        Iterator ruleIterator = this.ruleSet.iterator();
        while (ruleIterator.hasNext()) {
            MultiLabelRule rule = (MultiLabelRule)ruleIterator.next();
            if (!rule.isCovering(instance)) continue;
            rulesCoveringInstance = true;
            if (!rule.updateAnomalyDetection(instance)) {
                if (rule.updateChangeDetection(instance)) {
                    this.debug("I) Drift Detected. Exa. : " + this.numInstances + " (" + rule.getWeightSeenSinceExpansion() + ") Remove Rule: " + rule.getRuleNumberID(), 1);
                    ruleIterator.remove();
                    this.numChangesDetected += instance.weight();
                } else {
                    rule.trainOnInstance(instance);
                    if (rule.getWeightSeenSinceExpansion() % (double)this.gracePeriodOption.getValue() == 0.0 && rule.tryToExpand(this.splitConfidenceOption.getValue(), this.tieThresholdOption.getValue())) {
                        this.setRuleOptions(rule);
                        this.debug("Rule Expanded:", 2);
                        this.debug(rule.toString(), 2);
                    }
                }
            } else {
                this.debug("Anomaly Detected: " + this.numInstances + " Rule: " + rule.getRuleNumberID(), 1);
                this.numAnomaliesDetected += instance.weight();
            }
            if (this.unorderedRulesOption.isSet()) continue;
            break;
        }
        if (!rulesCoveringInstance) {
            this.defaultRule.trainOnInstance(instance);
            if (this.defaultRule.getWeightSeenSinceExpansion() % (double)this.gracePeriodOption.getValue() == 0.0) {
                this.debug("Nr. examples " + this.defaultRule.getWeightSeenSinceExpansion(), 4);
                if (this.defaultRule.tryToExpand(this.splitConfidenceOption.getValue(), this.tieThresholdOption.getValue())) {
                    MultiLabelRule newDefaultRule = this.defaultRule.getNewRuleFromOtherBranch();
                    newDefaultRule.setRuleNumberID(++this.ruleNumberID);
                    this.setRuleOptions(newDefaultRule);
                    this.setRuleOptions(this.defaultRule);
                    this.ruleSet.add(this.defaultRule);
                    this.debug("Default rule expanded! New Rule:", 2);
                    this.debug(this.defaultRule.toString(), 2);
                    this.debug("New default rule:", 3);
                    this.debug(newDefaultRule.toString(), 3);
                    this.defaultRule = newDefaultRule;
                }
            }
        }
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("anomaly detections", this.numAnomaliesDetected), new Measurement("change detections", this.numChangesDetected), new Measurement("rules (number)", this.ruleSet.size() + 1)};
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        if (!this.unorderedRulesOption.isSet()) {
            StringUtils.appendIndented(out, indent, "Method Ordered");
            StringUtils.appendNewline(out);
        } else {
            StringUtils.appendIndented(out, indent, "Method Unordered");
            StringUtils.appendNewline(out);
        }
        StringUtils.appendIndented(out, indent, "Number of Rules: " + (this.ruleSet.size() + 1));
        StringUtils.appendNewline(out);
        StringUtils.appendIndented(out, indent, "Default rule :");
        this.defaultRule.getDescription(out, indent);
        StringUtils.appendIndented(out, indent, "Rules in ruleSet:");
        StringUtils.appendNewline(out);
        for (MultiLabelRule rule : this.ruleSet) {
            rule.getDescription(out, indent);
        }
    }

    protected void debug(String string, int level) {
        if (this.VerbosityOption.getValue() >= level) {
            System.out.println(string);
        }
    }

    protected void VerboseToConsole(MultiLabelInstance inst) {
        if (this.VerbosityOption.getValue() >= 5) {
            System.out.println();
            System.out.println("I) Dataset: " + inst.dataset().getRelationName());
            if (!this.unorderedRulesOption.isSet()) {
                System.out.println("I) Method Ordered");
            } else {
                System.out.println("I) Method Unordered");
            }
        }
    }

    public void PrintRuleSet() {
        this.debug("Default rule :", 2);
        this.debug(this.defaultRule.toString(), 2);
        this.debug("Rules in ruleSet:", 2);
        for (MultiLabelRule rule : this.ruleSet) {
            this.debug(rule.toString(), 2);
        }
    }

    @Override
    public void resetLearningImpl() {
        this.defaultRule = this.newDefaultRule();
        this.defaultRule.setLearner((MultiLabelLearner)((MultiLabelLearner)this.getPreparedClassOption(this.learnerOption)).copy());
        this.setRuleOptions(this.defaultRule);
    }

    protected void setRuleOptions(MultiLabelRule rule) {
        rule.setSplitCriterion((MultiLabelSplitCriterion)((MultiLabelSplitCriterion)this.getPreparedClassOption(this.splitCriterionOption)).copy());
        rule.setChangeDetector(((ChangeDetector)this.getPreparedClassOption(this.changeDetector)).copy());
        rule.setAnomalyDetector(((AnomalyDetector)this.getPreparedClassOption(this.anomalyDetector)).copy());
        rule.setNumericObserverOption((NumericStatisticsObserver)((NumericStatisticsObserver)this.getPreparedClassOption(this.numericObserverOption)).copy());
        rule.setNominalObserverOption((NominalStatisticsObserver)((NominalStatisticsObserver)this.getPreparedClassOption(this.nominalObserverOption)).copy());
        rule.setErrorMeasurer((MultiLabelErrorMeasurer)((MultiLabelErrorMeasurer)this.getPreparedClassOption(this.errorMeasurerOption)).copy());
        rule.setOutputAttributesSelector((OutputAttributesSelector)((OutputAttributesSelector)this.getPreparedClassOption(this.outputSelectorOption)).copy());
        rule.setRandomGenerator(this.classifierRandom);
        rule.setAttributesPercentage(this.attributesPercentage);
    }

    protected abstract MultiLabelRule newDefaultRule();

    public abstract ErrorWeightedVoteMultiLabel newErrorWeightedVote();

    @Override
    public void setRandomSeed(int randomSeed) {
        this.classifierRandom.setSeed(randomSeed);
    }
}

