/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.meta;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.github.javacliparser.MultiChoiceOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.Arrays;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.Regressor;
import moa.classifiers.rules.AMRulesRegressorOld;
import moa.classifiers.rules.AbstractAMRules;
import moa.classifiers.rules.core.voting.ErrorWeightedVote;
import moa.classifiers.rules.core.voting.Vote;
import moa.core.Measurement;
import moa.core.MiscUtils;
import moa.options.ClassOption;

public class RandomAMRulesOld
extends AbstractClassifier
implements Regressor {
    public IntOption VerbosityOption = new IntOption("verbosity", 'v', "Output Verbosity Control Level. 1 (Less) to 2 (More)", 1, 1, 2);
    private static final long serialVersionUID = 1L;
    public ClassOption baseLearnerOption = new ClassOption("baseLearner", 'l', "Classifier to train.", AbstractAMRules.class, AMRulesRegressorOld.class.getName());
    public IntOption ensembleSizeOption = new IntOption("ensembleSize", 's', "The number of models in the bag.", 10, 1, Integer.MAX_VALUE);
    public FloatOption numAttributesPercentageOption = new FloatOption("numAttributesPercentage", 'n', "The number of attributes to use per model.", 63.2, 0.0, 100.0);
    public FlagOption useBaggingOption = new FlagOption("useBagging", 'p', "Use Bagging.");
    public ClassOption votingFunctionOption = new ClassOption("votingFunction", 'V', "Voting Function.", ErrorWeightedVote.class, "UniformWeightedVote");
    public MultiChoiceOption votingTypeOption = new MultiChoiceOption("votingTypeOption", 'C', "Select whether the base learner error is computed as the overall error os only the error of the rules that cover the example.", new String[]{"Overall", "Only rules covered"}, new String[]{"Overall", "Covered"}, 0);
    public FloatOption fadingErrorFactorOption = new FloatOption("fadingErrorFactor", 'e', "Fading error factor for the accumulated error", 0.99, 0.0, 1.0);
    public IntOption randomSeedOption = new IntOption("randomSeed", 'r', "Seed for random behaviour of the classifier.", 1);
    protected AbstractAMRules[] ensemble;
    protected double[] sumError;
    protected double[] nError;
    protected boolean isRegression;
    protected int[][] listAttributes;
    protected int numAttributes;
    protected InstancesHeader[] dataset;

    @Override
    public void resetLearningImpl() {
        this.classifierRandom.setSeed(this.randomSeedOption.getValue());
        int n = this.ensembleSizeOption.getValue();
        this.ensemble = new AbstractAMRules[n];
        this.sumError = new double[n];
        this.nError = new double[n];
        AbstractAMRules baseLearner = (AbstractAMRules)this.getPreparedClassOption(this.baseLearnerOption);
        baseLearner.setAttributesPercentage(this.numAttributesPercentageOption.getValue());
        baseLearner.resetLearning();
        for (int i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i] = (AbstractAMRules)baseLearner.copy();
            this.ensemble[i].setRandomSeed(this.classifierRandom.nextInt());
        }
        this.isRegression = baseLearner instanceof Regressor;
    }

    @Override
    public void trainOnInstanceImpl(Instance instance) {
        double factor = this.fadingErrorFactorOption.getValue();
        for (int i = 0; i < this.ensemble.length; ++i) {
            Instance inst = instance.copy();
            int k = 1;
            if (this.useBaggingOption.isSet()) {
                k = MiscUtils.poisson(1.0, this.classifierRandom);
            }
            if (k <= 0) continue;
            inst.setWeight(inst.weight() * (double)k);
            double error = Math.abs(inst.classValue() - this.ensemble[i].getVotesForInstance(inst)[0]);
            this.sumError[i] = error * inst.weight() + this.sumError[i] * factor;
            this.nError[i] = inst.weight() + this.nError[i] * factor;
            this.ensemble[i].trainOnInstance(inst);
        }
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double[] votes = null;
        ErrorWeightedVote combinedVote = (ErrorWeightedVote)((Object)((ErrorWeightedVote)this.getPreparedClassOption(this.votingFunctionOption)).copy());
        StringBuilder sb = null;
        if (this.VerbosityOption.getValue() > 1) {
            sb = new StringBuilder();
        }
        for (int i = 0; i < this.ensemble.length; ++i) {
            Vote v = this.ensemble[i].getVotes(inst);
            if (this.VerbosityOption.getValue() > 1) {
                sb.append(Arrays.toString(v.getVote()) + ", " + " E: " + v.getError() + " ");
            }
            if (!this.isRegression && v.sumVoteDistrib() != 0.0) {
                v.normalize();
            }
            if (this.votingTypeOption.getChosenIndex() == 0) {
                combinedVote.addVote(v.getVote(), this.sumError[i] / this.nError[i]);
                continue;
            }
            combinedVote.addVote(v.getVote(), v.getError());
        }
        votes = combinedVote.computeWeightedVote();
        if (this.VerbosityOption.getValue() > 1) {
            sb.append(Arrays.toString(votes) + ", ").append(inst.classValue());
            System.out.println(sb.toString());
        }
        return votes;
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        Measurement[] baseLearnerMeasurements = ((AbstractAMRules)this.getPreparedClassOption(this.baseLearnerOption)).getModelMeasurements();
        int nMeasurements = baseLearnerMeasurements.length;
        Measurement[] m = new Measurement[nMeasurements + 1];
        for (int i = 0; i < baseLearnerMeasurements.length; ++i) {
            m[i + 1] = baseLearnerMeasurements[i];
        }
        int ensembleSize = 0;
        if (this.ensemble != null) {
            ensembleSize = this.ensemble.length;
            for (int i = 0; i < nMeasurements; ++i) {
                double value = 0.0;
                for (int j = 0; j < ensembleSize; ++j) {
                    value += this.ensemble[j].getModelMeasurements()[i].getValue();
                }
                m[i + 1] = new Measurement("Avg " + baseLearnerMeasurements[i].getName(), value / (double)ensembleSize);
            }
        }
        m[0] = new Measurement("ensemble size", ensembleSize);
        return m;
    }

    @Override
    public Classifier[] getSubClassifiers() {
        return this.ensemble;
    }

    @Override
    public String getPurposeString() {
        return "WeightedRandomRules";
    }
}

