/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core.anomalydetection;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import moa.classifiers.rules.core.Utils;
import moa.classifiers.rules.core.anomalydetection.AbstractAnomalyDetector;
import moa.classifiers.rules.core.anomalydetection.probabilityfunctions.ProbabilityFunction;
import moa.core.AutoExpandVector;
import moa.core.ObjectRepository;
import moa.options.ClassOption;
import moa.tasks.TaskMonitor;

public class AnomalinessRatioScore
extends AbstractAnomalyDetector {
    private static final long serialVersionUID = 1L;
    private static final double MINSTD = 0.01;
    public FloatOption percentageAnomalousAttributesOption = new FloatOption("percentageAnomalousAttributes", 'm', "Percentage of anomalous attributes.", 0.5, 0.0, 1.0);
    public FloatOption univariateAnomalyprobabilityThresholdOption = new FloatOption("univariateAnomalyprobabilityThreshold", 'u', "Univariate anomaly threshold value.", 0.9, 0.0, 1.0);
    public IntOption minNumberInstancesOption = new IntOption("minNumberInstances", 'n', "The minimum number of instances required to perform anomaly detection.", 30, 0, Integer.MAX_VALUE);
    public ClassOption probabilityFunctionOption = new ClassOption("probabilityFunction", 'p', "Probability function", ProbabilityFunction.class, "GaussInequality");
    private int minInstances;
    private double weightSeen;
    private double univariateThreshold;
    private double percentageAnomalous;
    AutoExpandVector<double[]> sufficientStatistics;
    private ProbabilityFunction probabilityFunction;

    @Override
    public boolean updateAndCheckAnomalyDetection(MultiLabelInstance instance) {
        boolean isAnomaly = false;
        if (this.probabilityFunction == null) {
            this.weightSeen = 0.0;
            this.minInstances = this.minNumberInstancesOption.getValue();
            this.univariateThreshold = this.univariateAnomalyprobabilityThresholdOption.getValue();
            this.percentageAnomalous = this.percentageAnomalousAttributesOption.getValue();
            this.probabilityFunction = (ProbabilityFunction)this.getPreparedClassOption(this.probabilityFunctionOption);
            this.minNumberInstancesOption = null;
            this.univariateAnomalyprobabilityThresholdOption = null;
            this.percentageAnomalousAttributesOption = null;
            this.probabilityFunctionOption = null;
        }
        double anomaly = 0.0;
        if (this.weightSeen > (double)this.minInstances) {
            int anomalousTotal = 0;
            int total = 0;
            for (int i = 0; i < instance.numInputAttributes(); ++i) {
                double prob = 0.0;
                double[] stats = this.sufficientStatistics.get(i);
                if (!instance.attribute(i).isNumeric()) continue;
                double val = instance.valueInputAttribute(i);
                double sd = Utils.computeSD(stats[1], stats[0], this.weightSeen);
                if (!(sd > 0.01)) continue;
                prob = this.probabilityFunction.getProbability(stats[0] / this.weightSeen, Utils.computeSD(stats[1], stats[0], this.weightSeen), val);
                if (1.0 - prob > this.univariateThreshold) {
                    ++anomalousTotal;
                }
                ++total;
            }
            if (total > 0) {
                anomaly /= (double)total;
            }
            boolean bl = isAnomaly = (double)anomalousTotal / (double)total > this.percentageAnomalous;
        }
        if (!isAnomaly) {
            if (this.sufficientStatistics == null) {
                this.sufficientStatistics = new AutoExpandVector();
            }
            this.weightSeen += instance.weight();
            for (int i = 0; i < instance.numInputAttributes(); ++i) {
                double[] stats = this.sufficientStatistics.get(i);
                if (!instance.attribute(i).isNumeric()) continue;
                double val = instance.valueInputAttribute(i);
                if (stats != null) {
                    stats[0] = stats[0] + val;
                    stats[1] = stats[1] + val * val;
                    continue;
                }
                stats = new double[]{instance.weight() * val, instance.weight() * val * val};
                this.sufficientStatistics.set(i, stats);
            }
        }
        return isAnomaly;
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

