/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.github.javacliparser.MultiChoiceOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.BinaryTreeNumericAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.GaussianNumericAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.NominalAttributeClassObserver;
import moa.classifiers.rules.Predicates;
import moa.classifiers.rules.RuleClassification;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.StringUtils;
import moa.core.Utils;

public class RuleClassifier
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    protected Instance instance;
    protected AutoExpandVector<AttributeClassObserver> attributeObservers;
    protected AutoExpandVector<AttributeClassObserver> attributeObserversGauss;
    protected DoubleVector observedClassDistribution;
    protected DoubleVector saveBestEntropy = new DoubleVector();
    protected DoubleVector saveBestEntropyNominalAttrib = new DoubleVector();
    protected DoubleVector ruleClassIndex = new DoubleVector();
    protected DoubleVector saveBestGlobalEntropy = new DoubleVector();
    protected ArrayList<ArrayList<Double>> saveBestValGlobalEntropy = new ArrayList();
    protected ArrayList<Double> saveTheBest = new ArrayList();
    protected ArrayList<RuleClassification> ruleSet = new ArrayList();
    protected ArrayList<RuleClassification> ruleSetAnomalies = new ArrayList();
    protected ArrayList<Integer> ruleAnomaliesIndex = new ArrayList();
    protected ArrayList<ArrayList<Integer>> caseAnomaly = new ArrayList();
    protected ArrayList<ArrayList<ArrayList<Double>>> ruleAttribAnomalyStatistics = new ArrayList();
    protected ArrayList<RuleClassification> ruleSetAnomaliesSupervised = new ArrayList();
    protected ArrayList<Integer> ruleAnomaliesIndexSupervised = new ArrayList();
    protected ArrayList<ArrayList<Integer>> caseAnomalySupervised = new ArrayList();
    protected ArrayList<ArrayList<ArrayList<Double>>> ruleAttribAnomalyStatisticsSupervised = new ArrayList();
    double minEntropyTemp = Double.MAX_VALUE;
    double cutPointTemp = 0.0;
    double minEntropyNominalAttrib = Double.MAX_VALUE;
    double symbol = 0.0;
    int numInstance = 0;
    int numAttributes = 0;
    int numClass = 0;
    BinaryTreeNumericAttributeClassObserver.Node root;
    Predicates pred;
    public FloatOption PminOption = new FloatOption("Pmin", 'p', "Percentage of the total number of example seen in the node.", 0.1, 0.0, 1.0);
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-6, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public FloatOption anomalyProbabilityThresholdOption = new FloatOption("anomalyprobabilityThreshold", 'o', "The threshold value.", 0.99, 0.0, 1.0);
    public FloatOption probabilityThresholdOption = new FloatOption("probabilityThreshold", 'k', "The threshold value.", 0.1, 0.0, 1.0);
    public IntOption anomalyNumInstThresholdOption = new IntOption("anomalyThreshold", 'i', "The threshold value to be used in the anomaly detection.", 15, 0, Integer.MAX_VALUE);
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "The number of instances a leaf should observe between split attempts.", 200, 0, Integer.MAX_VALUE);
    public MultiChoiceOption predictionFunctionOption = new MultiChoiceOption("predictionFunctionOption", 'z', "The prediction function to use.", new String[]{"firstHit", "weightedSum", "weightedMax"}, new String[]{"first Hit", "weighted Sum", "weighted Max"}, 0);
    public FlagOption orderedRulesOption = new FlagOption("orderedRules", 'r', "orderedRules.");
    public FlagOption anomalyDetectionOption = new FlagOption("anomalyDetection", 'u', "anomaly Detection.");
    public FlagOption Supervised = new FlagOption("supervised", 'n', "supervised.");
    public FlagOption Unsupervised = new FlagOption("unsupervised", 'm', "unsupervised.");

    @Override
    public String getPurposeString() {
        return "Rule Classifier.";
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double[] votes = new double[this.numClass];
        switch (this.predictionFunctionOption.getChosenIndex()) {
            case 0: {
                votes = this.firstHit(inst);
                break;
            }
            case 1: {
                votes = this.weightedSum(inst);
                break;
            }
            case 2: {
                votes = this.weightedMax(inst);
            }
        }
        return votes;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void resetLearningImpl() {
        this.observedClassDistribution = new DoubleVector();
        this.attributeObservers = new AutoExpandVector();
        this.attributeObserversGauss = new AutoExpandVector();
    }

    public double getWeightSeen() {
        return this.observedClassDistribution.sumOfValues();
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        int countRuleFiredTrue = 0;
        boolean ruleFired = false;
        this.instance = inst;
        this.numAttributes = this.instance.numAttributes() - 1;
        this.numClass = this.instance.numClasses();
        ++this.numInstance;
        int conta1 = 0;
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countRuleFiredTrue;
            double anomaly = 0.0;
            if (this.Supervised.isSet()) {
                anomaly = this.computeAnomalySupervised(this.ruleSet.get(j), j, inst);
            } else if (this.Unsupervised.isSet()) {
                anomaly = this.computeAnomalyUnsupervised(this.ruleSet.get(j), j, inst);
            }
            if (anomaly >= this.anomalyProbabilityThresholdOption.getValue()) {
                ++conta1;
            }
            try {
                File dir = new File("SeaAnomaliesUnsupervised.txt");
                FileWriter fileWriter = new FileWriter(dir, true);
                PrintWriter printWriter = new PrintWriter(fileWriter);
                printWriter.println(this.numInstance + ";" + anomaly);
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.ruleSet.get((int)j).instancesSeen <= this.anomalyNumInstThresholdOption.getValue() || anomaly < this.anomalyProbabilityThresholdOption.getValue() && this.anomalyDetectionOption.isSet() || !this.anomalyDetectionOption.isSet()) {
                this.ruleSet.get((int)j).obserClassDistrib.addToValue((int)inst.classValue(), inst.weight());
                for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                    int instAttIndex = RuleClassifier.modelAttIndexToInstanceAttIndex(i, inst);
                    if (inst.isMissing(instAttIndex)) continue;
                    AttributeClassObserver obs = this.ruleSet.get((int)j).observers.get(i);
                    AttributeClassObserver obsGauss = this.ruleSet.get((int)j).observersGauss.get(i);
                    if (obs == null) {
                        obs = inst.attribute(instAttIndex).isNominal() ? this.newNominalClassObserver() : this.newNumericClassObserver();
                        this.ruleSet.get((int)j).observers.set(i, obs);
                    }
                    if (obsGauss == null) {
                        obsGauss = inst.attribute(instAttIndex).isNumeric() ? this.newNumericClassObserver2() : null;
                        this.ruleSet.get((int)j).observersGauss.set(i, obsGauss);
                    }
                    obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
                    if (!inst.attribute(instAttIndex).isNumeric()) continue;
                    obsGauss.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
                }
                this.expandeRule(this.ruleSet.get(j), inst, j);
            }
            if (this.orderedRulesOption.isSet()) break;
        }
        if (!(ruleFired = countRuleFiredTrue > 0)) {
            this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                int instAttIndex = RuleClassifier.modelAttIndexToInstanceAttIndex(i, inst);
                if (inst.isMissing(instAttIndex)) continue;
                AttributeClassObserver obs = this.attributeObservers.get(i);
                AttributeClassObserver obsGauss = this.attributeObserversGauss.get(i);
                if (obs == null) {
                    obs = inst.attribute(instAttIndex).isNominal() ? this.newNominalClassObserver() : this.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                if (obsGauss == null) {
                    obsGauss = inst.attribute(instAttIndex).isNumeric() ? this.newNumericClassObserver2() : null;
                    this.attributeObserversGauss.set(i, obsGauss);
                }
                obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
                if (!inst.attribute(instAttIndex).isNumeric()) continue;
                obsGauss.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
            }
            this.createRule(inst);
        }
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        if (this.anomalyDetectionOption.isSet()) {
            if (this.Supervised.isSet()) {
                this.printAnomaliesSupervised(out, indent);
            } else if (this.Unsupervised.isSet()) {
                this.printAnomaliesUnsupervised(out, indent);
            }
        } else {
            this.getModelDescriptionNoAnomalyDetection(out, indent);
        }
    }

    public void printAnomaliesUnsupervised(StringBuilder out, int indent) {
        StringUtils.appendNewline(out);
        StringUtils.appendIndented(out, indent, "**********************UNSUPERVISED*****************");
        StringUtils.appendNewline(out);
        StringUtils.appendNewline(out);
        for (int k = 0; k < this.ruleSetAnomalies.size(); ++k) {
            String val;
            StringUtils.appendIndented(out, indent, "Case: " + this.caseAnomaly.get(k).get(0) + "   Anomaly Score: " + this.caseAnomaly.get(k).get(1) + "%");
            StringUtils.appendNewline(out);
            StringUtils.appendIndented(out, indent, "Rule " + this.ruleAnomaliesIndex.get(k) + ": ");
            for (int i = 0; i < this.ruleSetAnomalies.get((int)k).predicateSet.size(); ++i) {
                String nam;
                if (this.ruleSetAnomalies.get((int)k).predicateSet.size() == 1) {
                    if (this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getSymbol() == 0.0) {
                        String nam2 = this.instance.attribute((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                        val = this.instance.attribute((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getAttributeValue()).value((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getValue());
                        StringUtils.appendIndented(out, indent, nam2 + " = " + val + " --> " + this.instance.classAttribute().value((int)this.getRuleMajorityClassIndex(this.ruleSetAnomalies.get(k))));
                        StringUtils.appendNewline(out);
                        continue;
                    }
                    if (this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getSymbol() == -1.0) {
                        String nam3 = this.instance.attribute((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                        StringUtils.appendIndented(out, indent, nam3 + " <= " + this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getValue() + " --> " + this.instance.classAttribute().value((int)this.ruleClassIndex.getValue(this.ruleAnomaliesIndex.get(k) - 1)));
                        StringUtils.appendNewline(out);
                        continue;
                    }
                    String nam4 = this.instance.attribute((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam4 + " > " + this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getValue() + " --> " + this.instance.classAttribute().value((int)this.ruleClassIndex.getValue(this.ruleAnomaliesIndex.get(k) - 1)));
                    StringUtils.appendNewline(out);
                    continue;
                }
                if (this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getSymbol() == 0.0) {
                    nam = this.instance.attribute((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    val = this.instance.attribute((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getAttributeValue()).value((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getValue());
                    StringUtils.appendIndented(out, indent, nam + " = " + val + " ");
                } else if (this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getSymbol() == -1.0) {
                    nam = this.instance.attribute((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam + " <= " + this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getValue() + " ");
                } else {
                    nam = this.instance.attribute((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam + " > " + this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getValue() + " ");
                }
                if (i < this.ruleSetAnomalies.get((int)k).predicateSet.size() - 1) {
                    StringUtils.appendIndented(out, indent, "and ");
                    continue;
                }
                int count = this.getCountNominalAttrib(this.ruleSetAnomalies.get((int)k).predicateSet);
                if (this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getSymbol() == 0.0 || count != 0) {
                    StringUtils.appendIndented(out, indent, " --> " + this.instance.classAttribute().value((int)this.getRuleMajorityClassIndex(this.ruleSetAnomalies.get(k))));
                    StringUtils.appendNewline(out);
                    continue;
                }
                StringUtils.appendIndented(out, indent, " --> " + this.instance.classAttribute().value((int)this.ruleClassIndex.getValue(this.ruleAnomaliesIndex.get(k) - 1)));
                StringUtils.appendNewline(out);
            }
            for (int z = 0; z < this.ruleAttribAnomalyStatistics.get(k).size(); ++z) {
                String s;
                if (this.ruleAttribAnomalyStatistics.get(k).get(z).size() == 5) {
                    s = String.format("%.3e", this.ruleAttribAnomalyStatistics.get(k).get(z).get(4));
                    StringUtils.appendIndented(out, indent, this.instance.attribute(this.ruleAttribAnomalyStatistics.get(k).get(z).get(0).intValue()).name() + "=" + this.round(this.ruleAttribAnomalyStatistics.get(k).get(z).get(1)) + "   (" + this.round(this.ruleAttribAnomalyStatistics.get(k).get(z).get(2)) + " +- " + this.round(this.ruleAttribAnomalyStatistics.get(k).get(z).get(3)) + ")   P=" + s);
                    StringUtils.appendNewline(out);
                    continue;
                }
                s = String.format("%.3e", this.ruleAttribAnomalyStatistics.get(k).get(z).get(2));
                val = this.instance.attribute(this.ruleAttribAnomalyStatistics.get(k).get(z).get(0).intValue()).value(this.ruleAttribAnomalyStatistics.get(k).get(z).get(1).intValue());
                StringUtils.appendIndented(out, indent, this.instance.attribute(this.ruleAttribAnomalyStatistics.get(k).get(z).get(0).intValue()).name() + "=" + val + "   P=" + s);
                StringUtils.appendNewline(out);
            }
            StringUtils.appendNewline(out);
        }
    }

    public void printAnomaliesSupervised(StringBuilder out, int indent) {
        StringUtils.appendNewline(out);
        StringUtils.appendIndented(out, indent, "************************SUPERVISED*******************");
        StringUtils.appendNewline(out);
        StringUtils.appendNewline(out);
        for (int k = 0; k < this.ruleSetAnomaliesSupervised.size(); ++k) {
            String val;
            StringUtils.appendIndented(out, indent, "Case: " + this.caseAnomalySupervised.get(k).get(0) + "   Anomaly Score: " + this.caseAnomalySupervised.get(k).get(1) + "%");
            StringUtils.appendNewline(out);
            StringUtils.appendIndented(out, indent, "Rule " + this.ruleAnomaliesIndexSupervised.get(k) + ": ");
            for (int i = 0; i < this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.size(); ++i) {
                String nam;
                if (this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.size() == 1) {
                    if (this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getSymbol() == 0.0) {
                        String nam2 = this.instance.attribute((int)this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                        val = this.instance.attribute((int)this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getAttributeValue()).value((int)this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getValue());
                        StringUtils.appendIndented(out, indent, nam2 + " = " + val + " --> " + this.instance.classAttribute().value((int)this.getRuleMajorityClassIndex(this.ruleSetAnomaliesSupervised.get(k))));
                        StringUtils.appendNewline(out);
                        continue;
                    }
                    if (this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getSymbol() == -1.0) {
                        String nam3 = this.instance.attribute((int)this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                        StringUtils.appendIndented(out, indent, nam3 + " <= " + this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getValue() + " --> " + this.instance.classAttribute().value((int)this.ruleClassIndex.getValue(this.ruleAnomaliesIndexSupervised.get(k) - 1)));
                        StringUtils.appendNewline(out);
                        continue;
                    }
                    String nam4 = this.instance.attribute((int)this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam4 + " > " + this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getValue() + " --> " + this.instance.classAttribute().value((int)this.ruleClassIndex.getValue(this.ruleAnomaliesIndexSupervised.get(k) - 1)));
                    StringUtils.appendNewline(out);
                    continue;
                }
                if (this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getSymbol() == 0.0) {
                    nam = this.instance.attribute((int)this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    val = this.instance.attribute((int)this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getAttributeValue()).value((int)this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getValue());
                    StringUtils.appendIndented(out, indent, nam + " = " + val + " ");
                } else if (this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getSymbol() == -1.0) {
                    nam = this.instance.attribute((int)this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam + " <= " + this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getValue() + " ");
                } else {
                    nam = this.instance.attribute((int)this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam + " > " + this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getValue() + " ");
                }
                if (i < this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.size() - 1) {
                    StringUtils.appendIndented(out, indent, "and ");
                    continue;
                }
                int count = this.getCountNominalAttrib(this.ruleSetAnomaliesSupervised.get((int)k).predicateSet);
                if (this.ruleSetAnomaliesSupervised.get((int)k).predicateSet.get(i).getSymbol() == 0.0 || count != 0) {
                    StringUtils.appendIndented(out, indent, " --> " + this.instance.classAttribute().value((int)this.getRuleMajorityClassIndex(this.ruleSetAnomaliesSupervised.get(k))));
                    StringUtils.appendNewline(out);
                    continue;
                }
                StringUtils.appendIndented(out, indent, " --> " + this.instance.classAttribute().value((int)this.ruleClassIndex.getValue(this.ruleAnomaliesIndexSupervised.get(k) - 1)));
                StringUtils.appendNewline(out);
            }
            for (int z = 0; z < this.ruleAttribAnomalyStatisticsSupervised.get(k).size(); ++z) {
                String s;
                if (this.ruleAttribAnomalyStatisticsSupervised.get(k).get(z).size() == 5) {
                    s = String.format("%.3e", this.ruleAttribAnomalyStatisticsSupervised.get(k).get(z).get(4));
                    StringUtils.appendIndented(out, indent, this.instance.attribute(this.ruleAttribAnomalyStatisticsSupervised.get(k).get(z).get(0).intValue()).name() + "=" + this.round(this.ruleAttribAnomalyStatisticsSupervised.get(k).get(z).get(1)) + "   (" + this.round(this.ruleAttribAnomalyStatisticsSupervised.get(k).get(z).get(2)) + " +- " + this.round(this.ruleAttribAnomalyStatisticsSupervised.get(k).get(z).get(3)) + ")   P=" + s);
                    StringUtils.appendNewline(out);
                    continue;
                }
                s = String.format("%.3e", this.ruleAttribAnomalyStatisticsSupervised.get(k).get(z).get(2));
                val = this.instance.attribute(this.ruleAttribAnomalyStatisticsSupervised.get(k).get(z).get(0).intValue()).value(this.ruleAttribAnomalyStatisticsSupervised.get(k).get(z).get(1).intValue());
                StringUtils.appendIndented(out, indent, this.instance.attribute(this.ruleAttribAnomalyStatisticsSupervised.get(k).get(z).get(0).intValue()).name() + "=" + val + "   P=" + s);
                StringUtils.appendNewline(out);
            }
            StringUtils.appendNewline(out);
        }
    }

    public void getModelDescriptionNoAnomalyDetection(StringBuilder out, int indent) {
        StringUtils.appendNewline(out);
        StringUtils.appendIndented(out, indent, "Number of Rule: " + this.ruleSet.size());
        StringUtils.appendNewline(out);
        StringUtils.appendNewline(out);
        for (int k = 0; k < this.ruleSet.size(); ++k) {
            StringUtils.appendIndented(out, indent, "Rule " + (k + 1) + ": ");
            for (int i = 0; i < this.ruleSet.get((int)k).predicateSet.size(); ++i) {
                String nam;
                String val;
                if (this.ruleSet.get((int)k).predicateSet.size() == 1) {
                    if (this.ruleSet.get((int)k).predicateSet.get(i).getSymbol() == 0.0) {
                        String nam2 = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                        val = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).value((int)this.ruleSet.get((int)k).predicateSet.get(i).getValue());
                        StringUtils.appendIndented(out, indent, nam2 + " = " + val + " --> " + this.instance.classAttribute().value((int)this.getRuleMajorityClassIndex(this.ruleSet.get(k))));
                        StringUtils.appendNewline(out);
                        continue;
                    }
                    if (this.ruleSet.get((int)k).predicateSet.get(i).getSymbol() == -1.0) {
                        String nam3 = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                        StringUtils.appendIndented(out, indent, nam3 + " <= " + this.ruleSet.get((int)k).predicateSet.get(i).getValue() + " --> " + this.instance.classAttribute().value((int)this.ruleClassIndex.getValue(k)));
                        StringUtils.appendNewline(out);
                        continue;
                    }
                    String nam4 = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam4 + " > " + this.ruleSet.get((int)k).predicateSet.get(i).getValue() + " --> " + this.instance.classAttribute().value((int)this.ruleClassIndex.getValue(k)));
                    StringUtils.appendNewline(out);
                    continue;
                }
                if (this.ruleSet.get((int)k).predicateSet.get(i).getSymbol() == 0.0) {
                    nam = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    val = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).value((int)this.ruleSet.get((int)k).predicateSet.get(i).getValue());
                    StringUtils.appendIndented(out, indent, nam + " = " + val + " ");
                } else if (this.ruleSet.get((int)k).predicateSet.get(i).getSymbol() == -1.0) {
                    nam = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam + " <= " + this.ruleSet.get((int)k).predicateSet.get(i).getValue() + " ");
                } else {
                    nam = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam + " > " + this.ruleSet.get((int)k).predicateSet.get(i).getValue() + " ");
                }
                if (i < this.ruleSet.get((int)k).predicateSet.size() - 1) {
                    StringUtils.appendIndented(out, indent, "and ");
                    continue;
                }
                int count = this.getCountNominalAttrib(this.ruleSet.get((int)k).predicateSet);
                if (this.ruleSet.get((int)k).predicateSet.get(i).getSymbol() == 0.0 || count != 0) {
                    StringUtils.appendIndented(out, indent, " --> " + this.instance.classAttribute().value((int)this.getRuleMajorityClassIndex(this.ruleSet.get(k))));
                    StringUtils.appendNewline(out);
                    continue;
                }
                StringUtils.appendIndented(out, indent, " --> " + this.instance.classAttribute().value((int)this.ruleClassIndex.getValue(k)));
                StringUtils.appendNewline(out);
            }
            StringUtils.appendNewline(out);
        }
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    public int getCountNominalAttrib(ArrayList<Predicates> predicateSet) {
        int count = 0;
        for (int i = 0; i < predicateSet.size(); ++i) {
            if (predicateSet.get(i).getSymbol() != 0.0) continue;
            ++count;
            break;
        }
        return count;
    }

    protected BigDecimal round(double val) {
        BigDecimal value = new BigDecimal(val);
        if (val != 0.0) {
            value = value.setScale(3, 1);
        }
        return value;
    }

    public void initializeRuleStatistics(RuleClassification rl, Predicates pred, Instance inst) {
        rl.predicateSet.add(pred);
        rl.obserClassDistrib = new DoubleVector();
        rl.observers = new AutoExpandVector();
        rl.observersGauss = new AutoExpandVector();
        rl.instancesSeen = 0;
        rl.attributeStatistics = new DoubleVector();
        rl.squaredAttributeStatistics = new DoubleVector();
        rl.attributeStatisticsSupervised = new ArrayList();
        rl.squaredAttributeStatisticsSupervised = new ArrayList();
        rl.attributeMissingValues = new DoubleVector();
    }

    public void updateRuleAttribStatistics(Instance inst, RuleClassification rl, int ruleIndex) {
        int s;
        ++rl.instancesSeen;
        if (rl.squaredAttributeStatisticsSupervised.size() == 0 && rl.attributeStatisticsSupervised.size() == 0) {
            for (s = 0; s < inst.numAttributes() - 1; ++s) {
                ArrayList temp1 = new ArrayList();
                ArrayList temp2 = new ArrayList();
                rl.attributeStatisticsSupervised.add(temp1);
                rl.squaredAttributeStatisticsSupervised.add(temp2);
                int instAttIndex = RuleClassifier.modelAttIndexToInstanceAttIndex(s, inst);
                if (!this.instance.attribute(instAttIndex).isNumeric()) continue;
                for (int i = 0; i < inst.numClasses(); ++i) {
                    rl.attributeStatisticsSupervised.get(s).add(0.0);
                    rl.squaredAttributeStatisticsSupervised.get(s).add(1.0);
                }
            }
        }
        for (s = 0; s < inst.numAttributes() - 1; ++s) {
            int instAttIndex = RuleClassifier.modelAttIndexToInstanceAttIndex(s, inst);
            if (!inst.isMissing(instAttIndex)) {
                if (!this.instance.attribute(instAttIndex).isNumeric()) continue;
                rl.attributeStatistics.addToValue(s, inst.value(s));
                rl.squaredAttributeStatistics.addToValue(s, inst.value(s) * inst.value(s));
                double sumValue = rl.attributeStatisticsSupervised.get(s).get((int)inst.classValue()) + inst.value(s);
                rl.attributeStatisticsSupervised.get(s).set((int)inst.classValue(), sumValue);
                double squaredSumvalue = rl.squaredAttributeStatisticsSupervised.get(s).get((int)inst.classValue()) + inst.value(s) * inst.value(s);
                rl.squaredAttributeStatisticsSupervised.get(s).set((int)inst.classValue(), squaredSumvalue);
                continue;
            }
            rl.attributeMissingValues.addToValue(s, 1.0);
        }
    }

    public double computeAnomalyUnsupervised(RuleClassification rl, int ruleIndex, Instance inst) {
        ArrayList<Integer> caseAnomalyTemp = new ArrayList<Integer>();
        ArrayList AttribAnomalyStatisticTemp2 = new ArrayList();
        double D = 0.0;
        double N = 0.0;
        if (rl.instancesSeen > this.anomalyNumInstThresholdOption.getValue() && this.anomalyDetectionOption.isSet()) {
            for (int x = 0; x < inst.numAttributes() - 1; ++x) {
                if (inst.isMissing(x)) continue;
                ArrayList<Double> AttribAnomalyStatisticTemp = new ArrayList<Double>();
                if (inst.attribute(x).isNumeric()) {
                    double sd;
                    double mean;
                    double probability;
                    if (!((double)rl.instancesSeen - rl.attributeMissingValues.getValue(x) > 30.0) || (probability = this.computeProbability(mean = this.computeMean(rl.attributeStatistics.getValue(x), rl.instancesSeen), sd = this.computeSD(rl.squaredAttributeStatistics.getValue(x), rl.attributeStatistics.getValue(x), rl.instancesSeen), inst.value(x))) == 0.0) continue;
                    D += Math.log(probability);
                    if (!(probability < this.probabilityThresholdOption.getValue())) continue;
                    N += Math.log(probability);
                    AttribAnomalyStatisticTemp.add(Double.valueOf(x));
                    AttribAnomalyStatisticTemp.add(inst.value(x));
                    AttribAnomalyStatisticTemp.add(mean);
                    AttribAnomalyStatisticTemp.add(sd);
                    AttribAnomalyStatisticTemp.add(probability);
                    AttribAnomalyStatisticTemp2.add(AttribAnomalyStatisticTemp);
                    continue;
                }
                AutoExpandVector<DoubleVector> attribNominal = ((NominalAttributeClassObserver)rl.observers.get((int)x)).attValDistPerClass;
                double numbAttribValue = 0.0;
                double attribVal = inst.value(x);
                for (int i = 0; i < attribNominal.size(); ++i) {
                    if (attribNominal.get(i) == null) continue;
                    numbAttribValue += attribNominal.get(i).getValue((int)attribVal);
                }
                double probability = numbAttribValue / (double)rl.instancesSeen;
                if (probability == 0.0) continue;
                D += Math.log(probability);
                if (!(probability < this.probabilityThresholdOption.getValue())) continue;
                N += Math.log(probability);
                AttribAnomalyStatisticTemp.add(Double.valueOf(x));
                AttribAnomalyStatisticTemp.add(inst.value(x));
                AttribAnomalyStatisticTemp.add(probability);
                AttribAnomalyStatisticTemp2.add(AttribAnomalyStatisticTemp);
            }
        }
        double anomaly = 0.0;
        if (D != 0.0) {
            anomaly = Math.abs(N / D);
        }
        if (anomaly >= this.anomalyProbabilityThresholdOption.getValue()) {
            caseAnomalyTemp.add(this.numInstance);
            double val = anomaly * 100.0;
            caseAnomalyTemp.add((int)val);
            this.caseAnomaly.add(caseAnomalyTemp);
            RuleClassification x = new RuleClassification(this.ruleSet.get(ruleIndex));
            this.ruleSetAnomalies.add(x);
            this.ruleAnomaliesIndex.add(ruleIndex + 1);
            this.ruleAttribAnomalyStatistics.add(AttribAnomalyStatisticTemp2);
        }
        return anomaly;
    }

    public double computeAnomalySupervised(RuleClassification rl, int ruleIndex, Instance inst) {
        ArrayList<Integer> caseAnomalyTemp = new ArrayList<Integer>();
        ArrayList AttribAnomalyStatisticTemp2 = new ArrayList();
        double D = 0.0;
        double N = 0.0;
        if (rl.instancesSeen > this.anomalyNumInstThresholdOption.getValue() && this.anomalyDetectionOption.isSet()) {
            for (int x = 0; x < inst.numAttributes() - 1; ++x) {
                double probability;
                if (inst.isMissing(x)) continue;
                ArrayList<Double> AttribAnomalyStatisticTemp = new ArrayList<Double>();
                if (inst.attribute(x).isNumeric()) {
                    double sd;
                    double mean;
                    if (!((double)rl.instancesSeen - rl.attributeMissingValues.getValue(x) > 30.0) || (probability = this.computeProbability(mean = this.computeMean(rl.attributeStatisticsSupervised.get(x).get((int)inst.classValue()), (int)rl.obserClassDistrib.getValue((int)inst.classValue())), sd = this.computeSD(rl.squaredAttributeStatisticsSupervised.get(x).get((int)inst.classValue()), rl.attributeStatisticsSupervised.get(x).get((int)inst.classValue()), (int)rl.obserClassDistrib.getValue((int)inst.classValue())), inst.value(x))) == 0.0) continue;
                    D += Math.log(probability);
                    if (!(probability < this.probabilityThresholdOption.getValue())) continue;
                    N += Math.log(probability);
                    AttribAnomalyStatisticTemp.add(Double.valueOf(x));
                    AttribAnomalyStatisticTemp.add(inst.value(x));
                    AttribAnomalyStatisticTemp.add(mean);
                    AttribAnomalyStatisticTemp.add(sd);
                    AttribAnomalyStatisticTemp.add(probability);
                    AttribAnomalyStatisticTemp2.add(AttribAnomalyStatisticTemp);
                    continue;
                }
                double attribVal = inst.value(x);
                double classVal = inst.classValue();
                probability = rl.observers.get(x).probabilityOfAttributeValueGivenClass(attribVal, (int)classVal);
                if (probability == 0.0) continue;
                D += Math.log(probability);
                if (!(probability < this.probabilityThresholdOption.getValue())) continue;
                N += Math.log(probability);
                AttribAnomalyStatisticTemp.add(Double.valueOf(x));
                AttribAnomalyStatisticTemp.add(inst.value(x));
                AttribAnomalyStatisticTemp.add(probability);
                AttribAnomalyStatisticTemp2.add(AttribAnomalyStatisticTemp);
            }
        }
        double anomaly = 0.0;
        if (D != 0.0) {
            anomaly = Math.abs(N / D);
        }
        if (anomaly >= this.anomalyProbabilityThresholdOption.getValue()) {
            caseAnomalyTemp.add(this.numInstance);
            double val = anomaly * 100.0;
            caseAnomalyTemp.add((int)val);
            this.caseAnomalySupervised.add(caseAnomalyTemp);
            RuleClassification y = new RuleClassification(this.ruleSet.get(ruleIndex));
            this.ruleSetAnomaliesSupervised.add(y);
            this.ruleAnomaliesIndexSupervised.add(ruleIndex + 1);
            this.ruleAttribAnomalyStatisticsSupervised.add(AttribAnomalyStatisticTemp2);
        }
        return anomaly;
    }

    public double computeMean(double sum, int size) {
        return sum / (double)size;
    }

    public double computeSD(double squaredVal, double val, int size) {
        return Math.sqrt((squaredVal - val * val / (double)size) / (double)size);
    }

    public double computeProbability(double mean, double sd, double value) {
        sd += 1.0E-5;
        double probability = 0.0;
        double diff = value - mean;
        if (sd > 0.0) {
            double k = Math.abs(value - mean) / sd;
            probability = k > 1.0 ? 1.0 / (k * k) : Math.exp(-(diff * diff / (2.0 * sd * sd)));
        }
        return probability;
    }

    public void createRule(Instance inst) {
        int remainder = Integer.MAX_VALUE;
        int numInstanciaObservers = (int)this.observedClassDistribution.sumOfValues();
        if (numInstanciaObservers != 0 && this.gracePeriodOption.getValue() != 0) {
            remainder = numInstanciaObservers % this.gracePeriodOption.getValue();
        }
        if (remainder == 0) {
            this.saveBestValGlobalEntropy = new ArrayList();
            this.saveBestGlobalEntropy = new DoubleVector();
            this.saveTheBest = new ArrayList();
            this.minEntropyTemp = Double.MAX_VALUE;
            this.minEntropyNominalAttrib = Double.MAX_VALUE;
            this.theBestAttributes(inst, this.attributeObservers);
            boolean HB = this.checkBestAttrib(numInstanciaObservers, this.attributeObservers, this.observedClassDistribution);
            if (HB) {
                double attributeValue = this.saveTheBest.get(3);
                double symbol = this.saveTheBest.get(2);
                double value = this.saveTheBest.get(0);
                this.pred = new Predicates(attributeValue, symbol, value);
                RuleClassification Rl = new RuleClassification();
                Rl.predicateSet.add(this.pred);
                this.ruleSet.add(Rl);
                if (Rl.predicateSet.get(0).getSymbol() == -1.0 || Rl.predicateSet.get(0).getSymbol() == 1.0) {
                    double posClassDouble = this.saveTheBest.get(4);
                    this.ruleClassIndex.setValue(this.ruleSet.size() - 1, posClassDouble);
                } else {
                    this.ruleClassIndex.setValue(this.ruleSet.size() - 1, 0.0);
                }
                this.observedClassDistribution = new DoubleVector();
                this.attributeObservers = new AutoExpandVector();
                this.attributeObserversGauss = new AutoExpandVector();
            }
        }
    }

    public void expandeRule(RuleClassification rl, Instance inst, int ruleIndex) {
        int remainder = Integer.MAX_VALUE;
        int numInstanciaObservers = (int)rl.obserClassDistrib.sumOfValues();
        this.updateRuleAttribStatistics(inst, rl, ruleIndex);
        if (numInstanciaObservers != 0 && this.gracePeriodOption.getValue() != 0) {
            remainder = numInstanciaObservers % this.gracePeriodOption.getValue();
        }
        if (remainder == 0) {
            this.saveBestValGlobalEntropy = new ArrayList();
            this.saveBestGlobalEntropy = new DoubleVector();
            this.saveTheBest = new ArrayList();
            this.minEntropyTemp = Double.MAX_VALUE;
            this.minEntropyNominalAttrib = Double.MAX_VALUE;
            this.theBestAttributes(inst, rl.observers);
            boolean HB = this.checkBestAttrib(numInstanciaObservers, rl.observers, rl.obserClassDistrib);
            if (HB) {
                double attributeValue = this.saveTheBest.get(3);
                double symbol = this.saveTheBest.get(2);
                double value = this.saveTheBest.get(0);
                this.pred = new Predicates(attributeValue, symbol, value);
                int countPred = 0;
                for (int i = 0; i < rl.predicateSet.size(); ++i) {
                    if (this.pred.getSymbol() == 0.0) {
                        if (rl.predicateSet.get(i).getAttributeValue() == this.pred.getAttributeValue()) continue;
                        ++countPred;
                        continue;
                    }
                    if (rl.predicateSet.get(i).getAttributeValue() == this.pred.getAttributeValue() && rl.predicateSet.get(i).getSymbol() == this.pred.getSymbol() && rl.predicateSet.get(i).getValue() == this.pred.getValue()) continue;
                    ++countPred;
                }
                if (countPred == rl.predicateSet.size()) {
                    int countDifPred = 0;
                    ArrayList<Predicates> predicSetTemp = new ArrayList<Predicates>();
                    for (int x = 0; x < rl.predicateSet.size(); ++x) {
                        predicSetTemp.add(rl.predicateSet.get(x));
                    }
                    predicSetTemp.add(this.pred);
                    for (int f = 0; f < this.ruleSet.size(); ++f) {
                        int countDifPredTemp = 0;
                        if (this.ruleSet.get((int)f).predicateSet.size() == predicSetTemp.size()) {
                            for (int x = 0; x < this.ruleSet.get((int)f).predicateSet.size(); ++x) {
                                if (this.ruleSet.get((int)f).predicateSet.get(x).getAttributeValue() != ((Predicates)predicSetTemp.get(x)).getAttributeValue() || this.ruleSet.get((int)f).predicateSet.get(x).getSymbol() != ((Predicates)predicSetTemp.get(x)).getSymbol() || this.ruleSet.get((int)f).predicateSet.get(x).getValue() != ((Predicates)predicSetTemp.get(x)).getValue()) continue;
                                ++countDifPredTemp;
                            }
                            if (countDifPredTemp == predicSetTemp.size()) break;
                            ++countDifPred;
                            continue;
                        }
                        ++countDifPred;
                    }
                    if (countDifPred == this.ruleSet.size()) {
                        int f;
                        int countIqualPred;
                        if (this.pred.getSymbol() == 0.0) {
                            this.initializeRuleStatistics(rl, this.pred, inst);
                        } else if (this.pred.getSymbol() == 1.0) {
                            countIqualPred = 0;
                            for (f = 0; f < rl.predicateSet.size(); ++f) {
                                if (this.pred.getAttributeValue() != rl.predicateSet.get(f).getAttributeValue() || this.pred.getSymbol() != rl.predicateSet.get(f).getSymbol()) continue;
                                ++countIqualPred;
                                if (!(this.pred.getValue() > rl.predicateSet.get(f).getValue())) continue;
                                rl.predicateSet.remove(f);
                                this.initializeRuleStatistics(rl, this.pred, inst);
                            }
                            if (countIqualPred == 0) {
                                this.initializeRuleStatistics(rl, this.pred, inst);
                            }
                        } else {
                            countIqualPred = 0;
                            for (f = 0; f < rl.predicateSet.size(); ++f) {
                                if (this.pred.getAttributeValue() != rl.predicateSet.get(f).getAttributeValue() || this.pred.getSymbol() != rl.predicateSet.get(f).getSymbol()) continue;
                                ++countIqualPred;
                                if (!(this.pred.getValue() < rl.predicateSet.get(f).getValue())) continue;
                                rl.predicateSet.remove(f);
                                this.initializeRuleStatistics(rl, this.pred, inst);
                            }
                            if (countIqualPred == 0) {
                                this.initializeRuleStatistics(rl, this.pred, inst);
                            }
                        }
                    }
                }
            }
        }
    }

    public void theBestAttributes(Instance instance, AutoExpandVector<AttributeClassObserver> observersParameter) {
        for (int z = 0; z < instance.numAttributes() - 1; ++z) {
            if (!instance.isMissing(z)) {
                int instAttIndex = RuleClassifier.modelAttIndexToInstanceAttIndex(z, instance);
                ArrayList<Double> attribBest = new ArrayList<Double>();
                if (instance.attribute(instAttIndex).isNominal()) {
                    this.minEntropyNominalAttrib = Double.MAX_VALUE;
                    AutoExpandVector<DoubleVector> attribNominal = ((NominalAttributeClassObserver)observersParameter.get((int)z)).attValDistPerClass;
                    this.findBestValEntropyNominalAtt(attribNominal, instance.attribute(z).numValues());
                    attribBest.add(this.saveBestEntropyNominalAttrib.getValue(0));
                    attribBest.add(this.saveBestEntropyNominalAttrib.getValue(1));
                    attribBest.add(this.saveBestEntropyNominalAttrib.getValue(2));
                    this.saveBestValGlobalEntropy.add(attribBest);
                    this.saveBestGlobalEntropy.setValue(z, this.saveBestEntropyNominalAttrib.getValue(1));
                    continue;
                }
                this.root = ((BinaryTreeNumericAttributeClassObserver)observersParameter.get((int)z)).root;
                this.mainFindBestValEntropy(this.root);
                attribBest.add(this.saveBestEntropy.getValue(0));
                attribBest.add(this.saveBestEntropy.getValue(1));
                attribBest.add(this.saveBestEntropy.getValue(2));
                attribBest.add(this.saveBestEntropy.getValue(4));
                this.saveBestValGlobalEntropy.add(attribBest);
                this.saveBestGlobalEntropy.setValue(z, this.saveBestEntropy.getValue(1));
                continue;
            }
            double value = Double.MAX_VALUE;
            this.saveBestGlobalEntropy.setValue(z, value);
        }
    }

    public double entropy(DoubleVector ValorDistClassE) {
        double entropy = 0.0;
        double sum = 0.0;
        for (double d : ValorDistClassE.getArrayCopy()) {
            if (!(d > 0.0)) continue;
            entropy -= d * Utils.log2(d);
            sum += d;
        }
        return sum > 0.0 ? (entropy + sum * Utils.log2(sum)) / sum : 0.0;
    }

    public void findBestValEntropy(BinaryTreeNumericAttributeClassObserver.Node node, DoubleVector classCountL, DoubleVector classCountR, boolean status, double minEntropy, DoubleVector parentCCLeft) {
        if (this.root != null && node != null) {
            double classCountREntropy;
            double classCountLEntropy;
            int numClass = 0;
            DoubleVector classCountLTemp = new DoubleVector();
            DoubleVector classCountRTemp = new DoubleVector();
            DoubleVector parentCCL = new DoubleVector();
            DoubleVector parentCCLParameter = new DoubleVector();
            for (int f = 0; f < node.classCountsLeft.numValues(); ++f) {
                parentCCLParameter.setValue(f, node.classCountsLeft.getValue(f));
            }
            for (int p = 0; p < parentCCLeft.numValues(); ++p) {
                parentCCL.addToValue(p, parentCCLeft.getValue(p));
            }
            numClass = classCountL.numValues() >= classCountR.numValues() ? classCountL.numValues() : classCountR.numValues();
            if (node.cut_point != this.root.cut_point) {
                for (int i = 0; i < numClass; ++i) {
                    if (status) {
                        double parentss = parentCCL.getValue(i) - (node.classCountsLeft.getValue(i) + node.classCountsRight.getValue(i));
                        double left = classCountL.getValue(i) - node.classCountsRight.getValue(i) - parentss;
                        double right = classCountR.getValue(i) + node.classCountsRight.getValue(i) + parentss;
                        classCountLTemp.addToValue(i, left);
                        classCountRTemp.addToValue(i, right);
                    }
                    if (status) continue;
                    double left = classCountL.getValue(i) + node.classCountsLeft.getValue(i);
                    double right = classCountR.getValue(i) - node.classCountsLeft.getValue(i);
                    classCountLTemp.addToValue(i, left);
                    classCountRTemp.addToValue(i, right);
                }
            } else {
                classCountLTemp = classCountL;
                classCountRTemp = classCountR;
            }
            double classCountLSum = classCountLTemp.sumOfValues();
            double classCountRSum = classCountRTemp.sumOfValues();
            double numInst = this.root.classCountsLeft.sumOfValues() + this.root.classCountsRight.sumOfValues();
            if (classCountLSum > this.PminOption.getValue() * numInst && classCountRSum > this.PminOption.getValue() * numInst && classCountLSum / numInst * (classCountLEntropy = this.entropy(classCountLTemp)) + classCountRSum / numInst * (classCountREntropy = this.entropy(classCountRTemp)) <= minEntropy) {
                this.minEntropyTemp = classCountLSum / numInst * classCountLEntropy + classCountRSum / numInst * classCountREntropy;
                this.cutPointTemp = node.cut_point;
                if (classCountLEntropy <= classCountREntropy) {
                    this.symbol = -1.0;
                    double value = 0.0;
                    double index = 0.0;
                    for (int h = 0; h < numClass; ++h) {
                        if (!(value <= classCountLTemp.getValue(h))) continue;
                        value = classCountLTemp.getValue(h);
                        index = h;
                    }
                    this.saveBestEntropy.setValue(0, this.cutPointTemp);
                    this.saveBestEntropy.setValue(1, classCountLEntropy);
                    this.saveBestEntropy.setValue(2, this.symbol);
                    this.saveBestEntropy.setValue(4, index);
                } else {
                    this.symbol = 1.0;
                    double value = 0.0;
                    double index = 0.0;
                    for (int h = 0; h < numClass; ++h) {
                        if (!(value <= classCountRTemp.getValue(h))) continue;
                        value = classCountRTemp.getValue(h);
                        index = h;
                    }
                    this.saveBestEntropy.setValue(0, this.cutPointTemp);
                    this.saveBestEntropy.setValue(1, classCountREntropy);
                    this.saveBestEntropy.setValue(2, this.symbol);
                    this.saveBestEntropy.setValue(4, index);
                }
            }
            this.findBestValEntropy(node.left, classCountLTemp, classCountRTemp, true, this.minEntropyTemp, parentCCLParameter);
            this.findBestValEntropy(node.right, classCountLTemp, classCountRTemp, false, this.minEntropyTemp, parentCCLParameter);
        }
    }

    public void mainFindBestValEntropy(BinaryTreeNumericAttributeClassObserver.Node root) {
        if (root != null) {
            DoubleVector parentClassCL = new DoubleVector();
            DoubleVector classCountL = root.classCountsLeft;
            DoubleVector classCountR = root.classCountsRight;
            double numInst = root.classCountsLeft.sumOfValues() + root.classCountsRight.sumOfValues();
            double classCountLSum = root.classCountsLeft.sumOfValues();
            double classCountRSum = root.classCountsRight.sumOfValues();
            double classCountLEntropy = this.entropy(classCountL);
            double classCountREntropy = this.entropy(classCountR);
            this.minEntropyTemp = classCountLSum / numInst * classCountLEntropy + classCountRSum / numInst * classCountREntropy;
            for (int f = 0; f < root.classCountsLeft.numValues(); ++f) {
                parentClassCL.setValue(f, root.classCountsLeft.getValue(f));
            }
            this.findBestValEntropy(root, classCountL, classCountR, true, this.minEntropyTemp, parentClassCL);
        }
    }

    public void findBestValEntropyNominalAtt(AutoExpandVector<DoubleVector> attrib, int attNumValues) {
        ArrayList distClassValue = new ArrayList();
        for (int z = 0; z < attrib.size(); ++z) {
            distClassValue.add(new ArrayList());
        }
        for (int v = 0; v < attNumValues; ++v) {
            double entropyVal;
            DoubleVector saveVal = new DoubleVector();
            for (int z = 0; z < attrib.size(); ++z) {
                if (attrib.get(z) != null) {
                    ((ArrayList)distClassValue.get(z)).add(attrib.get(z).getValue(v));
                } else {
                    ((ArrayList)distClassValue.get(z)).add(0.0);
                }
                if (((Double)((ArrayList)distClassValue.get(z)).get(v)).isNaN()) {
                    ((ArrayList)distClassValue.get(z)).add(0.0);
                }
                saveVal.setValue(z, (Double)((ArrayList)distClassValue.get(z)).get(v));
            }
            double sumValue = saveVal.sumOfValues();
            if (!(sumValue > 0.0) || !((entropyVal = this.entropy(saveVal)) <= this.minEntropyNominalAttrib)) continue;
            this.minEntropyNominalAttrib = entropyVal;
            this.saveBestEntropyNominalAttrib.setValue(0, v);
            this.saveBestEntropyNominalAttrib.setValue(1, entropyVal);
            this.saveBestEntropyNominalAttrib.setValue(2, 0.0);
        }
    }

    public double ComputeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    public boolean checkBestAttrib(double n, AutoExpandVector<AttributeClassObserver> observerss, DoubleVector observedClassDistribution) {
        double h0 = this.entropy(observedClassDistribution);
        boolean isTheBest = false;
        double[] entropyValues = this.getBestSecondBestEntropy(this.saveBestGlobalEntropy);
        double bestEntropy = entropyValues[0];
        double secondBestEntropy = entropyValues[1];
        double range = Utils.log2(this.numClass);
        double hoeffdingBound = this.ComputeHoeffdingBound(range, this.splitConfidenceOption.getValue(), n);
        if (h0 > bestEntropy && (secondBestEntropy - bestEntropy > hoeffdingBound || hoeffdingBound < this.tieThresholdOption.getValue())) {
            for (int i = 0; i < this.saveBestValGlobalEntropy.size(); ++i) {
                if (bestEntropy != this.saveBestValGlobalEntropy.get(i).get(1)) continue;
                this.saveTheBest.add(this.saveBestValGlobalEntropy.get(i).get(0));
                this.saveTheBest.add(this.saveBestValGlobalEntropy.get(i).get(1));
                this.saveTheBest.add(this.saveBestValGlobalEntropy.get(i).get(2));
                this.saveTheBest.add(Double.valueOf(i));
                if (this.saveTheBest.get(2) == 0.0) break;
                this.saveTheBest.add(this.saveBestValGlobalEntropy.get(i).get(3));
                break;
            }
            isTheBest = true;
        } else {
            isTheBest = false;
        }
        return isTheBest;
    }

    protected double[] getBestSecondBestEntropy(DoubleVector entropy) {
        double[] entropyValues = new double[2];
        double best = Double.MAX_VALUE;
        double secondBest = Double.MAX_VALUE;
        for (int i = 0; i < entropy.numValues(); ++i) {
            if (entropy.getValue(i) < best) {
                secondBest = best;
                best = entropy.getValue(i);
                continue;
            }
            if (!(entropy.getValue(i) < secondBest)) continue;
            secondBest = entropy.getValue(i);
        }
        entropyValues[0] = best;
        entropyValues[1] = secondBest;
        return entropyValues;
    }

    protected double getRuleMajorityClassIndex(RuleClassification r) {
        double maxvalue = 0.0;
        int posMaxValue = 0;
        for (int i = 0; i < r.obserClassDistrib.numValues(); ++i) {
            if (!(r.obserClassDistrib.getValue(i) > maxvalue)) continue;
            maxvalue = r.obserClassDistrib.getValue(i);
            posMaxValue = i;
        }
        return posMaxValue;
    }

    protected double[] oberversDistribProb(Instance inst, DoubleVector classDistrib) {
        double[] votes = new double[this.numClass];
        double sum = classDistrib.sumOfValues();
        for (int z = 0; z < this.numClass; ++z) {
            votes[z] = classDistrib.getValue(z) / sum;
        }
        return votes;
    }

    protected double[] firstHit(Instance inst) {
        boolean fired = false;
        int countFired = 0;
        double[] votes = new double[this.numClass];
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countFired;
            for (int z = 0; z < this.numClass; ++z) {
                votes[z] = this.ruleSet.get((int)j).obserClassDistrib.getValue(z) / this.ruleSet.get((int)j).obserClassDistrib.sumOfValues();
            }
            return votes;
        }
        fired = countFired > 0;
        if (!fired) {
            votes = this.oberversDistribProb(inst, this.observedClassDistribution);
        }
        return votes;
    }

    protected double[] weightedMax(Instance inst) {
        int countFired = 0;
        boolean fired = false;
        double highest = 0.0;
        double[] votes = new double[this.numClass];
        ArrayList<Double> ruleSetVotes = new ArrayList<Double>();
        ArrayList majorityProb = new ArrayList();
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            ArrayList<Double> ruleProb = new ArrayList<Double>();
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countFired;
            for (int z = 0; z < this.numClass; ++z) {
                ruleSetVotes.add(this.ruleSet.get((int)j).obserClassDistrib.getValue(z) / this.ruleSet.get((int)j).obserClassDistrib.sumOfValues());
                ruleProb.add(this.ruleSet.get((int)j).obserClassDistrib.getValue(z) / this.ruleSet.get((int)j).obserClassDistrib.sumOfValues());
            }
            majorityProb.add(ruleProb);
        }
        if (countFired > 0) {
            fired = true;
            Collections.sort(ruleSetVotes);
            highest = (Double)ruleSetVotes.get(ruleSetVotes.size() - 1);
            block2: for (int t = 0; t < majorityProb.size(); ++t) {
                for (int m = 0; m < ((ArrayList)majorityProb.get(t)).size(); ++m) {
                    if ((Double)((ArrayList)majorityProb.get(t)).get(m) != highest) continue;
                    for (int h = 0; h < ((ArrayList)majorityProb.get(t)).size(); ++h) {
                        votes[h] = (Double)((ArrayList)majorityProb.get(t)).get(h);
                    }
                    continue block2;
                }
            }
        } else {
            fired = false;
        }
        if (!fired) {
            votes = this.oberversDistribProb(inst, this.observedClassDistribution);
        }
        return votes;
    }

    protected double[] weightedSum(Instance inst) {
        boolean fired = false;
        int countFired = 0;
        double[] votes = new double[this.numClass];
        ArrayList<Double> weightSum = new ArrayList<Double>();
        ArrayList majorityProb = new ArrayList();
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            ArrayList<Double> ruleProb = new ArrayList<Double>();
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countFired;
            for (int z = 0; z < this.numClass; ++z) {
                ruleProb.add(this.ruleSet.get((int)j).obserClassDistrib.getValue(z) / this.ruleSet.get((int)j).obserClassDistrib.sumOfValues());
            }
            majorityProb.add(ruleProb);
        }
        if (countFired > 0) {
            fired = true;
            for (int m = 0; m < ((ArrayList)majorityProb.get(0)).size(); ++m) {
                double sum = 0.0;
                for (int t = 0; t < majorityProb.size(); ++t) {
                    sum += ((Double)((ArrayList)majorityProb.get(t)).get(m)).doubleValue();
                }
                weightSum.add(sum);
            }
            for (int h = 0; h < weightSum.size(); ++h) {
                votes[h] = (Double)weightSum.get(h) / (double)majorityProb.size();
            }
        } else {
            fired = false;
        }
        if (!fired) {
            votes = this.oberversDistribProb(inst, this.observedClassDistribution);
        }
        return votes;
    }

    protected AttributeClassObserver newNominalClassObserver() {
        return new NominalAttributeClassObserver();
    }

    protected AttributeClassObserver newNumericClassObserver() {
        return new BinaryTreeNumericAttributeClassObserver();
    }

    protected AttributeClassObserver newNumericClassObserver2() {
        return new GaussianNumericAttributeClassObserver();
    }

    public void manageMemory(int currentByteSize, int maxByteSize) {
    }
}

