/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.Prediction;
import java.util.LinkedList;
import java.util.List;
import moa.classifiers.Classifier;
import moa.classifiers.MultiLabelLearner;
import moa.classifiers.MultiTargetRegressor;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.multilabel.HoeffdingTreeClassifLeaves;
import moa.classifiers.trees.HoeffdingTree;
import moa.core.Example;
import moa.core.StringUtils;

public class MultilabelHoeffdingTree
extends HoeffdingTreeClassifLeaves
implements MultiLabelLearner,
MultiTargetRegressor {
    private static final long serialVersionUID = 1L;

    @Override
    protected HoeffdingTree.LearningNode newLearningNode(double[] initialClassObservations) {
        return new MultilabelLearningNodeClassifier(initialClassObservations, null, this);
    }

    @Override
    protected HoeffdingTree.LearningNode newLearningNode(double[] initialClassObservations, Classifier cl) {
        return new MultilabelLearningNodeClassifier(initialClassObservations, cl, this);
    }

    @Override
    protected void deactivateLearningNode(HoeffdingTree.ActiveLearningNode toDeactivate, HoeffdingTree.SplitNode parent, int parentBranch) {
        MultilabelInactiveLearningNode newLeaf = new MultilabelInactiveLearningNode(toDeactivate.getObservedClassDistribution());
        if (parent == null) {
            this.treeRoot = newLeaf;
        } else {
            parent.setChild(parentBranch, newLeaf);
        }
        --this.activeLeafNodeCount;
        ++this.inactiveLeafNodeCount;
    }

    @Override
    public Prediction getPredictionForInstance(Example<Instance> example) {
        return this.getPredictionForInstance((MultiLabelInstance)example.getData());
    }

    @Override
    public Prediction getPredictionForInstance(MultiLabelInstance inst) {
        if (this.treeRoot != null) {
            HoeffdingTree.Node leafNode;
            HoeffdingTree.FoundNode foundNode = this.treeRoot.filterInstanceToLeaf(inst, null, -1);
            MultilabelLearningNodeClassifier multilabelLeafNode = leafNode = (MultilabelLearningNodeClassifier)foundNode.node;
            if (leafNode == null) {
                leafNode = foundNode.parent;
            }
            return multilabelLeafNode.getPredictionForInstance(inst, this);
        }
        System.err.println("[WARNING] Root Node == Null !!!!!!");
        return null;
    }

    @Override
    public void trainOnInstance(Instance inst) {
        boolean isTraining;
        boolean bl = isTraining = inst.weight() > 0.0;
        if (isTraining) {
            this.trainingWeightSeenByModel += inst.weight();
            this.trainOnInstanceImpl((MultiLabelInstance)inst);
        }
    }

    @Override
    public void trainOnInstanceImpl(MultiLabelInstance instance) {
        this.trainOnInstanceImpl((Instance)instance);
    }

    public static List<Integer> getRelevantLabels(Instance x) {
        LinkedList<Integer> classValues = new LinkedList<Integer>();
        for (int j = 0; j < x.numberOutputTargets(); ++j) {
            if (!(x.classValue(j) > 0.0)) continue;
            classValues.add(j);
        }
        return classValues;
    }

    public class MultilabelLearningNodeClassifier
    extends HoeffdingTreeClassifLeaves.LearningNodeClassifier {
        private static final long serialVersionUID = 1L;

        public MultilabelLearningNodeClassifier(double[] initialClassObservations, Classifier cl, MultilabelHoeffdingTree ht) {
            super(initialClassObservations);
            if (cl == null) {
                this.classifier = ((Classifier)MultilabelHoeffdingTree.this.getPreparedClassOption(ht.learnerOption)).copy();
                this.classifier.resetLearning();
                InstancesHeader raw_header = ht.getModelContext();
                this.classifier.setModelContext(raw_header);
            } else {
                this.classifier = cl.copy();
            }
        }

        @Override
        public double[] getClassVotes(Instance inst, HoeffdingTree ht) {
            return this.classifier.getVotesForInstance(inst);
        }

        public Prediction getPredictionForInstance(Instance inst, HoeffdingTree ht) {
            return this.classifier.getPredictionForInstance(inst);
        }

        @Override
        public void disableAttribute(int attIndex) {
        }

        @Override
        public Classifier getClassifier() {
            return this.classifier;
        }

        @Override
        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            this.classifier.trainOnInstance(inst);
            MultilabelHoeffdingTree mht = (MultilabelHoeffdingTree)ht;
            List<Integer> labels = MultilabelHoeffdingTree.getRelevantLabels(inst);
            for (int l : labels) {
                this.observedClassDistribution.addToValue(l, inst.weight());
            }
            for (int i = 0; i < inst.numInputAttributes(); ++i) {
                int instAttIndex = i;
                AttributeClassObserver obs = (AttributeClassObserver)this.attributeObservers.get(instAttIndex);
                if (obs == null) {
                    obs = inst.inputAttribute(i).isNominal() ? mht.newNominalClassObserver() : mht.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                for (int l : labels) {
                    obs.observeAttributeClass(inst.valueInputAttribute(i), l, inst.weight());
                }
            }
        }

        @Override
        public void describeSubtree(HoeffdingTree ht, StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, "Leaf ");
            out.append(" = ");
            out.append(" weights: ");
            this.observedClassDistribution.getSingleLineDescription(out, this.observedClassDistribution.numValues());
            StringUtils.appendNewline(out);
        }
    }

    public static class MultilabelInactiveLearningNode
    extends HoeffdingTree.InactiveLearningNode {
        private static final long serialVersionUID = 1L;

        public MultilabelInactiveLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        @Override
        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            MultilabelHoeffdingTree cfr_ignored_0 = (MultilabelHoeffdingTree)ht;
            List<Integer> labels = MultilabelHoeffdingTree.getRelevantLabels(inst);
            for (int l : labels) {
                this.observedClassDistribution.addToValue(l, inst.weight());
            }
        }
    }
}

