/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.bayes;

import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.GaussianNumericAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.NominalAttributeClassObserver;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.StringUtils;

public class NaiveBayes
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    protected DoubleVector observedClassDistribution;
    protected AutoExpandVector<AttributeClassObserver> attributeObservers;

    @Override
    public String getPurposeString() {
        return "Naive Bayes classifier: performs classic bayesian prediction while making naive assumption that all inputs are independent.";
    }

    @Override
    public void resetLearningImpl() {
        this.observedClassDistribution = new DoubleVector();
        this.attributeObservers = new AutoExpandVector();
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
        for (int i = 0; i < inst.numAttributes() - 1; ++i) {
            int instAttIndex = NaiveBayes.modelAttIndexToInstanceAttIndex(i, inst);
            AttributeClassObserver obs = this.attributeObservers.get(i);
            if (obs == null) {
                obs = inst.attribute(instAttIndex).isNominal() ? this.newNominalClassObserver() : this.newNumericClassObserver();
                this.attributeObservers.set(i, obs);
            }
            obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
        }
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        return NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        for (int i = 0; i < this.observedClassDistribution.numValues(); ++i) {
            StringUtils.appendIndented(out, indent, "Observations for ");
            out.append(this.getClassNameString());
            out.append(" = ");
            out.append(this.getClassLabelString(i));
            out.append(":");
            StringUtils.appendNewlineIndented(out, indent + 1, "Total observed weight = ");
            out.append(this.observedClassDistribution.getValue(i));
            out.append(" / prob = ");
            out.append(this.observedClassDistribution.getValue(i) / this.observedClassDistribution.sumOfValues());
            for (int j = 0; j < this.attributeObservers.size(); ++j) {
                StringUtils.appendNewlineIndented(out, indent + 1, "Observations for ");
                out.append(this.getAttributeNameString(j));
                out.append(": ");
                out.append(this.attributeObservers.get(j));
            }
            StringUtils.appendNewline(out);
        }
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    protected AttributeClassObserver newNominalClassObserver() {
        return new NominalAttributeClassObserver();
    }

    protected AttributeClassObserver newNumericClassObserver() {
        return new GaussianNumericAttributeClassObserver();
    }

    public static double[] doNaiveBayesPrediction(Instance inst, DoubleVector observedClassDistribution, AutoExpandVector<AttributeClassObserver> attributeObservers) {
        double[] votes = new double[observedClassDistribution.numValues()];
        double observedClassSum = observedClassDistribution.sumOfValues();
        for (int classIndex = 0; classIndex < votes.length; ++classIndex) {
            votes[classIndex] = observedClassDistribution.getValue(classIndex) / observedClassSum;
            for (int attIndex = 0; attIndex < inst.numAttributes() - 1; ++attIndex) {
                int instAttIndex = NaiveBayes.modelAttIndexToInstanceAttIndex(attIndex, inst);
                AttributeClassObserver obs = attributeObservers.get(attIndex);
                if (obs == null || inst.isMissing(instAttIndex)) continue;
                int n = classIndex;
                votes[n] = votes[n] * obs.probabilityOfAttributeValueGivenClass(inst.value(instAttIndex), classIndex);
            }
        }
        return votes;
    }

    public static double[] doNaiveBayesPredictionLog(Instance inst, DoubleVector observedClassDistribution, AutoExpandVector<AttributeClassObserver> observers, AutoExpandVector<AttributeClassObserver> observers2) {
        double[] votes = new double[observedClassDistribution.numValues()];
        double observedClassSum = observedClassDistribution.sumOfValues();
        for (int classIndex = 0; classIndex < votes.length; ++classIndex) {
            votes[classIndex] = Math.log10(observedClassDistribution.getValue(classIndex) / observedClassSum);
            for (int attIndex = 0; attIndex < inst.numAttributes() - 1; ++attIndex) {
                int instAttIndex = NaiveBayes.modelAttIndexToInstanceAttIndex(attIndex, inst);
                AttributeClassObserver obs = inst.attribute(instAttIndex).isNominal() ? observers.get(attIndex) : observers2.get(attIndex);
                if (obs == null || inst.isMissing(instAttIndex)) continue;
                int n = classIndex;
                votes[n] = votes[n] + Math.log10(obs.probabilityOfAttributeValueGivenClass(inst.value(instAttIndex), classIndex));
            }
        }
        return votes;
    }

    public void manageMemory(int currentByteSize, int maxByteSize) {
    }
}

