/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.AttributesInformation;
import com.yahoo.labs.samoa.instances.Range;
import java.io.Serializable;
import java.util.List;

public class InstanceInformation
implements Serializable {
    protected String relationName;
    protected AttributesInformation attributesInformation;
    protected int classIndex = Integer.MAX_VALUE;
    protected Range range;

    public Attribute inputAttribute(int w) {
        return this.attributesInformation.attribute(this.inputAttributeIndex(w));
    }

    public Attribute outputAttribute(int w) {
        return this.attributesInformation.attribute(this.outputAttributeIndex(w));
    }

    public InstanceInformation(InstanceInformation chunk) {
        this.relationName = chunk.relationName;
        this.attributesInformation = chunk.attributesInformation;
        this.classIndex = chunk.classIndex;
    }

    public InstanceInformation(String st, List<Attribute> input) {
        this.relationName = st;
        this.attributesInformation = new AttributesInformation(input, input.size());
    }

    public InstanceInformation() {
        this.relationName = null;
        this.attributesInformation = null;
    }

    public void setRelationName(String string) {
        this.relationName = string;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public int classIndex() {
        return this.classIndex;
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    public Attribute classAttribute() {
        return this.attribute(this.classIndex());
    }

    public int numAttributes() {
        return this.attributesInformation.numberAttributes;
    }

    public Attribute attribute(int w) {
        return this.attributesInformation.attribute(w);
    }

    public int numClasses() {
        return this.attributesInformation.attribute(this.classIndex()).numValues();
    }

    public void deleteAttributeAt(Integer integer) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void insertAttributeAt(Attribute attribute, int i) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setAttributes(List<Attribute> v) {
        if (this.attributesInformation == null) {
            this.attributesInformation = new AttributesInformation();
        }
        this.attributesInformation.setAttributes(v);
    }

    public int inputAttributeIndex(int index) {
        int ret = 0;
        ret = this.classIndex == Integer.MAX_VALUE ? (index < this.range.getStart() ? index : index + this.range.getSelectionLength()) : (this.classIndex() > index ? index : index + 1);
        return ret;
    }

    public int outputAttributeIndex(int attributeIndex) {
        int ret = 0;
        ret = this.classIndex == Integer.MAX_VALUE ? attributeIndex + this.range.getStart() : this.classIndex;
        return ret;
    }

    public int numInputAttributes() {
        int ret = 0;
        ret = this.classIndex == Integer.MAX_VALUE ? this.numAttributes() - this.range.getSelectionLength() : this.numAttributes() - 1;
        return ret;
    }

    public int numOutputAttributes() {
        int ret = 0;
        ret = this.classIndex == Integer.MAX_VALUE ? this.range.getSelectionLength() : 1;
        return ret;
    }

    public void setRangeOutputIndices(Range range) {
        this.setClassIndex(Integer.MAX_VALUE);
        this.range = range;
    }

    public void setAttributes(List<Attribute> v, List<Integer> indexValues) {
        if (this.attributesInformation == null) {
            this.attributesInformation = new AttributesInformation();
        }
        this.attributesInformation.setAttributes(v, indexValues);
    }
}

