/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstanceData;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceData;
import com.yahoo.labs.samoa.instances.InstanceInformation;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.SparseInstanceData;
import java.text.SimpleDateFormat;

public class InstanceImpl
implements MultiLabelInstance {
    protected double weight;
    protected InstanceData instanceData;
    protected InstancesHeader instanceHeader;

    public InstanceImpl(InstanceImpl inst) {
        this.weight = inst.weight;
        this.instanceData = inst.instanceData.copy();
        this.instanceHeader = inst.instanceHeader;
    }

    public InstanceImpl(double weight, double[] res) {
        this.weight = weight;
        this.instanceData = new DenseInstanceData(res);
    }

    public InstanceImpl(double weight, double[] attributeValues, int[] indexValues, int numberAttributes) {
        this.weight = weight;
        this.instanceData = new SparseInstanceData(attributeValues, indexValues, numberAttributes);
    }

    public InstanceImpl(double weight, InstanceData instanceData) {
        this.weight = weight;
        this.instanceData = instanceData;
    }

    public InstanceImpl(int numAttributes) {
        this.instanceData = new DenseInstanceData(new double[numAttributes]);
        this.weight = 1.0;
    }

    @Override
    public double weight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public Attribute attribute(int instAttIndex) {
        return this.instanceHeader.attribute(instAttIndex);
    }

    @Override
    public int indexOfAttribute(Attribute attribute) {
        return this.instanceHeader.indexOf(attribute);
    }

    @Override
    public void deleteAttributeAt(int i) {
        this.instanceData.deleteAttributeAt(i);
    }

    @Override
    public void insertAttributeAt(int i) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int numAttributes() {
        return this.instanceData.numAttributes();
    }

    @Override
    public double value(int instAttIndex) {
        return this.instanceData.value(instAttIndex);
    }

    @Override
    public boolean isMissing(int instAttIndex) {
        return this.instanceData.isMissing(instAttIndex);
    }

    @Override
    public int numValues() {
        return this.instanceData.numValues();
    }

    @Override
    public int index(int i) {
        return this.instanceData.index(i);
    }

    @Override
    public double valueSparse(int i) {
        return this.instanceData.valueSparse(i);
    }

    @Override
    public boolean isMissingSparse(int p) {
        return this.instanceData.isMissingSparse(p);
    }

    @Override
    public double value(Attribute attribute) {
        int index = this.instanceHeader.indexOf(attribute);
        return this.value(index);
    }

    @Override
    public String stringValue(int i) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double[] toDoubleArray() {
        return this.instanceData.toDoubleArray();
    }

    @Override
    public void setValue(int numAttribute, double d) {
        this.instanceData.setValue(numAttribute, d);
    }

    @Override
    public double classValue() {
        return this.instanceData.value(this.classIndex());
    }

    @Override
    public int classIndex() {
        int classIndex = this.instanceHeader.classIndex();
        return classIndex != Integer.MAX_VALUE ? classIndex : 0;
    }

    @Override
    public int numClasses() {
        return this.instanceHeader.numClasses();
    }

    @Override
    public boolean classIsMissing() {
        return this.instanceData.isMissing(this.classIndex());
    }

    @Override
    public Attribute classAttribute() {
        return this.instanceHeader.attribute(this.classIndex());
    }

    @Override
    public void setClassValue(double d) {
        this.setValue(this.classIndex(), d);
    }

    @Override
    public Instance copy() {
        InstanceImpl inst = new InstanceImpl(this);
        return inst;
    }

    @Override
    public Instances dataset() {
        return this.instanceHeader;
    }

    @Override
    public void setDataset(Instances dataset) {
        this.instanceHeader = new InstancesHeader(dataset);
    }

    @Override
    public void addSparseValues(int[] indexValues, double[] attributeValues, int numberAttributes) {
        this.instanceData = new SparseInstanceData(attributeValues, indexValues, numberAttributes);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int attIndex = 0; attIndex < this.numAttributes(); ++attIndex) {
            if (!this.isMissing(attIndex)) {
                if (this.attribute(attIndex).isNominal()) {
                    int valueIndex = (int)this.value(attIndex);
                    String stringValue = this.attribute(attIndex).value(valueIndex);
                    str.append(stringValue).append(",");
                    continue;
                }
                if (this.attribute(attIndex).isNumeric()) {
                    str.append(this.value(attIndex)).append(",");
                    continue;
                }
                if (!this.attribute(attIndex).isDate()) continue;
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                str.append(dateFormatter.format(this.value(attIndex))).append(",");
                continue;
            }
            str.append("?,");
        }
        return str.toString();
    }

    @Override
    public int numInputAttributes() {
        return this.instanceHeader.numInputAttributes();
    }

    @Override
    public int numOutputAttributes() {
        return this.numberOutputTargets();
    }

    @Override
    public int numberOutputTargets() {
        return this.instanceHeader.numOutputAttributes();
    }

    @Override
    public double classValue(int instAttIndex) {
        return this.valueOutputAttribute(instAttIndex);
    }

    @Override
    public void setClassValue(int indexClass, double valueAttribute) {
        InstanceInformation instanceInformation = this.instanceHeader.getInstanceInformation();
        this.instanceData.setValue(instanceInformation.outputAttributeIndex(indexClass), valueAttribute);
    }

    @Override
    public Attribute outputAttribute(int outputIndex) {
        InstanceInformation instanceInformation = this.instanceHeader.getInstanceInformation();
        return instanceInformation.outputAttribute(outputIndex);
    }

    @Override
    public Attribute inputAttribute(int attributeIndex) {
        InstanceInformation instanceInformation = this.instanceHeader.getInstanceInformation();
        return instanceInformation.inputAttribute(attributeIndex);
    }

    @Override
    public double valueInputAttribute(int attributeIndex) {
        InstanceInformation instanceInformation = this.instanceHeader.getInstanceInformation();
        return this.instanceData.value(instanceInformation.inputAttributeIndex(attributeIndex));
    }

    @Override
    public double valueOutputAttribute(int attributeIndex) {
        InstanceInformation instanceInformation = this.instanceHeader.getInstanceInformation();
        return this.instanceData.value(instanceInformation.outputAttributeIndex(attributeIndex));
    }

    @Override
    public void setMissing(int instAttIndex) {
        this.setValue(instAttIndex, Double.NaN);
    }

    @Override
    public void setMissing(Attribute attribute) {
        int index = this.instanceHeader.indexOf(attribute);
        this.setMissing(index);
    }

    @Override
    public boolean isMissing(Attribute attribute) {
        int index = this.instanceHeader.indexOf(attribute);
        return this.isMissing(index);
    }

    @Override
    public void setValue(Attribute attribute, double value) {
        int index = this.instanceHeader.indexOf(attribute);
        this.setValue(index, value);
    }
}

