/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import com.yahoo.labs.samoa.instances.Attribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AttributesInformation
implements Serializable {
    protected List<Attribute> attributes;
    protected List<Integer> indexValues;
    protected int numberAttributes;
    protected Attribute defaultNumericAttribute;

    public AttributesInformation(AttributesInformation chunk) {
        this.attributes = chunk.attributes;
        this.indexValues = chunk.indexValues;
        this.numberAttributes = chunk.numberAttributes;
    }

    public AttributesInformation(List<Attribute> v, List<Integer> i, int numberAttributes) {
        this.attributes = v;
        this.indexValues = i;
        this.numberAttributes = numberAttributes;
    }

    public AttributesInformation(List<Attribute> v, int numberAttributes) {
        this.attributes = v;
        this.indexValues = new ArrayList<Integer>(numberAttributes);
        for (int i = 0; i < numberAttributes; ++i) {
            this.indexValues.add(i);
        }
        this.numberAttributes = numberAttributes;
    }

    public AttributesInformation() {
        this.attributes = null;
        this.indexValues = null;
        this.numberAttributes = 0;
        this.defaultNumericAttribute = null;
    }

    public Attribute attribute(int indexAttribute) {
        if (this.attributes == null) {
            return this.defaultNumericAttribute();
        }
        int location = this.locateIndex(indexAttribute);
        if (location == -1) {
            return this.defaultNumericAttribute();
        }
        return this.attributes.get(location);
    }

    public void add(Attribute attribute, int value) {
        this.attributes.add(attribute);
        this.indexValues.add(value);
    }

    public void setAttributes(List<Attribute> v) {
        this.attributes = v;
        this.numberAttributes = v.size();
    }

    public int locateIndex(int index) {
        int min = 0;
        int max = this.indexValues.size() - 1;
        if (max == -1) {
            return -1;
        }
        while (this.indexValues.get(min) <= index && this.indexValues.get(max) >= index) {
            int current = (max + min) / 2;
            if (this.indexValues.get(current) > index) {
                max = current - 1;
                continue;
            }
            if (this.indexValues.get(current) < index) {
                min = current + 1;
                continue;
            }
            return current;
        }
        if (this.indexValues.get(max) < index) {
            return max;
        }
        return min - 1;
    }

    private Attribute defaultNumericAttribute() {
        if (this.defaultNumericAttribute == null) {
            this.defaultNumericAttribute = new Attribute("default");
        }
        return this.defaultNumericAttribute;
    }

    public void setAttributes(List<Attribute> v, List<Integer> indexValues) {
        this.attributes = v;
        this.numberAttributes = v.size();
        this.indexValues = indexValues;
    }
}

