/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.StringOption;
import moa.core.ObjectRepository;
import moa.options.ClassOption;
import moa.tasks.ConceptDriftMainTask;
import moa.tasks.EvaluateConceptDrift;
import moa.tasks.Task;
import moa.tasks.TaskMonitor;

public class RunStreamTasks
extends ConceptDriftMainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption taskOption = new ClassOption("task", 't', "Task to do.", Task.class, "EvaluatePrequential -l active.ActiveClassifier -i 1000000 -d temp.txt");
    public StringOption streamParameterOption = new StringOption("streamParameter", 'p', "Stream parameter to vary.", "b");
    public FloatOption firstValueOption = new FloatOption("firstValue", 'f', "First value", 0.0);
    public FloatOption lastValueOption = new FloatOption("lastValue", 'l', "Last value", 1.0);
    public FloatOption incrementValueOption = new FloatOption("incrementValue", 'i', "Increment value", 0.1);
    protected Task task;

    @Override
    public String getPurposeString() {
        return "Runs several experiments modifying values of parameters.";
    }

    @Override
    public Class<?> getTaskResultType() {
        return this.task.getTaskResultType();
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Object result = null;
        Task taskBase = (Task)this.getPreparedClassOption(this.taskOption);
        String commandString = this.taskOption.getValueAsCLIString();
        int valueParameter = (int)this.firstValueOption.getValue();
        while ((double)valueParameter <= this.lastValueOption.getValue()) {
            this.task = (Task)taskBase.copy();
            if (this.task instanceof EvaluateConceptDrift) {
                String stream = ((EvaluateConceptDrift)this.task).streamOption.getValueAsCLIString();
                ((EvaluateConceptDrift)this.task).streamOption.setValueViaCLIString(stream + " -" + this.streamParameterOption.getValue() + " " + valueParameter);
            }
            result = this.task.doTask(monitor, repository);
            valueParameter += (int)this.incrementValueOption.getValue();
        }
        return result;
    }
}

