/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import com.github.javacliparser.IntOption;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.core.TimingUtils;
import moa.evaluation.LearningEvaluation;
import moa.options.ClassOption;
import moa.streams.ExampleStream;
import moa.tasks.MainTask;
import moa.tasks.TaskMonitor;

public class MeasureStreamSpeed
extends MainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to measure.", ExampleStream.class, "generators.RandomTreeGenerator");
    public IntOption generateSizeOption = new IntOption("generateSize", 'g', "Number of examples.", 10000000, 0, Integer.MAX_VALUE);

    @Override
    public String getPurposeString() {
        return "Measures the speed of a stream.";
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        int numInstances;
        TimingUtils.enablePreciseTiming();
        ExampleStream stream = (ExampleStream)this.getPreparedClassOption(this.streamOption);
        long genStartTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
        for (numInstances = 0; numInstances < this.generateSizeOption.getValue(); ++numInstances) {
            stream.nextInstance();
        }
        double genTime = TimingUtils.nanoTimeToSeconds(TimingUtils.getNanoCPUTimeOfCurrentThread() - genStartTime);
        return new LearningEvaluation(new Measurement[]{new Measurement("Number of instances generated", numInstances), new Measurement("Time elapsed", genTime), new Measurement("Instances per second", (double)numInstances / genTime)});
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningEvaluation.class;
    }
}

