/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.ClusterGenerator;
import moa.clusterers.KMeans;
import moa.core.FastVector;
import moa.evaluation.MeasureCollection;
import moa.gui.TextViewerPanel;
import moa.gui.clustertab.ClusteringSetupTab;
import moa.gui.clustertab.ClusteringVisualEvalPanel;
import moa.gui.clustertab.ClusteringVisualTab;
import moa.gui.visualization.DataPoint;
import moa.gui.visualization.GraphCanvas;
import moa.gui.visualization.StreamPanel;
import moa.gui.visualization.WekaExplorer;
import moa.streams.clustering.ClusterEvent;
import moa.streams.clustering.ClusterEventListener;
import moa.streams.clustering.ClusteringStream;
import moa.streams.clustering.RandomRBFGeneratorEvents;

public class RunVisualizer
implements Runnable,
ActionListener,
ClusterEventListener {
    public static final int initialPauseInterval = 5000;
    private int m_wait_frequency = 1000;
    private int m_redrawInterval = 100;
    private static boolean work;
    private boolean stop = false;
    private static int timestamp;
    private static int lastPauseTimestamp;
    private int m_processFrequency;
    private final ClusteringStream m_stream0;
    private int m_stream0_decayHorizon;
    private double m_stream0_decay_threshold;
    private double m_stream0_decay_rate;
    private AbstractClusterer m_clusterer0;
    private AbstractClusterer m_clusterer1;
    private MeasureCollection[] m_measures0 = null;
    private MeasureCollection[] m_measures1 = null;
    private StreamPanel m_streampanel0;
    private StreamPanel m_streampanel1;
    private ClusteringVisualEvalPanel m_evalPanel;
    private GraphCanvas m_graphcanvas;
    private ClusteringVisualTab m_visualPanel;
    private Clustering gtClustering0 = null;
    private Clustering gtClustering1 = null;
    private Clustering macro0 = null;
    private Clustering macro1 = null;
    private Clustering micro0 = null;
    private Clustering micro1 = null;
    private ArrayList<ClusterEvent> clusterEvents;
    private final TextViewerPanel m_logPanel;

    public RunVisualizer(ClusteringVisualTab visualPanel, ClusteringSetupTab clusteringSetupTab) {
        this.m_visualPanel = visualPanel;
        this.m_streampanel0 = visualPanel.getLeftStreamPanel();
        this.m_streampanel1 = visualPanel.getRightStreamPanel();
        this.m_graphcanvas = visualPanel.getGraphCanvas();
        this.m_evalPanel = visualPanel.getEvalPanel();
        this.m_logPanel = clusteringSetupTab.getLogPanel();
        this.m_stream0 = clusteringSetupTab.getStream0();
        this.m_stream0_decayHorizon = this.m_stream0.getDecayHorizon();
        this.m_stream0_decay_threshold = this.m_stream0.getDecayThreshold();
        this.m_stream0_decay_rate = Math.log(1.0 / this.m_stream0_decay_threshold) / Math.log(2.0) / (double)this.m_stream0_decayHorizon;
        timestamp = 0;
        lastPauseTimestamp = 0;
        work = true;
        if (this.m_stream0 instanceof RandomRBFGeneratorEvents) {
            ((RandomRBFGeneratorEvents)this.m_stream0).addClusterChangeListener(this);
            this.clusterEvents = new ArrayList();
            this.m_graphcanvas.setClusterEventsList(this.clusterEvents);
        }
        this.m_stream0.prepareForUse();
        this.m_clusterer0 = clusteringSetupTab.getClusterer0();
        this.m_clusterer0.prepareForUse();
        this.m_clusterer1 = clusteringSetupTab.getClusterer1();
        if (this.m_clusterer1 != null) {
            this.m_clusterer1.prepareForUse();
        }
        this.m_measures0 = clusteringSetupTab.getMeasures();
        this.m_measures1 = clusteringSetupTab.getMeasures();
        this.m_processFrequency = this.m_stream0.getEvaluationFrequency();
        int dims = this.m_stream0.numAttsOption.getValue();
        visualPanel.setDimensionComobBoxes(dims);
        visualPanel.setPauseInterval(5000);
        this.m_evalPanel.setMeasures(this.m_measures0, this.m_measures1, this);
        this.m_graphcanvas.setGraph(this.m_measures0[0], this.m_measures1[0], 0, this.m_processFrequency);
    }

    @Override
    public void run() {
        this.runVisual();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runVisual() {
        int processCounter = 0;
        int speedCounter = 0;
        LinkedList<DataPoint> pointBuffer0 = new LinkedList<DataPoint>();
        LinkedList<DataPoint> pointBuffer1 = new LinkedList<DataPoint>();
        ArrayList<DataPoint> pointarray0 = null;
        ArrayList pointarray1 = null;
        while (work || processCounter != 0) {
            if (this.m_stream0.hasMoreInstances()) {
                ++speedCounter;
                ++processCounter;
                if (++timestamp % 100 == 0) {
                    this.m_visualPanel.setProcessedPointsCounter(timestamp);
                }
                Instance next0 = (Instance)this.m_stream0.nextInstance().getData();
                DataPoint point0 = new DataPoint(next0, timestamp);
                pointBuffer0.add(point0);
                while (pointBuffer0.size() > this.m_stream0_decayHorizon) {
                    pointBuffer0.removeFirst();
                }
                DataPoint point1 = null;
                if (this.m_clusterer1 != null) {
                    point1 = new DataPoint(next0, timestamp);
                    pointBuffer1.add(point1);
                    while (pointBuffer1.size() > this.m_stream0_decayHorizon) {
                        pointBuffer1.removeFirst();
                    }
                }
                if (this.m_visualPanel.isEnabledDrawPoints()) {
                    this.m_streampanel0.drawPoint(point0);
                    if (this.m_clusterer1 != null) {
                        this.m_streampanel1.drawPoint(point1);
                    }
                    if (processCounter % this.m_redrawInterval == 0) {
                        this.m_streampanel0.applyDrawDecay((float)this.m_stream0_decayHorizon / (float)this.m_redrawInterval);
                        if (this.m_clusterer1 != null) {
                            this.m_streampanel1.applyDrawDecay((float)this.m_stream0_decayHorizon / (float)this.m_redrawInterval);
                        }
                    }
                }
                DenseInstance traininst0 = new DenseInstance(point0);
                if (this.m_clusterer0.keepClassLabel()) {
                    traininst0.setDataset(point0.dataset());
                } else {
                    traininst0.deleteAttributeAt(point0.classIndex());
                }
                this.m_clusterer0.trainOnInstanceImpl(traininst0);
                if (this.m_clusterer1 != null) {
                    DenseInstance traininst1 = new DenseInstance(point1);
                    if (this.m_clusterer1.keepClassLabel()) {
                        traininst1.setDataset(point1.dataset());
                    } else {
                        traininst1.deleteAttributeAt(point1.classIndex());
                    }
                    this.m_clusterer1.trainOnInstanceImpl(traininst1);
                }
                if (processCounter >= this.m_processFrequency) {
                    processCounter = 0;
                    for (DataPoint p : pointBuffer0) {
                        p.updateWeight(timestamp, this.m_stream0_decay_rate);
                    }
                    pointarray0 = new ArrayList<DataPoint>(pointBuffer0);
                    if (this.m_clusterer1 != null) {
                        for (DataPoint p : pointBuffer1) {
                            p.updateWeight(timestamp, this.m_stream0_decay_rate);
                        }
                        pointarray1 = new ArrayList(pointBuffer1);
                    }
                    this.processClusterings(pointarray0, pointarray1);
                    int pauseInterval = this.m_visualPanel.getPauseInterval();
                    if (pauseInterval != 0 && lastPauseTimestamp + pauseInterval <= timestamp) {
                        this.m_visualPanel.toggleVisualizer(true);
                    }
                }
            } else {
                System.out.println("DONE");
                return;
            }
            if (speedCounter <= this.m_wait_frequency * 30 || this.m_wait_frequency >= 15) continue;
            try {
                RunVisualizer runVisualizer = this;
                synchronized (runVisualizer) {
                    if (this.m_wait_frequency == 0) {
                        this.wait(50L);
                    } else {
                        this.wait(1L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            speedCounter = 0;
        }
        if (!this.stop) {
            this.m_streampanel0.drawPointPanels(pointarray0, timestamp, this.m_stream0_decay_rate, this.m_stream0_decay_threshold);
            if (this.m_clusterer1 != null) {
                this.m_streampanel1.drawPointPanels(pointarray1, timestamp, this.m_stream0_decay_rate, this.m_stream0_decay_threshold);
            }
            this.work_pause();
        }
    }

    private void processClusterings(ArrayList<DataPoint> points0, ArrayList<DataPoint> points1) {
        this.gtClustering0 = new Clustering(points0);
        this.gtClustering1 = null;
        if (this.m_clusterer1 != null) {
            this.gtClustering1 = new Clustering(points1);
        }
        Clustering evalClustering0 = null;
        Clustering evalClustering1 = null;
        if (this.gtClustering0 != null) {
            if (this.m_clusterer0 instanceof ClusterGenerator) {
                ((ClusterGenerator)this.m_clusterer0).setSourceClustering(this.gtClustering0);
            }
            if (this.m_clusterer1 instanceof ClusterGenerator) {
                ((ClusterGenerator)this.m_clusterer1).setSourceClustering(this.gtClustering1);
            }
        }
        evalClustering0 = this.macro0 = this.m_clusterer0.getClusteringResult();
        if (this.m_clusterer0.implementsMicroClusterer()) {
            this.micro0 = this.m_clusterer0.getMicroClusteringResult();
            if (this.macro0 == null && this.micro0 != null) {
                this.macro0 = KMeans.gaussianMeans(this.gtClustering0, this.micro0);
            }
            evalClustering0 = this.m_clusterer0.evaluateMicroClusteringOption.isSet() ? this.micro0 : this.macro0;
        }
        if (this.m_clusterer1 != null) {
            evalClustering1 = this.macro1 = this.m_clusterer1.getClusteringResult();
            if (this.m_clusterer1.implementsMicroClusterer()) {
                this.micro1 = this.m_clusterer1.getMicroClusteringResult();
                if (this.macro1 == null && this.micro1 != null) {
                    this.macro1 = KMeans.gaussianMeans(this.gtClustering1, this.micro1);
                }
                evalClustering1 = this.m_clusterer1.evaluateMicroClusteringOption.isSet() ? this.micro1 : this.macro1;
            }
        }
        this.evaluateClustering(evalClustering0, this.gtClustering0, points0, true);
        this.evaluateClustering(evalClustering1, this.gtClustering1, points1, false);
        this.drawClusterings(points0, points1);
    }

    private void evaluateClustering(Clustering found_clustering, Clustering trueClustering, ArrayList<DataPoint> points, boolean algorithm0) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.m_measures0.length; ++i) {
            if (algorithm0) {
                if (found_clustering != null && found_clustering.size() > 0) {
                    try {
                        double msec = this.m_measures0[i].evaluateClusteringPerformance(found_clustering, trueClustering, points);
                        sb.append(this.m_measures0[i].getClass().getSimpleName() + " took " + msec + "ms (Mean:" + this.m_measures0[i].getMeanRunningTime() + ")");
                        sb.append("\n");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                for (int j = 0; j < this.m_measures0[i].getNumMeasures(); ++j) {
                    this.m_measures0[i].addEmptyValue(j);
                }
                continue;
            }
            if (this.m_clusterer1 != null && found_clustering != null && found_clustering.size() > 0) {
                try {
                    double msec = this.m_measures1[i].evaluateClusteringPerformance(found_clustering, trueClustering, points);
                    sb.append(this.m_measures1[i].getClass().getSimpleName() + " took " + msec + "ms (Mean:" + this.m_measures1[i].getMeanRunningTime() + ")");
                    sb.append("\n");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            for (int j = 0; j < this.m_measures1[i].getNumMeasures(); ++j) {
                this.m_measures1[i].addEmptyValue(j);
            }
        }
        this.m_logPanel.setText(sb.toString());
        this.m_evalPanel.update();
        this.m_graphcanvas.updateCanvas();
    }

    public void drawClusterings(List<DataPoint> points0, List<DataPoint> points1) {
        if (this.macro0 != null && this.macro0.size() > 0) {
            this.m_streampanel0.drawMacroClustering(this.macro0, points0, Color.RED);
        }
        if (this.micro0 != null && this.micro0.size() > 0) {
            this.m_streampanel0.drawMicroClustering(this.micro0, points0, Color.GREEN);
        }
        if (this.gtClustering0 != null && this.gtClustering0.size() > 0) {
            this.m_streampanel0.drawGTClustering(this.gtClustering0, points0, Color.BLACK);
        }
        if (this.m_clusterer1 != null) {
            if (this.macro1 != null && this.macro1.size() > 0) {
                this.m_streampanel1.drawMacroClustering(this.macro1, points1, Color.BLUE);
            }
            if (this.micro1 != null && this.micro1.size() > 0) {
                this.m_streampanel1.drawMicroClustering(this.micro1, points1, Color.GREEN);
            }
            if (this.gtClustering1 != null && this.gtClustering1.size() > 0) {
                this.m_streampanel1.drawGTClustering(this.gtClustering1, points1, Color.BLACK);
            }
        }
    }

    public void redraw() {
        this.m_streampanel0.repaint();
        this.m_streampanel1.repaint();
    }

    public static int getCurrentTimestamp() {
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work_pause() {
        while (!work && !this.stop) {
            try {
                RunVisualizer runVisualizer = this;
                synchronized (runVisualizer) {
                    this.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.run();
    }

    public static void pause() {
        work = false;
        lastPauseTimestamp = timestamp;
    }

    public static void resume() {
        work = true;
    }

    public void stop() {
        work = false;
        this.stop = true;
    }

    public void setSpeed(int speed) {
        this.m_wait_frequency = speed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selected;
        int counter = selected = Integer.parseInt(e.getActionCommand());
        int m_select = 0;
        int m_select_offset = 0;
        boolean found = false;
        for (int i = 0; i < this.m_measures0.length; ++i) {
            for (int j = 0; j < this.m_measures0[i].getNumMeasures(); ++j) {
                if (!this.m_measures0[i].isEnabled(j) || --counter >= 0) continue;
                m_select = i;
                m_select_offset = j;
                found = true;
                break;
            }
            if (found) break;
        }
        this.m_graphcanvas.setGraph(this.m_measures0[m_select], this.m_measures1[m_select], m_select_offset, this.m_processFrequency);
    }

    public void setPointLayerVisibility(boolean selected) {
        this.m_streampanel0.setPointVisibility(selected);
        this.m_streampanel1.setPointVisibility(selected);
    }

    public void setMicroLayerVisibility(boolean selected) {
        this.m_streampanel0.setMicroLayerVisibility(selected);
        this.m_streampanel1.setMicroLayerVisibility(selected);
    }

    public void setMacroVisibility(boolean selected) {
        this.m_streampanel0.setMacroLayerVisibility(selected);
        this.m_streampanel1.setMacroLayerVisibility(selected);
    }

    public void setGroundTruthVisibility(boolean selected) {
        this.m_streampanel0.setGroundTruthLayerVisibility(selected);
        this.m_streampanel1.setGroundTruthLayerVisibility(selected);
    }

    @Override
    public void changeCluster(ClusterEvent e) {
        if (this.clusterEvents != null) {
            this.clusterEvents.add(e);
        }
        System.out.println(e.getType() + ": " + e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportCSV(String filepath) {
        PrintWriter out = null;
        try {
            if (!filepath.endsWith(".csv")) {
                filepath = filepath + ".csv";
            }
            out = new PrintWriter(new BufferedWriter(new FileWriter(filepath)));
            String del = ";";
            Iterator<ClusterEvent> eventIt = null;
            ClusterEvent event = null;
            if (this.clusterEvents != null && this.clusterEvents.size() > 0) {
                eventIt = this.clusterEvents.iterator();
                event = eventIt.next();
            }
            MeasureCollection[][] measurecol = new MeasureCollection[][]{this.m_measures0, this.m_measures1};
            int numValues = 0;
            out.write("Nr" + del);
            out.write("Event" + del);
            for (int m = 0; m < 2; ++m) {
                for (int i = 0; i < measurecol[m].length; ++i) {
                    for (int j = 0; j < measurecol[m][i].getNumMeasures(); ++j) {
                        if (!measurecol[m][i].isEnabled(j)) continue;
                        out.write(m + "-" + measurecol[m][i].getName(j) + del);
                        numValues = measurecol[m][i].getNumberOfValues(j);
                    }
                }
            }
            out.write("\n");
            for (int v = 0; v < numValues; ++v) {
                out.write(v + del);
                if (event != null && event.getTimestamp() <= (long)(this.m_stream0_decayHorizon * v)) {
                    out.write(event.getType() + del);
                    event = eventIt != null && eventIt.hasNext() ? eventIt.next() : null;
                } else {
                    out.write(del);
                }
                for (int m = 0; m < 2; ++m) {
                    for (int i = 0; i < measurecol[m].length; ++i) {
                        for (int j = 0; j < measurecol[m][i].getNumMeasures(); ++j) {
                            if (!measurecol[m][i].isEnabled(j)) continue;
                            double value = measurecol[m][i].getValue(j, v);
                            if (Double.isNaN(value)) {
                                out.write(del);
                                continue;
                            }
                            out.write(value + del);
                        }
                    }
                }
                out.write("\n");
            }
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(RunVisualizer.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            out.close();
        }
    }

    public void weka() {
        try {
            Class.forName("weka.gui.Logger");
        }
        catch (Exception e) {
            this.m_logPanel.addText("Please add weka.jar to the classpath to use the Weka explorer.");
            return;
        }
        Clustering wekaClustering = this.m_clusterer0.implementsMicroClusterer() && this.m_clusterer0.evaluateMicroClusteringOption.isSet() ? this.micro0 : this.macro0;
        if (wekaClustering == null || wekaClustering.size() == 0) {
            this.m_logPanel.addText("Empty Clustering");
            return;
        }
        int dims = wekaClustering.get(0).getCenter().length;
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        for (int i = 0; i < dims; ++i) {
            attributes.addElement(new Attribute("att" + i));
        }
        Instances instances = new Instances("trainset", attributes, 0);
        for (int c = 0; c < wekaClustering.size(); ++c) {
            Cluster cluster = wekaClustering.get(c);
            DenseInstance inst = new DenseInstance(cluster.getWeight(), cluster.getCenter());
            inst.setDataset(instances);
            instances.add(inst);
        }
        WekaExplorer explorer = new WekaExplorer(instances);
    }
}

