/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.github.javacliparser.IntOption;
import moa.evaluation.BasicClassificationPerformanceEvaluator;

public class WindowClassificationPerformanceEvaluator
extends BasicClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    public IntOption widthOption = new IntOption("width", 'w', "Size of Window", 1000);

    @Override
    protected BasicClassificationPerformanceEvaluator.Estimator newEstimator() {
        return new WindowEstimator(this.widthOption.getValue());
    }

    public class WindowEstimator
    implements BasicClassificationPerformanceEvaluator.Estimator {
        protected double[] window;
        protected int posWindow;
        protected int lenWindow;
        protected int SizeWindow;
        protected double sum;

        public WindowEstimator(int sizeWindow) {
            this.window = new double[sizeWindow];
            this.SizeWindow = sizeWindow;
            this.posWindow = 0;
            this.lenWindow = 0;
        }

        @Override
        public void add(double value) {
            this.sum -= this.window[this.posWindow];
            this.sum += value;
            this.window[this.posWindow] = value;
            ++this.posWindow;
            if (this.posWindow == this.SizeWindow) {
                this.posWindow = 0;
            }
            if (this.lenWindow < this.SizeWindow) {
                ++this.lenWindow;
            }
        }

        @Override
        public double estimation() {
            return this.sum / (double)this.lenWindow;
        }
    }
}

