/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.AbstractMOAObject;
import moa.core.Example;
import moa.core.Measurement;
import moa.evaluation.MultiTargetPerformanceEvaluator;

public class BasicMultiLabelPerformanceEvaluator
extends AbstractMOAObject
implements MultiTargetPerformanceEvaluator {
    protected int L;
    double sumAccuracy = 0.0;
    double sumHamming = 0.0;
    int sumExamples = 0;
    private double t = 0.5;

    @Override
    public void reset() {
        this.sumAccuracy = 0.0;
        this.sumHamming = 0.0;
        this.sumExamples = 0;
    }

    @Override
    public void addResult(Example<Instance> example, Prediction y) {
        MultiLabelInstance x = (MultiLabelInstance)example.getData();
        if (this.L == 0) {
            this.L = x.numberOutputTargets();
        }
        if (y == null) {
            System.err.print("[WARNING] Prediction is null! (Ignoring this prediction)");
        } else if (y.numOutputAttributes() < x.numOutputAttributes()) {
            System.err.println("[WARNING] Only " + y.numOutputAttributes() + " labels found! (Expecting " + x.numOutputAttributes() + ")\n (Ignoring this prediction)");
        } else {
            ++this.sumExamples;
            int correct = 0;
            for (int j = 0; j < y.numOutputAttributes(); ++j) {
                int yp = y.getVote(j, 1) > this.t ? 1 : 0;
                correct += (int)x.classValue(j) == yp ? 1 : 0;
            }
            this.sumHamming += (double)correct / (double)this.L;
            this.sumAccuracy += correct == this.L ? 1.0 : 0.0;
        }
    }

    @Override
    public Measurement[] getPerformanceMeasurements() {
        Measurement[] m = new Measurement[]{new Measurement("Exact Match", this.sumAccuracy / (double)this.sumExamples), new Measurement("Hamming Score", this.sumHamming / (double)this.sumExamples)};
        return m;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        sb.append("Basic Multi-label Performance Evaluator");
    }

    @Override
    public void addResult(Example<Instance> example, double[] classVotes) {
    }
}

