/*
 * Decompiled with CFR 0.152.
 */
package moa.core;

public class Statistics {
    protected static final double MACHEP = (double)1.110223E-16f;
    protected static final double MAXLOG = 709.782712893384;
    protected static final double MINLOG = -745.1332191019412;
    protected static final double MAXGAM = 171.6243769563027;
    protected static final double SQTPI = 2.5066282746310007;
    protected static final double SQRTH = 0.7071067811865476;
    protected static final double LOGPI = 1.1447298858494002;
    protected static final double big = 4.503599627370496E15;
    protected static final double biginv = 2.220446049250313E-16;
    protected static final double[] P0 = new double[]{-59.96335010141079, 98.00107541859997, -56.67628574690703, 13.931260938727968, -1.2391658386738125};
    protected static final double[] Q0 = new double[]{1.9544885833814176, 4.676279128988815, 86.36024213908905, -225.46268785411937, 200.26021238006066, -82.03722561683334, 15.90562251262117, -1.1833162112133};
    protected static final double[] P1 = new double[]{4.0554489230596245, 31.525109459989388, 57.16281922464213, 44.08050738932008, 14.684956192885803, 2.1866330685079025, -0.1402560791713545, -0.03504246268278482, -8.574567851546854E-4};
    protected static final double[] Q1 = new double[]{15.779988325646675, 45.39076351288792, 41.3172038254672, 15.04253856929075, 2.504649462083094, -0.14218292285478779, -0.03808064076915783, -9.332594808954574E-4};
    protected static final double[] P2 = new double[]{3.2377489177694603, 6.915228890689842, 3.9388102529247444, 1.3330346081580755, 0.20148538954917908, 0.012371663481782003, 3.0158155350823543E-4, 2.6580697468673755E-6, 6.239745391849833E-9};
    protected static final double[] Q2 = new double[]{6.02427039364742, 3.6798356385616087, 1.3770209948908132, 0.21623699359449663, 0.013420400608854318, 3.2801446468212774E-4, 2.8924786474538068E-6, 6.790194080099813E-9};

    public static double binomialStandardError(double p, int n) {
        if (n == 0) {
            return 0.0;
        }
        return Math.sqrt(p * (1.0 - p) / (double)n);
    }

    public static double chiSquaredProbability(double x, double v) {
        if (x < 0.0 || v < 1.0) {
            return 0.0;
        }
        return Statistics.incompleteGammaComplement(v / 2.0, x / 2.0);
    }

    public static double FProbability(double F, int df1, int df2) {
        return Statistics.incompleteBeta((double)df2 / 2.0, (double)df1 / 2.0, (double)df2 / ((double)df2 + (double)df1 * F));
    }

    public static double normalProbability(double a) {
        double y;
        double x = a * 0.7071067811865476;
        double z = Math.abs(x);
        if (z < 0.7071067811865476) {
            y = 0.5 + 0.5 * Statistics.errorFunction(x);
        } else {
            y = 0.5 * Statistics.errorFunctionComplemented(z);
            if (x > 0.0) {
                y = 1.0 - y;
            }
        }
        return y;
    }

    public static double normalInverse(double y0) {
        double s2pi = Math.sqrt(Math.PI * 2);
        if (y0 <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (y0 >= 1.0) {
            throw new IllegalArgumentException();
        }
        boolean code = true;
        double y = y0;
        if (y > 0.8646647167633873) {
            y = 1.0 - y;
            code = false;
        }
        if (y > 0.1353352832366127) {
            double y2 = (y -= 0.5) * y;
            double x = y + y * (y2 * Statistics.polevl(y2, P0, 4) / Statistics.p1evl(y2, Q0, 8));
            return x *= s2pi;
        }
        double x = Math.sqrt(-2.0 * Math.log(y));
        double x0 = x - Math.log(x) / x;
        double z = 1.0 / x;
        double x1 = x < 8.0 ? z * Statistics.polevl(z, P1, 8) / Statistics.p1evl(z, Q1, 8) : z * Statistics.polevl(z, P2, 8) / Statistics.p1evl(z, Q2, 8);
        x = x0 - x1;
        if (code) {
            x = -x;
        }
        return x;
    }

    public static double lnGamma(double x) {
        double[] A2 = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
        double[] B = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
        double[] C = new double[]{-351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};
        if (x < -34.0) {
            double q = -x;
            double w = Statistics.lnGamma(q);
            double p = Math.floor(q);
            if (p == q) {
                throw new ArithmeticException("lnGamma: Overflow");
            }
            double z = q - p;
            if (z > 0.5) {
                z = (p += 1.0) - q;
            }
            if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                throw new ArithmeticException("lnGamma: Overflow");
            }
            z = 1.1447298858494002 - Math.log(z) - w;
            return z;
        }
        if (x < 13.0) {
            double z = 1.0;
            while (x >= 3.0) {
                z *= (x -= 1.0);
            }
            while (x < 2.0) {
                if (x == 0.0) {
                    throw new ArithmeticException("lnGamma: Overflow");
                }
                z /= x;
                x += 1.0;
            }
            if (z < 0.0) {
                z = -z;
            }
            if (x == 2.0) {
                return Math.log(z);
            }
            double p = (x -= 2.0) * Statistics.polevl(x, B, 5) / Statistics.p1evl(x, C, 6);
            return Math.log(z) + p;
        }
        if (x > 2.556348E305) {
            throw new ArithmeticException("lnGamma: Overflow");
        }
        double q = (x - 0.5) * Math.log(x) - x + 0.9189385332046728;
        if (x > 1.0E8) {
            return q;
        }
        double p = 1.0 / (x * x);
        q = x >= 1000.0 ? (q += ((7.936507936507937E-4 * p - 0.002777777777777778) * p + 0.08333333333333333) / x) : (q += Statistics.polevl(p, A2, 4) / x);
        return q;
    }

    public static double errorFunction(double x) {
        double[] T = new double[]{9.604973739870516, 90.02601972038427, 2232.005345946843, 7003.325141128051, 55592.30130103949};
        double[] U = new double[]{33.56171416475031, 521.3579497801527, 4594.323829709801, 22629.000061389095, 49267.39426086359};
        if (Math.abs(x) > 1.0) {
            return 1.0 - Statistics.errorFunctionComplemented(x);
        }
        double z = x * x;
        double y = x * Statistics.polevl(z, T, 4) / Statistics.p1evl(z, U, 5);
        return y;
    }

    public static double errorFunctionComplemented(double a) {
        double q;
        double p;
        double[] P = new double[]{2.461969814735305E-10, 0.5641895648310689, 7.463210564422699, 48.63719709856814, 196.5208329560771, 526.4451949954773, 934.5285271719576, 1027.5518868951572, 557.5353353693994};
        double[] Q = new double[]{13.228195115474499, 86.70721408859897, 354.9377788878199, 975.7085017432055, 1823.9091668790973, 2246.3376081871097, 1656.6630919416134, 557.5353408177277};
        double[] R = new double[]{0.5641895835477551, 1.275366707599781, 5.019050422511805, 6.160210979930536, 7.4097426995044895, 2.9788666537210022};
        double[] S = new double[]{2.2605286322011726, 9.396035249380015, 12.048953980809666, 17.08144507475659, 9.608968090632859, 3.369076451000815};
        double x = a < 0.0 ? -a : a;
        if (x < 1.0) {
            return 1.0 - Statistics.errorFunction(a);
        }
        double z = -a * a;
        if (z < -709.782712893384) {
            if (a < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        z = Math.exp(z);
        if (x < 8.0) {
            p = Statistics.polevl(x, P, 8);
            q = Statistics.p1evl(x, Q, 8);
        } else {
            p = Statistics.polevl(x, R, 5);
            q = Statistics.p1evl(x, S, 6);
        }
        double y = z * p / q;
        if (a < 0.0) {
            y = 2.0 - y;
        }
        if (y == 0.0) {
            if (a < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        return y;
    }

    public static double p1evl(double x, double[] coef, int N) {
        double ans = x + coef[0];
        for (int i = 1; i < N; ++i) {
            ans = ans * x + coef[i];
        }
        return ans;
    }

    public static double polevl(double x, double[] coef, int N) {
        double ans = coef[0];
        for (int i = 1; i <= N; ++i) {
            ans = ans * x + coef[i];
        }
        return ans;
    }

    public static double incompleteGamma(double a, double x) {
        if (x <= 0.0 || a <= 0.0) {
            return 0.0;
        }
        if (x > 1.0 && x > a) {
            return 1.0 - Statistics.incompleteGammaComplement(a, x);
        }
        double ax = a * Math.log(x) - x - Statistics.lnGamma(a);
        if (ax < -709.782712893384) {
            return 0.0;
        }
        ax = Math.exp(ax);
        double r = a;
        double c = 1.0;
        double ans = 1.0;
        while ((c *= x / (r += 1.0)) / (ans += c) > (double)1.110223E-16f) {
        }
        return ans * ax / a;
    }

    public static double incompleteGammaComplement(double a, double x) {
        double t;
        if (x <= 0.0 || a <= 0.0) {
            return 1.0;
        }
        if (x < 1.0 || x < a) {
            return 1.0 - Statistics.incompleteGamma(a, x);
        }
        double ax = a * Math.log(x) - x - Statistics.lnGamma(a);
        if (ax < -709.782712893384) {
            return 0.0;
        }
        ax = Math.exp(ax);
        double y = 1.0 - a;
        double z = x + y + 1.0;
        double c = 0.0;
        double pkm2 = 1.0;
        double qkm2 = x;
        double pkm1 = x + 1.0;
        double qkm1 = z * x;
        double ans = pkm1 / qkm1;
        do {
            double yc = (y += 1.0) * (c += 1.0);
            double pk = pkm1 * (z += 2.0) - pkm2 * yc;
            double qk = qkm1 * z - qkm2 * yc;
            if (qk != 0.0) {
                double r = pk / qk;
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (!(Math.abs(pk) > 4.503599627370496E15)) continue;
            pkm2 *= 2.220446049250313E-16;
            pkm1 *= 2.220446049250313E-16;
            qkm2 *= 2.220446049250313E-16;
            qkm1 *= 2.220446049250313E-16;
        } while (t > (double)1.110223E-16f);
        return ans * ax;
    }

    public static double gamma(double x) {
        double[] P = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] Q = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double q = Math.abs(x);
        if (q > 33.0) {
            if (x < 0.0) {
                double p = Math.floor(q);
                if (p == q) {
                    throw new ArithmeticException("gamma: overflow");
                }
                int i = (int)p;
                double z = q - p;
                if (z > 0.5) {
                    z = q - (p += 1.0);
                }
                if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                    throw new ArithmeticException("gamma: overflow");
                }
                z = Math.abs(z);
                z = Math.PI / (z * Statistics.stirlingFormula(q));
                return -z;
            }
            return Statistics.stirlingFormula(x);
        }
        double z = 1.0;
        while (x >= 3.0) {
            z *= (x -= 1.0);
        }
        while (x < 0.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x > -1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        while (x < 2.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x < 1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        if (x == 2.0 || x == 3.0) {
            return z;
        }
        double p = Statistics.polevl(x -= 2.0, P, 6);
        q = Statistics.polevl(x, Q, 7);
        return z * p / q;
    }

    public static double stirlingFormula(double x) {
        double[] STIR = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double MAXSTIR = 143.01608;
        double w = 1.0 / x;
        double y = Math.exp(x);
        w = 1.0 + w * Statistics.polevl(w, STIR, 4);
        if (x > MAXSTIR) {
            double v = Math.pow(x, 0.5 * x - 0.25);
            y = v * (v / y);
        } else {
            y = Math.pow(x, x - 0.5) / y;
        }
        y = 2.5066282746310007 * y * w;
        return y;
    }

    public static double incompleteBeta(double aa, double bb, double xx) {
        double x;
        double xc;
        double b;
        double a;
        if (aa <= 0.0 || bb <= 0.0) {
            throw new ArithmeticException("ibeta: Domain error!");
        }
        if (xx <= 0.0 || xx >= 1.0) {
            if (xx == 0.0) {
                return 0.0;
            }
            if (xx == 1.0) {
                return 1.0;
            }
            throw new ArithmeticException("ibeta: Domain error!");
        }
        boolean flag = false;
        if (bb * xx <= 1.0 && xx <= 0.95) {
            double t = Statistics.powerSeries(aa, bb, xx);
            return t;
        }
        double w = 1.0 - xx;
        if (xx > aa / (aa + bb)) {
            flag = true;
            a = bb;
            b = aa;
            xc = xx;
            x = w;
        } else {
            a = aa;
            b = bb;
            xc = w;
            x = xx;
        }
        if (flag && b * x <= 1.0 && x <= 0.95) {
            double t = Statistics.powerSeries(a, b, x);
            t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
            return t;
        }
        double y = x * (a + b - 2.0) - (a - 1.0);
        w = y < 0.0 ? Statistics.incompleteBetaFraction1(a, b, x) : Statistics.incompleteBetaFraction2(a, b, x) / xc;
        y = a * Math.log(x);
        double t = b * Math.log(xc);
        if (a + b < 171.6243769563027 && Math.abs(y) < 709.782712893384 && Math.abs(t) < 709.782712893384) {
            t = Math.pow(xc, b);
            t *= Math.pow(x, a);
            t /= a;
            t *= w;
            t *= Statistics.gamma(a + b) / (Statistics.gamma(a) * Statistics.gamma(b));
            if (flag) {
                t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
            }
            return t;
        }
        y += t + Statistics.lnGamma(a + b) - Statistics.lnGamma(a) - Statistics.lnGamma(b);
        t = (y += Math.log(w / a)) < -745.1332191019412 ? 0.0 : Math.exp(y);
        if (flag) {
            t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
        }
        return t;
    }

    public static double incompleteBetaFraction1(double a, double b, double x) {
        double k1 = a;
        double k2 = a + b;
        double k3 = a;
        double k4 = a + 1.0;
        double k5 = 1.0;
        double k6 = b - 1.0;
        double k7 = k4;
        double k8 = a + 2.0;
        double pkm2 = 0.0;
        double qkm2 = 1.0;
        double pkm1 = 1.0;
        double qkm1 = 1.0;
        double ans = 1.0;
        double r = 1.0;
        int n = 0;
        double thresh = 3.330669E-16f;
        do {
            double t;
            double xk = -(x * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = x * k5 * k6 / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (qk != 0.0) {
                r = pk / qk;
            }
            if (r != 0.0) {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            if (t < thresh) {
                return ans;
            }
            k1 += 1.0;
            k2 += 1.0;
            k3 += 2.0;
            k4 += 2.0;
            k5 += 1.0;
            k6 -= 1.0;
            k7 += 2.0;
            k8 += 2.0;
            if (Math.abs(qk) + Math.abs(pk) > 4.503599627370496E15) {
                pkm2 *= 2.220446049250313E-16;
                pkm1 *= 2.220446049250313E-16;
                qkm2 *= 2.220446049250313E-16;
                qkm1 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(qk) < 2.220446049250313E-16) && !(Math.abs(pk) < 2.220446049250313E-16)) continue;
            pkm2 *= 4.503599627370496E15;
            pkm1 *= 4.503599627370496E15;
            qkm2 *= 4.503599627370496E15;
            qkm1 *= 4.503599627370496E15;
        } while (++n < 300);
        return ans;
    }

    public static double incompleteBetaFraction2(double a, double b, double x) {
        double k1 = a;
        double k2 = b - 1.0;
        double k3 = a;
        double k4 = a + 1.0;
        double k5 = 1.0;
        double k6 = a + b;
        double k7 = a + 1.0;
        double k8 = a + 2.0;
        double pkm2 = 0.0;
        double qkm2 = 1.0;
        double pkm1 = 1.0;
        double qkm1 = 1.0;
        double z = x / (1.0 - x);
        double ans = 1.0;
        double r = 1.0;
        int n = 0;
        double thresh = 3.330669E-16f;
        do {
            double t;
            double xk = -(z * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = z * k5 * k6 / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (qk != 0.0) {
                r = pk / qk;
            }
            if (r != 0.0) {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            if (t < thresh) {
                return ans;
            }
            k1 += 1.0;
            k2 -= 1.0;
            k3 += 2.0;
            k4 += 2.0;
            k5 += 1.0;
            k6 += 1.0;
            k7 += 2.0;
            k8 += 2.0;
            if (Math.abs(qk) + Math.abs(pk) > 4.503599627370496E15) {
                pkm2 *= 2.220446049250313E-16;
                pkm1 *= 2.220446049250313E-16;
                qkm2 *= 2.220446049250313E-16;
                qkm1 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(qk) < 2.220446049250313E-16) && !(Math.abs(pk) < 2.220446049250313E-16)) continue;
            pkm2 *= 4.503599627370496E15;
            pkm1 *= 4.503599627370496E15;
            qkm2 *= 4.503599627370496E15;
            qkm1 *= 4.503599627370496E15;
        } while (++n < 300);
        return ans;
    }

    public static double powerSeries(double a, double b, double x) {
        double v;
        double ai = 1.0 / a;
        double u = (1.0 - b) * x;
        double t1 = v = u / (a + 1.0);
        double t = u;
        double n = 2.0;
        double s = 0.0;
        double z = (double)1.110223E-16f * ai;
        while (Math.abs(v) > z) {
            u = (n - b) * x / n;
            v = (t *= u) / (a + n);
            s += v;
            n += 1.0;
        }
        s += t1;
        s += ai;
        u = a * Math.log(x);
        if (a + b < 171.6243769563027 && Math.abs(u) < 709.782712893384) {
            t = Statistics.gamma(a + b) / (Statistics.gamma(a) * Statistics.gamma(b));
            s = s * t * Math.pow(x, a);
        } else {
            t = Statistics.lnGamma(a + b) - Statistics.lnGamma(a) - Statistics.lnGamma(b) + u + Math.log(s);
            s = t < -745.1332191019412 ? 0.0 : Math.exp(t);
        }
        return s;
    }
}

