/*
 * Decompiled with CFR 0.152.
 */
package moa.core;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class AutoClassDiscovery {
    protected static final Map<String, String[]> cachedClassNames = new HashMap<String, String[]>();

    public static String[] findClassNames(String packageNameToSearch) {
        Object[] cached = cachedClassNames.get(packageNameToSearch);
        if (cached == null) {
            HashSet<String> classNames = new HashSet<String>();
            String packageDirName = packageNameToSearch.replace('.', File.separatorChar);
            String packageJarName = packageNameToSearch.length() > 0 ? packageNameToSearch.replace('.', '/') + "/" : "";
            String part = "";
            AutoClassDiscovery adc = new AutoClassDiscovery();
            URLClassLoader sysLoader = (URLClassLoader)adc.getClass().getClassLoader();
            URL[] cl_urls = sysLoader.getURLs();
            for (int i = 0; i < cl_urls.length; ++i) {
                part = cl_urls[i].toString();
                if (part.startsWith("file:")) {
                    part = part.replace(" ", "%20");
                    try {
                        File temp = new File(new URI(part));
                        part = temp.getAbsolutePath();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
                ArrayList files = new ArrayList();
                File dir = new File(part);
                if (dir.isDirectory()) {
                    File root = new File(dir.toString() + File.separatorChar + packageDirName);
                    String[] names = AutoClassDiscovery.findClassesInDirectoryRecursive(root, "");
                    classNames.addAll(Arrays.asList(names));
                    continue;
                }
                try {
                    JarFile jar = new JarFile(part);
                    Enumeration<JarEntry> jarEntries = jar.entries();
                    while (jarEntries.hasMoreElements()) {
                        String relativeName;
                        String jarEntry = jarEntries.nextElement().getName();
                        if (!jarEntry.startsWith(packageJarName) || !(relativeName = jarEntry.substring(packageJarName.length())).endsWith(".class")) continue;
                        relativeName = relativeName.replace('/', '.');
                        classNames.add(relativeName.substring(0, relativeName.length() - ".class".length()));
                    }
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            cached = classNames.toArray(new String[classNames.size()]);
            Arrays.sort(cached);
            cachedClassNames.put(packageNameToSearch, (String[])cached);
        }
        return cached;
    }

    protected static String[] findClassesInDirectoryRecursive(File root, String packagePath) {
        HashSet<String> classNames = new HashSet<String>();
        if (root.isDirectory()) {
            String[] list;
            for (String string : list = root.list()) {
                if (string.endsWith(".class")) {
                    classNames.add(packagePath + string.substring(0, string.length() - ".class".length()));
                    continue;
                }
                File testDir = new File(root.getPath() + File.separatorChar + string);
                if (!testDir.isDirectory()) continue;
                String[] names = AutoClassDiscovery.findClassesInDirectoryRecursive(testDir, packagePath + string + ".");
                classNames.addAll(Arrays.asList(names));
            }
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    public static Class[] findClassesOfType(String packageNameToSearch, Class<?> typeDesired) {
        String[] classNames;
        ArrayList classesFound = new ArrayList();
        for (String className : classNames = AutoClassDiscovery.findClassNames(packageNameToSearch)) {
            String fullName;
            String string = fullName = packageNameToSearch.length() > 0 ? packageNameToSearch + "." + className : className;
            if (!AutoClassDiscovery.isPublicConcreteClassOfType(fullName, typeDesired)) continue;
            try {
                classesFound.add(Class.forName(fullName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return classesFound.toArray(new Class[classesFound.size()]);
    }

    public static boolean isPublicConcreteClassOfType(String className, Class<?> typeDesired) {
        Class<?> testClass = null;
        try {
            testClass = Class.forName(className);
        }
        catch (Exception e) {
            return false;
        }
        int classModifiers = testClass.getModifiers();
        return Modifier.isPublic(classModifiers) && !Modifier.isAbstract(classModifiers) && typeDesired.isAssignableFrom(testClass) && AutoClassDiscovery.hasEmptyConstructor(testClass);
    }

    public static boolean hasEmptyConstructor(Class<?> type) {
        try {
            type.getConstructor(new Class[0]);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

