/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.MCOD;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.Vector;
import moa.clusterers.outliers.MCOD.ISBIndex;
import moa.clusterers.outliers.MCOD.MCODBase;
import moa.clusterers.outliers.MCOD.MTreeMicroClusters;
import moa.clusterers.outliers.MCOD.MicroCluster;
import moa.clusterers.outliers.MCOD.StreamObj;

public class MCOD
extends MCODBase {
    public FloatOption radiusOption = new FloatOption("radius", 'r', "Search radius.", 0.1);
    public IntOption kOption = new IntOption("k", 't', "Parameter k.", 50);

    @Override
    public void Init() {
        super.Init();
        this.m_WindowSize = this.windowSizeOption.getValue();
        this.m_radius = this.radiusOption.getValue();
        this.m_k = this.kOption.getValue();
        this.Println("Init MCOD:");
        this.Println("   window_size: " + this.m_WindowSize);
        this.Println("   radius: " + this.m_radius);
        this.Println("   k: " + this.m_k);
        this.objId = FIRST_OBJ_ID;
        this.windowNodes = new Vector();
        this.ISB_PD = new ISBIndex(this.m_radius, this.m_k);
        this.setMC = new TreeSet();
        this.mtreeMC = new MTreeMicroClusters();
        this.eventQueue = new MCODBase.EventQueue();
        this.m_nBothInlierOutlier = 0;
        this.m_nOnlyInlier = 0;
        this.m_nOnlyOutlier = 0;
    }

    void SetNodeType(ISBIndex.ISBNode node, ISBIndex.ISBNode.NodeType type) {
        node.nodeType = type;
        if (type == ISBIndex.ISBNode.NodeType.OUTLIER) {
            ++node.nOutlier;
        } else {
            ++node.nInlier;
        }
    }

    void AddNeighbor(ISBIndex.ISBNode node, ISBIndex.ISBNode q, boolean bUpdateState) {
        if (this.bTrace) {
            this.Println("AddNeighbor: node.id: " + node.id + ", q.id: " + q.id);
        }
        if (!this.IsNodeIdInWin(q.id)) {
            if (this.bWarning) {
                this.Println("AddNeighbor: node.id: " + node.id + ", q.id: " + q.id + " (expired)");
            }
            return;
        }
        if (q.id < node.id) {
            node.AddPrecNeigh(q);
        } else {
            ++node.count_after;
        }
        if (bUpdateState) {
            int count = node.count_after + node.CountPrecNeighs(this.GetWindowStart());
            if (node.nodeType == ISBIndex.ISBNode.NodeType.OUTLIER && count >= this.m_k) {
                if (this.bTrace) {
                    this.Println("Remove node from outliers");
                }
                this.RemoveOutlier(node);
                this.SetNodeType(node, ISBIndex.ISBNode.NodeType.INLIER_PD);
                ISBIndex.ISBNode nodeMinExp = node.GetMinPrecNeigh(this.GetWindowStart());
                this.AddToEventQueue(node, nodeMinExp);
            }
        }
    }

    void ProcessNewNode(ISBIndex.ISBNode nodeNew, boolean bNewNode) {
        if (this.bTrace) {
            this.Print("ProcessNewNode: ");
            this.PrintNode(nodeNew);
        }
        if (this.bTrace) {
            this.Println("Perform 3R/2 range query to cluster centers w.r.t new node");
        }
        Vector<MCODBase.SearchResultMC> resultsMC = this.RangeSearchMC(nodeNew, 1.5 * this.m_radius);
        if (this.bTrace) {
            this.Println("MC query found: ");
            for (MCODBase.SearchResultMC sr : resultsMC) {
                this.Printf("  (%.1f) mcc: ", sr.distance);
                this.PrintNode(sr.mc.mcc);
            }
        }
        if (this.bTrace) {
            this.Println("Get closest micro-cluster");
        }
        MicroCluster mcClosest = null;
        if (resultsMC.size() > 0) {
            mcClosest = resultsMC.get((int)0).mc;
            if (this.bTrace) {
                this.Println("Closest mcc: " + mcClosest.mcc.id);
            }
        }
        boolean bFoundMC = false;
        if (mcClosest != null) {
            double d = this.GetEuclideanDist(nodeNew, mcClosest.mcc);
            if (d <= this.m_radius / 2.0) {
                bFoundMC = true;
            } else if (this.bTrace) {
                this.Println("Not close enough to closest mcc");
            }
        }
        if (bFoundMC) {
            if (this.bTrace) {
                this.Println("Add new node to micro-cluster");
            }
            nodeNew.mc = mcClosest;
            this.SetNodeType(nodeNew, ISBIndex.ISBNode.NodeType.INLIER_MC);
            mcClosest.AddNode(nodeNew);
            if (this.bTrace) {
                this.Print("mcClosest.nodes: ");
                this.PrintNodeList(mcClosest.nodes);
            }
            if (this.bTrace) {
                this.Println("Update neighbors of set PD");
            }
            Vector<ISBIndex.ISBNode> nodes = this.ISB_PD.GetAllNodes();
            for (ISBIndex.ISBNode q : nodes) {
                if (!q.Rmc.contains(mcClosest) || !(this.GetEuclideanDist(q, nodeNew) <= this.m_radius)) continue;
                if (bNewNode) {
                    this.AddNeighbor(q, nodeNew, true);
                    continue;
                }
                if (!this.nodesReinsert.contains(q)) continue;
                this.AddNeighbor(q, nodeNew, true);
            }
        } else {
            if (this.bTrace) {
                this.Println("Perform 3R/2 range query to nodes in set PD");
            }
            ++this.nRangeQueriesExecuted;
            ArrayList<ISBIndex.ISBNode> setNC = new ArrayList<ISBIndex.ISBNode>();
            ArrayList<ISBIndex.ISBNode> setNNC = new ArrayList<ISBIndex.ISBNode>();
            Vector<ISBIndex.ISBSearchResult> resultNodes = this.ISB_PD.RangeSearch(nodeNew, 1.5 * this.m_radius);
            for (ISBIndex.ISBSearchResult iSBSearchResult : resultNodes) {
                ISBIndex.ISBNode q = iSBSearchResult.node;
                if (iSBSearchResult.distance <= this.m_radius) {
                    this.AddNeighbor(nodeNew, q, false);
                    if (bNewNode) {
                        this.AddNeighbor(q, nodeNew, true);
                    } else if (this.nodesReinsert.contains(q)) {
                        this.AddNeighbor(q, nodeNew, true);
                    }
                }
                if (iSBSearchResult.distance <= this.m_radius / 2.0) {
                    setNC.add(q);
                    continue;
                }
                setNNC.add(q);
            }
            if (this.bTrace) {
                this.Print("Prec neighs of new node: ");
                this.PrintNodeList(nodeNew.Get_nn_before());
                this.Print("NC: ");
                this.PrintNodeList(setNC);
                this.Print("NNC: ");
                this.PrintNodeList(setNNC);
            }
            if (this.bTrace) {
                this.Println("Check size of set NC");
            }
            if ((double)setNC.size() >= this.m_theta * (double)this.m_k) {
                if (this.bTrace) {
                    this.Println("Create new micro-cluster");
                }
                MicroCluster mcNew = new MicroCluster(nodeNew);
                this.AddMicroCluster(mcNew);
                nodeNew.mc = mcNew;
                this.SetNodeType(nodeNew, ISBIndex.ISBNode.NodeType.INLIER_MC);
                if (this.bTrace) {
                    this.Println("Add to new mc nodes within range R/2");
                }
                for (ISBIndex.ISBNode q : setNC) {
                    q.mc = mcNew;
                    mcNew.AddNode(q);
                    this.SetNodeType(q, ISBIndex.ISBNode.NodeType.INLIER_MC);
                    this.ISB_PD.Remove(q);
                    this.RemoveOutlier(q);
                }
                if (this.bTrace) {
                    this.Print("mcNew.nodes: ");
                    this.PrintNodeList(mcNew.nodes);
                    this.PrintPD();
                }
                if (this.bTrace) {
                    this.Println("Update Rmc lists of nodes of PD in range 3R/2 from mcNew");
                }
                for (ISBIndex.ISBNode q : setNNC) {
                    q.Rmc.add(mcNew);
                    if (!this.bTrace) continue;
                    this.Print(q.id + ".Rmc: ");
                    this.PrintMCSet(q.Rmc);
                }
            } else {
                int count;
                if (this.bTrace) {
                    this.Println("Add to nodeNew neighs nodes of near micro-clusters");
                }
                for (MCODBase.SearchResultMC searchResultMC : resultsMC) {
                    for (ISBIndex.ISBNode q : searchResultMC.mc.nodes) {
                        if (!(this.GetEuclideanDist(q, nodeNew) <= this.m_radius)) continue;
                        this.AddNeighbor(nodeNew, q, false);
                    }
                }
                if (this.bTrace) {
                    this.Println("nodeNew.count_after = " + nodeNew.count_after);
                    this.Print("nodeNew.nn_before: ");
                    this.PrintNodeList(nodeNew.Get_nn_before());
                }
                if (this.bTrace) {
                    this.Println("Insert nodeNew to index of nodes of PD");
                }
                this.ISB_PD.Insert(nodeNew);
                if (this.bTrace) {
                    this.PrintPD();
                }
                if ((count = nodeNew.CountPrecNeighs(this.GetWindowStart()) + nodeNew.count_after) >= this.m_k) {
                    if (this.bTrace) {
                        this.Println("nodeNew is an inlier");
                    }
                    this.SetNodeType(nodeNew, ISBIndex.ISBNode.NodeType.INLIER_PD);
                    ISBIndex.ISBNode iSBNode = nodeNew.GetMinPrecNeigh(this.GetWindowStart());
                    this.AddToEventQueue(nodeNew, iSBNode);
                } else {
                    if (this.bTrace) {
                        this.Println("nodeNew is an outlier");
                    }
                    this.SetNodeType(nodeNew, ISBIndex.ISBNode.NodeType.OUTLIER);
                    this.SaveOutlier(nodeNew);
                }
                if (this.bTrace) {
                    this.Println("Update nodeNew.Rmc");
                }
                for (MCODBase.SearchResultMC sr : resultsMC) {
                    nodeNew.Rmc.add(sr.mc);
                }
                if (this.bTrace) {
                    this.Print("nodeNew.Rmc: ");
                    this.PrintMCSet(nodeNew.Rmc);
                }
            }
        }
    }

    void AddToEventQueue(ISBIndex.ISBNode x, ISBIndex.ISBNode nodeMinExp) {
        if (this.bTrace) {
            this.Println("AddToEventQueue x.id: " + x.id);
        }
        if (nodeMinExp != null) {
            Long expTime = this.GetExpirationTime(nodeMinExp);
            this.eventQueue.Insert(x, expTime);
            if (this.bTrace) {
                this.Print("x.nn_before: ");
                this.PrintNodeList(x.Get_nn_before());
                this.Println("nodeMinExp: " + nodeMinExp.id + ", expTime = " + expTime);
                this.PrintEventQueue();
            }
        } else if (this.bWarning) {
            this.Println("AddToEventQueue: Cannot add x.id: " + x.id + " to event queue (nn_before is empty, count_after=" + x.count_after + ")");
        }
    }

    void ProcessEventQueue(ISBIndex.ISBNode nodeExpired) {
        MCODBase.EventItem e = this.eventQueue.FindMin();
        while (e != null && e.timeStamp <= this.GetWindowEnd()) {
            boolean bValid;
            e = this.eventQueue.ExtractMin();
            ISBIndex.ISBNode x = e.node;
            if (this.bTrace) {
                this.Println("Process event queue: check node x: " + x.id);
            }
            boolean bl = bValid = this.IsNodeIdInWin(x.id) && x.mc == null;
            if (bValid) {
                x.RemovePrecNeigh(nodeExpired);
                int count = x.count_after + x.CountPrecNeighs(this.GetWindowStart());
                if (count < this.m_k) {
                    if (this.bTrace) {
                        this.Println("x is an outlier");
                    }
                    this.SetNodeType(x, ISBIndex.ISBNode.NodeType.OUTLIER);
                    this.SaveOutlier(x);
                } else {
                    if (this.bTrace) {
                        this.Println("x is an inlier, add to event queue");
                    }
                    ISBIndex.ISBNode nodeMinExp = x.GetMinPrecNeigh(this.GetWindowStart());
                    this.AddToEventQueue(x, nodeMinExp);
                }
            } else if (this.bWarning) {
                this.Println("Process event queue: node x.id: " + x.id + " is not valid!");
            }
            e = this.eventQueue.FindMin();
        }
    }

    void ProcessExpiredNode(ISBIndex.ISBNode nodeExpired) {
        if (nodeExpired != null) {
            MicroCluster mc;
            if (this.bTrace) {
                this.Println("\nnodeExpired: " + nodeExpired.id);
            }
            if ((mc = nodeExpired.mc) != null) {
                if (this.bTrace) {
                    this.Println("nodeExpired belongs to mc: " + mc.mcc.id);
                }
                mc.RemoveNode(nodeExpired);
                if (this.bTrace) {
                    this.Print("mc.nodes: ");
                    this.PrintNodeList(mc.nodes);
                }
                if (this.bTrace) {
                    this.Println("Check if mc has enough objects");
                }
                if (mc.GetNodesCount() < this.m_k) {
                    if (this.bTrace) {
                        this.Println("Remove mc");
                    }
                    this.RemoveMicroCluster(mc);
                    this.nodesReinsert = new TreeSet();
                    for (ISBIndex.ISBNode q : mc.nodes) {
                        this.nodesReinsert.add(q);
                    }
                    for (ISBIndex.ISBNode q : mc.nodes) {
                        if (this.bTrace) {
                            this.Println("\nTreat as new node q: " + q.id);
                        }
                        q.InitNode();
                        this.ProcessNewNode(q, false);
                    }
                }
            } else {
                this.ISB_PD.Remove(nodeExpired);
            }
            this.RemoveNode(nodeExpired);
            this.ProcessEventQueue(nodeExpired);
        }
    }

    @Override
    protected void ProcessNewStreamObj(Instance inst) {
        if (this.bShowProgress) {
            this.ShowProgress("Processed " + (this.objId - 1L) + " stream objects.");
        }
        double[] values = this.getInstanceValues(inst);
        StreamObj obj = new StreamObj(values);
        if (this.bTrace) {
            this.Println("\n- - - - - - - - - - - -\n");
        }
        ISBIndex.ISBNode nodeNew = new ISBIndex.ISBNode(inst, obj, this.objId);
        if (this.bTrace) {
            this.Print("New node: ");
            this.PrintNode(nodeNew);
        }
        Long l = this.objId;
        Long l2 = this.objId = Long.valueOf(this.objId + 1L);
        this.AddNode(nodeNew);
        if (this.bTrace) {
            this.PrintWindow();
        }
        this.ProcessNewNode(nodeNew, true);
        this.ProcessExpiredNode(this.GetExpiredNode());
        if (this.bTrace) {
            this.Print("Micro-clusters: ");
            this.PrintMCSet(this.setMC);
            this.PrintOutliers();
            this.PrintPD();
        }
    }
}

