/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.kmeanspm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import moa.clusterers.kmeanspm.Metric;

public class CoresetKMeans {
    public static List<double[]> generatekMeansPlusPlusCentroids(int k, List<double[]> input, Random random) {
        int n = input.size();
        assert (n > 0);
        int d = input.get(0).length - 1;
        assert (k <= n);
        ArrayList<double[]> centerValue = new ArrayList<double[]>(k);
        double[] lastCenter = new double[d];
        System.arraycopy(input.get(random.nextInt(n)), 1, lastCenter, 0, d);
        centerValue.add(lastCenter);
        double[] distance = new double[n];
        for (int j = 0; j < n; ++j) {
            distance[j] = Double.POSITIVE_INFINITY;
        }
        for (int i = 1; i < k; ++i) {
            double sum = 0.0;
            Iterator<double[]> jIter = input.iterator();
            for (int j = 0; j < n; ++j) {
                double[] point = jIter.next();
                distance[j] = Math.min(distance[j], point[0] * Metric.distanceSquared(lastCenter, point, 1));
                sum += distance[j];
            }
            double nextCenterValue = sum * random.nextDouble();
            int candidate = 0;
            for (double currentValue = distance[0]; !(nextCenterValue < currentValue); currentValue += distance[++candidate]) {
            }
            lastCenter = new double[d];
            System.arraycopy(input.get(candidate), 1, lastCenter, 0, d);
            centerValue.add(lastCenter);
        }
        return centerValue;
    }

    public static double kMeans(List<double[]> centroids, List<double[]> input) {
        boolean converged;
        int k = centroids.size();
        assert (k > 0);
        int d = centroids.get(0).length;
        int size = input.size();
        double[][] center = new double[k][];
        Iterator<double[]> iIter = centroids.iterator();
        for (int i = 0; i < k; ++i) {
            center[i] = iIter.next();
        }
        double[][] newCenter = new double[k][d];
        double[] newCenterWeight = new double[k];
        int[] nearestCluster = new int[size];
        do {
            for (int i = 0; i < k; ++i) {
                for (int j = 0; j < d; ++j) {
                    newCenter[i][j] = 0.0;
                }
                newCenterWeight[i] = 0.0;
            }
            Iterator<double[]> lIter = input.iterator();
            for (int l = 0; l < size; ++l) {
                double[] point = lIter.next();
                assert (d == point.length - 1);
                double minDistance = Double.POSITIVE_INFINITY;
                int closestCluster = -1;
                for (int i = 0; i < k; ++i) {
                    double distance = Metric.distance(center[i], point, 1);
                    if (!(distance < minDistance)) continue;
                    closestCluster = i;
                    minDistance = distance;
                }
                assert (closestCluster >= 0 && closestCluster < k);
                for (int j = 0; j < d; ++j) {
                    double[] dArray = newCenter[closestCluster];
                    int n = j;
                    dArray[n] = dArray[n] + point[0] * point[j + 1];
                }
                int n = closestCluster;
                newCenterWeight[n] = newCenterWeight[n] + point[0];
                nearestCluster[l] = closestCluster;
            }
            converged = true;
            for (int i = 0; i < k; ++i) {
                for (int j = 0; j < d; ++j) {
                    if (newCenterWeight[i] == 0.0) continue;
                    double newValue = newCenter[i][j] / newCenterWeight[i];
                    if (newValue != center[i][j]) {
                        converged = false;
                    }
                    center[i][j] = newValue;
                }
            }
        } while (!converged);
        for (int i = 0; i < k; ++i) {
            centroids.set(i, center[i]);
        }
        double costs = 0.0;
        Iterator<double[]> lIter = input.iterator();
        for (int l = 0; l < size; ++l) {
            double[] point = lIter.next();
            costs += point[0] * Metric.distanceSquared(center[nearestCluster[l]], point, 1);
        }
        return costs;
    }
}

