/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core.anomalydetection;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import moa.classifiers.rules.core.Utils;
import moa.classifiers.rules.core.anomalydetection.AbstractAnomalyDetector;
import moa.classifiers.rules.core.anomalydetection.probabilityfunctions.CantellisInequality;
import moa.classifiers.rules.core.anomalydetection.probabilityfunctions.ProbabilityFunction;
import moa.core.AutoExpandVector;
import moa.core.ObjectRepository;
import moa.options.ClassOption;
import moa.tasks.TaskMonitor;

public class OddsRatioScore
extends AbstractAnomalyDetector {
    private static final long serialVersionUID = 1L;
    private static final double MINSTD = 0.01;
    private static final double MINPROB = 0.01;
    private static final double MAXPROB = 0.99;
    public IntOption minNumberInstancesOption = new IntOption("minNumberInstances", 'n', "The minimum number of instances required to perform anomaly detection.", 30, 0, Integer.MAX_VALUE);
    public FloatOption thresholdOption = new FloatOption("threshold", 't', "The threshold value for detecting anomalies.", -0.75, -10.0, 0.0);
    public ClassOption probabilityFunctionOption = new ClassOption("probabilityFunction", 'p', "Probability function", ProbabilityFunction.class, CantellisInequality.class.getName());
    private int minInstances;
    private double weightSeen;
    private double threshold;
    AutoExpandVector<double[]> sufficientStatistics;
    private ProbabilityFunction probabilityFunction;

    @Override
    public boolean updateAndCheckAnomalyDetection(MultiLabelInstance instance) {
        boolean isAnomaly = false;
        if (this.probabilityFunction == null) {
            this.weightSeen = 0.0;
            this.minInstances = this.minNumberInstancesOption.getValue();
            this.threshold = this.thresholdOption.getValue();
            this.probabilityFunction = (ProbabilityFunction)this.getPreparedClassOption(this.probabilityFunctionOption);
            this.minNumberInstancesOption = null;
            this.probabilityFunctionOption = null;
        }
        double anomaly = 0.0;
        if (this.weightSeen > (double)this.minInstances) {
            int ct = 0;
            for (int i = 0; i < instance.numInputAttributes(); ++i) {
                double prob = 0.0;
                double[] stats = this.sufficientStatistics.get(i);
                if (!instance.attribute(i).isNumeric()) continue;
                double val = instance.valueInputAttribute(i);
                double sd = Utils.computeSD(stats[1], stats[0], this.weightSeen);
                if (!(sd > 0.01)) continue;
                prob = this.probabilityFunction.getProbability(stats[0] / this.weightSeen, sd, val);
                if (prob > 0.99) {
                    prob = 0.99;
                } else if (prob < 0.01) {
                    prob = 0.01;
                }
                anomaly += Math.log(prob) - Math.log(1.0 - prob);
                ++ct;
            }
            if (ct > 0) {
                anomaly /= (double)ct;
            }
            boolean bl = isAnomaly = anomaly < this.threshold;
        }
        if (!isAnomaly) {
            if (this.sufficientStatistics == null) {
                this.sufficientStatistics = new AutoExpandVector();
            }
            this.weightSeen += instance.weight();
            for (int i = 0; i < instance.numInputAttributes(); ++i) {
                double[] stats = this.sufficientStatistics.get(i);
                if (!instance.attribute(i).isNumeric()) continue;
                double val = instance.valueInputAttribute(i);
                if (stats != null) {
                    stats[0] = stats[0] + val;
                    stats[1] = stats[1] + val * val;
                    continue;
                }
                stats = new double[]{instance.weight() * val, instance.weight() * val * val};
                this.sufficientStatistics.set(i, stats);
            }
        }
        return isAnomaly;
    }

    protected void printAnomaly(Instance inst, double anomaly) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < inst.numInputAttributes(); ++i) {
            if (!inst.attribute(i).isNumeric()) continue;
            sb.append("Attribute " + i + " (" + inst.attribute(i).name() + ") - ");
            double val = inst.valueInputAttribute(i);
            sb.append("Value: ").append(val);
            double[] stats = this.sufficientStatistics.get(i);
            double mean = stats[0] / this.weightSeen;
            double std = Utils.computeSD(stats[1], stats[0], this.weightSeen);
            double prob = this.probabilityFunction.getProbability(mean, Utils.computeSD(stats[1], stats[0], this.weightSeen), val);
            sb.append(" - Prob: ").append(prob);
            sb.append(" - Mean: ").append(mean);
            sb.append(" - Std: ").append(std).append("\n");
        }
        sb.append("Score - ").append(anomaly);
        System.out.println(sb);
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

