/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import moa.AbstractMOAObject;
import moa.classifiers.rules.core.Predicate;
import moa.core.StringUtils;

public class NominalRulePredicate
extends AbstractMOAObject
implements Predicate {
    private static final long serialVersionUID = 1L;
    private int inputAttributeIndex;
    private double attributeValue;
    private boolean isEqual;

    public NominalRulePredicate(int inputAttributeIndex, double attributeValue, boolean isEqual) {
        this.inputAttributeIndex = inputAttributeIndex;
        this.attributeValue = attributeValue;
        this.isEqual = isEqual;
    }

    @Override
    public boolean evaluate(Instance instance) {
        return this.evaluate((MultiLabelInstance)instance);
    }

    public boolean evaluate(MultiLabelInstance instance) {
        if (instance.isMissing(this.inputAttributeIndex)) {
            return false;
        }
        boolean evaluation = false;
        if (instance.valueInputAttribute(this.inputAttributeIndex) == this.attributeValue) {
            evaluation = true;
        }
        return this.isEqual ? evaluation : !evaluation;
    }

    @Override
    public void negateCondition() {
        this.isEqual = !this.isEqual;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        if (this.isEqual) {
            StringUtils.appendIndented(sb, indent + 1, "In" + this.inputAttributeIndex + " == " + this.attributeValue);
        } else {
            StringUtils.appendIndented(sb, indent + 1, "In" + this.inputAttributeIndex + " <> " + this.attributeValue);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.getDescription(sb, 0);
        return sb.toString();
    }

    @Override
    public int getAttributeIndex() {
        return this.inputAttributeIndex;
    }

    @Override
    public boolean isEqualOrLess() {
        return this.isEqual;
    }
}

