/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel.trees;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import java.util.Arrays;
import java.util.LinkedList;
import moa.AbstractMOAObject;
import moa.classifiers.AbstractMultiLabelLearner;
import moa.classifiers.MultiTargetRegressor;
import moa.classifiers.multilabel.core.splitcriteria.ICVarianceReduction;
import moa.classifiers.rules.core.Predicate;
import moa.classifiers.rules.multilabel.attributeclassobservers.AttributeStatisticsObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.MultiLabelBSTree;
import moa.classifiers.rules.multilabel.attributeclassobservers.MultiLabelNominalAttributeObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.NominalStatisticsObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.NumericStatisticsObserver;
import moa.classifiers.rules.multilabel.core.AttributeExpansionSuggestion;
import moa.classifiers.rules.multilabel.core.splitcriteria.MultiLabelSplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.SizeOf;
import moa.core.StringUtils;

public class ISOUPTree
extends AbstractMultiLabelLearner
implements MultiTargetRegressor {
    private static final long serialVersionUID = 1L;
    protected Node treeRoot;
    private int leafNodeCount = 0;
    private int splitNodeCount = 0;
    private double examplesSeen = 0.0;
    private DoubleVector sumOfValues = new DoubleVector();
    private DoubleVector sumOfSquares = new DoubleVector();
    private DoubleVector sumOfAttrValues = new DoubleVector();
    private DoubleVector sumOfAttrSquares = new DoubleVector();
    public int maxID = 0;
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "The number of instances a leaf should observe between split attempts.", 200, 0, Integer.MAX_VALUE);
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-7, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public FloatOption alternateTreeFadingFactorOption = new FloatOption("alternateTreeFadingFactor", 'f', "The fading factor to use when deciding if an alternate tree should replace an original.", 0.995, 0.0, 1.0);
    public IntOption alternateTreeTMinOption = new IntOption("alternateTreeTMin", 'y', "The Tmin value to use when deciding if an alternate tree should replace an original.", 150, 0, Integer.MAX_VALUE);
    public IntOption alternateTreeTimeOption = new IntOption("alternateTreeTime", 'u', "The 'time' (in terms of number of instances) value to use when deciding if an alternate tree should be discarded.", 1500, 0, Integer.MAX_VALUE);
    public FlagOption regressionTreeOption = new FlagOption("regressionTree", 'r', "Build a regression tree instead of a model tree.");
    public FloatOption learningRatioOption = new FloatOption("learningRatio", 'l', "Learning ratio to use for training the Perceptrons in the leaves.", 0.02);
    public FloatOption learningRateDecayFactorOption = new FloatOption("learningRatioDecayFactor", 'd', "Learning rate decay factor (not used when learning rate is constant).", 0.001);
    public FlagOption learningRatioConstOption = new FlagOption("learningRatioConst", 'o', "Keep learning rate constant instead of decaying (if kept constant learning ratio is suggested to be 0.001).");
    public FlagOption doNotNormalizeOption = new FlagOption("doNotNormalize", 'n', "Don't normalize.");

    @Override
    public String getPurposeString() {
        return "Implementation of the iSOUP-Tree algorithm as described by Osojnik et al.";
    }

    @Override
    public void resetLearningImpl() {
        this.treeRoot = null;
        this.leafNodeCount = 0;
        this.splitNodeCount = 0;
        this.maxID = 0;
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        if (this.treeRoot != null) {
            this.treeRoot.describeSubtree(out, indent);
        }
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[0];
    }

    public int calcByteSize() {
        int size = (int)SizeOf.sizeOf(this);
        if (this.treeRoot != null) {
            size += this.treeRoot.calcByteSize();
        }
        return size;
    }

    @Override
    public Prediction getPredictionForInstance(MultiLabelInstance inst) {
        this.checkRoot();
        double[] predictionVector = this.treeRoot.getPrediction(inst);
        MultiLabelPrediction prediction = new MultiLabelPrediction(this.getModelContext().numOutputAttributes());
        for (int i = 0; i < this.getModelContext().numOutputAttributes(); ++i) {
            prediction.setVote(i, 1, predictionVector[i]);
        }
        return prediction;
    }

    public double[] normalizedInputVector(MultiLabelInstance inst) {
        double[] normalizedInput = new double[inst.numInputAttributes() + 1];
        if (this.normalize()) {
            for (int j = 0; j < inst.numInputAttributes(); ++j) {
                Attribute attr = inst.inputAttribute(j);
                double value = inst.valueInputAttribute(j);
                double mean = this.sumOfAttrValues.getValue(j) / this.examplesSeen;
                double sd = this.computeSD(this.sumOfAttrSquares.getValue(j), this.sumOfAttrValues.getValue(j), this.examplesSeen);
                if (this.examplesSeen > 1.0 && sd > 1.0E-5) {
                    if (attr.isNumeric()) {
                        normalizedInput[j] = (value - mean) / sd;
                        continue;
                    }
                    normalizedInput[j] = value;
                    continue;
                }
                normalizedInput[j] = 0.0;
            }
            normalizedInput[inst.numInputAttributes()] = this.examplesSeen > 1.0 ? 1.0 : 0.0;
        } else {
            for (int j = 0; j < inst.numInputAttributes(); ++j) {
                normalizedInput[j] = inst.valueInputAttribute(j);
            }
            normalizedInput[inst.numInputAttributes()] = 1.0;
        }
        return normalizedInput;
    }

    public double[] normalizedTargetVector(MultiLabelInstance inst) {
        double[] out = new double[this.getModelContext().numOutputAttributes()];
        if (this.normalize()) {
            for (int i = 0; i < inst.numOutputAttributes(); ++i) {
                double value = inst.valueOutputAttribute(i);
                double sd = this.computeSD(this.sumOfSquares.getValue(i), this.sumOfValues.getValue(i), this.examplesSeen);
                double average = this.sumOfValues.getValue(i) / this.examplesSeen;
                out[i] = sd > 0.0 && this.examplesSeen > 1.0 ? (value - average) / sd : 0.0;
            }
        } else {
            for (int i = 0; i < inst.numOutputAttributes(); ++i) {
                out[i] = inst.valueOutputAttribute(i);
            }
        }
        return out;
    }

    public double[] normalizeTargetVector(double[] pred) {
        if (this.normalize()) {
            double[] out = new double[pred.length];
            for (int i = 0; i < pred.length; ++i) {
                double value = pred[i];
                double sd = this.computeSD(this.sumOfSquares.getValue(i), this.sumOfValues.getValue(i), this.examplesSeen);
                double average = this.sumOfValues.getValue(i) / this.examplesSeen;
                out[i] = sd > 0.0 && this.examplesSeen > 1.0 ? (value - average) / (3.0 * sd) : 0.0;
            }
            return out;
        }
        return pred;
    }

    public double normalizeTargetValue(MultiLabelInstance inst, int i) {
        if (this.normalize()) {
            if (this.examplesSeen > 1.0) {
                double value = inst.valueOutputAttribute(i);
                double sd = this.computeSD(this.sumOfSquares.getValue(i), this.sumOfValues.getValue(i), this.examplesSeen);
                double average = this.sumOfValues.getValue(i) / this.examplesSeen;
                if (sd > 0.0) {
                    return (value - average) / (3.0 * sd);
                }
                return 0.0;
            }
            return 0.0;
        }
        return inst.valueOutputAttribute(i);
    }

    public double normalizeTargetValue(double value, int i) {
        if (this.normalize()) {
            if (this.examplesSeen > 1.0) {
                double sd = this.computeSD(this.sumOfSquares.getValue(i), this.sumOfValues.getValue(i), this.examplesSeen);
                double average = this.sumOfValues.getValue(i) / this.examplesSeen;
                if (sd > 0.0) {
                    return (value - average) / (3.0 * sd);
                }
                return 0.0;
            }
            return 0.0;
        }
        return value;
    }

    public double[] getNormalizedError(MultiLabelInstance inst, double[] prediction) {
        double[] normalPrediction = this.normalizeTargetVector(prediction);
        double[] normalValue = this.normalizedTargetVector(inst);
        double[] out = new double[this.getModelContext().numOutputAttributes()];
        for (int i = 0; i < inst.numOutputAttributes(); ++i) {
            out[i] = Math.abs(normalValue[i] - normalPrediction[i]);
        }
        return out;
    }

    @Override
    public void trainOnInstanceImpl(MultiLabelInstance inst) {
        if (inst.weight() > 0.0) {
            int i;
            this.checkRoot();
            double[] prediction = this.treeRoot.getPrediction(inst);
            double[] normalError = this.getNormalizedError(inst, prediction);
            this.processInstance(inst, this.treeRoot, prediction, normalError, true, false);
            this.examplesSeen += inst.weight();
            for (i = 0; i < inst.numberOutputTargets(); ++i) {
                this.sumOfValues.addToValue(i, inst.weight() * inst.valueOutputAttribute(i));
                this.sumOfSquares.addToValue(i, inst.weight() * inst.valueOutputAttribute(i) * inst.valueOutputAttribute(i));
            }
            for (i = 0; i < inst.numInputAttributes(); ++i) {
                this.sumOfAttrValues.addToValue(i, inst.weight() * inst.valueInputAttribute(i));
                this.sumOfAttrSquares.addToValue(i, inst.weight() * inst.valueInputAttribute(i) * inst.valueInputAttribute(i));
            }
        }
    }

    public void processInstance(MultiLabelInstance inst, Node node, double[] prediction, double[] normalError, boolean growthAllowed, boolean inAlternate) {
        block2: {
            Node currentNode = node;
            while (true) {
                if (currentNode instanceof LeafNode) {
                    ((LeafNode)currentNode).learnFromInstance(inst, prediction, growthAllowed);
                    break block2;
                }
                currentNode.examplesSeen += inst.weight();
                if (!(currentNode instanceof SplitNode)) break;
                currentNode = ((SplitNode)currentNode).getChild(((SplitNode)currentNode).instanceChildIndex(inst));
            }
            ((LeafNode)currentNode).learnFromInstance(inst, prediction, growthAllowed);
        }
    }

    protected NumericStatisticsObserver newNumericClassObserver() {
        return new MultiLabelBSTree();
    }

    public NominalStatisticsObserver newNominalClassObserver() {
        return new MultiLabelNominalAttributeObserver();
    }

    protected SplitNode newSplitNode(Predicate predicate) {
        ++this.maxID;
        return new SplitNode(predicate, this);
    }

    protected LeafNode newLeafNode() {
        ++this.maxID;
        return new LeafNode(this);
    }

    protected MultitargetPerceptron newLeafModel() {
        return new MultitargetPerceptron(this);
    }

    protected void checkRoot() {
        if (this.treeRoot == null) {
            this.treeRoot = this.newLeafNode();
            this.leafNodeCount = 1;
        }
    }

    public static double computeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    public boolean buildingModelTree() {
        return !this.regressionTreeOption.isSet();
    }

    public boolean normalize() {
        return !this.doNotNormalizeOption.isSet();
    }

    protected void attemptToSplit(LeafNode node, SplitNode parent, int parentIndex) {
        ICVarianceReduction splitCriterion = new ICVarianceReduction();
        Object[] bestSplitSuggestions = node.getBestSplitSuggestions(splitCriterion);
        Arrays.sort(bestSplitSuggestions);
        boolean shouldSplit = false;
        if (bestSplitSuggestions.length < 2) {
            shouldSplit = bestSplitSuggestions.length > 0;
        } else {
            double hoeffdingBound = ISOUPTree.computeHoeffdingBound(1.0, this.splitConfidenceOption.getValue(), node.examplesSeen);
            Object bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
            if (((AttributeExpansionSuggestion)secondBestSuggestion).merit / ((AttributeExpansionSuggestion)bestSuggestion).merit < 1.0 - hoeffdingBound || hoeffdingBound < this.tieThresholdOption.getValue()) {
                shouldSplit = true;
            } else {
                for (int i = 0; i < node.attributeObservers.size(); ++i) {
                    AttributeStatisticsObserver obs = (AttributeStatisticsObserver)node.attributeObservers.get(i);
                    if (obs == null) continue;
                    if (this.getModelContext().attribute(i).isNumeric()) {
                        // empty if block
                    }
                    if (!this.getModelContext().attribute(i).isNominal()) continue;
                }
            }
        }
        if (shouldSplit) {
            Object splitDecision = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            SplitNode newSplit = this.newSplitNode(((AttributeExpansionSuggestion)splitDecision).predicate);
            newSplit.copyStatistics(node);
            newSplit.changeDetection = node.changeDetection;
            newSplit.ID = node.ID;
            --this.leafNodeCount;
            for (int i = 0; i < 2; ++i) {
                LeafNode newChild = this.newLeafNode();
                if (this.buildingModelTree()) {
                    newChild.learningModel = new MultitargetPerceptron(this, node.learningModel);
                }
                newChild.changeDetection = node.changeDetection;
                newChild.setParent(newSplit);
                newSplit.setChild(i, newChild);
                ++this.leafNodeCount;
            }
            if (parent == null && node.originalNode == null) {
                this.treeRoot = newSplit;
            } else if (parent == null && node.originalNode != null) {
                node.originalNode.alternateTree = newSplit;
            } else {
                parent.setChild(parentIndex, newSplit);
                newSplit.setParent(parent);
            }
            ++this.splitNodeCount;
        }
    }

    public double computeSD(double squaredVal, double val, double size) {
        if (size > 1.0) {
            return Math.sqrt((squaredVal - val * val / size) / size);
        }
        return 0.0;
    }

    public static double scalarProduct(DoubleVector u, DoubleVector v) {
        double ret = 0.0;
        for (int i = 0; i < Math.max(u.numValues(), v.numValues()); ++i) {
            ret += u.getValue(i) * v.getValue(i);
        }
        return ret;
    }

    public class MultitargetPerceptron {
        protected ISOUPTree tree;
        protected double[][] weights;
        protected int instancesSeen = 0;

        public String getPurposeString() {
            return "A multi-target perceptron";
        }

        public MultitargetPerceptron(ISOUPTree tree, MultitargetPerceptron original) {
            this.tree = tree;
            this.weights = (double[][])original.weights.clone();
        }

        public MultitargetPerceptron(ISOUPTree tree) {
            this.tree = tree;
            this.initializeWeights();
        }

        public void initializeWeights() {
            this.instancesSeen = 0;
            int numTargets = this.tree.getModelContext().numOutputAttributes();
            int numInputs = this.tree.getModelContext().numInputAttributes();
            this.weights = new double[numTargets][numInputs + 1];
            this.tree.classifierRandom.setSeed(1234L);
            for (int i = 0; i < numTargets; ++i) {
                for (int j = 0; j < numInputs + 1; ++j) {
                    this.weights[i][j] = 2.0 * this.tree.classifierRandom.nextDouble() - 1.0;
                }
            }
        }

        public void updatePerceptron(MultiLabelInstance inst) {
            this.instancesSeen = (int)((double)this.instancesSeen + inst.weight());
            double learningRatio = 0.0;
            learningRatio = this.tree.learningRatioConstOption.isSet() ? this.tree.learningRatioOption.getValue() : ISOUPTree.this.learningRatioOption.getValue() / (1.0 + (double)this.instancesSeen * this.tree.learningRateDecayFactorOption.getValue());
            for (int i = 0; i < (int)inst.weight(); ++i) {
                this.updateWeights(inst, learningRatio);
            }
        }

        public void updateWeights(MultiLabelInstance inst, double learningRatio) {
            if ((double)this.instancesSeen > 1.0) {
                double[] normalizedInput = this.tree.normalizedInputVector(inst);
                double[] normalizedPrediction = this.prediction(normalizedInput);
                double[] normalizedTarget = this.tree.normalizedTargetVector(inst);
                for (int i = 0; i < inst.numOutputAttributes(); ++i) {
                    double delta = normalizedTarget[i] - normalizedPrediction[i];
                    for (int j = 0; j < normalizedInput.length; ++j) {
                        double[] dArray = this.weights[i];
                        int n = j;
                        dArray[n] = dArray[n] + delta * learningRatio * normalizedInput[j];
                    }
                }
                this.normalizeWeights();
            }
        }

        public void normalizeWeights() {
            for (int j = 0; j < this.weights.length; ++j) {
                int i;
                double sum = 0.0;
                for (i = 0; i < this.weights[j].length; ++i) {
                    sum += Math.abs(this.weights[j][i]);
                }
                i = 0;
                while (i < this.weights[j].length) {
                    double[] dArray = this.weights[j];
                    int n = i++;
                    dArray[n] = dArray[n] / sum;
                }
            }
        }

        public double[] prediction(double[] instanceValues) {
            double[] out = new double[this.tree.getModelContext().numOutputAttributes()];
            for (int i = 0; i < this.tree.getModelContext().numOutputAttributes(); ++i) {
                out[i] = 0.0;
                for (int j = 0; j < instanceValues.length; ++j) {
                    int n = i;
                    out[n] = out[n] + this.weights[i][j] * instanceValues[j];
                }
            }
            return out;
        }

        private double[] prediction(MultiLabelInstance inst) {
            double[] normalizedInput = this.tree.normalizedInputVector(inst);
            double[] normalizedPrediction = this.prediction(normalizedInput);
            return this.denormalizePrediction(normalizedPrediction);
        }

        private double[] denormalizePrediction(double[] normalizedPrediction) {
            double[] out = new double[normalizedPrediction.length];
            if (this.tree.normalize()) {
                for (int i = 0; i < this.tree.getModelContext().numOutputAttributes(); ++i) {
                    double mean = this.tree.sumOfValues.getValue(i) / this.tree.examplesSeen;
                    double sd = ISOUPTree.this.computeSD(this.tree.sumOfSquares.getValue(i), this.tree.sumOfValues.getValue(i), this.tree.examplesSeen);
                    out[i] = ISOUPTree.this.examplesSeen > 1.0 ? normalizedPrediction[i] * sd + mean : 0.0;
                }
                return out;
            }
            return normalizedPrediction;
        }

        public void getModelDescription(StringBuilder out, int indent) {
            for (int i = 0; i < this.tree.getModelContext().numOutputAttributes(); ++i) {
                StringUtils.appendIndented(out, indent, " [" + this.tree.getModelContext().outputAttribute(i).name() + "]");
                if (ISOUPTree.this.getModelContext() != null) {
                    for (int j = 0; j < ISOUPTree.this.getModelContext().numOutputAttributes(); ++j) {
                        if (!ISOUPTree.this.getModelContext().attribute(j).isNumeric()) continue;
                        out.append(j == 0 || this.weights[i][j] < 0.0 ? " " : " + ");
                        out.append(String.format("%.4f", this.weights[i][j]));
                        out.append(" * ");
                        out.append(ISOUPTree.this.getAttributeNameString(j));
                    }
                    out.append(" + " + this.weights[i][ISOUPTree.this.getModelContext().numOutputAttributes()]);
                }
                StringUtils.appendNewline(out);
            }
        }
    }

    public static class SplitNode
    extends InnerNode {
        private static final long serialVersionUID = 1L;
        protected Predicate predicate;

        public SplitNode(Predicate predicate, ISOUPTree tree) {
            super(tree);
            this.predicate = predicate;
            this.ID = tree.maxID;
        }

        public int instanceChildIndex(MultiLabelInstance inst) {
            return this.predicate.evaluate(inst) ? 0 : 1;
        }

        @Override
        public void describeSubtree(StringBuilder out, int indent) {
            for (int branch = 0; branch < this.children.size(); ++branch) {
                Node child = this.getChild(branch);
                if (child == null) continue;
                if (branch == 0) {
                    StringUtils.appendIndented(out, indent, "if ");
                    this.predicate.getDescription(out, 0);
                } else {
                    StringUtils.appendIndented(out, indent, "else");
                }
                out.append(": ");
                StringUtils.appendNewline(out);
                child.describeSubtree(out, indent + 2);
            }
        }

        @Override
        public double[] getPrediction(MultiLabelInstance inst) {
            return ((Node)this.children.get(this.predicate.evaluate(inst) ? 0 : 1)).getPrediction(inst);
        }
    }

    public static abstract class InnerNode
    extends Node {
        private static final long serialVersionUID = 1L;
        protected AutoExpandVector<Node> children = new AutoExpandVector();
        protected DoubleVector sumOfAbsErrors = new DoubleVector();
        protected DoubleVector PHsums = new DoubleVector();
        protected DoubleVector PHmins = new DoubleVector();
        protected double lossExamplesSeen;
        protected double lossFadedSumOriginal;
        protected double lossFadedSumAlternate;
        protected double lossNumQiTests;
        protected double lossSumQi;
        protected double previousWeight = 0.0;

        public InnerNode(ISOUPTree tree) {
            super(tree);
        }

        public int numChildren() {
            return this.children.size();
        }

        public Node getChild(int i) {
            return this.children.get(i);
        }

        @Override
        public int getChildIndex(Node child) {
            return this.children.indexOf(child);
        }

        @Override
        public void setChild(int i, Node child) {
            this.children.set(i, child);
        }

        @Override
        public void disableChangeDetection() {
            this.changeDetection = false;
            for (Node child : this.children) {
                child.disableChangeDetection();
            }
        }

        @Override
        public void restartChangeDetection() {
            if (this.alternateTree == null) {
                this.changeDetection = true;
                this.PHsums = new DoubleVector();
                this.PHmins = new DoubleVector();
                for (int i = 0; i < this.tree.getModelContext().numOutputAttributes(); ++i) {
                    this.PHmins.setValue(i, Double.MAX_VALUE);
                }
                for (Node child : this.children) {
                    child.restartChangeDetection();
                }
            }
        }

        public boolean PageHinckleyTest(double error, double threshold, int targetIndex) {
            this.PHsums.addToValue(targetIndex, error);
            if (this.PHsums.getValue(targetIndex) < this.PHmins.getValue(targetIndex)) {
                this.PHmins.setValue(targetIndex, this.PHsums.getValue(targetIndex));
            }
            return this.PHsums.getValue(targetIndex) - this.PHmins.getValue(targetIndex) > threshold;
        }

        public void initializeAlternateTree(ISOUPTree tree) {
            this.alternateTree = tree.newLeafNode();
            this.alternateTree.originalNode = this;
            this.lossExamplesSeen = 0.0;
            this.lossFadedSumOriginal = 0.0;
            this.lossFadedSumAlternate = 0.0;
            this.lossNumQiTests = 0.0;
            this.lossSumQi = 0.0;
            this.previousWeight = 0.0;
            this.disableChangeDetection();
        }
    }

    public static class LeafNode
    extends Node {
        private static final long serialVersionUID = 1L;
        public MultitargetPerceptron learningModel;
        public DoubleVector errorP = new DoubleVector();
        public DoubleVector errorM = new DoubleVector();
        protected double examplesSeenAtLastSplitEvaluation = 0.0;

        public LeafNode(ISOUPTree tree) {
            super(tree);
            if (tree.buildingModelTree()) {
                this.learningModel = tree.newLeafModel();
            }
            this.examplesSeen = 0.0;
            this.sumOfValues = new DoubleVector();
            this.sumOfSquares = new DoubleVector();
        }

        public void learnFromInstance(MultiLabelInstance inst, double[] prediction, boolean growthAllowed) {
            int i;
            double[] predictionP = this.tree.buildingModelTree() ? this.getPredictionModel(inst) : null;
            double[] predictionM = this.getPredictionTargetMean(inst);
            this.examplesSeen += inst.weight();
            for (i = 0; i < this.tree.getModelContext().numOutputAttributes(); ++i) {
                this.sumOfValues.addToValue(i, inst.weight() * inst.valueOutputAttribute(i));
                this.sumOfSquares.addToValue(i, inst.weight() * inst.valueOutputAttribute(i) * inst.valueOutputAttribute(i));
                if (!this.tree.buildingModelTree()) continue;
                this.errorP.setValue(i, this.errorP.getValue(i) * 0.95 + Math.abs(predictionP[i] - inst.valueOutputAttribute(i)));
                this.errorM.setValue(i, this.errorM.getValue(i) * 0.95 + Math.abs(predictionM[i] - inst.valueOutputAttribute(i)));
            }
            if (this.tree.buildingModelTree()) {
                this.learningModel.updatePerceptron(inst);
            }
            for (i = 0; i < inst.numInputAttributes(); ++i) {
                AttributeStatisticsObserver obs = (AttributeStatisticsObserver)this.attributeObservers.get(i);
                if (obs == null) {
                    if (inst.inputAttribute(i).isNumeric()) {
                        obs = this.tree.newNumericClassObserver();
                        this.attributeObservers.set(i, obs);
                    } else if (inst.inputAttribute(i).isNominal()) {
                        obs = this.tree.newNominalClassObserver();
                        this.attributeObservers.set(i, obs);
                    }
                }
                if (obs == null) continue;
                DoubleVector[] observations = new DoubleVector[inst.numOutputAttributes()];
                for (int j = 0; j < inst.numOutputAttributes(); ++j) {
                    observations[j] = new DoubleVector();
                    observations[j].setValue(0, inst.weight());
                    observations[j].setValue(1, inst.weight() * inst.valueOutputAttribute(j));
                    observations[j].setValue(2, inst.weight() * inst.valueOutputAttribute(j) * inst.valueOutputAttribute(j));
                }
                obs.observeAttribute(inst.valueInputAttribute(i), observations);
            }
            if (growthAllowed) {
                this.checkForSplit();
            }
        }

        public AttributeExpansionSuggestion[] getBestSplitSuggestions(MultiLabelSplitCriterion criterion) {
            LinkedList<AttributeExpansionSuggestion> bestSuggestions = new LinkedList<AttributeExpansionSuggestion>();
            for (int i = 0; i < this.attributeObservers.size(); ++i) {
                AttributeStatisticsObserver obs = (AttributeStatisticsObserver)this.attributeObservers.get(i);
                if (obs == null) continue;
                DoubleVector[] preSplitStatistics = new DoubleVector[this.tree.getModelContext().numOutputAttributes()];
                for (int j = 0; j < this.tree.getModelContext().numOutputAttributes(); ++j) {
                    preSplitStatistics[j] = new DoubleVector();
                    preSplitStatistics[j].setValue(0, this.examplesSeen);
                    preSplitStatistics[j].setValue(1, this.sumOfValues.getValue(j));
                    preSplitStatistics[j].setValue(2, this.sumOfSquares.getValue(j));
                }
                AttributeExpansionSuggestion bestSuggestion = null;
                bestSuggestion = obs.getBestEvaluatedSplitSuggestion(criterion, preSplitStatistics, i);
                if (bestSuggestion == null) continue;
                bestSuggestions.add(bestSuggestion);
            }
            return bestSuggestions.toArray(new AttributeExpansionSuggestion[bestSuggestions.size()]);
        }

        public double[] getPredictionModel(MultiLabelInstance inst) {
            return this.learningModel.prediction(inst);
        }

        public double[] getPredictionTargetMean(MultiLabelInstance inst) {
            double[] pred = new double[inst.numOutputAttributes()];
            if (this.examplesSeen > 0.0) {
                for (int i = 0; i < inst.numOutputAttributes(); ++i) {
                    pred[i] = this.sumOfValues.getValue(i) / this.examplesSeen;
                }
            }
            return pred;
        }

        @Override
        public double[] getPrediction(MultiLabelInstance inst) {
            if (this.tree.buildingModelTree()) {
                double[] predictionP = this.getPredictionModel(inst);
                double[] predictionM = this.getPredictionTargetMean(inst);
                double[] prediction = new double[predictionP.length];
                for (int i = 0; i < predictionP.length; ++i) {
                    prediction[i] = this.errorP.getValue(i) < this.errorM.getValue(i) ? predictionP[i] : predictionM[i];
                }
                return prediction;
            }
            return this.getPredictionTargetMean(inst);
        }

        public void checkForSplit() {
            if (this.examplesSeen - this.examplesSeenAtLastSplitEvaluation >= (double)this.tree.gracePeriodOption.getValue()) {
                int index = this.parent != null ? this.parent.getChildIndex(this) : 0;
                this.tree.attemptToSplit(this, this.parent, index);
                this.examplesSeenAtLastSplitEvaluation = this.examplesSeen;
            }
        }

        @Override
        public void describeSubtree(StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, "Leaf ");
            if (this.tree.buildingModelTree()) {
                this.learningModel.getModelDescription(out, 0);
            } else {
                StringUtils.appendNewline(out);
            }
        }
    }

    public static abstract class Node
    extends AbstractMOAObject {
        private static final long serialVersionUID = 1L;
        protected double weightSeenAtLastSplitEvaluation;
        public int ID;
        protected ISOUPTree tree;
        protected SplitNode parent;
        protected Node alternateTree;
        protected Node originalNode;
        protected AutoExpandVector<AttributeStatisticsObserver> attributeObservers = new AutoExpandVector();
        protected boolean changeDetection = true;
        protected double examplesSeen;
        protected DoubleVector sumOfValues = new DoubleVector();
        protected DoubleVector sumOfSquares = new DoubleVector();

        public Node(ISOUPTree tree) {
            this.tree = tree;
        }

        public void copyStatistics(Node node) {
            this.examplesSeen = node.examplesSeen;
            this.sumOfValues = (DoubleVector)node.sumOfValues.copy();
            this.sumOfSquares = (DoubleVector)node.sumOfSquares.copy();
        }

        public int calcByteSize() {
            return (int)SizeOf.fullSizeOf(this);
        }

        public void setParent(SplitNode parent) {
            this.parent = parent;
        }

        public Node getParent() {
            return this.parent;
        }

        public void disableChangeDetection() {
            this.changeDetection = false;
        }

        public void restartChangeDetection() {
            this.changeDetection = true;
        }

        @Override
        public void getDescription(StringBuilder sb, int i) {
        }

        public double[] getPrediction(MultiLabelInstance inst) {
            return null;
        }

        public void describeSubtree(StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, "Leaf");
        }

        public int getLevel() {
            Node target = this;
            int level = 0;
            while (target.getParent() != null) {
                if (target.skipInLevelCount()) {
                    target = target.getParent();
                    continue;
                }
                ++level;
                target = target.getParent();
            }
            if (target.originalNode == null) {
                return level;
            }
            return level + this.originalNode.getLevel();
        }

        public void setChild(int parentBranch, Node node) {
        }

        public int getChildIndex(Node child) {
            return -1;
        }

        public int getNumSubtrees() {
            return 1;
        }

        protected boolean skipInLevelCount() {
            return false;
        }
    }
}

