/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel;

import com.yahoo.labs.samoa.instances.Instance;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import moa.classifiers.Classifier;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.classifiers.trees.HoeffdingTree;
import moa.options.ClassOption;

public class HoeffdingTreeClassifLeaves
extends HoeffdingTree {
    private static final long serialVersionUID = 1L;
    public ClassOption learnerOption = new ClassOption("learner", 'a', "Classifier to train.", Classifier.class, "bayes.NaiveBayes");

    public HoeffdingTreeClassifLeaves() {
        this.removePoorAttsOption = null;
    }

    @Override
    protected HoeffdingTree.LearningNode newLearningNode(double[] initialClassObservations) {
        return new LearningNodeClassifier(initialClassObservations, null, this);
    }

    protected HoeffdingTree.LearningNode newLearningNode(double[] initialClassObservations, Classifier cl) {
        return new LearningNodeClassifier(initialClassObservations, cl, this);
    }

    @Override
    protected void attemptToSplit(HoeffdingTree.ActiveLearningNode node, HoeffdingTree.SplitNode parent, int parentIndex) {
        if (!node.observedClassDistributionIsPure()) {
            SplitCriterion splitCriterion = (SplitCriterion)this.getPreparedClassOption(this.splitCriterionOption);
            Object[] bestSplitSuggestions = node.getBestSplitSuggestions(splitCriterion, this);
            Arrays.sort(bestSplitSuggestions);
            boolean shouldSplit = false;
            if (bestSplitSuggestions.length < 2) {
                shouldSplit = bestSplitSuggestions.length > 0;
            } else {
                double hoeffdingBound = HoeffdingTreeClassifLeaves.computeHoeffdingBound(splitCriterion.getRangeOfMerit(node.getObservedClassDistribution()), this.splitConfidenceOption.getValue(), node.getWeightSeen());
                Object bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
                Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
                if (((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)secondBestSuggestion).merit > hoeffdingBound || hoeffdingBound < this.tieThresholdOption.getValue()) {
                    shouldSplit = true;
                }
                if (this.removePoorAttsOption != null && this.removePoorAttsOption.isSet()) {
                    int[] splitAtts;
                    int i;
                    HashSet<Integer> poorAtts = new HashSet<Integer>();
                    for (i = 0; i < bestSplitSuggestions.length; ++i) {
                        if (((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest == null || (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()).length != 1 || !(((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)bestSplitSuggestions[i]).merit > hoeffdingBound)) continue;
                        poorAtts.add(new Integer(splitAtts[0]));
                    }
                    for (i = 0; i < bestSplitSuggestions.length; ++i) {
                        if (((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest == null || (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()).length != 1 || !(((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)bestSplitSuggestions[i]).merit < hoeffdingBound)) continue;
                        poorAtts.remove(new Integer(splitAtts[0]));
                    }
                    Iterator i$ = poorAtts.iterator();
                    while (i$.hasNext()) {
                        int poorAtt = (Integer)i$.next();
                        node.disableAttribute(poorAtt);
                    }
                }
            }
            if (shouldSplit) {
                Object splitDecision = bestSplitSuggestions[bestSplitSuggestions.length - 1];
                if (((AttributeSplitSuggestion)splitDecision).splitTest == null) {
                    this.deactivateLearningNode(node, parent, parentIndex);
                } else {
                    HoeffdingTree.SplitNode newSplit = this.newSplitNode(((AttributeSplitSuggestion)splitDecision).splitTest, node.getObservedClassDistribution());
                    for (int i = 0; i < ((AttributeSplitSuggestion)splitDecision).numSplits(); ++i) {
                        HoeffdingTree.LearningNode newChild = this.newLearningNode(((AttributeSplitSuggestion)splitDecision).resultingClassDistributionFromSplit(i), ((LearningNodeClassifier)node).getClassifier());
                        newSplit.setChild(i, newChild);
                    }
                    --this.activeLeafNodeCount;
                    ++this.decisionNodeCount;
                    this.activeLeafNodeCount += ((AttributeSplitSuggestion)splitDecision).numSplits();
                    if (parent == null) {
                        this.treeRoot = newSplit;
                    } else {
                        parent.setChild(parentIndex, newSplit);
                    }
                }
                this.enforceTrackerLimit();
            }
        }
    }

    public class LearningNodeClassifier
    extends HoeffdingTree.ActiveLearningNode {
        protected Classifier classifier;
        private static final long serialVersionUID = 1L;

        public LearningNodeClassifier(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public LearningNodeClassifier(double[] initialClassObservations, Classifier cl, HoeffdingTreeClassifLeaves ht) {
            super(initialClassObservations);
            this.classifier = cl == null ? (Classifier)HoeffdingTreeClassifLeaves.this.getPreparedClassOption(ht.learnerOption) : cl.copy();
        }

        @Override
        public double[] getClassVotes(Instance inst, HoeffdingTree ht) {
            if (this.getWeightSeen() >= (double)((HoeffdingTreeClassifLeaves)ht).nbThresholdOption.getValue()) {
                return this.classifier.getVotesForInstance(inst);
            }
            return super.getClassVotes(inst, ht);
        }

        @Override
        public void disableAttribute(int attIndex) {
        }

        @Override
        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            this.classifier.trainOnInstance(inst);
            super.learnFromInstance(inst, ht);
        }

        public Classifier getClassifier() {
            return this.classifier;
        }
    }
}

