/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.SamoaToWekaInstanceConverter;
import moa.classifiers.AbstractClassifier;
import moa.core.Measurement;
import moa.options.WEKAClassOption;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class WEKAClassifier
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    protected SamoaToWekaInstanceConverter instanceConverter;
    public WEKAClassOption baseLearnerOption = new WEKAClassOption("baseLearner", 'l', "Classifier to train.", Classifier.class, "weka.classifiers.bayes.NaiveBayesUpdateable");
    public IntOption widthOption = new IntOption("width", 'w', "Size of Window for training learner.", 0, 0, Integer.MAX_VALUE);
    public IntOption widthInitOption = new IntOption("widthInit", 'i', "Size of first Window for training learner.", 1000, 0, Integer.MAX_VALUE);
    public IntOption sampleFrequencyOption = new IntOption("sampleFrequency", 'f', "How many instances between samples of the learning performance.", 0, 0, Integer.MAX_VALUE);
    protected Classifier classifier;
    protected int numberInstances;
    protected Instances instancesBuffer;
    protected boolean isClassificationEnabled;
    protected boolean isBufferStoring;

    @Override
    public String getPurposeString() {
        return "Classifier from Weka";
    }

    @Override
    public void resetLearningImpl() {
        try {
            String[] options = Utils.splitOptions((String)this.baseLearnerOption.getValueAsCLIString());
            this.createWekaClassifier(options);
        }
        catch (Exception e) {
            System.err.println("Creating a new classifier: " + e.getMessage());
        }
        this.numberInstances = 0;
        this.isClassificationEnabled = false;
        this.isBufferStoring = true;
        this.instanceConverter = new SamoaToWekaInstanceConverter();
    }

    @Override
    public void trainOnInstanceImpl(com.yahoo.labs.samoa.instances.Instance samoaInstance) {
        Instance inst = this.instanceConverter.wekaInstance(samoaInstance);
        try {
            if (this.numberInstances == 0) {
                this.instancesBuffer = new Instances(inst.dataset());
                if (this.classifier instanceof UpdateableClassifier) {
                    this.classifier.buildClassifier(this.instancesBuffer);
                    this.isClassificationEnabled = true;
                } else {
                    this.isBufferStoring = true;
                }
            }
            ++this.numberInstances;
            if (this.classifier instanceof UpdateableClassifier) {
                if (this.numberInstances > 0) {
                    ((UpdateableClassifier)this.classifier).updateClassifier(inst);
                }
            } else {
                if (this.numberInstances == this.widthInitOption.getValue()) {
                    this.buildClassifier();
                    this.isClassificationEnabled = true;
                    if (this.sampleFrequencyOption.getValue() != 0) {
                        this.isBufferStoring = true;
                    }
                }
                if (this.widthOption.getValue() == 0) {
                    if (this.isBufferStoring) {
                        this.instancesBuffer.add(inst);
                    }
                } else {
                    int numInstances = this.numberInstances % this.sampleFrequencyOption.getValue();
                    if (this.sampleFrequencyOption.getValue() == 0) {
                        numInstances = this.numberInstances;
                    }
                    if (numInstances == 0) {
                        this.isBufferStoring = true;
                    }
                    if (this.isBufferStoring && numInstances <= this.widthOption.getValue()) {
                        this.instancesBuffer.add(inst);
                    }
                    if (numInstances == this.widthOption.getValue()) {
                        this.buildClassifier();
                        this.isClassificationEnabled = true;
                        this.instancesBuffer = new Instances(inst.dataset());
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Training: " + e.getMessage());
        }
    }

    public void buildClassifier() {
        try {
            if (!(this.classifier instanceof UpdateableClassifier)) {
                Classifier auxclassifier = weka.classifiers.AbstractClassifier.makeCopy((Classifier)this.classifier);
                auxclassifier.buildClassifier(this.instancesBuffer);
                this.classifier = auxclassifier;
                this.isBufferStoring = false;
            }
        }
        catch (Exception e) {
            System.err.println("Building WEKA Classifier: " + e.getMessage());
        }
    }

    @Override
    public double[] getVotesForInstance(com.yahoo.labs.samoa.instances.Instance samoaInstance) {
        Instance inst = this.instanceConverter.wekaInstance(samoaInstance);
        double[] votes = new double[inst.numClasses()];
        if (!this.isClassificationEnabled) {
            for (int i = 0; i < inst.numClasses(); ++i) {
                votes[i] = 1.0 / (double)inst.numClasses();
            }
        } else {
            try {
                votes = this.classifier.distributionForInstance(inst);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        return votes;
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        if (this.classifier != null) {
            out.append(this.classifier.toString());
        }
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        Measurement[] m = new Measurement[]{};
        return m;
    }

    public void createWekaClassifier(String[] options) throws Exception {
        String classifierName = options[0];
        String[] newoptions = (String[])options.clone();
        newoptions[0] = "";
        this.classifier = weka.classifiers.AbstractClassifier.forName((String)classifierName, (String[])newoptions);
    }
}

