/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import java.util.Arrays;
import java.util.Collections;
import moa.classifiers.Classifier;
import moa.classifiers.meta.DACC;
import moa.core.Measurement;
import moa.core.Utils;

public class ADACC
extends DACC {
    private static final long serialVersionUID = 1L;
    public IntOption tauSizeOption = new IntOption("tau", 't', "The size of the evaluation window for the meta-learning.", 100, 1, 10000);
    public FloatOption stabIndexSizeOption = new FloatOption("StabThr", 'z', "The threshold for stability", 0.8, 0.0, 1.0);
    public FloatOption equivIndexSizeOption = new FloatOption("CeThr", 'q', "The threshold for concept equivalence", 0.7, 0.0, 1.0);
    protected int tau_size = 0;
    protected Instances recentChunk;
    protected double theta_stab;
    protected double theta_diff;
    protected double index;
    protected static final int MAXPERMANENT = 100;
    protected int addedPermanent = 0;

    @Override
    public String getPurposeString() {
        return "Anticipative and Dynamic Adaptation to Concept Changes for data streams.";
    }

    @Override
    protected void initVariables() {
        this.tau_size = this.tauSizeOption.getValue();
        this.theta_stab = this.stabIndexSizeOption.getValue();
        this.theta_diff = this.equivIndexSizeOption.getValue();
        this.recentChunk = null;
        int ensembleSize = (int)this.memberCountOption.getValue() + 100;
        this.ensemble = new Classifier[ensembleSize];
        this.ensembleAges = new double[ensembleSize];
        this.ensembleWindows = new int[ensembleSize][(int)this.evaluationSizeOption.getValue()];
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (this.recentChunk == null) {
            this.recentChunk = new Instances(this.getModelContext());
        }
        if (this.recentChunk.size() < this.tau_size) {
            this.recentChunk.add(inst);
        } else {
            this.recentChunk.set(this.nbInstances % this.tau_size, inst);
        }
        this.trainAndClassify(inst);
        if (this.nbInstances % this.tau_size == 0) {
            this.takeSnapshot();
        }
    }

    private void takeSnapshot() {
        this.index = this.computeStabilityIndex();
        if (this.index >= this.theta_stab) {
            if (this.addedPermanent == 0) {
                this.ensemble[this.ensemble.length - 100 + this.addedPermanent] = this.getBestAdaptiveClassifier().copy();
                ++this.addedPermanent;
            } else {
                Classifier candidate = this.getBestAdaptiveClassifier().copy();
                boolean duplicate = false;
                for (int j = 0; j < Math.min(100, this.addedPermanent); ++j) {
                    Classifier lastSnapshot = this.ensemble[this.ensemble.length - 100 + j];
                    int[][] votes = new int[2][this.tau_size];
                    for (int k = 0; k < this.tau_size; ++k) {
                        votes[0][k] = Utils.maxIndex(candidate.getVotesForInstance(this.recentChunk.get(k)));
                        votes[1][k] = Utils.maxIndex(lastSnapshot.getVotesForInstance(this.recentChunk.get(k)));
                    }
                    double kappa = this.computeKappa(votes[0], votes[1]);
                    if (!(kappa >= this.theta_diff)) continue;
                    duplicate = true;
                    break;
                }
                if (!duplicate) {
                    this.ensemble[this.ensemble.length - 100 + this.addedPermanent % 100] = candidate;
                    ++this.addedPermanent;
                }
            }
        }
    }

    private double computeKappa(int[] y1, int[] y2) {
        int m = y1.length;
        double theta1 = 0.0;
        double[][] counts = new double[2][this.modelContext.numClasses()];
        for (int i = 0; i < m; ++i) {
            if (y1[i] == y2[i]) {
                theta1 += 1.0;
            }
            counts[0][y1[i]] = counts[0][y1[i]] + 1.0;
            counts[1][y2[i]] = counts[1][y2[i]] + 1.0;
        }
        theta1 /= (double)m;
        double theta2 = 0.0;
        for (int i = 0; i < this.modelContext.numClasses(); ++i) {
            theta2 += counts[0][i] / (double)m * counts[1][i] / (double)m;
        }
        if (theta1 == theta2 && theta2 == 1.0) {
            return 1.0;
        }
        return (theta1 - theta2) / (1.0 - theta2);
    }

    private double computeStabilityIndex() {
        int m = (int)Math.floor((this.ensemble.length - 100) / 2);
        int[][] votes = new int[m][this.tau_size];
        double errors = 0.0;
        int count = 0;
        DACC.Pair[] arr = this.getHalf(true);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < this.tau_size; ++j) {
                votes[i][j] = Utils.maxIndex(this.ensemble[arr[i].index].getVotesForInstance(this.recentChunk.get(j)));
                errors += votes[i][j] == (int)this.recentChunk.get(j).classValue() ? 0.0 : 1.0;
                ++count;
            }
        }
        errors /= (double)count;
        double res = 0.0;
        count = 0;
        for (int i = 0; i < m; ++i) {
            for (int j = i + 1; j < m; ++j) {
                if (i == j) continue;
                res += this.computeKappa(votes[i], votes[j]);
                ++count;
            }
        }
        return res / (double)count - errors;
    }

    private Classifier getBestAdaptiveClassifier() {
        DACC.Pair[] newEnsembleWeights = new DACC.Pair[this.ensembleWeights.length - 100];
        for (int i = 0; i < newEnsembleWeights.length; ++i) {
            newEnsembleWeights[i] = this.ensembleWeights[i];
        }
        Arrays.sort(newEnsembleWeights, Collections.reverseOrder());
        return this.ensemble[newEnsembleWeights[0].index].copy();
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        Measurement[] measurements = new Measurement[]{new Measurement("size ", this.ensemble.length - 100), new Measurement("maturity ", this.maturityOption.getValue()), new Measurement("evalsize ", this.evaluationSizeOption.getValue()), new Measurement("cmb ", this.combinationOption.getChosenIndex()), new Measurement("tau", this.tau_size), new Measurement("MaxSnapshotsSize", 100.0), new Measurement("SnapshotsSize", this.addedPermanent), new Measurement("stabilityIndex", this.index), new Measurement("stabilityThreshold", this.theta_stab), new Measurement("differenceThreshold", this.theta_diff)};
        return measurements;
    }

    @Override
    protected int getNbActiveClassifiers() {
        return this.ensemble.length - 100 + Math.min(this.addedPermanent, 100);
    }

    @Override
    protected int getNbAdaptiveClassifiers() {
        return this.ensemble.length - 100;
    }
}

