/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import java.util.ArrayList;
import moa.AbstractMOAObject;
import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.classifiers.core.driftdetection.SeqDrift2ChangeDetector;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;

public class SeqDrift1ChangeDetector
extends AbstractChangeDetector {
    protected SeqDrift1 seqDrift1;
    public FloatOption deltaOption = new FloatOption("deltaSeqDrift1", 'd', "Delta of SeqDrift1 change detection", 0.01, 0.0, 1.0);
    public FloatOption deltaWarningOption = new FloatOption("deltaWarningOption", 'w', "Delta of SeqDrift1 change detector to declare warning state", 0.1, 0.0, 1.0);
    public IntOption blockSeqDriftOption = new IntOption("blockSeqDrift1Option", 'b', "Block size of SeqDrift1 change detector", 200, 100, 10000);

    @Override
    public void input(double inputValue) {
        if (this.seqDrift1 == null) {
            this.resetLearning();
        }
        this.isChangeDetected = this.seqDrift1.setInput(inputValue);
        this.isWarningZone = false;
        this.delay = 0.0;
        this.estimation = this.seqDrift1.getEstimation();
    }

    @Override
    public void resetLearning() {
        this.seqDrift1 = new SeqDrift1(this.deltaOption.getValue(), this.blockSeqDriftOption.getValue(), this.deltaWarningOption.getValue());
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    class Epsilon {
        double d_warningEpsilon = 0.0;
        double d_driftEpsilon = 0.0;

        public void getDescription(StringBuilder sb, int indent) {
        }
    }

    public class SeqDrift1
    extends AbstractMOAObject {
        private SeqDrift2ChangeDetector.Repository leftRepository = null;
        private SeqDrift2ChangeDetector.Repository rightRepository = null;
        private ArrayList<Integer> uniqueRandomNumbers = null;
        private double significanceLevel = 0.01;
        private int blockSize = 200;
        private int sampleSize = 200;
        private int slidingWindowBlockCount;
        private double warningSignificanceLevel = 0.1;
        private int instanceCount = 0;
        private double leftRepositoryMean = 0.0;
        private double rightRepositoryMean = 0.0;
        private int blockCount = 0;
        private double variance = 0.0;
        private boolean isWarning = false;
        private double total = 0.0;
        private Epsilon epsilon = null;
        public static final int DRIFT = 0;
        public static final int WARNING = 1;
        public static final int HOMOGENEOUS = 2;
        public static final int INTERNAL_DRIFT = 3;

        public SeqDrift1(double _significanceLevel, int _blockSize, double _significanceWarningLevel) {
            SeqDrift2ChangeDetector sd;
            this.significanceLevel = _significanceLevel;
            this.blockSize = _blockSize;
            this.sampleSize = _blockSize;
            this.slidingWindowBlockCount = (int)(1.0 / _significanceLevel);
            this.warningSignificanceLevel = _significanceWarningLevel;
            this.instanceCount = 0;
            this.blockCount = 0;
            this.variance = 0.0;
            this.isWarning = false;
            this.total = 0.0;
            this.epsilon = new Epsilon();
            SeqDrift2ChangeDetector seqDrift2ChangeDetector = sd = new SeqDrift2ChangeDetector();
            seqDrift2ChangeDetector.getClass();
            this.leftRepository = new SeqDrift2ChangeDetector.Repository(seqDrift2ChangeDetector, this.blockSize);
            SeqDrift2ChangeDetector seqDrift2ChangeDetector2 = sd;
            seqDrift2ChangeDetector2.getClass();
            this.rightRepository = new SeqDrift2ChangeDetector.Repository(seqDrift2ChangeDetector2, this.blockSize);
            this.uniqueRandomNumbers = new ArrayList();
        }

        public boolean setInput(double _inputValue) {
            ++this.instanceCount;
            this.addToRightRepository(_inputValue);
            this.total += _inputValue;
            if (this.instanceCount % this.sampleSize == 0) {
                this.rightRepository.markLastAddedBlock();
                if (this.isWarning) {
                    this.removeExcessRightRepositoryValues();
                }
                this.isWarning = false;
                int iDriftType = this.getDriftType();
                if (iDriftType == 0) {
                    this.isWarning = false;
                    this.clearLeftRepository();
                    this.moveValuesFromRightToLeft();
                    this.sampleSize = this.blockSize;
                    return true;
                }
                if (iDriftType == 1) {
                    this.isWarning = true;
                    this.sampleSize *= 2;
                    return false;
                }
                this.isWarning = false;
                this.moveValuesFromRightToLeft();
                return false;
            }
            return false;
        }

        private void addToRightRepository(double _inputValue) {
            if (this.rightRepository.getSize() < this.sampleSize || this.isWarning) {
                this.rightRepository.add(new Double(_inputValue));
            } else {
                System.out.println("request to add to sliding window sliding window size :" + this.rightRepository.getSize() + " Warning :" + this.isWarning);
            }
        }

        private void removeExcessRightRepositoryValues() {
            int maxRightRepositorySize = this.slidingWindowBlockCount * this.blockSize;
            while (this.rightRepository.getSize() > maxRightRepositorySize) {
                this.total -= this.rightRepository.getFirstBlockTotal();
                this.rightRepository.removeFirstBlock();
            }
        }

        private void moveValuesFromRightToLeft() {
            for (int iIndex = 0; iIndex < this.rightRepository.getSize(); ++iIndex) {
                if (iIndex % this.sampleSize == 0) {
                    this.leftRepository.add(this.rightRepository.get(iIndex), true);
                    continue;
                }
                this.leftRepository.add(this.rightRepository.get(iIndex));
            }
            this.blockCount += this.rightRepository.getSize() / this.blockSize;
            if (this.slidingWindowBlockCount > 0) {
                while (this.blockCount > this.slidingWindowBlockCount) {
                    this.total -= this.leftRepository.getFirstBlockTotal();
                    this.leftRepository.removeFirstBlock();
                    --this.blockCount;
                }
            }
            if (!this.isWarning) {
                this.rightRepository.removeAll();
            } else {
                System.out.println("ERROR: requested to move instances from  sliding window to  repository");
                System.exit(2);
            }
        }

        private void clearLeftRepository() {
            this.blockCount = 0;
            this.total -= this.leftRepository.getTotal();
            this.leftRepository.removeAll();
        }

        private int getDriftType() {
            if (this.getWidth() > this.blockSize) {
                this.leftRepositoryMean = this.getLeftRepositorySampleMean();
                this.rightRepositoryMean = this.getRightRepositorySampleMean();
                this.epsilon = this.getEpsilon();
                double absValue = Math.abs(this.rightRepositoryMean - this.leftRepositoryMean);
                if (this.instanceCount > this.sampleSize && this.leftRepository.getSize() > 0) {
                    if (this.epsilon.d_warningEpsilon <= absValue) {
                        if (this.epsilon.d_driftEpsilon <= absValue) {
                            return 0;
                        }
                        return 1;
                    }
                    return 2;
                }
                return 2;
            }
            return 2;
        }

        private double getLeftRepositorySampleMean() {
            double leftTotal = 0.0;
            if (this.leftRepository.getSize() > 0) {
                if (this.leftRepository.getSize() <= this.sampleSize) {
                    return this.getLeftResitoryMean();
                }
                int iPossibleSampleSize = this.getPossibleSampleSize();
                for (int iCount = 0; iCount < iPossibleSampleSize; ++iCount) {
                    int iNextRandomNumber = this.getNextRandomNumber(this.leftRepository.getSize() - 1);
                    if (this.isUniqueRandomNumber(iNextRandomNumber)) {
                        leftTotal += this.leftRepository.get(iNextRandomNumber);
                        continue;
                    }
                    --iCount;
                }
                this.uniqueRandomNumbers.clear();
            }
            return leftTotal / (double)this.sampleSize;
        }

        private int getPossibleSampleSize() {
            int iNumberSampleElements = 0;
            int leftResitorySize = this.leftRepository.getSize();
            int rightRepositorySize = this.rightRepository.getSize();
            if (this.sampleSize <= leftResitorySize && this.sampleSize <= rightRepositorySize) {
                iNumberSampleElements = this.sampleSize;
            } else {
                this.sampleSize = leftResitorySize > rightRepositorySize ? leftResitorySize : rightRepositorySize;
            }
            return iNumberSampleElements;
        }

        private boolean isUniqueRandomNumber(int _iTrialNum) {
            for (int iIndex = 0; iIndex < this.uniqueRandomNumbers.size(); ++iIndex) {
                if (this.uniqueRandomNumbers.get(iIndex) != _iTrialNum) continue;
                return false;
            }
            this.uniqueRandomNumbers.add(_iTrialNum);
            return true;
        }

        private double getLeftResitoryMean() {
            double dTotal = 0.0;
            return (dTotal += this.leftRepository.getTotal()) / (double)this.sampleSize;
        }

        private double getRightRepositoryMean() {
            double dTotal = 0.0;
            return (dTotal += this.rightRepository.getTotal()) / (double)this.sampleSize;
        }

        private double getRightRepositorySampleMean() {
            double dTotal = 0.0;
            if (this.rightRepository.getSize() > 0) {
                if (this.rightRepository.getSize() <= this.sampleSize) {
                    return this.getRightRepositoryMean();
                }
                int iPossibleSampleSize = this.getPossibleSampleSize();
                for (int iCount = 0; iCount < iPossibleSampleSize; ++iCount) {
                    int iNextRandomNumber = this.getNextRandomNumber(this.rightRepository.getSize() - 1);
                    if (this.isUniqueRandomNumber(iNextRandomNumber)) {
                        dTotal += this.rightRepository.get(iNextRandomNumber);
                        continue;
                    }
                    --iCount;
                }
                this.uniqueRandomNumbers.clear();
            }
            return dTotal / (double)this.sampleSize;
        }

        private int getNextRandomNumber(int _iSize) {
            double dRandomNumber = (double)_iSize * Math.random();
            long lRoundedNumber = Math.round(dRandomNumber);
            return (int)lRoundedNumber;
        }

        private double getVariance() {
            double dMean = this.getPopulationMean();
            double d1minusMean = dMean - 1.0;
            double dtotalsize = this.getWidth();
            double x = this.total * d1minusMean * d1minusMean + (dtotalsize - this.total) * dMean * dMean;
            double y = dtotalsize - 1.0;
            return x / y;
        }

        private Epsilon getEpsilon() {
            int iNumberOfTests = this.leftRepository.getNumOfTests() + this.rightRepository.getNumOfTests();
            if (iNumberOfTests > 1) {
                double depsilon;
                this.variance = this.getVariance();
                double ddeltadash = this.getDriftEpsilon(iNumberOfTests);
                double x = Math.log(4.0 / ddeltadash);
                double squareRootValue = Math.sqrt(x * x + 18.0 * this.variance * (double)this.sampleSize * x);
                this.epsilon.d_driftEpsilon = depsilon = 2.0 / (double)(3 * this.sampleSize) * (x + squareRootValue);
                ddeltadash = this.getWarningEpsilon(iNumberOfTests);
                x = Math.log(4.0 / ddeltadash);
                squareRootValue = Math.sqrt(x * x + 18.0 * this.variance * (double)this.sampleSize * x);
                this.epsilon.d_warningEpsilon = depsilon = 2.0 / (double)(3 * this.sampleSize) * (x + squareRootValue);
            }
            return this.epsilon;
        }

        private double getDriftEpsilon(int _inumTests) {
            double errorValue = 2.0 * (1.0 - Math.pow(0.5, _inumTests));
            double ddeltadash = this.significanceLevel;
            ddeltadash = this.significanceLevel / errorValue;
            return ddeltadash;
        }

        private double getWarningEpsilon(int _inumTests) {
            double dTotalError = 2.0 * (1.0 - Math.pow(0.5, _inumTests));
            double ddeltadash = this.warningSignificanceLevel / dTotalError;
            return ddeltadash;
        }

        private double getPopulationMean() {
            return this.getTotal() / (double)this.getWidth();
        }

        private double getTotal() {
            return this.total;
        }

        public int getWidth() {
            return this.leftRepository.getSize() + this.rightRepository.getSize();
        }

        public double getEstimation() {
            int iWidth = this.getWidth();
            if (iWidth != 0) {
                return this.getTotal() / (double)this.getWidth();
            }
            return 0.0;
        }

        @Override
        public void getDescription(StringBuilder sb, int indent) {
        }
    }
}

