/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import com.yahoo.labs.samoa.instances.ArffLoader;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceInformation;
import com.yahoo.labs.samoa.instances.MultiTargetArffLoader;
import com.yahoo.labs.samoa.instances.Range;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import moa.core.Utils;

public class Instances
implements Serializable {
    public static final String ARFF_RELATION = "@relation";
    public static final String ARFF_DATA = "@data";
    private static final long serialVersionUID = 8110510475535581577L;
    protected InstanceInformation instanceInformation;
    protected List<Instance> instances;
    protected ArffLoader arff;
    protected HashMap<Attribute, Integer> hsAttributesIndices;

    public Instances(Instances chunk) {
        this(chunk, chunk.numInstances());
        chunk.copyInstances(0, this, chunk.numInstances());
        this.computeAttributesIndices();
    }

    public Instances() {
    }

    public Instances(Reader reader, int size, int classAttribute) {
        this.arff = new ArffLoader(reader, 0, classAttribute);
        this.instanceInformation = this.arff.getStructure();
        this.instances = new ArrayList<Instance>();
        this.computeAttributesIndices();
    }

    public Instances(Reader reader, Range range) {
        this.arff = new MultiTargetArffLoader(reader, range);
        this.instanceInformation = this.arff.getStructure();
        this.instances = new ArrayList<Instance>();
        this.computeAttributesIndices();
    }

    public Instances(Instances chunk, int capacity) {
        this.instanceInformation = chunk.instanceInformation();
        if (capacity < 0) {
            capacity = 0;
        }
        this.instances = new ArrayList<Instance>(capacity);
        this.computeAttributesIndices();
    }

    public Instances(String st, List<Attribute> v, int capacity) {
        this.instanceInformation = new InstanceInformation(st, v);
        this.instances = new ArrayList<Instance>(capacity);
        this.computeAttributesIndices();
    }

    public Instances(Instances chunk, int first, int toCopy) {
        this(chunk, toCopy);
        if (first < 0 || first + toCopy > chunk.numInstances()) {
            throw new IllegalArgumentException("Parameters first and/or toCopy out of range");
        }
        chunk.copyInstances(first, this, toCopy);
        this.computeAttributesIndices();
    }

    public Instances(StringReader st, int capacity) {
        this.instances = new ArrayList<Instance>(capacity);
        this.computeAttributesIndices();
    }

    public void setRelationName(String string) {
        this.instanceInformation.setRelationName(string);
    }

    public String getRelationName() {
        return this.instanceInformation.getRelationName();
    }

    public int classIndex() {
        return this.instanceInformation.classIndex();
    }

    public void setClassIndex(int classIndex) {
        this.instanceInformation.setClassIndex(classIndex);
    }

    public Attribute classAttribute() {
        return this.instanceInformation.classAttribute();
    }

    public int numAttributes() {
        return this.instanceInformation.numAttributes();
    }

    public Attribute attribute(int w) {
        return this.instanceInformation.attribute(w);
    }

    public int numClasses() {
        return this.instanceInformation.numClasses();
    }

    public void deleteAttributeAt(Integer integer) {
        this.instanceInformation.deleteAttributeAt(integer);
    }

    public void insertAttributeAt(Attribute attribute, int i) {
        if (this.instanceInformation == null) {
            this.instanceInformation = new InstanceInformation();
        }
        this.instanceInformation.insertAttributeAt(attribute, i);
    }

    public Instance instance(int num) {
        return this.instances.get(num);
    }

    public int numInstances() {
        return this.instances.size();
    }

    public void add(Instance inst) {
        this.instances.add(inst.copy());
    }

    public void randomize(Random random) {
        for (int j = this.numInstances() - 1; j > 0; --j) {
            this.swap(j, random.nextInt(j + 1));
        }
    }

    public void stratify(int numFolds) {
        if (this.classAttribute().isNominal()) {
            for (int index = 1; index < this.numInstances(); ++index) {
                Instance instance1 = this.instance(index - 1);
                for (int j = index; j < this.numInstances(); ++j) {
                    Instance instance2 = this.instance(j);
                    if (instance1.classValue() != instance2.classValue() && (!instance1.classIsMissing() || !instance2.classIsMissing())) continue;
                    this.swap(index, j);
                    ++index;
                }
            }
            this.stratStep(numFolds);
        }
    }

    protected void stratStep(int numFolds) {
        ArrayList<Instance> newVec = new ArrayList<Instance>(this.instances.size());
        int start = 0;
        while (newVec.size() < this.numInstances()) {
            for (int j = start; j < this.numInstances(); j += numFolds) {
                newVec.add(this.instance(j));
            }
            ++start;
        }
        this.instances = newVec;
    }

    public Instances trainCV(int numFolds, int numFold, Random random) {
        Instances train = this.trainCV(numFolds, numFold);
        train.randomize(random);
        return train;
    }

    public Instances trainCV(int numFolds, int numFold) {
        int offset;
        int numInstForFold = this.numInstances() / numFolds;
        if (numFold < this.numInstances() % numFolds) {
            ++numInstForFold;
            offset = numFold;
        } else {
            offset = this.numInstances() % numFolds;
        }
        Instances train = new Instances(this, this.numInstances() - numInstForFold);
        int first = numFold * (this.numInstances() / numFolds) + offset;
        this.copyInstances(0, train, first);
        this.copyInstances(first + numInstForFold, train, this.numInstances() - first - numInstForFold);
        return train;
    }

    protected void copyInstances(int from, Instances dest, int num) {
        for (int i = 0; i < num; ++i) {
            dest.add(this.instance(from + i));
        }
    }

    public Instances testCV(int numFolds, int numFold) {
        int offset;
        int numInstForFold = this.numInstances() / numFolds;
        if (numFold < this.numInstances() % numFolds) {
            ++numInstForFold;
            offset = numFold;
        } else {
            offset = this.numInstances() % numFolds;
        }
        Instances test = new Instances(this, numInstForFold);
        int first = numFold * (this.numInstances() / numFolds) + offset;
        this.copyInstances(first, test, numInstForFold);
        return test;
    }

    public double meanOrMode(int j) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean readInstance(Reader fileReader) {
        Instance inst = this.arff.readInstance();
        if (inst != null) {
            inst.setDataset(this);
            this.add(inst);
            return true;
        }
        return false;
    }

    public void delete() {
        this.instances = new ArrayList<Instance>();
    }

    public void delete(int index) {
        this.instances.remove(index);
    }

    public void swap(int i, int j) {
        Instance in = this.instances.get(i);
        this.instances.set(i, this.instances.get(j));
        this.instances.set(j, in);
    }

    private InstanceInformation instanceInformation() {
        return this.instanceInformation;
    }

    public Attribute attribute(String name) {
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (!this.attribute(i).name().equals(name)) continue;
            return this.attribute(i);
        }
        return null;
    }

    public int size() {
        return this.numInstances();
    }

    public void set(int i, Instance inst) {
        this.instances.set(i, inst);
    }

    public Instance get(int k) {
        return this.instance(k);
    }

    public void setRangeOutputIndices(Range range) {
        this.instanceInformation.setRangeOutputIndices(range);
    }

    public void setAttributes(List<Attribute> v) {
        if (this.instanceInformation == null) {
            this.instanceInformation = new InstanceInformation();
        }
        this.instanceInformation.setAttributes(v);
    }

    public void setAttributes(List<Attribute> v, List<Integer> indexValues) {
        if (this.instanceInformation == null) {
            this.instanceInformation = new InstanceInformation();
        }
        this.instanceInformation.setAttributes(v, indexValues);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(ARFF_RELATION).append(" ").append(Utils.quote(this.instanceInformation.getRelationName())).append("\n\n");
        for (int i = 0; i < this.numAttributes(); ++i) {
            text.append(this.attribute(i).toString()).append("\n");
        }
        text.append("\n").append(ARFF_DATA).append("\n");
        text.append(this.stringWithoutHeader());
        return text.toString();
    }

    protected String stringWithoutHeader() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.numInstances(); ++i) {
            text.append(this.instance(i));
            if (i >= this.numInstances() - 1) continue;
            text.append('\n');
        }
        return text.toString();
    }

    protected int indexOf(Attribute att) {
        return this.hsAttributesIndices.get(att);
    }

    private void computeAttributesIndices() {
        this.hsAttributesIndices = new HashMap();
        for (int i = 0; i < this.numAttributes(); ++i) {
            this.hsAttributesIndices.put(this.attribute(i), i);
        }
    }
}

