/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moa.core.Utils;

public class Attribute
implements Serializable {
    public static final String ARFF_ATTRIBUTE = "@attribute";
    public static final String ARFF_ATTRIBUTE_INTEGER = "integer";
    public static final String ARFF_ATTRIBUTE_REAL = "real";
    public static final String ARFF_ATTRIBUTE_NUMERIC = "numeric";
    public static final String ARFF_ATTRIBUTE_STRING = "string";
    public static final String ARFF_ATTRIBUTE_DATE = "date";
    public static final String ARFF_ATTRIBUTE_RELATIONAL = "relational";
    public static final String ARFF_END_SUBRELATION = "@end";
    private static final int STRING_COMPRESS_THRESHOLD = 200;
    protected boolean isNominal;
    protected boolean isNumeric;
    protected boolean isDate;
    protected SimpleDateFormat m_DateFormat;
    protected String name;
    protected List<String> attributeValues;
    private Map<String, Integer> valuesStringAttribute;

    public List<String> getAttributeValues() {
        return this.attributeValues;
    }

    public Attribute(String string) {
        this.name = string;
        this.isNumeric = true;
    }

    public Attribute(String attributeName, List<String> attributeValues) {
        this.name = attributeName;
        this.attributeValues = attributeValues;
        this.isNominal = true;
    }

    public Attribute(String attributeName, String dateFormat) {
        this.name = attributeName;
        this.valuesStringAttribute = null;
        this.isDate = true;
        this.m_DateFormat = dateFormat != null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    public Attribute() {
        this("");
    }

    public boolean isNominal() {
        return this.isNominal;
    }

    public String name() {
        return this.name;
    }

    public String value(int value) {
        return this.attributeValues.get(value);
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public int numValues() {
        if (this.isNumeric()) {
            return 0;
        }
        return this.attributeValues.size();
    }

    String formatDate(double value) {
        return this.m_DateFormat.format(new Date((long)value));
    }

    boolean isDate() {
        return this.isDate;
    }

    public final int indexOfValue(String value) {
        Integer val;
        if (!this.isNominal()) {
            return -1;
        }
        if (this.valuesStringAttribute == null) {
            this.valuesStringAttribute = new HashMap<String, Integer>();
            int count = 0;
            for (String stringValue : this.attributeValues) {
                this.valuesStringAttribute.put(stringValue, count);
                ++count;
            }
        }
        if ((val = this.valuesStringAttribute.get(value)) == null) {
            return -1;
        }
        return val;
    }

    public final String toString() {
        StringBuffer text = new StringBuffer();
        text.append(ARFF_ATTRIBUTE).append(" ").append(Utils.quote(this.name())).append(" ");
        if (this.isNominal) {
            text.append('{');
            Enumeration enu = this.enumerateValues();
            while (enu.hasMoreElements()) {
                text.append(Utils.quote((String)enu.nextElement()));
                if (!enu.hasMoreElements()) continue;
                text.append(',');
            }
            text.append('}');
        } else if (this.isNumeric) {
            text.append(ARFF_ATTRIBUTE_NUMERIC);
        } else if (this.isDate) {
            text.append(ARFF_ATTRIBUTE_DATE).append(" ").append(Utils.quote(this.m_DateFormat.toPattern()));
        } else {
            text.append("UNKNOW");
        }
        return text.toString();
    }

    public final Enumeration enumerateValues() {
        if (this.isNominal()) {
            return Collections.enumeration(this.attributeValues);
        }
        return null;
    }
}

