/*
 * Decompiled with CFR 0.152.
 */
package com.github.javacliparser;

import java.text.DecimalFormat;

public class StringUtils {
    public static final String newline = System.getProperty("line.separator");

    public static String doubleToString(double value, int fractionDigits) {
        return StringUtils.doubleToString(value, 0, fractionDigits);
    }

    public static String doubleToString(double value, int minFractionDigits, int maxFractionDigits) {
        DecimalFormat numberFormat = new DecimalFormat();
        numberFormat.setMinimumFractionDigits(minFractionDigits);
        numberFormat.setMaximumFractionDigits(maxFractionDigits);
        return numberFormat.format(value);
    }

    public static void appendNewline(StringBuilder out) {
        out.append(newline);
    }

    public static void appendIndent(StringBuilder out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.append(' ');
        }
    }

    public static void appendIndented(StringBuilder out, int indent, String s) {
        StringUtils.appendIndent(out, indent);
        out.append(s);
    }

    public static void appendNewlineIndented(StringBuilder out, int indent, String s) {
        StringUtils.appendNewline(out);
        StringUtils.appendIndented(out, indent, s);
    }
}

